/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc.index;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.misc.index.IndexRearranger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;

public class BinaryDocValueSelector
implements IndexRearranger.DocumentSelector,
Serializable {
    private final String field;
    private final Set<BytesRef> keySet;

    public BinaryDocValueSelector(String field, Set<BytesRef> keySet) {
        this.field = field;
        this.keySet = keySet;
    }

    @Override
    public BitSet getFilteredDocs(CodecReader reader) throws IOException {
        BinaryDocValues binaryDocValues = reader.getBinaryDocValues(this.field);
        FixedBitSet bits = new FixedBitSet(reader.maxDoc());
        for (int docid = 0; docid < reader.maxDoc(); ++docid) {
            if (!binaryDocValues.advanceExact(docid) || !this.keySet.contains(binaryDocValues.binaryValue())) continue;
            bits.set(docid);
        }
        return bits;
    }

    public static IndexRearranger.DocumentSelector createDeleteSelectorFromIndex(String field, Directory directory) throws IOException {
        HashSet<BytesRef> keySet = new HashSet<BytesRef>();
        try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
            for (LeafReaderContext context : reader.leaves()) {
                Bits liveDocs = context.reader().getLiveDocs();
                if (liveDocs == null) continue;
                BinaryDocValues binaryDocValues = context.reader().getBinaryDocValues(field);
                for (int docid = 0; docid < context.reader().maxDoc(); ++docid) {
                    if (liveDocs.get(docid)) continue;
                    if (binaryDocValues.advanceExact(docid)) {
                        keySet.add(BytesRef.deepCopyOf((BytesRef)binaryDocValues.binaryValue()));
                        continue;
                    }
                    throw new AssertionError((Object)("Document " + docid + " doesn't have key " + field));
                }
            }
        }
        return new BinaryDocValueSelector(field, keySet);
    }

    public static List<IndexRearranger.DocumentSelector> createLiveSelectorsFromIndex(String field, Directory directory) throws IOException {
        ArrayList<IndexRearranger.DocumentSelector> selectors = new ArrayList<IndexRearranger.DocumentSelector>();
        try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
            for (LeafReaderContext context : reader.leaves()) {
                HashSet<BytesRef> keySet = new HashSet<BytesRef>();
                BinaryDocValues binaryDocValues = context.reader().getBinaryDocValues(field);
                for (int docid = 0; docid < context.reader().maxDoc(); ++docid) {
                    if (!binaryDocValues.advanceExact(docid)) {
                        throw new AssertionError((Object)("Document " + docid + " doesn't have key " + field));
                    }
                    keySet.add(BytesRef.deepCopyOf((BytesRef)binaryDocValues.binaryValue()));
                }
                selectors.add(new BinaryDocValueSelector(field, keySet));
            }
        }
        return selectors;
    }
}

