/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.calcite.plan.volcano.RuleQueue;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.plan.volcano.VolcanoRuleMatch;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

class TopDownRuleQueue
extends RuleQueue {
    private final Map<RelNode, Deque<VolcanoRuleMatch>> matches = new HashMap<RelNode, Deque<VolcanoRuleMatch>>();
    private final Set<String> names = new HashSet<String>();

    TopDownRuleQueue(VolcanoPlanner planner) {
        super(planner);
    }

    @Override
    public void addMatch(VolcanoRuleMatch match) {
        Object rel = match.rel(0);
        Deque queue = this.matches.computeIfAbsent((RelNode)rel, (Function<RelNode, Deque<VolcanoRuleMatch>>)((Function<RelNode, Deque>)id -> new ArrayDeque()));
        this.addMatch(match, queue);
    }

    private void addMatch(VolcanoRuleMatch match, Deque<VolcanoRuleMatch> queue) {
        if (!this.names.add(match.toString())) {
            return;
        }
        if (!this.planner.isSubstituteRule(match)) {
            queue.addFirst(match);
        } else {
            queue.addLast(match);
        }
    }

    public @Nullable VolcanoRuleMatch popMatch(Pair<RelNode, Predicate<VolcanoRuleMatch>> category) {
        Deque<VolcanoRuleMatch> queue = this.matches.get(category.left);
        if (queue == null) {
            return null;
        }
        Iterator<VolcanoRuleMatch> iterator = queue.iterator();
        while (iterator.hasNext()) {
            VolcanoRuleMatch next = iterator.next();
            if (category.right != null && !((Predicate)category.right).test(next)) continue;
            iterator.remove();
            if (this.skipMatch(next)) continue;
            return next;
        }
        return null;
    }

    @Override
    public boolean clear() {
        boolean empty = this.matches.isEmpty();
        this.matches.clear();
        this.names.clear();
        return !empty;
    }
}

