/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.ddl;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlTruncate;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;

public class SqlTruncateTable
extends SqlTruncate {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("TRUNCATE TABLE", SqlKind.TRUNCATE_TABLE);
    public final SqlIdentifier name;
    public final boolean continueIdentify;

    public SqlTruncateTable(SqlParserPos pos, SqlIdentifier name, boolean continueIdentify) {
        super(OPERATOR, pos);
        this.name = name;
        this.continueIdentify = continueIdentify;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.name);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("TRUNCATE");
        writer.keyword("TABLE");
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.continueIdentify) {
            writer.keyword("CONTINUE IDENTITY");
        } else {
            writer.keyword("RESTART IDENTITY");
        }
    }
}

