/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class ResourceProvider {
    private static final Set<ClassLoader> classLoaders = Collections.synchronizedSet(new HashSet());

    private ResourceProvider() {
    }

    public static boolean addAdditionalClassLoader(ClassLoader additionalClassLoader) {
        return classLoaders.add(additionalClassLoader);
    }

    public static boolean addAdditionalClassLoaders(Collection<ClassLoader> additionalClassLoaders) {
        return classLoaders.addAll(additionalClassLoaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T getFirstNotNull(Function<ClassLoader, T> function) {
        Set<ClassLoader> set = classLoaders;
        synchronized (set) {
            for (ClassLoader source : classLoaders) {
                T res = function.apply(source);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    public static URL getResource(String name) {
        return ResourceProvider.getFirstNotNull(x -> x.getResource(name));
    }

    public static InputStream getResourceAsStream(String name) {
        return ResourceProvider.getFirstNotNull(x -> Utils.getResourceAsStream(x, name));
    }

    static {
        try {
            classLoaders.add(ClassLoader.getSystemClassLoader());
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to get system classloader", e);
        }
        try {
            classLoaders.add(ResourceProvider.class.getClassLoader());
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to get application classloader", e);
        }
    }
}

