/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import org.apache.ibatis.ognl.ASTConst;
import org.apache.ibatis.ognl.ExpressionNode;
import org.apache.ibatis.ognl.Node;
import org.apache.ibatis.ognl.NodeType;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlOps;
import org.apache.ibatis.ognl.OgnlParser;
import org.apache.ibatis.ognl.OgnlRuntime;
import org.apache.ibatis.ognl.enhance.ExpressionCompiler;

public abstract class NumericExpression
extends ExpressionNode
implements NodeType {
    private static final long serialVersionUID = 411246929049244018L;
    protected Class<?> getterClass;

    public NumericExpression(int id) {
        super(id);
    }

    public NumericExpression(OgnlParser p, int id) {
        super(p, id);
    }

    @Override
    public Class<?> getGetterClass() {
        if (this.getterClass != null) {
            return this.getterClass;
        }
        return Double.TYPE;
    }

    @Override
    public Class<?> getSetterClass() {
        return null;
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        StringBuilder result = new StringBuilder();
        try {
            Object value = this.getValueBody(context, target);
            if (value != null) {
                this.getterClass = value.getClass();
            }
            for (int i = 0; i < this.children.length; ++i) {
                if (i > 0) {
                    result.append(" ").append(this.getExpressionOperator(i)).append(" ");
                }
                String str = OgnlRuntime.getChildSource(context, target, this.children[i]);
                result.append(this.coerceToNumeric(str, context, this.children[i]));
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        return result.toString();
    }

    public String coerceToNumeric(String source, OgnlContext context, Node child) {
        String ret = source;
        Object value = context.getCurrentObject();
        if (child instanceof ASTConst && value != null) {
            return value.toString();
        }
        if (context.getCurrentType() != null && !context.getCurrentType().isPrimitive() && context.getCurrentObject() != null && context.getCurrentObject() instanceof Number) {
            ret = "((" + ExpressionCompiler.getCastString(context.getCurrentObject().getClass()) + ")" + ret + ")";
            ret = ret + "." + OgnlRuntime.getNumericValueGetter(context.getCurrentObject().getClass());
        } else if (context.getCurrentType() != null && context.getCurrentType().isPrimitive() && (child instanceof ASTConst || child instanceof NumericExpression)) {
            ret = ret + OgnlRuntime.getNumericLiteral(context.getCurrentType());
        } else if (context.getCurrentType() != null && String.class.isAssignableFrom(context.getCurrentType())) {
            ret = "Double.parseDouble(" + ret + ")";
            context.setCurrentType(Double.TYPE);
        }
        if (child instanceof NumericExpression) {
            ret = "(" + ret + ")";
        }
        return ret;
    }
}

