/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DropIndexFinalStep;
import org.jooq.DropIndexOnStep;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class DropIndexImpl
extends AbstractQuery
implements DropIndexOnStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_INDEX};
    private final Index index;
    private final boolean ifExists;
    private Table<?> on;

    DropIndexImpl(Configuration configuration, Index index) {
        this(configuration, index, false);
    }

    DropIndexImpl(Configuration configuration, Index index, boolean ifExists) {
        super(configuration);
        this.index = index;
        this.ifExists = ifExists;
        this.on = index.getTable();
    }

    @Override
    public final DropIndexFinalStep on(Table<?> table) {
        this.on = table;
        return this;
    }

    @Override
    public final DropIndexFinalStep on(String tableName) {
        return this.on(DSL.name(tableName));
    }

    @Override
    public final DropIndexFinalStep on(Name tableName) {
        return this.on(DSL.table(tableName));
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !Arrays.asList(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD).contains((Object)ctx.family());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.beginTryCatchIfExists(ctx, DDLStatementType.DROP_INDEX, this.index);
            this.accept0(ctx);
            Tools.endTryCatchIfExists(ctx, DDLStatementType.DROP_INDEX, this.index);
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.visit(Keywords.K_DROP_INDEX).sql(' ');
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.visit(Keywords.K_IF_EXISTS).sql(' ');
        }
        ctx.visit(this.index);
        if (this.on != null && Arrays.asList(SQLDialect.MARIADB, SQLDialect.MYSQL).contains((Object)ctx.family())) {
            ctx.sql(' ').visit(Keywords.K_ON).sql(' ').visit(this.on);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

