/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.persistence;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.persistence.InternalConfig;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.persistence.TCGroupConfig;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class TCGroupParser {
    public static final String INSTANCE_DTD_ID_2_0 = "-//NetBeans//DTD Top Component in Group Properties 2.0//EN";
    private static final boolean DEBUG = Debug.isLoggable(TCGroupParser.class);
    private String tc_id;
    private FileObject moduleParentFolder;
    private FileObject localParentFolder;
    private InternalConfig internalConfig;
    private boolean inModuleFolder;
    private boolean inLocalFolder;

    public TCGroupParser(String string) {
        this.tc_id = string;
    }

    TCGroupConfig load() throws IOException {
        if (DEBUG) {
            Debug.log(TCGroupParser.class, "load ENTER tcGrp:" + this.tc_id);
        }
        TCGroupConfig tCGroupConfig = new TCGroupConfig();
        PropertyHandler propertyHandler = new PropertyHandler();
        InternalConfig internalConfig = this.getInternalConfig();
        internalConfig.clear();
        propertyHandler.readData(tCGroupConfig, internalConfig);
        if (DEBUG) {
            Debug.log(TCGroupParser.class, "load LEAVE tcGrp:" + this.tc_id);
        }
        return tCGroupConfig;
    }

    void save(TCGroupConfig tCGroupConfig) throws IOException {
        if (DEBUG) {
            Debug.log(TCGroupParser.class, "save ENTER tcGrp:" + this.tc_id);
        }
        PropertyHandler propertyHandler = new PropertyHandler();
        InternalConfig internalConfig = this.getInternalConfig();
        propertyHandler.writeData(tCGroupConfig, internalConfig);
        if (DEBUG) {
            Debug.log(TCGroupParser.class, "save LEAVE tcGrp:" + this.tc_id);
        }
    }

    String getName() {
        return this.tc_id;
    }

    InternalConfig getInternalConfig() {
        if (this.internalConfig == null) {
            this.internalConfig = new InternalConfig();
        }
        return this.internalConfig;
    }

    boolean isInModuleFolder() {
        return this.inModuleFolder;
    }

    void setInModuleFolder(boolean bl) {
        this.inModuleFolder = bl;
    }

    boolean isInLocalFolder() {
        return this.inLocalFolder;
    }

    void setInLocalFolder(boolean bl) {
        this.inLocalFolder = bl;
    }

    void setModuleParentFolder(FileObject fileObject) {
        this.moduleParentFolder = fileObject;
    }

    void setLocalParentFolder(FileObject fileObject) {
        this.localParentFolder = fileObject;
    }

    void log(String string) {
        Debug.log(TCGroupParser.class, string);
    }

    private final class PropertyHandler
    extends DefaultHandler {
        private TCGroupConfig tcGroupConfig = null;
        private InternalConfig internalConfig = null;
        private final Object RW_LOCK = new Object();

        private FileObject getConfigFOInput() {
            FileObject fileObject = TCGroupParser.this.isInLocalFolder() ? TCGroupParser.this.localParentFolder.getFileObject(TCGroupParser.this.getName(), "wstcgrp") : (TCGroupParser.this.isInModuleFolder() ? TCGroupParser.this.moduleParentFolder.getFileObject(TCGroupParser.this.getName(), "wstcgrp") : null);
            return fileObject;
        }

        private FileObject getConfigFOOutput() throws IOException {
            FileObject fileObject = TCGroupParser.this.localParentFolder.getFileObject(TCGroupParser.this.getName(), "wstcgrp");
            if (fileObject != null) {
                return fileObject;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(TCGroupParser.this.getName());
            stringBuffer.append('.');
            stringBuffer.append("wstcgrp");
            fileObject = FileUtil.createData((FileObject)TCGroupParser.this.localParentFolder, (String)stringBuffer.toString());
            return fileObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readData(TCGroupConfig tCGroupConfig, InternalConfig internalConfig) throws IOException {
            this.tcGroupConfig = tCGroupConfig;
            this.internalConfig = internalConfig;
            FileObject fileObject = this.getConfigFOInput();
            if (fileObject == null) {
                throw new FileNotFoundException("[WinSys] Missing TCGroup configuration file:" + TCGroupParser.this.getName());
            }
            InputStream inputStream = null;
            try {
                Object object = this.RW_LOCK;
                synchronized (object) {
                    inputStream = fileObject.getInputStream();
                    PersistenceManager.getDefault().getXMLParser(this).parse(new InputSource(inputStream));
                }
            }
            catch (SAXException sAXException) {
                String string = NbBundle.getMessage(TCGroupParser.class, (String)"EXC_TCGroupParse", (Object)fileObject);
                throw (IOException)new IOException(string).initCause(sAXException);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(TCGroupParser.class.getName()).log(Level.WARNING, null, iOException);
                }
            }
            tCGroupConfig = this.tcGroupConfig;
            internalConfig = this.internalConfig;
            this.tcGroupConfig = null;
            this.internalConfig = null;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("tc-group".equals(string3)) {
                this.handleTCGroup(attributes);
            } else if (this.internalConfig.specVersion != null && this.internalConfig.specVersion.compareTo(new SpecificationVersion("2.0")) == 0) {
                if ("module".equals(string3)) {
                    this.handleModule(attributes);
                } else if ("tc-id".equals(string3)) {
                    this.handleTcId(attributes);
                } else if ("open-close-behavior".equals(string3)) {
                    this.handleOpenCloseBehavior(attributes);
                }
            } else {
                TCGroupParser.this.log("-- TCGroupParser.startElement PARSING OLD");
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        private void handleTCGroup(Attributes attributes) {
            String string = attributes.getValue("version");
            if (string != null) {
                this.internalConfig.specVersion = new SpecificationVersion(string);
            } else {
                PersistenceManager.LOG.log(Level.WARNING, "[WinSys.TCGroupParser.handleTCGroup] Warning: Missing attribute \"version\" of element \"tc-group\".");
                this.internalConfig.specVersion = new SpecificationVersion("2.0");
            }
        }

        private void handleModule(Attributes attributes) {
            String string = attributes.getValue("name");
            this.internalConfig.moduleCodeNameBase = null;
            this.internalConfig.moduleCodeNameRelease = null;
            this.internalConfig.moduleSpecificationVersion = null;
            if (string != null) {
                int n = string.indexOf(47);
                if (n != -1) {
                    this.internalConfig.moduleCodeNameBase = string.substring(0, n);
                    this.internalConfig.moduleCodeNameRelease = string.substring(n + 1);
                    this.checkReleaseCode(this.internalConfig);
                } else {
                    this.internalConfig.moduleCodeNameBase = string;
                }
                this.internalConfig.moduleSpecificationVersion = attributes.getValue("spec");
            }
        }

        private void checkReleaseCode(InternalConfig internalConfig) {
            if ("null".equals(internalConfig.moduleCodeNameRelease)) {
                Logger.getLogger(TCGroupParser.class.getName()).log(Level.WARNING, null, new IllegalStateException("Module release code was saved as null string for module " + internalConfig.moduleCodeNameBase + "! Repairing."));
                internalConfig.moduleCodeNameRelease = null;
            }
        }

        private void handleTcId(Attributes attributes) throws SAXException {
            String string = attributes.getValue("id");
            if (string != null) {
                this.tcGroupConfig.tc_id = string;
                if (!string.equals(TCGroupParser.this.getName())) {
                    PersistenceManager.LOG.log(Level.WARNING, "[WinSys.TCGroupParser.handleTcId] Error: Value of attribute \"id\" of element \"tc-id\" and configuration file name must be the same.");
                    throw new SAXException("Invalid attribute value");
                }
            } else {
                PersistenceManager.LOG.log(Level.WARNING, "[WinSys.TCGroupParser.handleTcId] Error: Missing required attribute \"id\" of element \"tc-id\".");
                throw new SAXException("Missing required attribute");
            }
        }

        private void handleOpenCloseBehavior(Attributes attributes) throws SAXException {
            String string = attributes.getValue("open");
            if (string != null) {
                if ("true".equals(string)) {
                    this.tcGroupConfig.open = true;
                } else if ("false".equals(string)) {
                    this.tcGroupConfig.open = false;
                } else {
                    PersistenceManager.LOG.log(Level.WARNING, "[WinSys.TCGroupParser.handleOpenCloseBehavior] Warning: Invalid value of attribute \"open\" of element \"open-close-behavior\".");
                    this.tcGroupConfig.open = false;
                }
            } else {
                PersistenceManager.LOG.log(Level.WARNING, "[WinSys.TCGroupParser.handleOpenCloseBehavior] Warning: Missing required attribute \"open\" of element \"open-close-behavior\".");
                this.tcGroupConfig.open = false;
            }
            String string2 = attributes.getValue("close");
            if (string2 != null) {
                if ("true".equals(string2)) {
                    this.tcGroupConfig.close = true;
                } else if ("false".equals(string2)) {
                    this.tcGroupConfig.close = false;
                } else {
                    PersistenceManager.LOG.log(Level.WARNING, "[WinSys.TCGroupParser.handleOpenCloseBehavior] Warning: Invalid value of attribute \"close\" of element \"open-close-behavior\".");
                    this.tcGroupConfig.close = false;
                }
            } else {
                PersistenceManager.LOG.log(Level.WARNING, "[WinSys.TCGroupParser.handleOpenCloseBehavior] Warning: Missing required attribute \"close\" of element \"open-close-behavior\".");
                this.tcGroupConfig.close = false;
            }
            String string3 = attributes.getValue("was-opened");
            if (string3 != null) {
                if ("true".equals(string3)) {
                    this.tcGroupConfig.wasOpened = true;
                } else if ("false".equals(string3)) {
                    this.tcGroupConfig.wasOpened = false;
                } else {
                    PersistenceManager.LOG.log(Level.WARNING, "[WinSys.TCGroupParser.handleOpenCloseBehavior] Warning: Invalid value of attribute \"was-opened\" of element \"open-close-behavior\".");
                    this.tcGroupConfig.wasOpened = false;
                }
            } else {
                this.tcGroupConfig.wasOpened = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeData(TCGroupConfig tCGroupConfig, InternalConfig internalConfig) throws IOException {
            StringBuffer stringBuffer = this.fillBuffer(tCGroupConfig, internalConfig);
            Object object = this.RW_LOCK;
            synchronized (object) {
                FileObject fileObject = this.getConfigFOOutput();
                FileLock fileLock = null;
                OutputStream outputStream = null;
                OutputStreamWriter outputStreamWriter = null;
                try {
                    fileLock = fileObject.lock();
                    outputStream = fileObject.getOutputStream(fileLock);
                    outputStreamWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
                    outputStreamWriter.write(stringBuffer.toString());
                }
                finally {
                    try {
                        if (outputStreamWriter != null) {
                            outputStreamWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(TCGroupParser.class.getName()).log(Level.WARNING, null, iOException);
                    }
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        }

        private StringBuffer fillBuffer(TCGroupConfig tCGroupConfig, InternalConfig internalConfig) throws IOException {
            StringBuffer stringBuffer = new StringBuffer(800);
            Object var4_4 = null;
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n").append("<tc-group version=\"2.0\">\n");
            this.appendModule(internalConfig, stringBuffer);
            this.appendTcId(tCGroupConfig, stringBuffer);
            this.appendOpenCloseBehavior(tCGroupConfig, stringBuffer);
            stringBuffer.append("</tc-group>\n");
            return stringBuffer;
        }

        private void appendModule(InternalConfig internalConfig, StringBuffer stringBuffer) {
            if (internalConfig == null) {
                return;
            }
            if (internalConfig.moduleCodeNameBase != null) {
                stringBuffer.append(" <module name=\"");
                stringBuffer.append(internalConfig.moduleCodeNameBase);
                if (internalConfig.moduleCodeNameRelease != null) {
                    stringBuffer.append("/").append(internalConfig.moduleCodeNameRelease);
                }
                if (internalConfig.moduleSpecificationVersion != null) {
                    stringBuffer.append("\" spec=\"");
                    stringBuffer.append(internalConfig.moduleSpecificationVersion);
                }
                stringBuffer.append("\" />\n");
            }
        }

        private void appendTcId(TCGroupConfig tCGroupConfig, StringBuffer stringBuffer) {
            stringBuffer.append(" <tc-id id=\"").append(PersistenceManager.escapeTcId4XmlContent(tCGroupConfig.tc_id)).append("\"/>\n");
        }

        private void appendOpenCloseBehavior(TCGroupConfig tCGroupConfig, StringBuffer stringBuffer) {
            stringBuffer.append(" <open-close-behavior open=\"").append(tCGroupConfig.open).append("\" close=\"").append(tCGroupConfig.close).append("\" was-opened=\"").append(tCGroupConfig.wasOpened).append("\"/>\n");
        }
    }
}

