/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.search;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.extension.search.HttpSearcher;
import org.zaproxy.zap.extension.search.OptionsSearchPanel;
import org.zaproxy.zap.extension.search.SearchAPI;
import org.zaproxy.zap.extension.search.SearchListenner;
import org.zaproxy.zap.extension.search.SearchPanel;
import org.zaproxy.zap.extension.search.SearchParam;
import org.zaproxy.zap.extension.search.SearchThread;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionSearch
extends ExtensionAdaptor {
    private static final Logger LOGGER = LogManager.getLogger(ExtensionSearch.class);
    public static final String NAME = "ExtensionSearch2";
    private SearchParam searchParam;
    private OptionsSearchPanel optionsPanel;
    private SearchPanel searchPanel = null;
    private JMenu searchMenu = null;
    private ZapMenuItem menuItemSearch = null;
    private ZapMenuItem menuItemNext = null;
    private ZapMenuItem menuItemPrev = null;
    private SearchThread searchThread = null;
    private boolean searchJustInScope = false;
    private Map<String, HttpSearcher> customSearchers = new HashMap<String, HttpSearcher>();

    public ExtensionSearch() {
        super(NAME);
        this.setOrder(20);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("search.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addOptionsParamSet(this.getSearchParam());
        if (this.getView() != null) {
            extensionHook.addSessionListener(new ViewSessionChangedListener());
            extensionHook.getHookView().addOptionPanel(this.getOptionsPanel());
            extensionHook.getHookView().addStatusPanel(this.getSearchPanel());
            extensionHook.getHookMenu().addEditSubMenu(this.getSearchMenu());
            ExtensionHelp.enableHelpKey(this.getSearchPanel(), "ui.tabs.search");
        }
        extensionHook.addApiImplementor(new SearchAPI(this));
    }

    SearchParam getSearchParam() {
        if (this.searchParam == null) {
            this.searchParam = new SearchParam();
        }
        return this.searchParam;
    }

    private OptionsSearchPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new OptionsSearchPanel();
        }
        return this.optionsPanel;
    }

    private SearchPanel getSearchPanel() {
        if (this.searchPanel == null) {
            this.searchPanel = new SearchPanel(this.getView());
            this.searchPanel.setExtension(this);
        }
        return this.searchPanel;
    }

    public void addCustomHttpSearcher(HttpSearcher searcher) {
        if (searcher == null) {
            return;
        }
        final String searcherName = searcher.getName();
        if (this.customSearchers.containsKey(searcherName)) {
            LOGGER.warn("Attempting to add an HTTP searcher with the same name: {}", (Object)searcherName);
            return;
        }
        this.customSearchers.put(searcherName, searcher);
        if (this.getView() != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtensionSearch.this.searchPanel.addCustomSearcher(searcherName);
                }
            });
        }
    }

    public void removeCustomHttpSearcher(HttpSearcher searcher) {
        final String searcherName = searcher.getName();
        if (this.customSearchers.remove(searcherName) != null && this.getView() != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExtensionSearch.this.searchPanel.removeCustomSearcher(searcherName);
                }
            });
        }
    }

    public void search(String filter, Type reqType) {
        this.search(filter, reqType, false, false);
    }

    public void search(String filter, Type reqType, boolean setToolbar, boolean inverse) {
        this.search(filter, reqType, null, setToolbar, inverse);
    }

    public void search(String filter, Type reqType, String customSearcherName, boolean setToolbar, boolean inverse) {
        this.searchPanel.resetSearchResults();
        this.search(filter, this.searchPanel, reqType, customSearcherName, setToolbar, inverse, null, -1, -1, true, this.getSearchParam().getMaximumSearchResultsGUI());
    }

    public void search(String filter, SearchListenner listenner, Type reqType, boolean setToolbar, boolean inverse) {
        this.search(filter, listenner, reqType, setToolbar, inverse, null, -1, -1);
    }

    public void search(String filter, SearchListenner listenner, Type reqType, boolean setToolbar, boolean inverse, String baseUrl, int start, int count) {
        this.search(filter, listenner, reqType, setToolbar, inverse, baseUrl, start, count, true);
    }

    public void search(String filter, SearchListenner listenner, Type reqType, boolean setToolbar, boolean inverse, String baseUrl, int start, int count, boolean searchAllOccurrences) {
        this.search(filter, listenner, reqType, setToolbar, inverse, baseUrl, start, count, searchAllOccurrences, -1);
    }

    public void search(String filter, SearchListenner listenner, Type reqType, boolean setToolbar, boolean inverse, String baseUrl, int start, int count, boolean searchAllOccurrences, int maxOccurrences) {
        this.search(filter, listenner, reqType, null, setToolbar, inverse, baseUrl, start, count, searchAllOccurrences, maxOccurrences);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(String filter, SearchListenner listenner, Type reqType, String customSearcherName, boolean setToolbar, boolean inverse, String baseUrl, int start, int count, boolean searchAllOccurrences, int maxOccurrences) {
        if (setToolbar) {
            this.getSearchPanel().searchFocus();
            this.getSearchPanel().getRegExField().setText(filter);
            this.getSearchPanel().setSearchType(reqType);
        }
        ExtensionSearch extensionSearch = this;
        synchronized (extensionSearch) {
            if (this.searchThread != null && this.searchThread.isAlive()) {
                this.searchThread.stopSearch();
                while (this.searchThread.isAlive()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.searchThread = new SearchThread(filter, reqType, customSearcherName, listenner, inverse, this.searchJustInScope, baseUrl, start, count, searchAllOccurrences, maxOccurrences);
            this.searchThread.setCustomSearchers(this.customSearchers);
            this.searchThread.start();
        }
    }

    private JMenu getSearchMenu() {
        if (this.searchMenu == null) {
            this.searchMenu = new JMenu(Constant.messages.getString("menu.edit.search"));
            this.searchMenu.add(this.getMenuItemSearch());
            this.searchMenu.add(this.getMenuItemNext());
            this.searchMenu.add(this.getMenuItemPrev());
        }
        return this.searchMenu;
    }

    private ZapMenuItem getMenuItemSearch() {
        if (this.menuItemSearch == null) {
            this.menuItemSearch = new ZapMenuItem("menu.edit.search.item", this.getView().getMenuShortcutKeyStroke(72, 0, false));
            this.menuItemSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtensionSearch.this.searchPanel.searchFocus();
                }
            });
        }
        return this.menuItemSearch;
    }

    private ZapMenuItem getMenuItemNext() {
        if (this.menuItemNext == null) {
            this.menuItemNext = new ZapMenuItem("menu.edit.search.next.item", this.getView().getMenuShortcutKeyStroke(71, 0, false));
            this.menuItemNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtensionSearch.this.searchPanel.highlightNextResult();
                }
            });
        }
        return this.menuItemNext;
    }

    private ZapMenuItem getMenuItemPrev() {
        if (this.menuItemPrev == null) {
            this.menuItemPrev = new ZapMenuItem("menu.edit.search.previous.item", this.getView().getMenuShortcutKeyStroke(71, 64, false));
            this.menuItemPrev.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtensionSearch.this.searchPanel.highlightPrevResult();
                }
            });
        }
        return this.menuItemPrev;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("search.desc");
    }

    public void setSearchJustInScope(boolean searchJustInScope) {
        this.searchJustInScope = searchJustInScope;
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    private class ViewSessionChangedListener
    implements SessionChangedListener {
        private ViewSessionChangedListener() {
        }

        @Override
        public void sessionAboutToChange(Session session) {
        }

        @Override
        public void sessionScopeChanged(Session session) {
        }

        @Override
        public void sessionChanged(final Session session) {
            if (EventQueue.isDispatchThread()) {
                ExtensionSearch.this.getSearchPanel().reset();
                return;
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ViewSessionChangedListener.this.sessionChanged(session);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void sessionModeChanged(Control.Mode mode) {
        }
    }

    public static enum Type {
        All,
        URL,
        Request,
        Response,
        Header,
        Tag,
        Note,
        Custom;

    }
}

