#!perl

use v5.10;
use Test::More;

use CVSS::v3;

while (my $line = <DATA>) {

    chomp($line);

    my ($base_score, $vector_string) = split /\t/, $line;

    my $cvss = CVSS::v3->from_vector_string($vector_string);

    cmp_ok($cvss->base_score,       '==', $base_score,    "$base_score --> $vector_string");
    cmp_ok($cvss->to_vector_string, 'eq', $vector_string, "$vector_string");

}

done_testing();

__DATA__
0.0	CVSS:3.0/AV:L/AC:H/PR:H/UI:R/S:U/C:N/I:N/A:N
0.0	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:N/I:N/A:N
0.0	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:N
0.0	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:N
0.0	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:N/I:N/A:N
0.0	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:N
0.0	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:N
0.0	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:N
1.6	CVSS:3.1/AV:P/AC:H/PR:H/UI:N/S:U/C:L/I:N/A:N
1.8	CVSS:3.0/AV:L/AC:H/PR:H/UI:R/S:U/C:N/I:L/A:N
1.8	CVSS:3.0/AV:L/AC:H/PR:H/UI:R/S:U/C:N/I:N/A:L
1.8	CVSS:3.1/AV:A/AC:H/PR:H/UI:R/S:U/C:N/I:N/A:L
1.8	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:U/C:L/I:N/A:N
1.8	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:U/C:N/I:L/A:N
1.8	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:U/C:N/I:N/A:L
1.8	CVSS:3.1/AV:P/AC:L/PR:H/UI:N/S:U/C:L/I:N/A:N
1.9	CVSS:3.0/AV:L/AC:H/PR:H/UI:N/S:U/C:L/I:N/A:N
1.9	CVSS:3.0/AV:L/AC:H/PR:H/UI:N/S:U/C:N/I:L/A:N
1.9	CVSS:3.0/AV:P/AC:L/PR:L/UI:R/S:U/C:L/I:N/A:N
1.9	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:U/C:L/I:N/A:N
1.9	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:U/C:N/I:N/A:L
2.0	CVSS:3.0/AV:N/AC:H/PR:H/UI:R/S:U/C:L/I:N/A:N
2.0	CVSS:3.0/AV:N/AC:H/PR:H/UI:R/S:U/C:N/I:L/A:N
2.0	CVSS:3.0/AV:P/AC:H/PR:N/UI:N/S:U/C:L/I:N/A:N
2.0	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:U/C:L/I:N/A:N
2.0	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:U/C:N/I:L/A:N
2.0	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:U/C:L/I:N/A:N
2.0	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:U/C:N/I:L/A:N
2.0	CVSS:3.1/AV:P/AC:H/PR:N/UI:N/S:U/C:N/I:L/A:N
2.0	CVSS:3.1/AV:P/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:L
2.1	CVSS:3.0/AV:P/AC:L/PR:L/UI:N/S:U/C:L/I:N/A:N
2.1	CVSS:3.0/AV:P/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:N
2.1	CVSS:3.0/AV:P/AC:L/PR:N/UI:R/S:U/C:L/I:N/A:N
2.1	CVSS:3.1/AV:P/AC:L/PR:L/UI:N/S:U/C:L/I:N/A:N
2.1	CVSS:3.1/AV:P/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:L
2.1	CVSS:3.1/AV:P/AC:L/PR:N/UI:R/S:U/C:L/I:N/A:N
2.2	CVSS:3.0/AV:L/AC:H/PR:L/UI:R/S:U/C:L/I:N/A:N
2.2	CVSS:3.0/AV:N/AC:H/PR:H/UI:N/S:U/C:N/I:L/A:N
2.2	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:U/C:L/I:N/A:N
2.2	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:U/C:N/I:L/A:N
2.2	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:L/I:N/A:N
2.2	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:N/I:L/A:N
2.2	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:N/I:N/A:L
2.3	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:U/C:L/I:N/A:N
2.3	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:U/C:N/I:L/A:N
2.3	CVSS:3.1/AV:A/AC:H/PR:L/UI:R/S:U/C:L/I:N/A:N
2.3	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:L/I:N/A:N
2.3	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:N/I:L/A:N
2.3	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:N/I:N/A:L
2.4	CVSS:3.0/AV:A/AC:L/PR:H/UI:N/S:U/C:L/I:N/A:N
2.4	CVSS:3.0/AV:N/AC:L/PR:H/UI:R/S:U/C:L/I:N/A:N
2.4	CVSS:3.0/AV:P/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:N
2.4	CVSS:3.0/AV:P/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:N
2.4	CVSS:3.0/AV:P/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:L
2.4	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:U/C:L/I:N/A:N
2.4	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:U/C:N/I:N/A:L
2.4	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:L/I:N/A:N
2.4	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:N/I:L/A:N
2.4	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:N/I:N/A:L
2.4	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:N
2.4	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:N
2.4	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:L
2.5	CVSS:3.0/AV:L/AC:H/PR:H/UI:N/S:C/C:L/I:N/A:N
2.5	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:U/C:L/I:N/A:N
2.5	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:L/A:N
2.5	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:N/A:L
2.5	CVSS:3.0/AV:L/AC:H/PR:N/UI:R/S:U/C:L/I:N/A:N
2.5	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:C/C:N/I:N/A:L
2.5	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:L/I:N/A:N
2.5	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:L/A:N
2.5	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:N/A:L
2.5	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:C/C:L/I:N/A:N
2.5	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:C/C:N/I:L/A:N
2.5	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:U/C:L/I:N/A:N
2.5	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:U/C:N/I:L/A:N
2.5	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:U/C:N/I:N/A:L
2.6	CVSS:3.0/AV:A/AC:H/PR:H/UI:N/S:C/C:L/I:N/A:N
2.6	CVSS:3.0/AV:A/AC:H/PR:L/UI:N/S:U/C:L/I:N/A:N
2.6	CVSS:3.0/AV:A/AC:H/PR:N/UI:R/S:U/C:L/I:N/A:N
2.6	CVSS:3.0/AV:N/AC:H/PR:H/UI:R/S:C/C:L/I:N/A:N
2.6	CVSS:3.1/AV:A/AC:H/PR:N/UI:R/S:U/C:L/I:N/A:N
2.6	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:C/C:L/I:N/A:N
2.6	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:U/C:L/I:N/A:N
2.6	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:U/C:N/I:L/A:N
2.6	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:U/C:N/I:N/A:L
2.7	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:L/I:N/A:N
2.7	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:N/I:L/A:N
2.7	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:N/I:N/A:L
2.7	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:C/C:L/I:N/A:N
2.7	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:L/I:N/A:N
2.7	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:N/I:L/A:N
2.7	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:N/I:N/A:L
2.7	CVSS:3.1/AV:P/AC:H/PR:H/UI:R/S:U/C:L/I:L/A:N
2.8	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:C/C:N/I:L/A:N
2.8	CVSS:3.0/AV:L/AC:L/PR:H/UI:R/S:C/C:N/I:L/A:N
2.8	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:U/C:L/I:N/A:N
2.8	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:U/C:N/I:L/A:N
2.8	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:C/C:L/I:N/A:N
2.8	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:C/C:N/I:N/A:L
2.8	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:L/I:N/A:N
2.8	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:N/I:L/A:N
2.8	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:N/I:N/A:L
2.9	CVSS:3.0/AV:L/AC:H/PR:N/UI:N/S:U/C:L/I:N/A:N
2.9	CVSS:3.0/AV:L/AC:H/PR:N/UI:N/S:U/C:N/I:L/A:N
2.9	CVSS:3.0/AV:P/AC:H/PR:L/UI:N/S:U/C:L/I:L/A:N
2.9	CVSS:3.1/AV:A/AC:H/PR:H/UI:R/S:U/C:L/I:N/A:L
2.9	CVSS:3.1/AV:L/AC:H/PR:N/UI:N/S:U/C:L/I:N/A:N
2.9	CVSS:3.1/AV:L/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:L
2.9	CVSS:3.1/AV:P/AC:L/PR:H/UI:N/S:U/C:L/I:L/A:N
3.0	CVSS:3.0/AV:L/AC:H/PR:H/UI:N/S:U/C:N/I:L/A:L
3.0	CVSS:3.0/AV:N/AC:H/PR:L/UI:R/S:C/C:L/I:N/A:N
3.0	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:U/C:L/I:N/A:N
3.0	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:U/C:N/I:N/A:L
3.0	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:U/C:N/I:L/A:L
3.0	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:C/C:L/I:N/A:N
3.0	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:C/C:N/I:L/A:N
3.0	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:C/C:L/I:N/A:N
3.0	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:C/C:N/I:L/A:N
3.1	CVSS:3.0/AV:A/AC:H/PR:H/UI:N/S:U/C:L/I:N/A:L
3.1	CVSS:3.0/AV:A/AC:H/PR:N/UI:N/S:U/C:L/I:N/A:N
3.1	CVSS:3.0/AV:A/AC:H/PR:N/UI:N/S:U/C:N/I:L/A:N
3.1	CVSS:3.0/AV:A/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:L
3.1	CVSS:3.0/AV:L/AC:L/PR:H/UI:R/S:U/C:L/I:L/A:N
3.1	CVSS:3.0/AV:N/AC:H/PR:H/UI:R/S:U/C:L/I:L/A:N
3.1	CVSS:3.0/AV:N/AC:H/PR:H/UI:R/S:U/C:N/I:L/A:L
3.1	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:L/I:N/A:N
3.1	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:N/I:L/A:N
3.1	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:N/I:N/A:L
3.1	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:U/C:L/I:N/A:N
3.1	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:U/C:N/I:L/A:N
3.1	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:U/C:N/I:N/A:L
3.1	CVSS:3.0/AV:P/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:N
3.1	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:U/C:L/I:N/A:N
3.1	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:U/C:N/I:L/A:N
3.1	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:U/C:N/I:L/A:L
3.1	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:U/C:L/I:L/A:N
3.1	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:U/C:N/I:L/A:L
3.1	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:L/I:N/A:N
3.1	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:N/I:L/A:N
3.1	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:N/I:N/A:L
3.1	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:L/I:N/A:N
3.1	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:N/I:L/A:N
3.1	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:N/I:N/A:L
3.2	CVSS:3.1/AV:L/AC:H/PR:N/UI:N/S:C/C:L/I:N/A:N
3.2	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:L/I:N/A:N
3.2	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:N/I:L/A:N
3.2	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:N/I:N/A:L
3.2	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:C/C:N/I:L/A:N
3.2	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:C/C:N/I:N/A:L
3.2	CVSS:3.1/AV:P/AC:L/PR:N/UI:R/S:U/C:L/I:L/A:N
3.3	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:L/I:N/A:N
3.3	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:N
3.3	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:L
3.3	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:L/I:N/A:N
3.3	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:N/I:L/A:N
3.3	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:L
3.3	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:L/I:N/A:N
3.3	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:N
3.3	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:L
3.3	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:L/I:N/A:N
3.3	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:N/I:L/A:N
3.3	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:L
3.3	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:L/I:L/A:N
3.3	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:L/I:N/A:L
3.3	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:N/I:L/A:L
3.4	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:U/C:L/I:L/A:N
3.4	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:C/C:L/I:N/A:N
3.4	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:C/C:N/I:N/A:L
3.4	CVSS:3.0/AV:N/AC:L/PR:H/UI:R/S:C/C:L/I:N/A:N
3.4	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:L/I:L/A:N
3.4	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:N/I:L/A:L
3.4	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:C/C:L/I:N/A:N
3.4	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:C/C:N/I:L/A:N
3.4	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:C/C:L/I:N/A:N
3.4	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:C/C:N/I:L/A:N
3.4	CVSS:3.1/AV:P/AC:H/PR:N/UI:R/S:C/C:L/I:L/A:N
3.5	CVSS:3.0/AV:A/AC:L/PR:L/UI:N/S:U/C:L/I:N/A:N
3.5	CVSS:3.0/AV:A/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:L
3.5	CVSS:3.0/AV:A/AC:L/PR:N/UI:R/S:U/C:L/I:N/A:N
3.5	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:C/C:L/I:N/A:N
3.5	CVSS:3.0/AV:N/AC:L/PR:H/UI:R/S:U/C:L/I:L/A:N
3.5	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:L/I:N/A:N
3.5	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:N/I:L/A:N
3.5	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:N/I:N/A:L
3.5	CVSS:3.0/AV:P/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:N
3.5	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:L/I:N/A:N
3.5	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:N
3.5	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:L
3.5	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:U/C:L/I:N/A:N
3.5	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:U/C:N/I:L/A:N
3.5	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:L
3.5	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:C/C:L/I:N/A:N
3.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:L/I:L/A:N
3.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:L/I:N/A:L
3.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:N/I:L/A:L
3.5	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:L/I:N/A:N
3.5	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:N/I:L/A:N
3.5	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:N/I:N/A:L
3.5	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:N
3.5	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:L
3.6	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:U/C:L/I:L/A:N
3.6	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:L/I:L/A:N
3.6	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:L/I:N/A:L
3.6	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:L/A:L
3.6	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:U/C:N/I:L/A:L
3.6	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:C/C:L/I:N/A:N
3.6	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:C/C:N/I:L/A:N
3.7	CVSS:3.0/AV:A/AC:H/PR:N/UI:R/S:U/C:L/I:L/A:N
3.7	CVSS:3.0/AV:L/AC:H/PR:H/UI:R/S:C/C:L/I:L/A:N
3.7	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:N/A:N
3.7	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:L/A:N
3.7	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:L
3.7	CVSS:3.0/AV:P/AC:L/PR:H/UI:N/S:U/C:L/I:L/A:L
3.7	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:C/C:L/I:L/A:N
3.7	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:U/C:L/I:L/A:N
3.7	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:U/C:L/I:N/A:L
3.7	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:N/A:N
3.7	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:L/A:N
3.7	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:L
3.8	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:C/C:L/I:N/A:N
3.8	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:L/I:L/A:N
3.8	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:C/C:L/I:N/A:N
3.8	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:U/C:L/I:L/A:L
3.8	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:L/I:N/A:N
3.8	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:N/I:L/A:N
3.8	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:N/I:N/A:L
3.8	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:L/I:L/A:N
3.8	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:L/I:N/A:L
3.8	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:N/I:L/A:L
3.8	CVSS:3.1/AV:P/AC:H/PR:H/UI:N/S:U/C:H/I:N/A:N
3.8	CVSS:3.1/AV:P/AC:H/PR:N/UI:R/S:U/C:L/I:L/A:L
3.9	CVSS:3.0/AV:L/AC:H/PR:H/UI:N/S:U/C:L/I:L/A:L
3.9	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:U/C:N/I:L/A:L
3.9	CVSS:3.0/AV:P/AC:L/PR:H/UI:N/S:U/C:H/I:N/A:N
3.9	CVSS:3.0/AV:P/AC:L/PR:H/UI:N/S:U/C:N/I:H/A:N
3.9	CVSS:3.0/AV:P/AC:L/PR:H/UI:N/S:U/C:N/I:N/A:H
3.9	CVSS:3.0/AV:P/AC:L/PR:L/UI:R/S:U/C:L/I:L/A:L
3.9	CVSS:3.1/AV:A/AC:H/PR:H/UI:N/S:U/C:L/I:L/A:L
3.9	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:C/C:L/I:L/A:N
3.9	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:C/C:L/I:N/A:L
3.9	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:C/C:N/I:L/A:L
3.9	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:U/C:L/I:L/A:L
3.9	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:C/C:N/I:L/A:L
3.9	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:L/I:L/A:N
3.9	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:N/I:L/A:L
3.9	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:U/C:L/I:L/A:L
3.9	CVSS:3.1/AV:P/AC:H/PR:L/UI:R/S:U/C:H/I:N/A:N
3.9	CVSS:3.1/AV:P/AC:L/PR:H/UI:N/S:U/C:H/I:N/A:N
3.9	CVSS:3.1/AV:P/AC:L/PR:H/UI:N/S:U/C:N/I:H/A:N
3.9	CVSS:3.1/AV:P/AC:L/PR:H/UI:N/S:U/C:N/I:N/A:H
3.9	CVSS:3.1/AV:P/AC:L/PR:L/UI:R/S:U/C:L/I:L/A:L
4.0	CVSS:3.0/AV:L/AC:H/PR:H/UI:R/S:U/C:H/I:N/A:N
4.0	CVSS:3.0/AV:L/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:N
4.0	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:N
4.0	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:N
4.0	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:L
4.0	CVSS:3.0/AV:N/AC:H/PR:H/UI:R/S:C/C:L/I:L/A:N
4.0	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:C/C:L/I:N/A:N
4.0	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:C/C:N/I:L/A:N
4.0	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:C/C:N/I:N/A:L
4.0	CVSS:3.0/AV:P/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:N
4.0	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:U/C:H/I:N/A:N
4.0	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:U/C:N/I:H/A:N
4.0	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:U/C:N/I:N/A:H
4.0	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:U/C:L/I:L/A:L
4.0	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:N
4.0	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:N
4.0	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:L
4.0	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:C/C:L/I:L/A:N
4.0	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:C/C:N/I:L/A:L
4.0	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:N/I:L/A:N
4.0	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:N/I:N/A:L
4.0	CVSS:3.1/AV:P/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:N
4.0	CVSS:3.1/AV:P/AC:H/PR:N/UI:R/S:U/C:H/I:N/A:N
4.0	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:C/C:L/I:N/A:L
4.1	CVSS:3.0/AV:A/AC:L/PR:L/UI:N/S:C/C:L/I:N/A:N
4.1	CVSS:3.0/AV:A/AC:L/PR:L/UI:N/S:C/C:N/I:L/A:N
4.1	CVSS:3.0/AV:L/AC:H/PR:H/UI:N/S:U/C:H/I:N/A:N
4.1	CVSS:3.0/AV:L/AC:H/PR:H/UI:N/S:U/C:N/I:H/A:N
4.1	CVSS:3.0/AV:L/AC:H/PR:H/UI:N/S:U/C:N/I:N/A:H
4.1	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:C/C:L/I:N/A:N
4.1	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:C/C:L/I:N/A:N
4.1	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:C/C:N/I:L/A:N
4.1	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:C/C:L/I:N/A:N
4.1	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:C/C:N/I:L/A:N
4.1	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:U/C:L/I:L/A:N
4.1	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:U/C:H/I:N/A:N
4.1	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:U/C:N/I:H/A:N
4.1	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:U/C:N/I:N/A:H
4.1	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:C/C:L/I:L/A:N
4.1	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:L/I:L/A:L
4.1	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:L/I:N/A:N
4.1	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:N/I:L/A:N
4.1	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:L/I:N/A:N
4.1	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:N/I:L/A:N
4.1	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:N/I:N/A:L
4.1	CVSS:3.1/AV:P/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:L
4.1	CVSS:3.1/AV:P/AC:L/PR:L/UI:R/S:U/C:H/I:N/A:N
4.1	CVSS:3.1/AV:P/AC:L/PR:L/UI:R/S:U/C:N/I:H/A:N
4.1	CVSS:3.1/AV:P/AC:L/PR:N/UI:R/S:U/C:L/I:L/A:L
4.2	CVSS:3.0/AV:A/AC:H/PR:H/UI:N/S:U/C:N/I:H/A:N
4.2	CVSS:3.0/AV:A/AC:H/PR:H/UI:N/S:U/C:N/I:N/A:H
4.2	CVSS:3.0/AV:A/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:N
4.2	CVSS:3.0/AV:L/AC:H/PR:L/UI:R/S:U/C:L/I:L/A:L
4.2	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:U/C:L/I:L/A:L
4.2	CVSS:3.0/AV:L/AC:L/PR:H/UI:R/S:U/C:N/I:N/A:H
4.2	CVSS:3.0/AV:N/AC:H/PR:H/UI:R/S:U/C:H/I:N/A:N
4.2	CVSS:3.0/AV:N/AC:H/PR:H/UI:R/S:U/C:N/I:H/A:N
4.2	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:L/I:L/A:N
4.2	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:U/C:L/I:L/A:N
4.2	CVSS:3.0/AV:P/AC:H/PR:N/UI:N/S:U/C:H/I:N/A:N
4.2	CVSS:3.1/AV:A/AC:H/PR:H/UI:N/S:U/C:H/I:N/A:N
4.2	CVSS:3.1/AV:A/AC:H/PR:H/UI:N/S:U/C:N/I:N/A:H
4.2	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:N
4.2	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:C/C:L/I:L/A:N
4.2	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:U/C:L/I:L/A:L
4.2	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:L/I:L/A:L
4.2	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:C/C:L/I:L/A:N
4.2	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:U/C:H/I:N/A:N
4.2	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:U/C:N/I:H/A:N
4.2	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:U/C:N/I:N/A:H
4.2	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:U/C:H/I:N/A:N
4.2	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:U/C:N/I:H/A:N
4.2	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:U/C:N/I:N/A:H
4.2	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:L/I:L/A:N
4.2	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:L/I:N/A:L
4.2	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:N/I:L/A:L
4.2	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:L/I:L/A:N
4.2	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:L/I:N/A:L
4.2	CVSS:3.1/AV:P/AC:H/PR:N/UI:N/S:U/C:H/I:N/A:N
4.2	CVSS:3.1/AV:P/AC:H/PR:N/UI:N/S:U/C:N/I:H/A:N
4.2	CVSS:3.1/AV:P/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H
4.3	CVSS:3.0/AV:A/AC:L/PR:H/UI:R/S:C/C:L/I:L/A:N
4.3	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:N
4.3	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:N
4.3	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:L
4.3	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:C/C:L/I:N/A:N
4.3	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:C/C:N/I:N/A:L
4.3	CVSS:3.0/AV:N/AC:L/PR:H/UI:R/S:U/C:L/I:L/A:L
4.3	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:N/A:N
4.3	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:N
4.3	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:L
4.3	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:L/I:N/A:N
4.3	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:L/A:N
4.3	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:L
4.3	CVSS:3.0/AV:P/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:N
4.3	CVSS:3.0/AV:P/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:N
4.3	CVSS:3.0/AV:P/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H
4.3	CVSS:3.0/AV:P/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:L
4.3	CVSS:3.0/AV:P/AC:L/PR:N/UI:R/S:U/C:H/I:N/A:N
4.3	CVSS:3.1/AV:A/AC:H/PR:L/UI:R/S:U/C:L/I:L/A:L
4.3	CVSS:3.1/AV:A/AC:L/PR:H/UI:R/S:C/C:L/I:L/A:N
4.3	CVSS:3.1/AV:A/AC:L/PR:H/UI:R/S:U/C:H/I:N/A:N
4.3	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:N
4.3	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:N
4.3	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:L
4.3	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:C/C:L/I:N/A:N
4.3	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:C/C:N/I:L/A:N
4.3	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:C/C:N/I:N/A:L
4.3	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:L/I:L/A:L
4.3	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:N/A:N
4.3	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:N
4.3	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:L
4.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:L/I:N/A:N
4.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:L/A:N
4.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:L
4.3	CVSS:3.1/AV:P/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:N
4.3	CVSS:3.1/AV:P/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:N
4.3	CVSS:3.1/AV:P/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H
4.3	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:L
4.3	CVSS:3.1/AV:P/AC:L/PR:N/UI:R/S:U/C:H/I:N/A:N
4.3	CVSS:3.1/AV:P/AC:L/PR:N/UI:R/S:U/C:N/I:H/A:N
4.3	CVSS:3.1/AV:P/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:H
4.4	CVSS:3.0/AV:A/AC:H/PR:L/UI:N/S:C/C:L/I:L/A:N
4.4	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:U/C:H/I:N/A:N
4.4	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:U/C:N/I:H/A:N
4.4	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:U/C:N/I:N/A:H
4.4	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:N
4.4	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:L
4.4	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:L/I:L/A:N
4.4	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:N/I:L/A:L
4.4	CVSS:3.0/AV:N/AC:H/PR:H/UI:N/S:U/C:H/I:N/A:N
4.4	CVSS:3.0/AV:N/AC:H/PR:H/UI:N/S:U/C:N/I:H/A:N
4.4	CVSS:3.0/AV:N/AC:H/PR:H/UI:N/S:U/C:N/I:N/A:H
4.4	CVSS:3.0/AV:N/AC:H/PR:L/UI:R/S:C/C:L/I:L/A:N
4.4	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:U/C:H/I:N/A:N
4.4	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:U/C:N/I:H/A:N
4.4	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:U/C:N/I:N/A:H
4.4	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:H/I:N/A:N
4.4	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:N/I:H/A:N
4.4	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:N/I:N/A:H
4.4	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:N
4.4	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:L/I:N/A:L
4.4	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:L
4.4	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:L/I:L/A:N
4.4	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:L/I:N/A:L
4.4	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:N/I:L/A:L
4.4	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:C/C:L/I:L/A:N
4.4	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:H/I:N/A:N
4.4	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:N/I:H/A:N
4.4	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:N/I:N/A:H
4.4	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:C/C:L/I:L/A:N
4.4	CVSS:3.1/AV:P/AC:H/PR:H/UI:N/S:C/C:L/I:L/A:L
4.5	CVSS:3.0/AV:A/AC:L/PR:H/UI:N/S:U/C:H/I:N/A:N
4.5	CVSS:3.0/AV:A/AC:L/PR:H/UI:N/S:U/C:N/I:N/A:H
4.5	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:U/C:L/I:L/A:L
4.5	CVSS:3.0/AV:L/AC:H/PR:N/UI:R/S:U/C:L/I:L/A:L
4.5	CVSS:3.0/AV:N/AC:L/PR:H/UI:R/S:U/C:H/I:N/A:N
4.5	CVSS:3.0/AV:N/AC:L/PR:H/UI:R/S:U/C:N/I:N/A:H
4.5	CVSS:3.0/AV:P/AC:H/PR:L/UI:R/S:U/C:H/I:L/A:N
4.5	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:U/C:H/I:N/A:N
4.5	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:U/C:N/I:H/A:N
4.5	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:U/C:N/I:N/A:H
4.5	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:L/I:L/A:L
4.5	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:U/C:L/I:L/A:L
4.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:H/I:N/A:N
4.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:N/I:H/A:N
4.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:N/I:N/A:H
4.6	CVSS:3.0/AV:A/AC:H/PR:L/UI:N/S:U/C:L/I:L/A:L
4.6	CVSS:3.0/AV:A/AC:L/PR:N/UI:R/S:U/C:L/I:L/A:N
4.6	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:C/C:N/I:L/A:L
4.6	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:L/I:L/A:N
4.6	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:L/I:N/A:L
4.6	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:N/I:L/A:L
4.6	CVSS:3.0/AV:P/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:L
4.6	CVSS:3.0/AV:P/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
4.6	CVSS:3.0/AV:P/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:N
4.6	CVSS:3.0/AV:P/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H
4.6	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:N
4.6	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:L
4.6	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:L/I:L/A:N
4.6	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:N/I:L/A:L
4.6	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:C/C:L/I:L/A:N
4.6	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:C/C:L/I:N/A:L
4.6	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:U/C:L/I:L/A:L
4.6	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:L/I:L/A:N
4.6	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:L/I:N/A:L
4.6	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:N/I:L/A:L
4.6	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
4.6	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:N
4.6	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H
4.7	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:C/C:N/I:L/A:N
4.7	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:C/C:N/I:N/A:L
4.7	CVSS:3.0/AV:L/AC:H/PR:H/UI:N/S:U/C:N/I:L/A:H
4.7	CVSS:3.0/AV:L/AC:H/PR:H/UI:R/S:C/C:L/I:L/A:L
4.7	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:N
4.7	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:H/A:N
4.7	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:N/A:H
4.7	CVSS:3.0/AV:L/AC:H/PR:N/UI:R/S:U/C:H/I:N/A:N
4.7	CVSS:3.0/AV:L/AC:H/PR:N/UI:R/S:U/C:N/I:H/A:N
4.7	CVSS:3.0/AV:L/AC:H/PR:N/UI:R/S:U/C:N/I:N/A:H
4.7	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:C/C:L/I:L/A:N
4.7	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:L/I:L/A:L
4.7	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:N/A:N
4.7	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:C/C:N/I:L/A:N
4.7	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:C/C:N/I:N/A:L
4.7	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:C/C:L/I:N/A:N
4.7	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:C/C:N/I:L/A:N
4.7	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:C/C:N/I:N/A:L
4.7	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:U/C:H/I:L/A:N
4.7	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:U/C:N/I:L/A:H
4.7	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:C/C:L/I:L/A:L
4.7	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:N
4.7	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:H/A:N
4.7	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:N/A:H
4.7	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:U/C:H/I:N/A:N
4.7	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:U/C:N/I:H/A:N
4.7	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:U/C:N/I:N/A:H
4.7	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:C/C:L/I:L/A:N
4.7	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:C/C:L/I:N/A:L
4.7	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:L/I:L/A:L
4.7	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:N/A:N
4.7	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:N/I:L/A:N
4.8	CVSS:3.0/AV:A/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:N
4.8	CVSS:3.0/AV:A/AC:H/PR:N/UI:R/S:U/C:H/I:N/A:N
4.8	CVSS:3.0/AV:A/AC:L/PR:L/UI:R/S:C/C:L/I:L/A:N
4.8	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:U/C:L/I:L/A:L
4.8	CVSS:3.0/AV:N/AC:H/PR:H/UI:R/S:U/C:H/I:L/A:N
4.8	CVSS:3.0/AV:N/AC:H/PR:L/UI:R/S:U/C:N/I:N/A:H
4.8	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:N
4.8	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:L/A:L
4.8	CVSS:3.0/AV:N/AC:L/PR:H/UI:R/S:C/C:L/I:L/A:N
4.8	CVSS:3.0/AV:P/AC:H/PR:L/UI:N/S:C/C:H/I:N/A:N
4.8	CVSS:3.0/AV:P/AC:H/PR:N/UI:N/S:U/C:N/I:H/A:L
4.8	CVSS:3.1/AV:A/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:N
4.8	CVSS:3.1/AV:A/AC:H/PR:L/UI:N/S:U/C:N/I:H/A:N
4.8	CVSS:3.1/AV:A/AC:H/PR:L/UI:N/S:U/C:N/I:N/A:H
4.8	CVSS:3.1/AV:A/AC:H/PR:N/UI:R/S:U/C:H/I:N/A:N
4.8	CVSS:3.1/AV:A/AC:H/PR:N/UI:R/S:U/C:N/I:H/A:N
4.8	CVSS:3.1/AV:A/AC:H/PR:N/UI:R/S:U/C:N/I:N/A:H
4.8	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:C/C:L/I:L/A:N
4.8	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:C/C:L/I:L/A:N
4.8	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:U/C:L/I:H/A:N
4.8	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:L/I:L/A:L
4.8	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:U/C:H/I:N/A:N
4.8	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:U/C:N/I:H/A:N
4.8	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:U/C:N/I:N/A:H
4.8	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:N
4.8	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:N/A:L
4.8	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:L/A:L
4.8	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:C/C:L/I:L/A:N
4.8	CVSS:3.1/AV:P/AC:H/PR:L/UI:N/S:C/C:H/I:N/A:N
4.8	CVSS:3.1/AV:P/AC:H/PR:N/UI:N/S:U/C:N/I:L/A:H
4.9	CVSS:3.0/AV:L/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:L
4.9	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:C/C:L/I:L/A:N
4.9	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:C/C:L/I:N/A:L
4.9	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:H/I:N/A:N
4.9	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:N/I:H/A:N
4.9	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:N/I:N/A:H
4.9	CVSS:3.0/AV:P/AC:H/PR:N/UI:N/S:C/C:H/I:N/A:N
4.9	CVSS:3.1/AV:L/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:L
4.9	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:C/C:L/I:L/A:N
4.9	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:H/I:N/A:N
4.9	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:N/I:H/A:N
4.9	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:N/I:N/A:H
4.9	CVSS:3.1/AV:P/AC:H/PR:H/UI:R/S:U/C:L/I:L/A:H
4.9	CVSS:3.1/AV:P/AC:H/PR:N/UI:N/S:C/C:H/I:N/A:N
4.9	CVSS:3.1/AV:P/AC:L/PR:L/UI:N/S:U/C:H/I:L/A:N
4.9	CVSS:3.1/AV:P/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:L
4.9	CVSS:3.1/AV:P/AC:L/PR:N/UI:R/S:U/C:N/I:H/A:L
5.0	CVSS:3.0/AV:A/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:L
5.0	CVSS:3.0/AV:L/AC:H/PR:H/UI:N/S:C/C:L/I:L/A:L
5.0	CVSS:3.0/AV:L/AC:H/PR:H/UI:R/S:C/C:H/I:N/A:N
5.0	CVSS:3.0/AV:L/AC:H/PR:L/UI:R/S:C/C:L/I:L/A:L
5.0	CVSS:3.0/AV:L/AC:H/PR:L/UI:R/S:U/C:L/I:H/A:N
5.0	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:U/C:H/I:N/A:N
5.0	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:U/C:N/I:H/A:N
5.0	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:U/C:N/I:N/A:H
5.0	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:N
5.0	CVSS:3.0/AV:N/AC:H/PR:H/UI:N/S:U/C:N/I:L/A:H
5.0	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:L/I:L/A:L
5.0	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:U/C:L/I:L/A:L
5.0	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:L/I:N/A:N
5.0	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:N/I:L/A:N
5.0	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:N/I:N/A:L
5.0	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:C/C:L/I:L/A:L
5.0	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:C/C:N/I:H/A:N
5.0	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:C/C:N/I:N/A:H
5.0	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:C/C:L/I:L/A:L
5.0	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:U/C:N/I:H/A:L
5.0	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:H/I:N/A:N
5.0	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:N/I:H/A:N
5.0	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:N/I:N/A:H
5.0	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:N
5.0	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:C/C:N/I:L/A:L
5.0	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:N/I:L/A:H
5.0	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:L/I:L/A:L
5.0	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:L/I:L/A:L
5.0	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:L/I:N/A:N
5.0	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:N/I:L/A:N
5.0	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:N/I:N/A:L
5.0	CVSS:3.1/AV:P/AC:L/PR:H/UI:N/S:U/C:L/I:L/A:H
5.1	CVSS:3.0/AV:L/AC:H/PR:H/UI:R/S:U/C:L/I:L/A:H
5.1	CVSS:3.0/AV:L/AC:H/PR:N/UI:N/S:U/C:H/I:N/A:N
5.1	CVSS:3.0/AV:L/AC:H/PR:N/UI:N/S:U/C:N/I:H/A:N
5.1	CVSS:3.0/AV:L/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H
5.1	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:U/C:H/I:L/A:N
5.1	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:U/C:L/I:N/A:H
5.1	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:U/C:N/I:L/A:H
5.1	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:N
5.1	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:L
5.1	CVSS:3.1/AV:A/AC:H/PR:H/UI:R/S:U/C:H/I:L/A:L
5.1	CVSS:3.1/AV:L/AC:H/PR:N/UI:N/S:U/C:H/I:N/A:N
5.1	CVSS:3.1/AV:L/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H
5.1	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:H/I:L/A:N
5.1	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:H/I:N/A:L
5.1	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:L/I:H/A:N
5.1	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:L/I:N/A:H
5.1	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:N/I:H/A:L
5.1	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:N/I:L/A:H
5.1	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:N
5.1	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:L
5.1	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:L
5.1	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:C/C:L/I:L/A:L
5.2	CVSS:3.0/AV:A/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:N
5.2	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:C/C:L/I:N/A:L
5.2	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:U/C:H/I:N/A:L
5.2	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:U/C:L/I:H/A:N
5.2	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:U/C:H/I:N/A:N
5.2	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:U/C:N/I:H/A:N
5.2	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:U/C:N/I:N/A:H
5.2	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:N
5.2	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:C/C:L/I:L/A:L
5.2	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:C/C:L/I:L/A:L
5.2	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:L/I:L/A:N
5.2	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:L/I:N/A:L
5.2	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:N/I:L/A:L
5.2	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:H/I:L/A:N
5.2	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:L/I:H/A:N
5.2	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:H/I:L/A:N
5.2	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:L
5.2	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:L/I:H/A:N
5.2	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:L
5.2	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:H
5.3	CVSS:3.0/AV:A/AC:H/PR:N/UI:N/S:U/C:H/I:N/A:N
5.3	CVSS:3.0/AV:A/AC:H/PR:N/UI:N/S:U/C:N/I:H/A:N
5.3	CVSS:3.0/AV:A/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H
5.3	CVSS:3.0/AV:L/AC:H/PR:H/UI:N/S:C/C:H/I:N/A:N
5.3	CVSS:3.0/AV:L/AC:H/PR:H/UI:N/S:C/C:N/I:N/A:H
5.3	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:L/A:H
5.3	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:L
5.3	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:L/I:L/A:L
5.3	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:N
5.3	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:N/I:H/A:N
5.3	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:N/I:N/A:H
5.3	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:U/C:H/I:N/A:N
5.3	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:U/C:N/I:H/A:N
5.3	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:U/C:N/I:N/A:H
5.3	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:N
5.3	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:N
5.3	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:L
5.3	CVSS:3.0/AV:P/AC:L/PR:N/UI:N/S:C/C:H/I:N/A:N
5.3	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:U/C:H/I:N/A:N
5.3	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:U/C:N/I:H/A:N
5.3	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H
5.3	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:C/C:H/I:N/A:N
5.3	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:C/C:N/I:H/A:N
5.3	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:C/C:N/I:N/A:H
5.3	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:C/C:L/I:L/A:L
5.3	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:H/I:L/A:N
5.3	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:L/I:N/A:H
5.3	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:H/A:L
5.3	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:L/A:H
5.3	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:C/C:N/I:H/A:N
5.3	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:C/C:N/I:N/A:H
5.3	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:U/C:H/I:L/A:N
5.3	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:U/C:L/I:N/A:H
5.3	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:U/C:L/I:H/A:L
5.3	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:L
5.3	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:L/I:L/A:L
5.3	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:U/C:H/I:L/A:L
5.3	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:U/C:L/I:L/A:H
5.3	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:N
5.3	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:N/I:H/A:N
5.3	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:N/I:N/A:H
5.3	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:H/I:N/A:N
5.3	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:N/I:H/A:N
5.3	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:N/I:N/A:H
5.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:N
5.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:N
5.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:L
5.3	CVSS:3.1/AV:P/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:H
5.3	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:C/C:H/I:N/A:N
5.3	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:C/C:N/I:H/A:N
5.3	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:C/C:N/I:N/A:H
5.4	CVSS:3.0/AV:A/AC:H/PR:H/UI:N/S:C/C:H/I:N/A:N
5.4	CVSS:3.0/AV:A/AC:H/PR:H/UI:N/S:C/C:N/I:N/A:H
5.4	CVSS:3.0/AV:A/AC:H/PR:N/UI:R/S:U/C:H/I:N/A:L
5.4	CVSS:3.0/AV:A/AC:L/PR:L/UI:N/S:C/C:L/I:L/A:N
5.4	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:N
5.4	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:L
5.4	CVSS:3.0/AV:N/AC:H/PR:L/UI:R/S:U/C:H/I:N/A:L
5.4	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:C/C:L/I:L/A:N
5.4	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:N
5.4	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:N/A:L
5.4	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:L
5.4	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:C/C:L/I:L/A:N
5.4	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:L/I:L/A:N
5.4	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:L/A:L
5.4	CVSS:3.0/AV:P/AC:L/PR:L/UI:N/S:U/C:H/I:L/A:L
5.4	CVSS:3.1/AV:A/AC:H/PR:L/UI:N/S:U/C:H/I:L/A:N
5.4	CVSS:3.1/AV:A/AC:H/PR:N/UI:R/S:U/C:H/I:L/A:N
5.4	CVSS:3.1/AV:A/AC:H/PR:N/UI:R/S:U/C:L/I:H/A:N
5.4	CVSS:3.1/AV:A/AC:L/PR:H/UI:R/S:C/C:L/I:L/A:L
5.4	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:N
5.4	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:L
5.4	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:L
5.4	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:C/C:H/I:N/A:N
5.4	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:U/C:H/I:L/A:N
5.4	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:U/C:L/I:H/A:N
5.4	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:L/I:L/A:N
5.4	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:N/I:L/A:L
5.4	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:N
5.4	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:N/A:L
5.4	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:L
5.4	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:L/I:L/A:N
5.4	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:N/I:L/A:L
5.4	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:L/I:L/A:N
5.4	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:L/I:N/A:L
5.4	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:L/A:L
5.4	CVSS:3.1/AV:P/AC:H/PR:H/UI:N/S:U/C:H/I:H/A:N
5.5	CVSS:3.0/AV:A/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:L
5.5	CVSS:3.0/AV:L/AC:H/PR:N/UI:R/S:C/C:H/I:N/A:N
5.5	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:N
5.5	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:N
5.5	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H
5.5	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:N/A:N
5.5	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:N/I:H/A:N
5.5	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:H
5.5	CVSS:3.0/AV:N/AC:H/PR:H/UI:N/S:U/C:L/I:H/A:L
5.5	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:C/C:L/I:L/A:N
5.5	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:H/I:L/A:N
5.5	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:L/I:H/A:N
5.5	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:N/I:L/A:H
5.5	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:L/I:L/A:L
5.5	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:L
5.5	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:U/C:L/I:H/A:L
5.5	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:C/C:H/I:N/A:N
5.5	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:C/C:H/I:N/A:N
5.5	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:C/C:N/I:H/A:N
5.5	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:C/C:N/I:N/A:H
5.5	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:N
5.5	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:N
5.5	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H
5.5	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:N/A:N
5.5	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:N/I:H/A:N
5.5	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:H
5.5	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:C/C:L/I:L/A:L
5.5	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:L/I:H/A:L
5.5	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:L/I:L/A:H
5.5	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:C/C:L/I:L/A:L
5.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:L/I:L/A:N
5.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:N/I:L/A:L
5.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:H/I:L/A:N
5.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:H/I:N/A:L
5.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:L/I:H/A:N
5.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:L/I:N/A:H
5.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:N/I:L/A:H
5.5	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:L/I:L/A:L
5.5	CVSS:3.1/AV:P/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:N
5.6	CVSS:3.0/AV:A/AC:H/PR:H/UI:R/S:U/C:N/I:H/A:H
5.6	CVSS:3.0/AV:A/AC:H/PR:N/UI:R/S:C/C:H/I:N/A:N
5.6	CVSS:3.0/AV:L/AC:H/PR:H/UI:R/S:U/C:H/I:H/A:N
5.6	CVSS:3.0/AV:L/AC:H/PR:H/UI:R/S:U/C:N/I:H/A:H
5.6	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:C/C:H/I:N/A:N
5.6	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:C/C:N/I:H/A:N
5.6	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:C/C:N/I:N/A:H
5.6	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:L
5.6	CVSS:3.1/AV:A/AC:H/PR:N/UI:R/S:C/C:N/I:N/A:H
5.6	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:U/C:H/I:H/A:N
5.6	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:U/C:H/I:N/A:H
5.6	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:C/C:H/I:N/A:N
5.6	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:C/C:N/I:N/A:H
5.6	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:H/I:L/A:L
5.6	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:L/I:H/A:L
5.6	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:L/I:L/A:H
5.6	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:H/I:N/A:L
5.6	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:N/I:H/A:L
5.6	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:N/I:L/A:H
5.6	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:L
5.6	CVSS:3.1/AV:P/AC:H/PR:H/UI:R/S:U/C:H/I:H/A:L
5.6	CVSS:3.1/AV:P/AC:H/PR:L/UI:N/S:C/C:H/I:L/A:N
5.6	CVSS:3.1/AV:P/AC:H/PR:L/UI:N/S:C/C:L/I:H/A:N
5.6	CVSS:3.1/AV:P/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:H
5.6	CVSS:3.1/AV:P/AC:H/PR:N/UI:R/S:U/C:H/I:H/A:N
5.7	CVSS:3.0/AV:A/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:N
5.7	CVSS:3.0/AV:A/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H
5.7	CVSS:3.0/AV:A/AC:L/PR:N/UI:R/S:U/C:H/I:N/A:N
5.7	CVSS:3.0/AV:A/AC:L/PR:N/UI:R/S:U/C:N/I:H/A:N
5.7	CVSS:3.0/AV:A/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:H
5.7	CVSS:3.0/AV:L/AC:H/PR:H/UI:N/S:U/C:N/I:H/A:H
5.7	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:C/C:L/I:L/A:L
5.7	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:C/C:L/I:L/A:L
5.7	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:H/I:N/A:N
5.7	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:N/I:H/A:N
5.7	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:N/I:N/A:H
5.7	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:U/C:L/I:H/A:L
5.7	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:N
5.7	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:N
5.7	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H
5.7	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:U/C:H/I:N/A:N
5.7	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:U/C:N/I:H/A:N
5.7	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:H
5.7	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:U/C:H/I:H/A:N
5.7	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:U/C:H/I:N/A:H
5.7	CVSS:3.1/AV:L/AC:H/PR:N/UI:N/S:U/C:H/I:L/A:N
5.7	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:L/I:L/A:L
5.7	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:C/C:L/I:L/A:L
5.7	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:C/C:N/I:L/A:L
5.7	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:U/C:H/I:H/A:N
5.7	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:H/I:L/A:L
5.7	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:L/I:L/A:H
5.7	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:H/I:N/A:N
5.7	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:N/I:H/A:N
5.7	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:N/I:N/A:H
5.7	CVSS:3.1/AV:P/AC:H/PR:H/UI:N/S:U/C:H/I:L/A:H
5.7	CVSS:3.1/AV:P/AC:H/PR:N/UI:N/S:C/C:H/I:L/A:N
5.7	CVSS:3.1/AV:P/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:N
5.7	CVSS:3.1/AV:P/AC:H/PR:N/UI:N/S:U/C:H/I:N/A:H
5.7	CVSS:3.1/AV:P/AC:H/PR:N/UI:N/S:U/C:N/I:H/A:H
5.7	CVSS:3.1/AV:P/AC:L/PR:L/UI:R/S:U/C:H/I:H/A:N
5.7	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:H/I:L/A:L
5.7	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:H
5.8	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:U/C:L/I:H/A:L
5.8	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:U/C:L/I:L/A:H
5.8	CVSS:3.0/AV:L/AC:H/PR:N/UI:R/S:U/C:L/I:L/A:H
5.8	CVSS:3.0/AV:N/AC:H/PR:H/UI:N/S:C/C:H/I:N/A:N
5.8	CVSS:3.0/AV:N/AC:H/PR:H/UI:N/S:C/C:N/I:N/A:H
5.8	CVSS:3.0/AV:N/AC:H/PR:L/UI:R/S:C/C:N/I:H/A:N
5.8	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:L/I:N/A:N
5.8	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:L/A:N
5.8	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:N/A:L
5.8	CVSS:3.1/AV:A/AC:H/PR:L/UI:N/S:C/C:H/I:N/A:N
5.8	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:C/C:L/I:L/A:L
5.8	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:U/C:L/I:H/A:N
5.8	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:C/C:N/I:L/A:H
5.8	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:H/I:L/A:L
5.8	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:L/I:L/A:H
5.8	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:U/C:L/I:H/A:L
5.8	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:U/C:H/I:H/A:N
5.8	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:C/C:H/I:N/A:N
5.8	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:C/C:N/I:H/A:N
5.8	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:C/C:N/I:N/A:H
5.8	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:C/C:N/I:H/A:N
5.8	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:C/C:L/I:L/A:L
5.8	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:L/I:N/A:N
5.8	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:L/A:N
5.8	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:N/A:L
5.8	CVSS:3.1/AV:P/AC:L/PR:H/UI:N/S:U/C:L/I:H/A:H
5.9	CVSS:3.0/AV:L/AC:H/PR:N/UI:N/S:C/C:H/I:N/A:N
5.9	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:C/C:H/I:N/A:N
5.9	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:C/C:N/I:N/A:H
5.9	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:L
5.9	CVSS:3.0/AV:N/AC:H/PR:H/UI:N/S:U/C:H/I:H/A:N
5.9	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:H/I:L/A:N
5.9	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:L/I:N/A:H
5.9	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:N/I:L/A:H
5.9	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:N/A:N
5.9	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:H/A:N
5.9	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H
5.9	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:U/C:H/I:L/A:N
5.9	CVSS:3.0/AV:P/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:N
5.9	CVSS:3.1/AV:A/AC:H/PR:L/UI:N/S:U/C:L/I:H/A:L
5.9	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:U/C:H/I:L/A:N
5.9	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:U/C:L/I:H/A:N
5.9	CVSS:3.1/AV:A/AC:H/PR:N/UI:R/S:U/C:H/I:L/A:L
5.9	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:C/C:L/I:L/A:L
5.9	CVSS:3.1/AV:L/AC:H/PR:N/UI:N/S:C/C:H/I:N/A:N
5.9	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:C/C:H/I:N/A:N
5.9	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:C/C:N/I:H/A:N
5.9	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:C/C:N/I:N/A:H
5.9	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:L
5.9	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:H/I:H/A:N
5.9	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:H/I:N/A:H
5.9	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:N/I:H/A:H
5.9	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:H/I:L/A:N
5.9	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:L/I:N/A:H
5.9	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:N/I:H/A:L
5.9	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:N/I:L/A:H
5.9	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:U/C:H/I:L/A:L
5.9	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:U/C:L/I:H/A:L
5.9	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:N/A:N
5.9	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:H/A:N
5.9	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H
5.9	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:H/I:L/A:N
5.9	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:L/I:H/A:N
5.9	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:N/I:L/A:H
5.9	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:C/C:L/I:L/A:L
5.9	CVSS:3.1/AV:P/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:N
5.9	CVSS:3.1/AV:P/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:H
5.9	CVSS:3.1/AV:P/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:H
5.9	CVSS:3.1/AV:P/AC:L/PR:N/UI:R/S:U/C:N/I:H/A:H
6.0	CVSS:3.0/AV:L/AC:H/PR:L/UI:R/S:U/C:H/I:H/A:N
6.0	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:C/C:H/I:N/A:N
6.0	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:C/C:N/I:N/A:H
6.0	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:N
6.0	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:U/C:H/I:N/A:H
6.0	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:U/C:N/I:H/A:H
6.0	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:C/C:L/I:L/A:L
6.0	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:H/I:L/A:L
6.0	CVSS:3.0/AV:P/AC:H/PR:H/UI:R/S:U/C:H/I:H/A:H
6.0	CVSS:3.0/AV:P/AC:H/PR:N/UI:N/S:U/C:L/I:H/A:H
6.0	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:U/C:H/I:H/A:L
6.0	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:U/C:H/I:H/A:N
6.0	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:U/C:N/I:H/A:H
6.0	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:H/I:N/A:N
6.0	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:N/I:H/A:N
6.0	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:N/I:N/A:H
6.0	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:N
6.0	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:H/I:N/A:H
6.0	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:N/I:H/A:H
6.0	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:U/C:H/I:H/A:L
6.0	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:U/C:H/I:L/A:H
6.0	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:C/C:L/I:L/A:L
6.0	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:H/I:L/A:L
6.0	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:L/I:H/A:L
6.0	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:L/I:L/A:H
6.1	CVSS:3.0/AV:A/AC:H/PR:N/UI:N/S:C/C:H/I:N/A:N
6.1	CVSS:3.0/AV:A/AC:H/PR:N/UI:N/S:C/C:N/I:N/A:H
6.1	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:C/C:L/I:L/A:N
6.1	CVSS:3.0/AV:L/AC:H/PR:H/UI:N/S:C/C:H/I:L/A:N
6.1	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:L/A:N
6.1	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:L
6.1	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:L/I:H/A:N
6.1	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:L/I:N/A:H
6.1	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:H
6.1	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:L
6.1	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:L/A:N
6.1	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:L/I:H/A:N
6.1	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:L/I:N/A:H
6.1	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:C/C:H/I:N/A:N
6.1	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:C/C:N/I:H/A:N
6.1	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:C/C:N/I:N/A:H
6.1	CVSS:3.0/AV:N/AC:L/PR:H/UI:R/S:U/C:H/I:H/A:N
6.1	CVSS:3.0/AV:N/AC:L/PR:H/UI:R/S:U/C:N/I:H/A:H
6.1	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:N
6.1	CVSS:3.0/AV:P/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:N
6.1	CVSS:3.0/AV:P/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:H
6.1	CVSS:3.1/AV:A/AC:H/PR:L/UI:R/S:U/C:H/I:H/A:N
6.1	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:C/C:H/I:N/A:N
6.1	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:C/C:N/I:N/A:H
6.1	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:N
6.1	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:U/C:H/I:N/A:H
6.1	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:U/C:N/I:H/A:H
6.1	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:C/C:H/I:N/A:N
6.1	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:C/C:N/I:N/A:H
6.1	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:C/C:L/I:L/A:N
6.1	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:C/C:N/I:L/A:L
6.1	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:C/C:L/I:H/A:N
6.1	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:C/C:N/I:H/A:L
6.1	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:C/C:N/I:L/A:H
6.1	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:C/C:L/I:H/A:N
6.1	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:U/C:H/I:H/A:L
6.1	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:U/C:L/I:H/A:H
6.1	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:L/A:N
6.1	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:L
6.1	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:L/I:H/A:N
6.1	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:L/I:N/A:H
6.1	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:H
6.1	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:H/I:L/A:L
6.1	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:L/I:H/A:L
6.1	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:L/I:L/A:H
6.1	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:L
6.1	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:L/A:N
6.1	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:N/A:L
6.1	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:L/I:H/A:N
6.1	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:L/I:N/A:H
6.1	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:N/I:L/A:H
6.1	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:C/C:H/I:N/A:N
6.1	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:C/C:N/I:H/A:N
6.1	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:C/C:N/I:N/A:H
6.1	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:H/I:H/A:N
6.1	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:N/I:H/A:H
6.1	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:N
6.1	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:N/A:L
6.1	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:N/I:L/A:L
6.1	CVSS:3.1/AV:P/AC:H/PR:H/UI:N/S:U/C:H/I:H/A:H
6.1	CVSS:3.1/AV:P/AC:L/PR:H/UI:R/S:U/C:H/I:H/A:H
6.1	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:C/C:L/I:N/A:H
6.1	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:N
6.1	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:H
6.1	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:H
6.2	CVSS:3.0/AV:A/AC:L/PR:H/UI:N/S:C/C:H/I:N/A:N
6.2	CVSS:3.0/AV:A/AC:L/PR:H/UI:N/S:C/C:N/I:N/A:H
6.2	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
6.2	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:N
6.2	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H
6.2	CVSS:3.0/AV:N/AC:H/PR:H/UI:N/S:U/C:H/I:H/A:L
6.2	CVSS:3.0/AV:P/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:H
6.2	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:C/C:H/I:N/A:N
6.2	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:C/C:N/I:N/A:H
6.2	CVSS:3.1/AV:L/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:H
6.2	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
6.2	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:N
6.2	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H
6.2	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:H/I:H/A:L
6.2	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:L/I:H/A:H
6.2	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:C/C:H/I:N/A:N
6.2	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:C/C:N/I:H/A:N
6.2	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:C/C:N/I:N/A:H
6.2	CVSS:3.1/AV:P/AC:H/PR:L/UI:R/S:U/C:H/I:H/A:H
6.2	CVSS:3.1/AV:P/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:H
6.2	CVSS:3.1/AV:P/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:L
6.3	CVSS:3.0/AV:A/AC:H/PR:H/UI:R/S:U/C:H/I:H/A:H
6.3	CVSS:3.0/AV:A/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:L
6.3	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:L
6.3	CVSS:3.0/AV:L/AC:H/PR:H/UI:R/S:U/C:H/I:H/A:H
6.3	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:U/C:H/I:H/A:N
6.3	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:H
6.3	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:H/A:H
6.3	CVSS:3.0/AV:L/AC:H/PR:N/UI:R/S:U/C:H/I:H/A:N
6.3	CVSS:3.0/AV:L/AC:H/PR:N/UI:R/S:U/C:N/I:H/A:H
6.3	CVSS:3.0/AV:L/AC:L/PR:H/UI:R/S:C/C:L/I:H/A:N
6.3	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:C/C:L/I:L/A:L
6.3	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:C/C:H/I:N/A:N
6.3	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:C/C:N/I:H/A:N
6.3	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:C/C:N/I:N/A:H
6.3	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:C/C:H/I:N/A:N
6.3	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:C/C:N/I:N/A:H
6.3	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:L
6.3	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:H/I:L/A:N
6.3	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:L/I:H/A:N
6.3	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:L/I:L/A:L
6.3	CVSS:3.0/AV:P/AC:H/PR:L/UI:N/S:U/C:H/I:H/A:H
6.3	CVSS:3.0/AV:P/AC:H/PR:N/UI:R/S:U/C:H/I:H/A:H
6.3	CVSS:3.1/AV:A/AC:H/PR:H/UI:R/S:U/C:H/I:H/A:H
6.3	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:H/I:L/A:N
6.3	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:L
6.3	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:H
6.3	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:U/C:L/I:L/A:H
6.3	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:L
6.3	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:L
6.3	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:U/C:H/I:L/A:N
6.3	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:U/C:H/I:H/A:H
6.3	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:H/I:H/A:N
6.3	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:H
6.3	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:H/A:H
6.3	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:U/C:H/I:H/A:N
6.3	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:U/C:N/I:H/A:H
6.3	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:L
6.3	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:L/I:H/A:H
6.3	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:L/I:L/A:L
6.3	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:C/C:H/I:N/A:N
6.3	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:C/C:N/I:H/A:N
6.3	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:C/C:N/I:N/A:H
6.3	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:C/C:H/I:N/A:N
6.3	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:C/C:N/I:H/A:N
6.3	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:C/C:N/I:N/A:H
6.3	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:L
6.3	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:H/I:L/A:N
6.3	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:L/I:H/A:N
6.3	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:N/I:H/A:L
6.3	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:N/I:L/A:H
6.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:L/I:L/A:L
6.3	CVSS:3.1/AV:P/AC:H/PR:L/UI:N/S:U/C:H/I:H/A:H
6.3	CVSS:3.1/AV:P/AC:H/PR:N/UI:R/S:U/C:H/I:H/A:H
6.4	CVSS:3.0/AV:A/AC:H/PR:N/UI:N/S:U/C:L/I:H/A:L
6.4	CVSS:3.0/AV:L/AC:H/PR:H/UI:N/S:U/C:H/I:H/A:H
6.4	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:C/C:H/I:L/A:N
6.4	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:C/C:N/I:L/A:H
6.4	CVSS:3.0/AV:N/AC:H/PR:H/UI:R/S:U/C:H/I:H/A:H
6.4	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:H/I:L/A:L
6.4	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:L/I:L/A:H
6.4	CVSS:3.0/AV:N/AC:H/PR:L/UI:R/S:U/C:H/I:H/A:N
6.4	CVSS:3.0/AV:N/AC:H/PR:L/UI:R/S:U/C:H/I:N/A:H
6.4	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:L/I:L/A:N
6.4	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:L/I:N/A:L
6.4	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:N/I:L/A:L
6.4	CVSS:3.0/AV:P/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H
6.4	CVSS:3.1/AV:A/AC:H/PR:H/UI:N/S:U/C:H/I:H/A:H
6.4	CVSS:3.1/AV:A/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:H
6.4	CVSS:3.1/AV:A/AC:H/PR:L/UI:N/S:U/C:N/I:H/A:H
6.4	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:H
6.4	CVSS:3.1/AV:A/AC:H/PR:N/UI:R/S:U/C:H/I:H/A:N
6.4	CVSS:3.1/AV:A/AC:H/PR:N/UI:R/S:U/C:N/I:H/A:H
6.4	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:L
6.4	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:U/C:H/I:H/A:H
6.4	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:C/C:H/I:N/A:L
6.4	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:C/C:L/I:H/A:N
6.4	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:C/C:N/I:L/A:H
6.4	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:U/C:H/I:H/A:H
6.4	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:H/I:L/A:L
6.4	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:L/I:L/A:H
6.4	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:U/C:H/I:H/A:N
6.4	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:H/I:L/A:L
6.4	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:L/I:H/A:L
6.4	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:L/I:L/A:H
6.4	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:H/I:H/A:L
6.4	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:H/I:L/A:H
6.4	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:L/I:L/A:N
6.4	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:N/I:L/A:L
6.4	CVSS:3.1/AV:P/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H
6.4	CVSS:3.1/AV:P/AC:L/PR:L/UI:R/S:U/C:H/I:H/A:H
6.4	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:L
6.4	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:H/I:L/A:H
6.5	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
6.5	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:N
6.5	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H
6.5	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:U/C:L/I:H/A:H
6.5	CVSS:3.0/AV:L/AC:H/PR:N/UI:R/S:U/C:H/I:H/A:L
6.5	CVSS:3.0/AV:L/AC:L/PR:H/UI:R/S:U/C:H/I:H/A:H
6.5	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:C/C:H/I:N/A:N
6.5	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:C/C:N/I:H/A:N
6.5	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:C/C:N/I:N/A:H
6.5	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:C/C:L/I:L/A:L
6.5	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:L/A:N
6.5	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:H/A:N
6.5	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:N/A:H
6.5	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:H/A:L
6.5	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:L/A:H
6.5	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:N
6.5	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:H/I:N/A:H
6.5	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:N/I:H/A:H
6.5	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:N
6.5	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:N
6.5	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H
6.5	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:C/C:L/I:L/A:L
6.5	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:N
6.5	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:L
6.5	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:L
6.5	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:N/A:N
6.5	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:H/A:N
6.5	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:H
6.5	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:C/C:L/I:L/A:L
6.5	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
6.5	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:N
6.5	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H
6.5	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:L/I:H/A:H
6.5	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:U/C:H/I:H/A:H
6.5	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:H/I:N/A:N
6.5	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:N/I:H/A:N
6.5	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:N/I:N/A:H
6.5	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:C/C:H/I:L/A:N
6.5	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:C/C:L/I:H/A:N
6.5	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:L/I:L/A:L
6.5	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:L/A:N
6.5	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:N/A:L
6.5	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:H/A:N
6.5	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:N/A:H
6.5	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:H/A:L
6.5	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:L/A:H
6.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:N
6.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:H/I:N/A:H
6.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:N/I:H/A:H
6.5	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:N
6.5	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:N
6.5	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H
6.5	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:L/I:L/A:L
6.5	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:N
6.5	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:L
6.5	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:L
6.5	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:N/A:N
6.5	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:H/A:N
6.5	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:H
6.6	CVSS:3.0/AV:A/AC:L/PR:H/UI:R/S:U/C:H/I:H/A:H
6.6	CVSS:3.0/AV:L/AC:H/PR:L/UI:R/S:C/C:L/I:L/A:H
6.6	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:L/A:L
6.6	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:L/I:H/A:L
6.6	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:H
6.6	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:U/C:H/I:H/A:N
6.6	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:U/C:H/I:N/A:H
6.6	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:U/C:N/I:H/A:H
6.6	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:L/I:L/A:H
6.6	CVSS:3.0/AV:N/AC:H/PR:H/UI:N/S:C/C:L/I:H/A:N
6.6	CVSS:3.0/AV:N/AC:H/PR:H/UI:N/S:U/C:H/I:H/A:H
6.6	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:C/C:L/I:L/A:L
6.6	CVSS:3.0/AV:P/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H
6.6	CVSS:3.0/AV:P/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:H
6.6	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:C/C:H/I:N/A:N
6.6	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:C/C:N/I:N/A:H
6.6	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:L/A:L
6.6	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:L/I:H/A:L
6.6	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:H
6.6	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:H/I:H/A:N
6.6	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:H/I:N/A:H
6.6	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:N/I:H/A:H
6.6	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:L/A:L
6.6	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:L/I:H/A:L
6.6	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:L/I:L/A:H
6.6	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:C/C:L/I:H/A:N
6.6	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:U/C:H/I:H/A:H
6.6	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:L/I:L/A:L
6.6	CVSS:3.1/AV:P/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H
6.6	CVSS:3.1/AV:P/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:H
6.7	CVSS:3.0/AV:L/AC:H/PR:L/UI:R/S:U/C:H/I:H/A:H
6.7	CVSS:3.0/AV:L/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:N
6.7	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:C/C:N/I:L/A:H
6.7	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:H
6.7	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:C/C:N/I:L/A:H
6.7	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:L
6.7	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:L/I:H/A:H
6.7	CVSS:3.0/AV:P/AC:H/PR:H/UI:R/S:C/C:H/I:H/A:L
6.7	CVSS:3.0/AV:P/AC:H/PR:L/UI:N/S:C/C:H/I:H/A:N
6.7	CVSS:3.1/AV:A/AC:H/PR:N/UI:R/S:U/C:L/I:H/A:H
6.7	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:U/C:H/I:H/A:N
6.7	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:U/C:N/I:H/A:H
6.7	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:C/C:H/I:L/A:L
6.7	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:U/C:H/I:H/A:H
6.7	CVSS:3.1/AV:L/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:N
6.7	CVSS:3.1/AV:L/AC:H/PR:N/UI:N/S:U/C:H/I:N/A:H
6.7	CVSS:3.1/AV:L/AC:H/PR:N/UI:N/S:U/C:N/I:H/A:H
6.7	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:H/I:L/A:N
6.7	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:L/I:N/A:H
6.7	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:N/I:L/A:H
6.7	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:H
6.7	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:U/C:H/I:H/A:L
6.7	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:L
6.7	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:L/I:H/A:H
6.7	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:C/C:L/I:L/A:H
6.8	CVSS:3.0/AV:A/AC:H/PR:H/UI:N/S:C/C:H/I:L/A:L
6.8	CVSS:3.0/AV:A/AC:H/PR:L/UI:R/S:U/C:H/I:H/A:H
6.8	CVSS:3.0/AV:A/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:N
6.8	CVSS:3.0/AV:A/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:H
6.8	CVSS:3.0/AV:A/AC:L/PR:L/UI:N/S:C/C:H/I:N/A:N
6.8	CVSS:3.0/AV:A/AC:L/PR:L/UI:N/S:C/C:N/I:H/A:N
6.8	CVSS:3.0/AV:A/AC:L/PR:L/UI:N/S:C/C:N/I:N/A:H
6.8	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:U/C:H/I:H/A:L
6.8	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:U/C:L/I:H/A:H
6.8	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:C/C:L/I:L/A:L
6.8	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:H
6.8	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:H/I:H/A:N
6.8	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:H
6.8	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:N/I:H/A:H
6.8	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:C/C:H/I:N/A:N
6.8	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:C/C:N/I:H/A:N
6.8	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:C/C:N/I:N/A:H
6.8	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:U/C:H/I:H/A:N
6.8	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:U/C:N/I:H/A:H
6.8	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:N/A:N
6.8	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:C/C:N/I:N/A:H
6.8	CVSS:3.0/AV:N/AC:L/PR:H/UI:R/S:U/C:H/I:H/A:H
6.8	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:C/C:H/I:N/A:N
6.8	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:C/C:N/I:H/A:N
6.8	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:C/C:N/I:N/A:H
6.8	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:H/I:L/A:L
6.8	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:L/I:L/A:H
6.8	CVSS:3.0/AV:P/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
6.8	CVSS:3.1/AV:A/AC:H/PR:H/UI:N/S:C/C:H/I:L/A:L
6.8	CVSS:3.1/AV:A/AC:H/PR:L/UI:R/S:U/C:H/I:H/A:H
6.8	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:N
6.8	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:U/C:H/I:N/A:H
6.8	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:U/C:N/I:H/A:H
6.8	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:H
6.8	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:C/C:H/I:N/A:N
6.8	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:C/C:N/I:H/A:N
6.8	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:C/C:N/I:N/A:H
6.8	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:H
6.8	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:H/I:H/A:L
6.8	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:L/I:H/A:H
6.8	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:C/C:L/I:L/A:L
6.8	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:H/I:L/A:N
6.8	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:L
6.8	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:L/I:H/A:N
6.8	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:H
6.8	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:L
6.8	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:H
6.8	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:C/C:L/I:H/A:L
6.8	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:H/I:H/A:N
6.8	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:H/I:N/A:H
6.8	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:N/I:H/A:H
6.8	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:H/I:N/A:N
6.8	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:N/I:H/A:N
6.8	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:N/I:N/A:H
6.8	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:H/I:H/A:N
6.8	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:H/I:N/A:H
6.8	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:N/I:H/A:H
6.8	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:N/A:N
6.8	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:N/I:H/A:N
6.8	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:N/I:N/A:H
6.8	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:U/C:H/I:H/A:H
6.8	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:H/I:N/A:N
6.8	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:N/I:H/A:N
6.8	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:N/I:N/A:H
6.8	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:H/I:L/A:L
6.8	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:L/I:H/A:L
6.8	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:L/I:L/A:H
6.8	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
6.9	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:C/C:H/I:L/A:N
6.9	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:C/C:L/I:H/A:N
6.9	CVSS:3.0/AV:N/AC:L/PR:H/UI:R/S:C/C:H/I:L/A:N
6.9	CVSS:3.0/AV:N/AC:L/PR:H/UI:R/S:C/C:L/I:H/A:N
6.9	CVSS:3.0/AV:P/AC:H/PR:H/UI:N/S:C/C:H/I:H/A:H
6.9	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:C/C:H/I:L/A:N
6.9	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:C/C:H/I:H/A:N
6.9	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:C/C:N/I:H/A:H
6.9	CVSS:3.1/AV:L/AC:H/PR:N/UI:N/S:U/C:H/I:L/A:H
6.9	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:C/C:H/I:L/A:N
6.9	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:C/C:N/I:L/A:H
6.9	CVSS:3.1/AV:P/AC:H/PR:H/UI:N/S:C/C:H/I:H/A:H
6.9	CVSS:3.1/AV:P/AC:H/PR:N/UI:R/S:C/C:H/I:H/A:L
7.0	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:U/C:H/I:H/A:H
7.0	CVSS:3.0/AV:L/AC:H/PR:N/UI:R/S:U/C:H/I:H/A:H
7.0	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:L/A:L
7.0	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:H/A:L
7.0	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:H
7.0	CVSS:3.0/AV:P/AC:H/PR:L/UI:N/S:C/C:H/I:H/A:L
7.0	CVSS:3.1/AV:A/AC:H/PR:N/UI:R/S:C/C:H/I:L/A:L
7.0	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:H/I:H/A:H
7.0	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:U/C:H/I:H/A:H
7.0	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:L/A:L
7.0	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:H/A:L
7.0	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:H
7.1	CVSS:3.0/AV:A/AC:H/PR:L/UI:N/S:U/C:H/I:H/A:H
7.1	CVSS:3.0/AV:A/AC:H/PR:N/UI:R/S:U/C:H/I:H/A:H
7.1	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:U/C:H/I:L/A:N
7.1	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:N
7.1	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:H
7.1	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:H
7.1	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:C/C:H/I:N/A:N
7.1	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:C/C:N/I:N/A:H
7.1	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:C/C:L/I:N/A:H
7.1	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:N
7.1	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:N/A:H
7.1	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:N/I:H/A:H
7.1	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:C/C:L/I:H/A:N
7.1	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:H/I:H/A:L
7.1	CVSS:3.0/AV:N/AC:H/PR:L/UI:R/S:U/C:H/I:H/A:H
7.1	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:U/C:H/I:H/A:L
7.1	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:U/C:H/I:L/A:H
7.1	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:L/A:N
7.1	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:L
7.1	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:H/A:N
7.1	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:N/A:H
7.1	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:L
7.1	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:H
7.1	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:L
7.1	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:L/A:N
7.1	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:N/A:L
7.1	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:L/I:H/A:N
7.1	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:L/I:N/A:H
7.1	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:H/A:L
7.1	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:L/A:H
7.1	CVSS:3.0/AV:P/AC:H/PR:N/UI:N/S:C/C:H/I:H/A:H
7.1	CVSS:3.1/AV:A/AC:H/PR:L/UI:N/S:U/C:H/I:H/A:H
7.1	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:L
7.1	CVSS:3.1/AV:A/AC:H/PR:N/UI:R/S:U/C:H/I:H/A:H
7.1	CVSS:3.1/AV:A/AC:L/PR:H/UI:R/S:C/C:L/I:H/A:L
7.1	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:C/C:L/I:L/A:L
7.1	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:H/I:L/A:N
7.1	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:L/I:H/A:N
7.1	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:H
7.1	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:L
7.1	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:H
7.1	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:N
7.1	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:H
7.1	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:H
7.1	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:C/C:H/I:N/A:N
7.1	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:C/C:N/I:H/A:N
7.1	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:C/C:N/I:N/A:H
7.1	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:C/C:L/I:H/A:N
7.1	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:N
7.1	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:N/A:H
7.1	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:N/I:H/A:H
7.1	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:C/C:H/I:L/A:N
7.1	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:C/C:L/I:H/A:N
7.1	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:H/I:H/A:L
7.1	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:C/C:H/I:L/A:L
7.1	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:U/C:H/I:H/A:H
7.1	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:H/I:H/A:L
7.1	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:L/A:N
7.1	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:L
7.1	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:H/A:N
7.1	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:N/A:H
7.1	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:L
7.1	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:H
7.1	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:L
7.1	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:L/A:N
7.1	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:L/I:H/A:N
7.1	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:L/I:N/A:H
7.1	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:H/A:L
7.1	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:L/A:H
7.1	CVSS:3.1/AV:P/AC:H/PR:N/UI:N/S:C/C:H/I:H/A:H
7.1	CVSS:3.1/AV:P/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:N
7.2	CVSS:3.0/AV:L/AC:H/PR:H/UI:R/S:C/C:H/I:H/A:H
7.2	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:H
7.2	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:L/I:L/A:N
7.2	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:L/I:N/A:L
7.2	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:L/A:L
7.2	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:C/C:H/I:H/A:N
7.2	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:C/C:N/I:H/A:H
7.2	CVSS:3.1/AV:L/AC:H/PR:H/UI:R/S:C/C:H/I:H/A:H
7.2	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:C/C:H/I:H/A:N
7.2	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:C/C:H/I:L/A:L
7.2	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:C/C:L/I:L/A:H
7.2	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:U/C:H/I:H/A:H
7.2	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:L/I:L/A:N
7.2	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:L/I:N/A:L
7.2	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:L/A:L
7.2	CVSS:3.1/AV:P/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:H
7.3	CVSS:3.0/AV:A/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:N
7.3	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:C/C:L/I:H/A:L
7.3	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:C/C:L/I:L/A:H
7.3	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:C/C:L/I:N/A:H
7.3	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:C/C:N/I:L/A:H
7.3	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:U/C:H/I:H/A:H
7.3	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:H
7.3	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:L
7.3	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:H/I:H/A:N
7.3	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:H/I:N/A:H
7.3	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:N/I:H/A:H
7.3	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:L
7.3	CVSS:3.0/AV:P/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:L
7.3	CVSS:3.0/AV:P/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:N
7.3	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:N
7.3	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:H
7.3	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:H
7.3	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:N
7.3	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:U/C:N/I:H/A:H
7.3	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:H/I:L/A:L
7.3	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:L/I:H/A:L
7.3	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:L/I:L/A:H
7.3	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:H/I:L/A:N
7.3	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:N/I:H/A:L
7.3	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:N/I:L/A:H
7.3	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:L
7.3	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:L/A:H
7.3	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:L/I:H/A:H
7.3	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:C/C:L/I:H/A:L
7.3	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:H/I:H/A:H
7.3	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:L/I:H/A:L
7.3	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:H
7.3	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:L
7.3	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:L/A:H
7.3	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:C/C:H/I:H/A:N
7.3	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:C/C:N/I:H/A:H
7.3	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:H/I:H/A:N
7.3	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:H/I:N/A:H
7.3	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:N/I:H/A:H
7.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:L
7.3	CVSS:3.1/AV:P/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:H
7.4	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:C/C:H/I:N/A:N
7.4	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:C/C:N/I:H/A:N
7.4	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:C/C:N/I:N/A:H
7.4	CVSS:3.0/AV:L/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H
7.4	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:N
7.4	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:N/A:H
7.4	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:H/A:H
7.4	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:L/I:L/A:L
7.4	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:N/A:N
7.4	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:C/C:N/I:H/A:N
7.4	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:C/C:N/I:N/A:H
7.4	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:U/C:H/I:H/A:H
7.4	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:C/C:H/I:N/A:N
7.4	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:C/C:N/I:H/A:N
7.4	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:C/C:N/I:N/A:H
7.4	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:C/C:H/I:H/A:L
7.4	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:C/C:H/I:H/A:L
7.4	CVSS:3.1/AV:L/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H
7.4	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:C/C:H/I:H/A:N
7.4	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:C/C:N/I:H/A:H
7.4	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:N
7.4	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:N/A:H
7.4	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:H/A:H
7.4	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:L/I:L/A:L
7.4	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:N/A:N
7.4	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:N/I:H/A:N
7.4	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:N/I:N/A:H
7.4	CVSS:3.1/AV:P/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H
7.5	CVSS:3.0/AV:A/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H
7.5	CVSS:3.0/AV:L/AC:H/PR:H/UI:N/S:C/C:H/I:H/A:H
7.5	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:C/C:H/I:H/A:N
7.5	CVSS:3.0/AV:L/AC:H/PR:L/UI:R/S:C/C:H/I:H/A:H
7.5	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:U/C:H/I:H/A:H
7.5	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:U/C:H/I:H/A:H
7.5	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
7.5	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:N
7.5	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H
7.5	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H
7.5	CVSS:3.1/AV:A/AC:H/PR:N/UI:R/S:C/C:H/I:H/A:N
7.5	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:C/C:H/I:L/A:L
7.5	CVSS:3.1/AV:L/AC:H/PR:H/UI:N/S:C/C:H/I:H/A:H
7.5	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:C/C:H/I:H/A:N
7.5	CVSS:3.1/AV:L/AC:H/PR:L/UI:R/S:C/C:H/I:H/A:H
7.5	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:U/C:H/I:H/A:H
7.5	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:L/I:H/A:N
7.5	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:L/I:N/A:H
7.5	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:N/I:H/A:L
7.5	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:N/I:L/A:H
7.5	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:C/C:H/I:L/A:L
7.5	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:C/C:L/I:H/A:L
7.5	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:C/C:L/I:L/A:H
7.5	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:U/C:H/I:H/A:H
7.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:C/C:L/I:H/A:L
7.5	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:C/C:L/I:L/A:H
7.5	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N
7.5	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:N
7.5	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H
7.6	CVSS:3.0/AV:A/AC:H/PR:H/UI:N/S:C/C:H/I:H/A:H
7.6	CVSS:3.0/AV:A/AC:H/PR:L/UI:R/S:C/C:H/I:H/A:H
7.6	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:H
7.6	CVSS:3.0/AV:N/AC:H/PR:H/UI:R/S:C/C:H/I:H/A:H
7.6	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:L/A:N
7.6	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:L/A:L
7.6	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:H/A:L
7.6	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:H
7.6	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:C/C:H/I:L/A:N
7.6	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:C/C:N/I:L/A:H
7.6	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:H/I:L/A:H
7.6	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:L/A:L
7.6	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:L/I:L/A:H
7.6	CVSS:3.0/AV:P/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H
7.6	CVSS:3.1/AV:A/AC:H/PR:H/UI:N/S:C/C:H/I:H/A:H
7.6	CVSS:3.1/AV:A/AC:H/PR:L/UI:R/S:C/C:H/I:H/A:H
7.6	CVSS:3.1/AV:A/AC:L/PR:H/UI:R/S:C/C:H/I:H/A:N
7.6	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:C/C:N/I:L/A:H
7.6	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:L
7.6	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:H/I:L/A:L
7.6	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:H
7.6	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:U/C:L/I:H/A:H
7.6	CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:C/C:H/I:H/A:H
7.6	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:L/A:N
7.6	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:N/A:L
7.6	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:L/I:H/A:N
7.6	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:L/I:N/A:H
7.6	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:N/I:L/A:H
7.6	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:L/A:L
7.6	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:H/A:L
7.6	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:L/A:H
7.6	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:H/I:L/A:N
7.6	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:L/I:H/A:N
7.6	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:H/I:H/A:L
7.6	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:H/I:L/A:H
7.6	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:L/A:L
7.6	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:L/I:H/A:L
7.6	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:L/I:L/A:H
7.6	CVSS:3.1/AV:P/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H
7.7	CVSS:3.0/AV:L/AC:H/PR:N/UI:R/S:C/C:H/I:H/A:H
7.7	CVSS:3.0/AV:L/AC:L/PR:H/UI:R/S:C/C:H/I:H/A:H
7.7	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:N
7.7	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:H
7.7	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:H
7.7	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:C/C:H/I:L/A:L
7.7	CVSS:3.0/AV:N/AC:H/PR:L/UI:R/S:C/C:H/I:H/A:N
7.7	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:L
7.7	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:N/A:N
7.7	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:N/I:H/A:N
7.7	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:N/I:N/A:H
7.7	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:C/C:H/I:H/A:L
7.7	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:C/C:L/I:H/A:H
7.7	CVSS:3.1/AV:L/AC:H/PR:N/UI:R/S:C/C:H/I:H/A:H
7.7	CVSS:3.1/AV:L/AC:L/PR:H/UI:R/S:C/C:H/I:H/A:H
7.7	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:N
7.7	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:H
7.7	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:H
7.7	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:C/C:H/I:L/A:L
7.7	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:C/C:N/I:H/A:H
7.7	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:C/C:H/I:L/A:L
7.7	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:C/C:H/I:H/A:N
7.7	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:L
7.7	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:L/A:H
7.7	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:H/A:H
7.7	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:N/A:N
7.7	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:N/I:H/A:N
7.7	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:N/I:N/A:H
7.8	CVSS:3.0/AV:L/AC:H/PR:L/UI:N/S:C/C:H/I:H/A:H
7.8	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H
7.8	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:H
7.8	CVSS:3.1/AV:A/AC:H/PR:N/UI:R/S:C/C:L/I:H/A:H
7.8	CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:C/C:H/I:H/A:H
7.8	CVSS:3.1/AV:L/AC:H/PR:N/UI:N/S:C/C:H/I:H/A:N
7.8	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H
7.8	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:H
7.9	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:N
7.9	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:C/C:N/I:H/A:H
7.9	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:C/C:L/I:L/A:H
7.9	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:C/C:H/I:H/A:N
7.9	CVSS:3.0/AV:N/AC:H/PR:H/UI:N/S:C/C:H/I:H/A:L
7.9	CVSS:3.1/AV:A/AC:H/PR:N/UI:R/S:C/C:H/I:H/A:H
7.9	CVSS:3.1/AV:A/AC:L/PR:H/UI:R/S:C/C:H/I:H/A:H
7.9	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:N
7.9	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:H/I:N/A:H
7.9	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:N/I:H/A:H
7.9	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:H/I:L/A:L
7.9	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:L/I:L/A:H
7.9	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:C/C:H/I:H/A:N
7.9	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:C/C:H/I:N/A:H
7.9	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:C/C:N/I:H/A:H
7.9	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:C/C:L/I:H/A:N
7.9	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:C/C:N/I:H/A:L
7.9	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:C/C:N/I:L/A:H
7.9	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:C/C:H/I:L/A:H
7.9	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:C/C:L/I:H/A:H
8.0	CVSS:3.0/AV:A/AC:H/PR:L/UI:N/S:C/C:H/I:H/A:H
8.0	CVSS:3.0/AV:A/AC:H/PR:N/UI:N/S:C/C:H/I:H/A:N
8.0	CVSS:3.0/AV:A/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H
8.0	CVSS:3.0/AV:A/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:H
8.0	CVSS:3.0/AV:N/AC:H/PR:H/UI:N/S:C/C:H/I:H/A:H
8.0	CVSS:3.0/AV:N/AC:H/PR:L/UI:R/S:C/C:H/I:H/A:H
8.0	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:U/C:H/I:H/A:H
8.0	CVSS:3.1/AV:A/AC:H/PR:L/UI:N/S:C/C:H/I:H/A:H
8.0	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:C/C:H/I:H/A:N
8.0	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H
8.0	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:H
8.0	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:L/I:H/A:H
8.0	CVSS:3.1/AV:N/AC:H/PR:H/UI:N/S:C/C:H/I:H/A:H
8.0	CVSS:3.1/AV:N/AC:H/PR:L/UI:R/S:C/C:H/I:H/A:H
8.0	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:C/C:H/I:H/A:N
8.0	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:C/C:N/I:H/A:H
8.0	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:U/C:H/I:H/A:H
8.1	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:N
8.1	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:H
8.1	CVSS:3.0/AV:L/AC:H/PR:N/UI:N/S:C/C:H/I:H/A:H
8.1	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H
8.1	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:N
8.1	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:H
8.1	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:H
8.1	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:N
8.1	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:N/A:H
8.1	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:H/A:H
8.1	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:C/C:N/I:H/A:H
8.1	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:N
8.1	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:H
8.1	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:H
8.1	CVSS:3.1/AV:L/AC:H/PR:N/UI:N/S:C/C:H/I:H/A:H
8.1	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:C/C:H/I:H/A:L
8.1	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:H/I:L/A:L
8.1	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:L/I:H/A:L
8.1	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:L/I:L/A:H
8.1	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H
8.1	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:C/C:H/I:H/A:N
8.1	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:C/C:N/I:H/A:H
8.1	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:N
8.1	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:N/A:H
8.1	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:H/A:H
8.1	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:N
8.1	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:N/A:H
8.1	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:H/A:H
8.2	CVSS:3.0/AV:A/AC:H/PR:N/UI:N/S:C/C:L/I:H/A:H
8.2	CVSS:3.0/AV:L/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:H
8.2	CVSS:3.0/AV:L/AC:L/PR:L/UI:R/S:C/C:H/I:H/A:H
8.2	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:C/C:H/I:N/A:H
8.2	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:C/C:N/I:H/A:H
8.2	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:C/C:H/I:H/A:N
8.2	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:C/C:L/I:L/A:H
8.2	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:C/C:H/I:L/A:L
8.2	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:C/C:L/I:H/A:L
8.2	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:L/A:N
8.2	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:L
8.2	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:H/A:N
8.2	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:H
8.2	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:L
8.2	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:H
8.2	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:L/A:N
8.2	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:H/A:N
8.2	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:C/C:N/I:L/A:H
8.2	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:C/C:H/I:L/A:H
8.2	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:C/C:L/I:L/A:H
8.2	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:C/C:N/I:H/A:L
8.2	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:C/C:N/I:L/A:H
8.2	CVSS:3.1/AV:L/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:H
8.2	CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:C/C:H/I:H/A:H
8.2	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:N
8.2	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:C/C:H/I:H/A:N
8.2	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:C/C:N/I:H/A:H
8.2	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:C/C:L/I:H/A:H
8.2	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:L/I:L/A:H
8.2	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:H/I:L/A:L
8.2	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:L/I:H/A:L
8.2	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:L/I:L/A:H
8.2	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:L/A:N
8.2	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:L
8.2	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:H/A:N
8.2	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:N/A:H
8.2	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:L
8.2	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:H
8.2	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:L/A:N
8.2	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:N/A:L
8.2	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:H/A:N
8.2	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:N/I:L/A:H
8.3	CVSS:3.0/AV:A/AC:H/PR:N/UI:N/S:C/C:H/I:H/A:H
8.3	CVSS:3.0/AV:N/AC:H/PR:N/UI:R/S:C/C:H/I:H/A:H
8.3	CVSS:3.0/AV:N/AC:L/PR:H/UI:R/S:C/C:H/I:H/A:L
8.3	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:L
8.3	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:L/A:H
8.3	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:H/A:H
8.3	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:L/I:L/A:L
8.3	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:L
8.3	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:L/A:H
8.3	CVSS:3.1/AV:A/AC:H/PR:N/UI:N/S:C/C:H/I:H/A:H
8.3	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:L
8.3	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:L
8.3	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:L/I:H/A:H
8.3	CVSS:3.1/AV:N/AC:H/PR:N/UI:R/S:C/C:H/I:H/A:H
8.3	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:C/C:H/I:H/A:L
8.3	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:L
8.3	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:L/A:H
8.3	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:L/I:H/A:H
8.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:L/I:L/A:L
8.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:L
8.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:L/I:H/A:H
8.4	CVSS:3.0/AV:A/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:H
8.4	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:N
8.4	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:C/C:H/I:N/A:H
8.4	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:C/C:N/I:H/A:H
8.4	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
8.4	CVSS:3.0/AV:N/AC:L/PR:H/UI:R/S:C/C:H/I:H/A:H
8.4	CVSS:3.1/AV:A/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:H
8.4	CVSS:3.1/AV:A/AC:L/PR:L/UI:R/S:C/C:H/I:H/A:H
8.4	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:N
8.4	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:H/I:N/A:H
8.4	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:N/I:H/A:H
8.4	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
8.4	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:C/C:H/I:H/A:L
8.4	CVSS:3.1/AV:N/AC:L/PR:H/UI:R/S:C/C:H/I:H/A:H
8.5	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:C/C:L/I:L/A:H
8.5	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:C/C:L/I:H/A:H
8.5	CVSS:3.0/AV:N/AC:H/PR:L/UI:N/S:C/C:H/I:H/A:H
8.5	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:L/A:N
8.5	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:N/A:L
8.5	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:L/I:H/A:N
8.5	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:L/I:N/A:H
8.5	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:N/I:L/A:H
8.5	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:C/C:H/I:N/A:H
8.5	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:L
8.5	CVSS:3.1/AV:N/AC:H/PR:L/UI:N/S:C/C:H/I:H/A:H
8.5	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:L/A:N
8.5	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:N/A:L
8.5	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:L/I:H/A:N
8.5	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:L/I:N/A:H
8.5	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:N/I:H/A:L
8.6	CVSS:3.0/AV:L/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:H
8.6	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:N/A:N
8.6	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:H/A:N
8.6	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:N/A:H
8.6	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:L/A:L
8.6	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:H/A:L
8.6	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:H
8.6	CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:H
8.6	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:N/A:N
8.6	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:H/A:N
8.6	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:N/A:H
8.6	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:L/A:L
8.6	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:H/A:L
8.6	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:L/A:H
8.7	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:L
8.7	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:C/C:L/I:H/A:H
8.7	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:C/C:H/I:H/A:N
8.7	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:C/C:N/I:H/A:H
8.7	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:N
8.7	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:N/A:H
8.7	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:C/C:N/I:H/A:H
8.7	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:C/C:H/I:H/A:N
8.7	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:C/C:N/I:H/A:H
8.7	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:L
8.7	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:H/I:H/A:N
8.7	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:H/I:N/A:H
8.7	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:N/I:H/A:H
8.7	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:N
8.7	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:N/I:H/A:H
8.7	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:H/I:H/A:N
8.7	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:N/I:H/A:H
8.8	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
8.8	CVSS:3.0/AV:L/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H
8.8	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H
8.8	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:H
8.8	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:H
8.8	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:C/C:H/I:L/A:L
8.8	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
8.8	CVSS:3.1/AV:A/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:H
8.8	CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H
8.8	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H
8.8	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:L/A:L
8.8	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:H/A:L
8.8	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:H
8.8	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:H
8.9	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:L/I:H/A:H
8.9	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:H/I:H/A:L
9.0	CVSS:3.0/AV:A/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H
9.0	CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:C/C:H/I:H/A:H
9.0	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:L
9.0	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:C/C:L/I:H/A:H
9.0	CVSS:3.0/AV:N/AC:L/PR:L/UI:R/S:C/C:H/I:H/A:H
9.0	CVSS:3.1/AV:A/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H
9.0	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:N
9.0	CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:C/C:H/I:H/A:H
9.0	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:L/A:H
9.0	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:L/I:H/A:H
9.0	CVSS:3.1/AV:N/AC:L/PR:L/UI:R/S:C/C:H/I:H/A:H
9.1	CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:H
9.1	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:L/A:L
9.1	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:L/I:L/A:H
9.1	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:N
9.1	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:H
9.1	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:H
9.1	CVSS:3.1/AV:N/AC:L/PR:H/UI:N/S:C/C:H/I:H/A:H
9.1	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:L/A:L
9.1	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:N
9.1	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:H
9.1	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:H
9.2	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:C/C:L/I:H/A:H
9.3	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:N
9.3	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:C/C:H/I:N/A:H
9.3	CVSS:3.0/AV:L/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H
9.3	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:L/A:N
9.3	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:N/A:L
9.3	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:L/A:H
9.3	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:N
9.3	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:C/C:H/I:N/A:H
9.3	CVSS:3.1/AV:L/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H
9.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:L/A:N
9.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:N/A:L
9.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:L/I:N/A:H
9.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:H/A:L
9.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:L/A:H
9.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:N
9.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:N/A:H
9.3	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:N/I:H/A:H
9.4	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:L
9.4	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:H/A:H
9.4	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:L
9.4	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:L/A:H
9.4	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:L/I:H/A:H
9.6	CVSS:3.0/AV:A/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H
9.6	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:N
9.6	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:N/A:H
9.6	CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:H
9.6	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H
9.6	CVSS:3.1/AV:A/AC:L/PR:N/UI:N/S:C/C:L/I:H/A:H
9.6	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:N
9.6	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:N/A:H
9.6	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:N/I:H/A:H
9.6	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:H/I:H/A:H
9.6	CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:H/A:H
9.8	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
9.8	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
9.9	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H
9.9	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:L
9.9	CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:L/I:H/A:H
9.9	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:L/A:L
9.9	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:L/I:L/A:H
9.9	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H
9.9	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:L
9.9	CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:C/C:L/I:H/A:H
9.9	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:L/A:L
9.9	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:L/I:H/A:L
9.9	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:L/I:L/A:H
10.0	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H
10.0	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:L
10.0	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:N
10.0	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:N/A:H
10.0	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:L/I:H/A:H
10.0	CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:H/A:H
10.0	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H
10.0	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:L
10.0	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:N
10.0	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:N/A:H
10.0	CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:H/A:H
