# Generated by default/object.tt
package Paws::CodePipeline::ActionTypeIdentifier;
  use Moose;
  has Category => (is => 'ro', isa => 'Str', request_name => 'category', traits => ['NameInRequest'], required => 1);
  has Owner => (is => 'ro', isa => 'Str', request_name => 'owner', traits => ['NameInRequest'], required => 1);
  has Provider => (is => 'ro', isa => 'Str', request_name => 'provider', traits => ['NameInRequest'], required => 1);
  has Version => (is => 'ro', isa => 'Str', request_name => 'version', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodePipeline::ActionTypeIdentifier

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodePipeline::ActionTypeIdentifier object:

  $service_obj->Method(Att1 => { Category => $value, ..., Version => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodePipeline::ActionTypeIdentifier object:

  $result = $service_obj->Method(...);
  $result->Att1->Category

=head1 DESCRIPTION

Specifies the category, owner, provider, and version of the action
type.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Category => Str

Defines what kind of action can be taken in the stage, one of the
following:

=over

=item *

C<Source>

=item *

C<Build>

=item *

C<Test>

=item *

C<Deploy>

=item *

C<Approval>

=item *

C<Invoke>

=back



=head2 B<REQUIRED> Owner => Str

The creator of the action type being called: C<AWS> or C<ThirdParty>.


=head2 B<REQUIRED> Provider => Str

The provider of the action type being called. The provider name is
supplied when the action type is created.


=head2 B<REQUIRED> Version => Str

A string that describes the action type version.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodePipeline>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

