# Generated by default/object.tt
package Paws::SecurityHub::NetworkPathComponent;
  use Moose;
  has ComponentId => (is => 'ro', isa => 'Str');
  has ComponentType => (is => 'ro', isa => 'Str');
  has Egress => (is => 'ro', isa => 'Paws::SecurityHub::NetworkHeader');
  has Ingress => (is => 'ro', isa => 'Paws::SecurityHub::NetworkHeader');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::NetworkPathComponent

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::NetworkPathComponent object:

  $service_obj->Method(Att1 => { ComponentId => $value, ..., Ingress => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::NetworkPathComponent object:

  $result = $service_obj->Method(...);
  $result->Att1->ComponentId

=head1 DESCRIPTION

Information about a network path component.

=head1 ATTRIBUTES


=head2 ComponentId => Str

The identifier of a component in the network path.


=head2 ComponentType => Str

The type of component.


=head2 Egress => L<Paws::SecurityHub::NetworkHeader>

Information about the component that comes after the current component
in the network path.


=head2 Ingress => L<Paws::SecurityHub::NetworkHeader>

Information about the component that comes before the current node in
the network path.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

