# Generated by default/object.tt
package Paws::CostExplorer::RootCause;
  use Moose;
  has LinkedAccount => (is => 'ro', isa => 'Str');
  has Region => (is => 'ro', isa => 'Str');
  has Service => (is => 'ro', isa => 'Str');
  has UsageType => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CostExplorer::RootCause

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CostExplorer::RootCause object:

  $service_obj->Method(Att1 => { LinkedAccount => $value, ..., UsageType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CostExplorer::RootCause object:

  $result = $service_obj->Method(...);
  $result->Att1->LinkedAccount

=head1 DESCRIPTION

The combination of AWS service, linked account, Region, and usage type
where a cost anomaly is observed.

=head1 ATTRIBUTES


=head2 LinkedAccount => Str

The linked account value associated with the cost anomaly.


=head2 Region => Str

The AWS Region associated with the cost anomaly.


=head2 Service => Str

The AWS service name associated with the cost anomaly.


=head2 UsageType => Str

The C<UsageType> value associated with the cost anomaly.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CostExplorer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

