# Generated by default/object.tt
package Paws::FSX::Backup;
  use Moose;
  has BackupId => (is => 'ro', isa => 'Str', required => 1);
  has CreationTime => (is => 'ro', isa => 'Str', required => 1);
  has DirectoryInformation => (is => 'ro', isa => 'Paws::FSX::ActiveDirectoryBackupAttributes');
  has FailureDetails => (is => 'ro', isa => 'Paws::FSX::BackupFailureDetails');
  has FileSystem => (is => 'ro', isa => 'Paws::FSX::FileSystem', required => 1);
  has KmsKeyId => (is => 'ro', isa => 'Str');
  has Lifecycle => (is => 'ro', isa => 'Str', required => 1);
  has OwnerId => (is => 'ro', isa => 'Str');
  has ProgressPercent => (is => 'ro', isa => 'Int');
  has ResourceARN => (is => 'ro', isa => 'Str');
  has SourceBackupId => (is => 'ro', isa => 'Str');
  has SourceBackupRegion => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::FSX::Tag]');
  has Type => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::FSX::Backup

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FSX::Backup object:

  $service_obj->Method(Att1 => { BackupId => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FSX::Backup object:

  $result = $service_obj->Method(...);
  $result->Att1->BackupId

=head1 DESCRIPTION

A backup of an Amazon FSx file system.

=head1 ATTRIBUTES


=head2 B<REQUIRED> BackupId => Str

The ID of the backup.


=head2 B<REQUIRED> CreationTime => Str

The time when a particular backup was created.


=head2 DirectoryInformation => L<Paws::FSX::ActiveDirectoryBackupAttributes>

The configuration of the self-managed Microsoft Active Directory (AD)
to which the Windows File Server instance is joined.


=head2 FailureDetails => L<Paws::FSX::BackupFailureDetails>

Details explaining any failures that occur when creating a backup.


=head2 B<REQUIRED> FileSystem => L<Paws::FSX::FileSystem>

Metadata of the file system associated with the backup. This metadata
is persisted even if the file system is deleted.


=head2 KmsKeyId => Str

The ID of the AWS Key Management Service (AWS KMS) key used to encrypt
the backup of the Amazon FSx file system's data at rest.


=head2 B<REQUIRED> Lifecycle => Str

The lifecycle status of the backup.

=over

=item *

C<AVAILABLE> - The backup is fully available.

=item *

C<PENDING> - For user-initiated backups on Lustre file systems only;
Amazon FSx has not started creating the backup.

=item *

C<CREATING> - Amazon FSx is creating the backup.

=item *

C<TRANSFERRING> - For user-initiated backups on Lustre file systems
only; Amazon FSx is transferring the backup to S3.

=item *

C<COPYING> - Amazon FSx is copying the backup.

=item *

C<DELETED> - Amazon FSx deleted the backup and it is no longer
available.

=item *

C<FAILED> - Amazon FSx could not complete the backup.

=back



=head2 OwnerId => Str




=head2 ProgressPercent => Int




=head2 ResourceARN => Str

The Amazon Resource Name (ARN) for the backup resource.


=head2 SourceBackupId => Str




=head2 SourceBackupRegion => Str

The source Region of the backup. Specifies the Region from where this
backup is copied.


=head2 Tags => ArrayRef[L<Paws::FSX::Tag>]

Tags associated with a particular file system.


=head2 B<REQUIRED> Type => Str

The type of the file system backup.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FSX>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

