/*
 * Copyright 2002,2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.28
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

#define SWIGPERL
#define SWIG_CASTRANK_MODE

#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC)
#   if (__SUNPRO_CC <= 0x560)
#     define SWIGTEMPLATEDISAMBIGUATOR template
#   else
#     define SWIGTEMPLATEDISAMBIGUATOR 
#   endif
# else
#   define SWIGTEMPLATEDISAMBIGUATOR 
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* -----------------------------------------------------------------------------
 * swigrun.swg
 *
 * This file contains generic CAPI SWIG runtime support for pointer
 * type checking.
 * ----------------------------------------------------------------------------- */

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "2"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

/*  Generic buffer size */
#ifndef SWIG_BUFFER_SIZE
# define SWIG_BUFFER_SIZE 1024
#endif

/* Flags for pointer conversions */
#define SWIG_POINTER_DISOWN        0x1

/* Flags for new pointer objects */
#define SWIG_POINTER_OWN           0x1


/* 
   Flags/methods for returning states.
   
   The swig conversion methods, as ConvertPtr, return and integer 
   that tells if the conversion was successful or not. And if not,
   an error code can be returned (see swigerrors.swg for the codes).
   
   Use the following macros/flags to set or process the returning
   states.
   
   In old swig versions, you usually write code as:

     if (SWIG_ConvertPtr(obj,vptr,ty.flags) != -1) {
       // success code
     } else {
       //fail code
     }

   Now you can be more explicit as:

    int res = SWIG_ConvertPtr(obj,vptr,ty.flags);
    if (SWIG_IsOK(res)) {
      // success code
    } else {
      // fail code
    }

   that seems to be the same, but now you can also do

    Type *ptr;
    int res = SWIG_ConvertPtr(obj,(void **)(&ptr),ty.flags);
    if (SWIG_IsOK(res)) {
      // success code
      if (SWIG_IsNewObj(res) {
        ...
	delete *ptr;
      } else {
        ...
      }
    } else {
      // fail code
    }
    
   I.e., now SWIG_ConvertPtr can return new objects and you can
   identify the case and take care of the deallocation. Of course that
   requires also to SWIG_ConvertPtr to return new result values, as

      int SWIG_ConvertPtr(obj, ptr,...) {         
        if (<obj is ok>) {			       
          if (<need new object>) {		       
            *ptr = <ptr to new allocated object>; 
            return SWIG_NEWOBJ;		       
          } else {				       
            *ptr = <ptr to old object>;	       
            return SWIG_OLDOBJ;		       
          } 				       
        } else {				       
          return SWIG_BADOBJ;		       
        }					       
      }

   Of course, returning the plain '0(success)/-1(fail)' still works, but you can be
   more explicit by returning SWIG_BADOBJ, SWIG_ERROR or any of the
   swig errors code.

   Finally, if the SWIG_CASTRANK_MODE is enabled, the result code
   allows to return the 'cast rank', for example, if you have this

       int food(double)
       int fooi(int);

   and you call
 
      food(1)   // cast rank '1'  (1 -> 1.0)
      fooi(1)   // cast rank '0'

   just use the SWIG_AddCast()/SWIG_CheckState()


 */
#define SWIG_OK                    (0) 
#define SWIG_ERROR                 (-1)
#define SWIG_IsOK(r)               (r >= 0)
#define SWIG_ArgError(r)           ((r != SWIG_ERROR) ? r : SWIG_TypeError)  

/* The CastRankLimit says how many bits are used for the cast rank */
#define SWIG_CASTRANKLIMIT         (1 << 8)
/* The NewMask denotes the object was created (using new/malloc) */
#define SWIG_NEWOBJMASK            (SWIG_CASTRANKLIMIT  << 1)
/* The TmpMask is for in/out typemaps that use temporal objects */
#define SWIG_TMPOBJMASK            (SWIG_NEWOBJMASK << 1)
/* Simple returning values */
#define SWIG_BADOBJ                (SWIG_ERROR)
#define SWIG_OLDOBJ                (SWIG_OK)
#define SWIG_NEWOBJ                (SWIG_OK | SWIG_NEWOBJMASK)
#define SWIG_TMPOBJ                (SWIG_OK | SWIG_TMPOBJMASK)
/* Check, add and del mask methods */
#define SWIG_AddNewMask(r)         (SWIG_IsOK(r) ? (r | SWIG_NEWOBJMASK) : r)
#define SWIG_DelNewMask(r)         (SWIG_IsOK(r) ? (r & ~SWIG_NEWOBJMASK) : r)
#define SWIG_IsNewObj(r)           (SWIG_IsOK(r) && (r & SWIG_NEWOBJMASK))
#define SWIG_AddTmpMask(r)         (SWIG_IsOK(r) ? (r | SWIG_TMPOBJMASK) : r)
#define SWIG_DelTmpMask(r)         (SWIG_IsOK(r) ? (r & ~SWIG_TMPOBJMASK) : r)
#define SWIG_IsTmpObj(r)           (SWIG_IsOK(r) && (r & SWIG_TMPOBJMASK))


/* Cast-Rank Mode */
#if defined(SWIG_CASTRANK_MODE)
#  ifndef SWIG_TypeRank
#    define SWIG_TypeRank             unsigned long
#  endif
#  ifndef SWIG_MAXCASTRANK            /* Default cast allowed */
#    define SWIG_MAXCASTRANK          (2)
#  endif
#  define SWIG_CASTRANKMASK          ((SWIG_CASTRANKLIMIT) -1)
#  define SWIG_CastRank(r)           (r & SWIG_CASTRANKMASK)
SWIGINTERNINLINE int SWIG_AddCast(int r) { 
  return SWIG_IsOK(r) ? ((SWIG_CastRank(r) < SWIG_MAXCASTRANK) ? (r + 1) : SWIG_ERROR) : r;
}
SWIGINTERNINLINE int SWIG_CheckState(int r) { 
  return SWIG_IsOK(r) ? SWIG_CastRank(r) + 1 : 0; 
}
#else /* no cast-rank mode */
#  define SWIG_AddCast
#  define SWIG_CheckState(r) (SWIG_IsOK(r) ? 1 : 0)
#endif




#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store inforomation on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
  int                    owndata;		/* flag if the structure owns the clientdata */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;

/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (*f1 > *f2) ? 1 : -1;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCompare(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}


/* think of this as a c++ template<> or a scheme macro */
#define SWIG_TypeCheck_Template(comparison, ty)         \
  if (ty) {                                             \
    swig_cast_info *iter = ty->cast;                    \
    while (iter) {                                      \
      if (comparison) {                                 \
        if (iter == ty->cast) return iter;              \
        /* Move iter to the top of the linked list */   \
        iter->prev->next = iter->next;                  \
        if (iter->next)                                 \
          iter->next->prev = iter->prev;                \
        iter->next = ty->cast;                          \
        iter->prev = 0;                                 \
        if (ty->cast) ty->cast->prev = iter;            \
        ty->cast = iter;                                \
        return iter;                                    \
      }                                                 \
      iter = iter->next;                                \
    }                                                   \
  }                                                     \
  return 0

/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  SWIG_TypeCheck_Template(strcmp(iter->type->name, c) == 0, ty);
}

/* Same as previous function, except strcmp is replaced with a pointer comparison */
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *into) {
  SWIG_TypeCheck_Template(iter->type == from, into);
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (!type) return NULL;
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_cast_info *cast = ti->cast;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  
  while (cast) {
    if (!cast->converter) {
      swig_type_info *tc = cast->type;
      if (!tc->clientdata) {
	SWIG_TypeClientData(tc, clientdata);
      }
    }    
    cast = cast->next;
  }
}
SWIGRUNTIME void
SWIG_TypeNewClientData(swig_type_info *ti, void *clientdata) {
  SWIG_TypeClientData(ti, clientdata);
  ti->owndata = 1;
}
  
/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start, 
                            swig_module_info *end, 
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      register size_t l = 0;
      register size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	register size_t i = (l + r) >> 1; 
	const char *iname = iter->types[i]->name;
	if (iname) {
	  register int compare = strcmp(name, iname);
	  if (compare == 0) {	    
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start, 
                     swig_module_info *end, 
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      register size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }
  
  /* neither found a match */
  return 0;
}

/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  register const unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    register char d = *(c++);
    register unsigned char uu;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1 
#define  SWIG_IOError        	   -2 
#define  SWIG_RuntimeError   	   -3 
#define  SWIG_IndexError     	   -4 
#define  SWIG_TypeError      	   -5 
#define  SWIG_DivisionByZero 	   -6 
#define  SWIG_OverflowError  	   -7 
#define  SWIG_SyntaxError    	   -8 
#define  SWIG_ValueError     	   -9 
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12 
#define  SWIG_NullReferenceError   -13



#ifdef __cplusplus
/* Needed on some windows machines---since MS plays funny games with the header files under C++ */
#include <math.h>
#include <stdlib.h>
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

/* Add in functionality missing in older versions of Perl. Much of this is based on Devel-PPPort on cpan. */

/* Add PERL_REVISION, PERL_VERSION, PERL_SUBVERSION if missing */
#ifndef PERL_REVISION
#  if !defined(__PATCHLEVEL_H_INCLUDED__) && !(defined(PATCHLEVEL) && defined(SUBVERSION))
#    define PERL_PATCHLEVEL_H_IMPLICIT
#    include <patchlevel.h>
#  endif
#  if !(defined(PERL_VERSION) || (defined(SUBVERSION) && defined(PATCHLEVEL)))
#    include <could_not_find_Perl_patchlevel.h>
#  endif
#  ifndef PERL_REVISION
#    define PERL_REVISION       (5)
#    define PERL_VERSION        PATCHLEVEL
#    define PERL_SUBVERSION     SUBVERSION
#  endif
#endif

#if defined(WIN32) && defined(PERL_OBJECT) && !defined(PerlIO_exportFILE)
#define PerlIO_exportFILE(fh,fl) (FILE*)(fh)
#endif

#ifndef SvIOK_UV
# define SvIOK_UV(sv)       (SvIOK(sv) && (SvUVX(sv) == SvIVX(sv)))
#endif

#ifndef SvUOK
# define SvUOK(sv)           SvIOK_UV(sv)
#endif

#if ((PERL_VERSION < 4) || ((PERL_VERSION == 4) && (PERL_SUBVERSION <= 5)))
#  define PL_sv_undef               sv_undef
#  define PL_na	                    na
#  define PL_errgv                  errgv
#  define PL_sv_no                  sv_no
#  define PL_sv_yes                 sv_yes
#  define PL_markstack_ptr          markstack_ptr
#endif

#ifndef IVSIZE
#  ifdef LONGSIZE
#    define IVSIZE LONGSIZE
#  else
#    define IVSIZE 4 /* A bold guess, but the best we can make. */
#  endif
#endif

#ifndef INT2PTR
#  if (IVSIZE == PTRSIZE) && (UVSIZE == PTRSIZE)
#    define PTRV                  UV
#    define INT2PTR(any,d)        (any)(d)
#  else
#    if PTRSIZE == LONGSIZE
#      define PTRV                unsigned long
#    else
#      define PTRV                unsigned
#    endif
#    define INT2PTR(any,d)        (any)(PTRV)(d)
#  endif

#  define NUM2PTR(any,d)  (any)(PTRV)(d)
#  define PTR2IV(p)       INT2PTR(IV,p)
#  define PTR2UV(p)       INT2PTR(UV,p)
#  define PTR2NV(p)       NUM2PTR(NV,p)

#  if PTRSIZE == LONGSIZE
#    define PTR2ul(p)     (unsigned long)(p)
#  else
#    define PTR2ul(p)     INT2PTR(unsigned long,p)
#  endif
#endif /* !INT2PTR */

#ifndef get_sv
#  define get_sv perl_get_sv
#endif

#ifndef ERRSV
#  define ERRSV get_sv("@",FALSE)
#endif

#ifndef pTHX_
#define pTHX_
#endif   

#include <string.h>
#ifdef __cplusplus
}
#endif

/* -----------------------------------------------------------------------------
 * error manipulation
 * ----------------------------------------------------------------------------- */

SWIGINTERN const char*
SWIG_Perl_ErrorType(int code) {
  const char* type = 0;
  switch(code) {
  case SWIG_MemoryError:
    type = "MemoryError";
    break;
  case SWIG_IOError:
    type = "IOError";
    break;
  case SWIG_RuntimeError:
    type = "RuntimeError";
    break;
  case SWIG_IndexError:
    type = "IndexError";
    break;
  case SWIG_TypeError:
    type = "TypeError";
    break;
  case SWIG_DivisionByZero:
    type = "ZeroDivisionError";
    break;
  case SWIG_OverflowError:
    type = "OverflowError";
    break;
  case SWIG_SyntaxError:
    type = "SyntaxError";
    break;
  case SWIG_ValueError:
    type = "ValueError";
    break;
  case SWIG_SystemError:
    type = "SystemError";
    break;
  case SWIG_AttributeError:
    type = "AttributeError";
    break;
  default:
    type = "RuntimeError";
  }
  return type;
}




/* -----------------------------------------------------------------------------
 * perlrun.swg
 *
 * This file contains the runtime support for Perl modules
 * and includes code for managing global variables and pointer
 * type checking.
 * ----------------------------------------------------------------------------- */

#ifdef PERL_OBJECT
#define SWIG_PERL_OBJECT_DECL CPerlObj *SWIGUNUSEDPARM(pPerl),
#define SWIG_PERL_OBJECT_CALL pPerl,
#else
#define SWIG_PERL_OBJECT_DECL
#define SWIG_PERL_OBJECT_CALL
#endif

/* Common SWIG API */

/* for raw pointers */
#define SWIG_ConvertPtr(obj, pp, type, flags)           SWIG_Perl_ConvertPtr(SWIG_PERL_OBJECT_CALL obj, pp, type, flags)
#define SWIG_NewPointerObj(p, type, flags)              SWIG_Perl_NewPointerObj(SWIG_PERL_OBJECT_CALL p, type, flags)

/* for raw packed data */
#define SWIG_ConvertPacked(obj, p, s, type)             SWIG_Perl_ConvertPacked(SWIG_PERL_OBJECT_CALL obj, p, s, type)
#define SWIG_NewPackedObj(p, s, type)	                SWIG_Perl_NewPackedObj(SWIG_PERL_OBJECT_CALL p, s, type)

/* for class or struct pointers */
#define SWIG_ConvertInstance(obj, pptr, type, flags)    SWIG_ConvertPtr(obj, pptr, type, flags)
#define SWIG_NewInstanceObj(ptr, type, flags)           SWIG_NewPointerObj(ptr, type, flags)

/* for C or C++ function pointers */
#define SWIG_ConvertFunctionPtr(obj, pptr, type)        SWIG_ConvertPtr(obj, pptr, type, 0)
#define SWIG_NewFunctionPtrObj(ptr, type)               SWIG_NewPointerObj(ptr, type, 0)

/* for C++ member pointers, ie, member methods */
#define SWIG_ConvertMember(obj, ptr, sz, ty)            SWIG_ConvertPacked(obj, ptr, sz, ty)
#define SWIG_NewMemberObj(ptr, sz, type)                SWIG_NewPackedObj(ptr, sz, type)


/* Runtime API */

#define SWIG_GetModule(clientdata)                      SWIG_Perl_GetModule()
#define SWIG_SetModule(clientdata, pointer)             SWIG_Perl_SetModule(pointer)


/* Error manipulation */

#define SWIG_ErrorType(code)                            SWIG_Perl_ErrorType(code)               
#define SWIG_Error(code, msg)            		sv_setpvf(GvSV(PL_errgv),"%s %s\n", SWIG_ErrorType(code), msg)
#define SWIG_fail                        		goto fail						    

/* Perl-specific SWIG API */

#define SWIG_MakePtr(sv, ptr, type, flags)              SWIG_Perl_MakePtr(SWIG_PERL_OBJECT_CALL sv, ptr, type, flags)
#define SWIG_MakePackedObj(sv, p, s, type)	        SWIG_Perl_MakePackedObj(SWIG_PERL_OBJECT_CALL sv, p, s, type)
#define SWIG_SetError(str)                              SWIG_Error(SWIG_RuntimeError, str)


#define SWIG_PERL_DECL_ARGS_1(arg1)                     (SWIG_PERL_OBJECT_DECL arg1)
#define SWIG_PERL_CALL_ARGS_1(arg1)                     (SWIG_PERL_OBJECT_CALL arg1)
#define SWIG_PERL_DECL_ARGS_2(arg1, arg2)               (SWIG_PERL_OBJECT_DECL arg1, arg2)
#define SWIG_PERL_CALL_ARGS_2(arg1, arg2)               (SWIG_PERL_OBJECT_CALL arg1, arg2)

/* -----------------------------------------------------------------------------
 * pointers/data manipulation
 * ----------------------------------------------------------------------------- */

/* For backward compatibility only */
#define SWIG_POINTER_EXCEPTION  0

#ifdef __cplusplus
extern "C" {
#endif

#define SWIG_OWNER   SWIG_POINTER_OWN
#define SWIG_SHADOW  SWIG_OWNER << 1

#define SWIG_MAYBE_PERL_OBJECT SWIG_PERL_OBJECT_DECL

/* SWIG Perl macros */

/* Macro to call an XS function */
#ifdef PERL_OBJECT 
#  define SWIG_CALLXS(_name) _name(cv,pPerl) 
#else 
#  ifndef MULTIPLICITY 
#    define SWIG_CALLXS(_name) _name(cv) 
#  else 
#    define SWIG_CALLXS(_name) _name(PERL_GET_THX, cv) 
#  endif 
#endif 

/* Note: SwigMagicFuncHack is a typedef used to get the C++ compiler to just shut up already */

#ifdef PERL_OBJECT
#define MAGIC_PPERL  CPerlObj *pPerl = (CPerlObj *) this;
typedef int (CPerlObj::*SwigMagicFunc)(SV *, MAGIC *);

#ifdef __cplusplus
extern "C" {
#endif
typedef int (CPerlObj::*SwigMagicFuncHack)(SV *, MAGIC *);
#ifdef __cplusplus
}
#endif

#define SWIG_MAGIC(a,b) (SV *a, MAGIC *b)
#define SWIGCLASS_STATIC
#else
#define MAGIC_PPERL
#define SWIGCLASS_STATIC static SWIGUNUSED
#ifndef MULTIPLICITY
#define SWIG_MAGIC(a,b) (SV *a, MAGIC *b)
typedef int (*SwigMagicFunc)(SV *, MAGIC *);

#ifdef __cplusplus
extern "C" {
#endif
typedef int (*SwigMagicFuncHack)(SV *, MAGIC *);
#ifdef __cplusplus
}
#endif


#else
#define SWIG_MAGIC(a,b) (struct interpreter *interp, SV *a, MAGIC *b)
typedef int (*SwigMagicFunc)(struct interpreter *, SV *, MAGIC *);
#ifdef __cplusplus
extern "C" {
#endif
typedef int (*SwigMagicFuncHack)(struct interpreter *, SV *, MAGIC *);
#ifdef __cplusplus
}
#endif

#endif
#endif

/* Workaround for bug in perl 5.6.x croak and earlier */
#if (PERL_VERSION < 8)
#  ifdef PERL_OBJECT
#    define SWIG_croak_null() SWIG_Perl_croak_null(pPerl)
static void SWIG_Perl_croak_null(CPerlObj *pPerl)
#  else
static void SWIG_croak_null()
#  endif
{
  SV *err=ERRSV;
#  if (PERL_VERSION < 6)
  croak("%_", err);
#  else
  if (SvOK(err) && !SvROK(err)) croak("%_", err);
  croak(Nullch);
#  endif
}
#else
#  define SWIG_croak_null() croak(Nullch)
#endif



#include <stdlib.h>

SWIGRUNTIME const char *
SWIG_Perl_TypeProxyName(const swig_type_info *type) {
  if (!type) return NULL;
  if (type->clientdata != NULL) {
    return (const char*) type->clientdata;
  } 
  else {
    return type->name;
  }
}

SWIGRUNTIME swig_cast_info *
SWIG_TypeProxyCheck(const char *c, swig_type_info *ty) {
  SWIG_TypeCheck_Template(( (!iter->type->clientdata && (strcmp((char*)iter->type->name, c) == 0)) 
			    || (iter->type->clientdata && (strcmp((char*)iter->type->clientdata, c) == 0))), ty);
}


/* Function for getting a pointer value */

SWIGRUNTIME int
SWIG_Perl_ConvertPtr(SWIG_MAYBE_PERL_OBJECT SV *sv, void **ptr, swig_type_info *_t, int flags) {
  swig_cast_info *tc;
  void *voidptr = (void *)0;
  SV *tsv = 0;
  /* If magical, apply more magic */
  if (SvGMAGICAL(sv))
    mg_get(sv);

  /* Check to see if this is an object */
  if (sv_isobject(sv)) {
    IV tmp = 0;
    tsv = (SV*) SvRV(sv);
    if ((SvTYPE(tsv) == SVt_PVHV)) {
      MAGIC *mg;
      if (SvMAGICAL(tsv)) {
        mg = mg_find(tsv,'P');
        if (mg) {
          sv = mg->mg_obj;
          if (sv_isobject(sv)) {
	    tsv = (SV*)SvRV(sv);
            tmp = SvIV(tsv);
          }
        }
      } else {
        return SWIG_ERROR;
      }
    } else {
      tmp = SvIV(tsv);
    }
    voidptr = INT2PTR(void *,tmp);
  } else if (! SvOK(sv)) {            /* Check for undef */
    *(ptr) = (void *) 0;
    return SWIG_OK;
  } else if (SvTYPE(sv) == SVt_RV) {  /* Check for NULL pointer */
    if (!SvROK(sv)) {
      *(ptr) = (void *) 0;
      return SWIG_OK;
    } else {
      return SWIG_ERROR;
    }
  } else {                            /* Don't know what it is */
    return SWIG_ERROR;
  }
  if (_t) {
    /* Now see if the types match */
    char *_c = HvNAME(SvSTASH(SvRV(sv)));
    tc = SWIG_TypeProxyCheck(_c,_t);
    if (!tc) {
      return SWIG_ERROR;
    }
    *ptr = SWIG_TypeCast(tc,voidptr);
  } else {
    *ptr = voidptr;
  }

  /* 
   *  DISOWN implementation: we need a perl guru to check this one.
   */
  if (tsv && (flags & SWIG_POINTER_DISOWN)) {
    /* 
     *  almost copy paste code from below SWIG_POINTER_OWN setting
     */
    SV *obj = sv;
    HV *stash = SvSTASH(SvRV(obj));
    GV *gv = *(GV**) hv_fetch(stash, "OWNER", 5, TRUE);
    if (isGV(gv)) {
      HV *hv = GvHVn(gv);
      /*
       * To set ownership (see below), a newSViv(1) entry is added. 
       * Hence, to remove ownership, we delete the entry.
       */
      if (hv_exists_ent(hv, obj, 0)) {
	hv_delete_ent(hv, obj, 0, 0);
      }
    }
  }
  return SWIG_OK;
}

SWIGRUNTIME void
SWIG_Perl_MakePtr(SWIG_MAYBE_PERL_OBJECT SV *sv, void *ptr, swig_type_info *t, int flags) {
  if (ptr && (flags & SWIG_SHADOW)) {
    SV *self;
    SV *obj=newSV(0);
    HV *hash=newHV();
    HV *stash;
    sv_setref_pv(obj, (char *) SWIG_Perl_TypeProxyName(t), ptr);
    stash=SvSTASH(SvRV(obj));
    if (flags & SWIG_POINTER_OWN) {
      HV *hv;
      GV *gv=*(GV**)hv_fetch(stash, "OWNER", 5, TRUE);
      if (!isGV(gv))
        gv_init(gv, stash, "OWNER", 5, FALSE);
      hv=GvHVn(gv);
      hv_store_ent(hv, obj, newSViv(1), 0);
    }
    sv_magic((SV *)hash, (SV *)obj, 'P', Nullch, 0);
    SvREFCNT_dec(obj);
    self=newRV_noinc((SV *)hash);
    sv_setsv(sv, self);
    SvREFCNT_dec((SV *)self);
    sv_bless(sv, stash);
  }
  else {
    sv_setref_pv(sv, (char *) SWIG_Perl_TypeProxyName(t), ptr);
  }
}

SWIGRUNTIMEINLINE SV *
SWIG_Perl_NewPointerObj(SWIG_MAYBE_PERL_OBJECT void *ptr, swig_type_info *t, int flags) {
  SV *result = sv_newmortal();
  SWIG_MakePtr(result, ptr, t, flags);
  return result;
}

SWIGRUNTIME void
SWIG_Perl_MakePackedObj(SWIG_MAYBE_PERL_OBJECT SV *sv, void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(SWIG_Perl_TypeProxyName(type))) > 1000) return;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  strcpy(r,SWIG_Perl_TypeProxyName(type));
  sv_setpv(sv, result);
}

SWIGRUNTIME SV *
SWIG_Perl_NewPackedObj(SWIG_MAYBE_PERL_OBJECT void *ptr, int sz, swig_type_info *type) {
  SV *result = sv_newmortal();
  SWIG_Perl_MakePackedObj(result, ptr, sz, type);
  return result;
}

/* Convert a packed value value */
SWIGRUNTIME int
SWIG_Perl_ConvertPacked(SWIG_MAYBE_PERL_OBJECT SV *obj, void *ptr, int sz, swig_type_info *ty) {
  swig_cast_info *tc;
  const char  *c = 0;

  if ((!obj) || (!SvOK(obj))) return SWIG_ERROR;
  c = SvPV(obj, PL_na);
  /* Pointer values must start with leading underscore */
  if (*c != '_') return SWIG_ERROR;
  c++;
  c = SWIG_UnpackData(c,ptr,sz);
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) return SWIG_ERROR;
  }
  return SWIG_OK;
}


/* Macros for low-level exception handling */
#define SWIG_croak(x)    { SWIG_Error(SWIG_RuntimeError, x); SWIG_fail; }


typedef XS(SwigPerlWrapper);
typedef SwigPerlWrapper *SwigPerlWrapperPtr;

/* Structure for command table */
typedef struct {
  const char         *name;
  SwigPerlWrapperPtr  wrapper;
} swig_command_info;

/* Information for constant table */

#define SWIG_INT     1
#define SWIG_FLOAT   2
#define SWIG_STRING  3
#define SWIG_POINTER 4
#define SWIG_BINARY  5

/* Constant information structure */
typedef struct swig_constant_info {
    int              type;
    const char      *name;
    long             lvalue;
    double           dvalue;
    void            *pvalue;
    swig_type_info **ptype;
} swig_constant_info;


/* Structure for variable table */
typedef struct {
  const char   *name;
  SwigMagicFunc   set;
  SwigMagicFunc   get;
  swig_type_info  **type;
} swig_variable_info;

/* Magic variable code */
#ifndef PERL_OBJECT
#define swig_create_magic(s,a,b,c) _swig_create_magic(s,a,b,c)
  #ifndef MULTIPLICITY
     SWIGRUNTIME void _swig_create_magic(SV *sv, char *name, int (*set)(SV *, MAGIC *), int (*get)(SV *,MAGIC *)) 
  #else
     SWIGRUNTIME void _swig_create_magic(SV *sv, char *name, int (*set)(struct interpreter*, SV *, MAGIC *), int (*get)(struct interpreter*, SV *,MAGIC *)) 
  #endif
#else
#  define swig_create_magic(s,a,b,c) _swig_create_magic(pPerl,s,a,b,c)
SWIGRUNTIME void _swig_create_magic(CPerlObj *pPerl, SV *sv, const char *name, int (CPerlObj::*set)(SV *, MAGIC *), int (CPerlObj::*get)(SV *, MAGIC *)) 
#endif
{
  MAGIC *mg;
  sv_magic(sv,sv,'U',(char *) name,strlen(name));
  mg = mg_find(sv,'U');
  mg->mg_virtual = (MGVTBL *) malloc(sizeof(MGVTBL));
  mg->mg_virtual->svt_get = (SwigMagicFuncHack) get;
  mg->mg_virtual->svt_set = (SwigMagicFuncHack) set;
  mg->mg_virtual->svt_len = 0;
  mg->mg_virtual->svt_clear = 0;
  mg->mg_virtual->svt_free = 0;
}


SWIGRUNTIME swig_module_info *
SWIG_Perl_GetModule(void) {
  static void *type_pointer = (void *)0;
  SV *pointer;

  /* first check if pointer already created */
  if (!type_pointer) {
    pointer = get_sv("swig_runtime_data::type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME, FALSE);
    if (pointer && SvOK(pointer)) {
      type_pointer = INT2PTR(swig_type_info **, SvIV(pointer));
    }
  }

  return (swig_module_info *) type_pointer;
}

SWIGRUNTIME void
SWIG_Perl_SetModule(swig_module_info *module) {
  SV *pointer;

  /* create a new pointer */
  pointer = get_sv("swig_runtime_data::type_pointer" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME, TRUE);
  sv_setiv(pointer, PTR2IV(module));
}

#ifdef __cplusplus
}
#endif

/* Workaround perl5 global namespace pollution. Note that undefining library
 * functions like fopen will not solve the problem on all platforms as fopen
 * might be a macro on Windows but not necessarily on other operating systems. */
#ifdef do_open
  #undef do_open
#endif
#ifdef do_close
  #undef do_close
#endif
#ifdef scalar
  #undef scalar
#endif
#ifdef list
  #undef list
#endif
#ifdef apply
  #undef apply
#endif
#ifdef convert
  #undef convert
#endif
#ifdef Error
  #undef Error
#endif
#ifdef form
  #undef form
#endif
#ifdef vform
  #undef vform
#endif
#ifdef LABEL
  #undef LABEL
#endif
#ifdef METHOD
  #undef METHOD
#endif
#ifdef Move
  #undef Move
#endif
#ifdef yylex
  #undef yylex
#endif
#ifdef yyparse
  #undef yyparse
#endif
#ifdef yyerror
  #undef yyerror
#endif
#ifdef invert
  #undef invert
#endif
#ifdef ref
  #undef ref
#endif
#ifdef read
  #undef read
#endif
#ifdef write
  #undef write
#endif
#ifdef eof
  #undef eof
#endif
#ifdef bool
  #undef bool
#endif
#ifdef close
  #undef close
#endif
#ifdef rewind
  #undef rewind
#endif
#ifdef free
  #undef free
#endif
#ifdef malloc
  #undef malloc
#endif
#ifdef calloc
  #undef calloc
#endif
#ifdef Stat
  #undef Stat
#endif
#ifdef check
  #undef check
#endif



#define SWIG_exception_fail(code, msg) do { SWIG_Error(code, msg); SWIG_fail; } while(0) 

#define SWIG_contract_assert(expr, msg) if (!(expr)) { SWIG_Error(SWIG_RuntimeError, msg); SWIG_fail; } else 



/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_DatatypeValidatorFactory swig_types[0]
#define SWIGTYPE_p_IdentityConstraint swig_types[1]
#define SWIGTYPE_p_PSVIAttributeList swig_types[2]
#define SWIGTYPE_p_PSVIDefs__Complexity swig_types[3]
#define SWIGTYPE_p_PSVIDefs__PSVIScope swig_types[4]
#define SWIGTYPE_p_PSVIDefs__Validation swig_types[5]
#define SWIGTYPE_p_PSVIDefs__Validity swig_types[6]
#define SWIGTYPE_p_PSVIElement swig_types[7]
#define SWIGTYPE_p_PanicHandler swig_types[8]
#define SWIGTYPE_p_PanicHandler__PanicReasons swig_types[9]
#define SWIGTYPE_p_PerlCallbackHandler swig_types[10]
#define SWIGTYPE_p_PerlContentCallbackHandler swig_types[11]
#define SWIGTYPE_p_PerlDocumentCallbackHandler swig_types[12]
#define SWIGTYPE_p_PerlEntityResolverHandler swig_types[13]
#define SWIGTYPE_p_PerlErrorCallbackHandler swig_types[14]
#define SWIGTYPE_p_PerlNodeFilterCallbackHandler swig_types[15]
#define SWIGTYPE_p_RefArrayVectorOfTunsigned_short_t swig_types[16]
#define SWIGTYPE_p_RefHash2KeysTableOfTValueVectorOfTXERCES_CPP_NAMESPACE__SchemaElementDecl_p_t_t swig_types[17]
#define SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__ComplexTypeInfo_t swig_types[18]
#define SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XMLAttDef_t swig_types[19]
#define SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XSAnnotation_t swig_types[20]
#define SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XercesAttGroupInfo_t swig_types[21]
#define SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XercesGroupInfo_t swig_types[22]
#define SWIGTYPE_p_RefHashTableOfTXMLRefInfo_t swig_types[23]
#define SWIGTYPE_p_SecurityManager swig_types[24]
#define SWIGTYPE_p_ValidationContext swig_types[25]
#define SWIGTYPE_p_ValueVectorOfTXERCES_CPP_NAMESPACE__SchemaElementDecl_p_t swig_types[26]
#define SWIGTYPE_p_ValueVectorOfTunsigned_int_t swig_types[27]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__AbstractDOMParser swig_types[28]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__AttributeList swig_types[29]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__Attributes swig_types[30]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__BinInputStream swig_types[31]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__ComplexTypeInfo swig_types[32]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__ContentHandler swig_types[33]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__ContentSpecNode swig_types[34]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr swig_types[35]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMBuilder swig_types[36]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMBuilderFilter swig_types[37]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMCDATASection swig_types[38]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMCharacterData swig_types[39]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMComment swig_types[40]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMConfiguration swig_types[41]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocument swig_types[42]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocumentFragment swig_types[43]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocumentRange swig_types[44]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocumentTraversal swig_types[45]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocumentType swig_types[46]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement swig_types[47]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMEntity swig_types[48]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMEntityReference swig_types[49]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMEntityResolver swig_types[50]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMError swig_types[51]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMErrorHandler swig_types[52]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMException swig_types[53]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMImplementation swig_types[54]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMImplementationLS swig_types[55]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMImplementationRegistry swig_types[56]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMImplementationSource swig_types[57]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMInputSource swig_types[58]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMLocator swig_types[59]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNamedNodeMap swig_types[60]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode swig_types[61]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNodeFilter swig_types[62]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNodeIterator swig_types[63]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNodeList swig_types[64]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNotation swig_types[65]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMProcessingInstruction swig_types[66]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMRange swig_types[67]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMRangeException swig_types[68]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMText swig_types[69]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMTreeWalker swig_types[70]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMTypeInfo swig_types[71]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMUserDataHandler swig_types[72]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMWriter swig_types[73]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMWriterFilter swig_types[74]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef swig_types[75]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList swig_types[76]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl swig_types[77]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl swig_types[78]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar swig_types[79]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDHandler swig_types[80]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDValidator swig_types[81]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator swig_types[82]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DeclHandler swig_types[83]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DefaultHandler swig_types[84]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__DocumentHandler swig_types[85]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__EntityResolver swig_types[86]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__ErrorHandler swig_types[87]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar swig_types[88]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__GrammarResolver swig_types[89]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__HandlerBase swig_types[90]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource swig_types[91]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__LexicalHandler swig_types[92]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__LocalFileFormatTarget swig_types[93]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__LocalFileInputSource swig_types[94]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__Locator swig_types[95]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemBufFormatTarget swig_types[96]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemBufInputSource swig_types[97]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager swig_types[98]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t swig_types[99]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t swig_types[100]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__XMLNotationDecl_t swig_types[101]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDElementDecl_t swig_types[102]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDEntityDecl_t swig_types[103]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__NamespaceScope swig_types[104]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__PSVIHandler swig_types[105]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__Parser swig_types[106]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName swig_types[107]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t swig_types[108]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolTXERCES_CPP_NAMESPACE__SchemaElementDecl_t swig_types[109]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SAX2XMLReader swig_types[110]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SAXException swig_types[111]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SAXNotRecognizedException swig_types[112]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SAXNotSupportedException swig_types[113]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SAXParseException swig_types[114]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SAXParser swig_types[115]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef swig_types[116]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList swig_types[117]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl swig_types[118]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar swig_types[119]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator swig_types[120]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__StdInInputSource swig_types[121]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__StdOutFormatTarget swig_types[122]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__URLInputSource swig_types[123]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__Wrapper4DOMInputSource swig_types[124]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__Wrapper4InputSource swig_types[125]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef swig_types[126]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList swig_types[127]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLContentModel swig_types[128]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDTDDescription swig_types[129]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDeleter swig_types[130]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDocumentHandler swig_types[131]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl swig_types[132]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl swig_types[133]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityResolver swig_types[134]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t swig_types[135]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t swig_types[136]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t swig_types[137]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException swig_types[138]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLExcepts swig_types[139]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLFormatTarget swig_types[140]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLFormatter swig_types[141]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription swig_types[142]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarPool swig_types[143]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl swig_types[144]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLPScanToken swig_types[145]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLPlatformUtils swig_types[146]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLReaderFactory swig_types[147]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription swig_types[148]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL swig_types[149]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUni swig_types[150]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri swig_types[151]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLValidator swig_types[152]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMemory swig_types[153]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XSAnnotation swig_types[154]
#define SWIGTYPE_p_XERCES_CPP_NAMESPACE__XercesDOMParser swig_types[155]
#define SWIGTYPE_p_XMLBuffer swig_types[156]
#define SWIGTYPE_p_XMLErrorReporter swig_types[157]
#define SWIGTYPE_p_XMLErrorReporter__ErrTypes swig_types[158]
#define SWIGTYPE_p_XSerializeEngine swig_types[159]
#define SWIGTYPE_p_a_32__unsigned_short swig_types[160]
#define SWIGTYPE_p_bool swig_types[161]
#define SWIGTYPE_p_char swig_types[162]
#define SWIGTYPE_p_int swig_types[163]
#define SWIGTYPE_p_long swig_types[164]
#define SWIGTYPE_p_p_void swig_types[165]
#define SWIGTYPE_p_unsigned_char swig_types[166]
#define SWIGTYPE_p_unsigned_int swig_types[167]
#define SWIGTYPE_p_unsigned_long swig_types[168]
#define SWIGTYPE_p_unsigned_short swig_types[169]
#define SWIGTYPE_p_void swig_types[170]
static swig_type_info *swig_types[172];
static swig_module_info swig_module = {swig_types, 171, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    boot_XML__Xerces

#define SWIG_name   "XML::Xercesc::boot_XML__Xerces"
#define SWIG_prefix "XML::Xercesc::"

#define SWIGVERSION 0x010328 


#define SWIG_as_voidptr(a) const_cast< void * >(static_cast< const void * >(a)) 
#define SWIG_as_voidptrptr(a) ((void)SWIG_as_voidptr(*a),reinterpret_cast< void** >(a)) 


#include <stdexcept>


#ifdef __cplusplus
extern "C"
#endif
#ifndef PERL_OBJECT
#ifndef MULTIPLICITY
SWIGEXPORT void SWIG_init (CV* cv);
#else
SWIGEXPORT void SWIG_init (pTHXo_ CV* cv);
#endif
#else
SWIGEXPORT void SWIG_init (CV *cv, CPerlObj *);
#endif


#include "xercesc/sax/InputSource.hpp"
#include "xercesc/sax/SAXException.hpp"
#include "xercesc/sax/SAXParseException.hpp"
#include "xercesc/sax/Locator.hpp"
#include "xercesc/sax/HandlerBase.hpp"
#include "xercesc/sax2/Attributes.hpp"
#include "xercesc/sax2/ContentHandler.hpp"
#include "xercesc/sax2/LexicalHandler.hpp"
#include "xercesc/sax2/DefaultHandler.hpp"
#include "xercesc/sax2/SAX2XMLReader.hpp"
#include "xercesc/sax2/XMLReaderFactory.hpp"
#include "xercesc/util/PlatformUtils.hpp"
#include "xercesc/util/TransService.hpp"
#include "xercesc/util/XMLString.hpp"
#include "xercesc/util/XMLUri.hpp"
#include "xercesc/util/QName.hpp"
#include "xercesc/util/HexBin.hpp"
#include "xercesc/util/Base64.hpp"
#include "xercesc/parsers/AbstractDOMParser.hpp"
#include "xercesc/parsers/XercesDOMParser.hpp"
#include "xercesc/parsers/SAXParser.hpp"
#include "xercesc/dom/DOM.hpp"
#include "xercesc/framework/LocalFileInputSource.hpp"
#include "xercesc/framework/MemBufInputSource.hpp"
#include "xercesc/framework/StdInInputSource.hpp"
#include "xercesc/framework/URLInputSource.hpp"
#include "xercesc/framework/XMLGrammarDescription.hpp"
#include "xercesc/framework/XMLDTDDescription.hpp"
#include "xercesc/framework/XMLSchemaDescription.hpp"
#include "xercesc/util/NameIdPool.hpp"
#include "xercesc/util/XMLEnumerator.hpp"
#include "xercesc/framework/XMLValidator.hpp"
#include "xercesc/validators/common/Grammar.hpp"
#include "xercesc/validators/DTD/DTDAttDef.hpp"
#include "xercesc/validators/DTD/DTDAttDefList.hpp"
#include "xercesc/validators/DTD/DTDGrammar.hpp"
#include "xercesc/validators/DTD/DTDValidator.hpp"
#include "xercesc/validators/schema/SchemaGrammar.hpp"
#include "xercesc/validators/schema/SchemaValidator.hpp"
#include "xercesc/validators/schema/SchemaAttDefList.hpp"
#include "xercesc/validators/schema/SchemaAttDef.hpp"
#include "xercesc/framework/XMLFormatter.hpp"
#include "xercesc/framework/MemBufFormatTarget.hpp"
#include "xercesc/framework/LocalFileFormatTarget.hpp"
#include "xercesc/framework/StdOutFormatTarget.hpp"
#include "xercesc/framework/Wrapper4InputSource.hpp"
#include "xercesc/framework/Wrapper4DOMInputSource.hpp"
#include "xercesc/framework/psvi/PSVIHandler.hpp"

// for resolving XMLExceptions
#include "xercesc/util/ArrayIndexOutOfBoundsException.hpp"
#include "xercesc/util/EmptyStackException.hpp"
#include "xercesc/util/IllegalArgumentException.hpp"
#include "xercesc/util/InvalidCastException.hpp"
#include "xercesc/util/IOException.hpp"
#include "xercesc/util/NoSuchElementException.hpp"
#include "xercesc/util/NullPointerException.hpp"
#include "xercesc/util/NumberFormatException.hpp"
#include "xercesc/util/ParseException.hpp"
#include "xercesc/util/RuntimeException.hpp"
#include "xercesc/util/SchemaDateTimeException.hpp"
#include "xercesc/util/TranscodingException.hpp"
#include "xercesc/util/UnexpectedEOFException.hpp"
#include "xercesc/util/UnsupportedEncodingException.hpp"
#include "xercesc/util/UTFDataFormatException.hpp"
#include "xercesc/util/XMLNetAccessor.hpp"
#include "xercesc/internal/XSerializationException.hpp"
#include "xercesc/validators/datatype/InvalidDatatypeFacetException.hpp"
#include "xercesc/validators/datatype/InvalidDatatypeValueException.hpp"
#include "xercesc/validators/schema/identity/XPathException.hpp"

XERCES_CPP_NAMESPACE_USE

// we initialize the static UTF-8 transcoding info
// these are used by the typemaps to convert between
// Xerces internal UTF-16 and Perl's internal UTF-8
static XMLCh* UTF8_ENCODING = NULL; 
static XMLTranscoder* UTF8_TRANSCODER  = NULL;

static bool DEBUG_UTF8_OUT = 0;
static bool DEBUG_UTF8_IN = 0;




#include "PerlCallbackHandler.hpp"
#include "PerlErrorCallbackHandler.hpp"
#include "PerlDocumentCallbackHandler.hpp"
#include "PerlContentCallbackHandler.hpp"
#include "PerlEntityResolverHandler.i"
#include "PerlNodeFilterCallbackHandler.i"

static void
SWIG_Disown(SV *sv) {
  
  if (SvGMAGICAL(sv)) {
      mg_get(sv);
  }
    

  /* Check to see if this is an object */
  if (sv_isobject(sv)) {
    SV *tsv = (SV*) SvRV(sv);
    if ((SvTYPE(tsv) == SVt_PVHV)) {
      MAGIC *mg;
      if (SvMAGICAL(tsv)) {
        mg = mg_find(tsv,'P');
        if (mg) {
          sv = mg->mg_obj;
          if (sv_isobject(sv)) {
              // fprintf(stderr,"Found object for disown\n");

	      HV *stash;
	      stash=SvSTASH(SvRV(sv));

	      if (stash != 0)
              {
                  // fprintf(stderr,"Found stash: %x\n",stash);
                  HV *hv;
                  GV *gv=*(GV**)hv_fetch(stash, "OWNER", 5, TRUE);
                  if (isGV(gv))
                  {
                      // fprintf(stderr,"Found OWNER glob: %x\n",gv);
                      // fprintf(stderr,"Found object: %x\n",sv);
                      // fprintf(stderr,"Found ref object: %x\n",SvRV(sv));
                      hv=GvHVn(gv);

                      HE *entry;
                      char *key;
                      I32 klen;
                      SV *hval;
	    
                      (void)hv_iterinit(hv);
                      while ((entry = hv_iternext(hv)))  {
                          key = hv_iterkey(entry, &klen);
                          // fprintf(stderr,"Found hash entry: %s\n",key);
                      }
            
		      if (hv_exists_ent(hv, sv, 0))
                      {
                          // fprintf(stderr,"Found key in OWNER hash!\n");
                          if (hv_delete_ent(hv,sv,0,0))
                          {
                              // fprintf(stderr,"Deleted key in OWNER hash!\n");
                          }
                          else 
                          {
                              SWIG_SetError("Couldn't delete key from OWNER hash :-<\n");
                          }
                      }
                      else
                      {
                          SWIG_SetError("no key in OWNER hash :-<\n");
                      }
                  }
                  else
                  {
                      SWIG_SetError("no GV\n");
                  }
              }
              else
              {
                  SWIG_SetError("no stash found\n");
              }
          } else {
              SWIG_SetError("SWIG_Disown: mg is not object");
          }
        } else {
            SWIG_SetError("SWIG_Disown: no mg");
        }
      } else {
          SWIG_SetError("SWIG_Disown: not magical");
      }
    } else {
      SWIG_SetError("SWIG_Disown: not PVHV");
    }
  } else {            /* not an object */
      SWIG_SetError("SWIG_Disown: not an object");
  }
}




SV*
XMLString2Perl(const XMLCh* input) {
    SV *output;
  unsigned int charsEaten = 0;
  int length  = XMLString::stringLen(input);            // string length
  // use +1 to make room for the '\0' at the end of the string
  // in the pathological case when each character of the string 
  // is UTF8_MAXLEN bytes long
  XMLByte* res = new XMLByte[(length * UTF8_MAXLEN) + 1]; // output string

  unsigned int total_chars =
    UTF8_TRANSCODER->transcodeTo((const XMLCh*) input, 
				   (unsigned int) length,
				   (XMLByte*) res,
				   (unsigned int) (length*UTF8_MAXLEN),
				   charsEaten,
				   XMLTranscoder::UnRep_Throw
				   );
  res[total_chars] = '\0';

#if (0) 
  if (DEBUG_UTF8_OUT) {
      printf("Xerces out length = %d: ",total_chars);
      for (int i=0;i<length;i++){
	  printf("<0x%.4X>",res[i]);
      }
      printf("\n");
  }
#endif

  output = sv_newmortal();
  sv_setpv((SV*)output, (char *)res );
  SvUTF8_on((SV*)output);
  delete[] res;
  return output;
}

XMLCh* 
Perl2XMLString(SV* input){
    XMLCh* output;

    STRLEN length;
    char *ptr = (char *)SvPVutf8(input,length);

#if (0) 
    if (DEBUG_UTF8_IN) {
	printf("Perl in length = %d: ",length);
	for (unsigned int i=0;i<length;i++){
	    printf("<0x%.4X>",ptr[i]);
	}
	printf("\n");
    }
#endif

    if (SvUTF8(input)) {
	unsigned int charsEaten = 0;
        unsigned char* sizes = new unsigned char[length+1];
        output = new XMLCh[length+1];
	unsigned int chars_stored = 
	    UTF8_TRANSCODER->transcodeFrom((const XMLByte*) ptr,
					   (unsigned int) length,
					   (XMLCh*) output, 
					   (unsigned int) length,
					   charsEaten,
					   (unsigned char*)sizes
					   );
	delete [] sizes;

#if (0) 
	if (DEBUG_UTF8_IN) {
	    printf("Xerces in length = %d: ",chars_stored);
	    for (unsigned int i=0;i<chars_stored;i++){
		printf("<0x%.4X>",output[i]);
	    }
	    printf("\n");
	}
#endif

	// indicate the end of the string
	output[chars_stored] = '\0';
    } else {
	output = XMLString::transcode(ptr);

#if (0) 
	if (DEBUG_UTF8_IN) {
	    printf("Xerces: ");
	    for (int i=0;output[i];i++){
		printf("<0x%.4X>",output[i]);
	    }
	    printf("\n");
	}
#endif

    }
    return(output);
}



static void
SWIG_Perl_SetErrorf(const char *fmt, ...) {
  va_list args;
  va_start(args, fmt);
  sv_vsetpvfn(perl_get_sv("@", TRUE), fmt, strlen(fmt), &args, Null(SV**), 0, Null(bool*));
  va_end(args);
}

SWIGRUNTIMEINLINE void
SWIG_Perl_NullRef(const char *type, int argnum, const char *symname)
{
  if (type) {
    SWIG_Perl_SetErrorf("null reference of type: '%s' was received as argumnent: %d of %s",type,argnum,symname);
  } else {
    SWIG_Perl_SetErrorf("null reference was received");
  }
}

SWIGRUNTIMEINLINE void
SWIG_Perl_NullRef(const char *type, const char *argname, const char *symname)
{
  if (type) {
    SWIG_Perl_SetErrorf("null reference of type: '%s' was received as argumnent: %s of %s",type,argname,symname);
  } else {
    SWIG_Perl_SetErrorf("null reference was received");
  }
}

SWIGRUNTIME void
SWIG_Perl_TypeError(const char *type, int argnum, const char *symname)
{
  if (type) {
    SWIG_Perl_SetErrorf("Type error in argument %d of %s. Expected %s", argnum, symname, type);
  } else {
    SWIG_Perl_SetErrorf("Type error in argument $argnum of $symname", argnum, symname);
  }
}


SWIGINTERN int
SWIG_AsVal_double SWIG_PERL_DECL_ARGS_2(SV *obj, double *val)
{
  if (SvNIOK(obj)) {
    if (val) *val = SvNV(obj);
    return SWIG_OK;
  } else if (SvIOK(obj)) {
    if (val) *val = (double) SvIV(obj);
    return SWIG_AddCast(SWIG_OK);
  } else {
    const char *nptr = SvPV(obj, PL_na);
    if (nptr) {
      char *endptr;
      double v = strtod(nptr, &endptr);
      if (errno == ERANGE) {
	errno = 0;
	return SWIG_OverflowError;
      } else {
	if (*endptr == '\0') {
	  if (val) *val = v;
	  return SWIG_AddCast(SWIG_OK);
	}
      }
    }
  }
  return SWIG_TypeError;
}


#include <float.h>


#include <math.h>


SWIGINTERNINLINE int
SWIG_CanCastAsInteger(double *d, double min, double max) {
  double x = *d;
  if ((min <= x && x <= max)) {
   double fx = floor(x);
   double cx = ceil(x);
   double rd =  ((x - fx) < 0.5) ? fx : cx; /* simple rint */
   if ((errno == EDOM) || (errno == ERANGE)) {
     errno = 0;
   } else {
     double summ, reps, diff;
     if (rd < x) {
       diff = x - rd;
     } else if (rd > x) {
       diff = rd - x;
     } else {
       return 1;
     }
     summ = rd + x;
     reps = diff/summ;
     if (reps < 8*DBL_EPSILON) {
       *d = rd;
       return 1;
     }
   }
  }
  return 0;
}


SWIGINTERN int
SWIG_AsVal_bool SWIG_PERL_DECL_ARGS_2(SV *obj, bool* val)
{
  if (obj == &PL_sv_yes) {
    if (val) *val = true;
    return SWIG_OK;
  } else if (obj == &PL_sv_no) { 
    if (val) *val = false;
    return SWIG_OK;
  } else {
    if (val) *val = SvTRUE(obj) ? true: false;
    return SWIG_AddCast(SWIG_OK);    
  }
  return SWIG_TypeError;
}


SWIGINTERNINLINE SV *
SWIG_From_bool  SWIG_PERL_DECL_ARGS_1(bool value)
{    
  SV *obj = sv_newmortal();
  if (value) {
    sv_setsv(obj, &PL_sv_yes);
  } else {
    sv_setsv(obj, &PL_sv_no); 
  }
  return obj;
}


XMLException*
copyXMLException(const XMLException& e)
{
    if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgArrayIndexOutOfBoundsException_Name)
    {
        return (XMLException*)((ArrayIndexOutOfBoundsException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgEmptyStackException_Name)
    {
        return (XMLException*)((EmptyStackException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgIllegalArgumentException_Name)
    {
        return (XMLException*)((IllegalArgumentException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgInvalidCastException_Name)
    {
        return (XMLException*)((InvalidCastException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgIOException_Name)
    {
        return (XMLException*)((IOException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgNoSuchElementException_Name)
    {
        return (XMLException*)((NoSuchElementException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgNullPointerException_Name)
    {
        return (XMLException*)((NullPointerException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgNumberFormatException_Name)
    {
        return (XMLException*)((NumberFormatException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgParseException_Name)
    {
        return (XMLException*)((ParseException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgXMLPlatformUtilsException_Name)
    {
        return (XMLException*)((XMLPlatformUtilsException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgRuntimeException_Name)
    {
        return (XMLException*)((RuntimeException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgSchemaDateTimeException_Name)
    {
        return (XMLException*)((SchemaDateTimeException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgTranscodingException_Name)
    {
        return (XMLException*)((TranscodingException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgUnexpectedEOFException_Name)
    {
        return (XMLException*)((UnexpectedEOFException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgUnsupportedEncodingException_Name)
    {
        return (XMLException*)((UnsupportedEncodingException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgUTFDataFormatException_Name)
    {
        return (XMLException*)((UTFDataFormatException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgNetAccessorException_Name)
    {
        return (XMLException*)((NetAccessorException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgMalformedURLException_Name)
    {
        return (XMLException*)((MalformedURLException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgXSerializationException_Name)
    {
        return (XMLException*)((XSerializationException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgInvalidDatatypeFacetException_Name)
    {
        return (XMLException*)((InvalidDatatypeFacetException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgInvalidDatatypeValueException_Name)
    {
        return (XMLException*)((InvalidDatatypeValueException*)&e)->duplicate();
    }
    else if(e.getType() == XERCES_CPP_NAMESPACE::XMLUni::fgXPathException_Name)
    {
        return (XMLException*)((XPathException*)&e)->duplicate();
    }
    else
    {
        SWIG_Perl_SetErrorf("Unknown Exception type: %d", e.getType());
    }
}

void
makeXMLException(const XMLException& e){
    SV *error = ERRSV;
    SWIG_MakePtr(error, (void *) copyXMLException(e), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException, SWIG_SHADOW|0);
}

void
makeDOMException(const DOMException& e){
    SV *error = ERRSV;
    SWIG_MakePtr(error, (void *) new DOMException(e), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMException, SWIG_SHADOW|0);
}

void
makeSAXNotRecognizedException(const SAXNotRecognizedException& e){
    SV *error = ERRSV;
    SWIG_MakePtr(error, (void *) new SAXNotRecognizedException(e), SWIGTYPE_p_XERCES_CPP_NAMESPACE__SAXNotRecognizedException, SWIG_SHADOW|0);
}

void
makeSAXNotSupportedException(const SAXNotSupportedException& e){
    SV *error = ERRSV;
    SWIG_MakePtr(error, (void *) new SAXNotSupportedException(e), SWIGTYPE_p_XERCES_CPP_NAMESPACE__SAXNotSupportedException, SWIG_SHADOW|0);
}



static swig_type_info *
Grammar_dynamic_cast(void **ptr) {
   Grammar **nptr = (Grammar **) ptr;
   if (*nptr == NULL) {
       return NULL;
   }
   short int type = (*nptr)->getGrammarType();
   if (type == Grammar::DTDGrammarType) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar;
   }
   if (type == Grammar::SchemaGrammarType) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar;
   }
   return NULL;
}


static swig_type_info *
DOMNode_dynamic_cast(void **ptr) {
   DOMNode **nptr = (DOMNode **) ptr;
   if (*nptr == NULL) {
       return NULL;
   }
   short int type = (*nptr)->getNodeType();
   if (type == DOMNode::TEXT_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMText;
   }
   if (type == DOMNode::PROCESSING_INSTRUCTION_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMProcessingInstruction;
   }
   if (type == DOMNode::DOCUMENT_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocument;
   }
   if (type == DOMNode::ELEMENT_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement;
   }
   if (type == DOMNode::ENTITY_REFERENCE_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMEntityReference;
   }
   if (type == DOMNode::CDATA_SECTION_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMCDATASection;
   }
   if (type == DOMNode::CDATA_SECTION_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMCDATASection;
   }
   if (type == DOMNode::COMMENT_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMComment;
   }
   if (type == DOMNode::DOCUMENT_TYPE_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocumentType;
   }
   if (type == DOMNode::ENTITY_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMEntity;
   }
   if (type == DOMNode::ATTRIBUTE_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr;
   }
   if (type == DOMNode::NOTATION_NODE) {
      return SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNotation;
   }
   return NULL;
}



static swig_type_info *
PerlCallbackHandler_dynamic_cast(void **ptr) {
   PerlCallbackHandler **nptr = (PerlCallbackHandler **) ptr;
   if (*nptr == NULL) {
       return NULL;
   }
   short int type = (*nptr)->type();
   if (type == PERLCALLBACKHANDLER_BASE_TYPE) {
      die("Can't cast a PerlCallbackHandler base type node\n");
   }
   if (type == PERLCALLBACKHANDLER_ERROR_TYPE) {
      return SWIGTYPE_p_PerlErrorCallbackHandler;
   }
   if (type == PERLCALLBACKHANDLER_ENTITY_TYPE) {
      return SWIGTYPE_p_PerlEntityResolverHandler;
   }
   if (type == PERLCALLBACKHANDLER_CONTENT_TYPE) {
      return SWIGTYPE_p_PerlContentCallbackHandler;
   }
   if (type == PERLCALLBACKHANDLER_DOCUMENT_TYPE) {
      return SWIGTYPE_p_PerlDocumentCallbackHandler;
   }
   if (type == PERLCALLBACKHANDLER_NODE_TYPE) {
      return SWIGTYPE_p_PerlNodeFilterCallbackHandler;
   }
   return NULL;
}



#define CATCH_XML_EXCEPTION       \
    catch (const XMLException& e) \
    {                             \
        makeXMLException(e);      \
	goto fail;                \
    }                             \
    catch (...)                   \
    {                             \
        SWIG_croak("Handling Unknown exception"); \
	goto fail;                \
    }


SWIGINTERN swig_type_info*
SWIG_pchar_descriptor()
{
  static int init = 0;
  static swig_type_info* info = 0;
  if (!init) {
    info = SWIG_TypeQuery("_p_char");
    init = 1;
  }
  return info;
}


SWIGINTERN int
SWIG_AsCharPtrAndSize(SV *obj, char** cptr, size_t* psize, int *alloc)
{
  if (SvPOK(obj)) {
    STRLEN len = 0;
    char *cstr = SvPV(obj, len); 
    size_t size = len + 1;
    if (cptr)  {
      if (alloc) {
	if (*alloc == SWIG_NEWOBJ) {
	  *cptr = reinterpret_cast< char* >(memcpy((new char[size]), cstr, sizeof(char)*(size)));
	} else {
	  *cptr = cstr;
	  *alloc = SWIG_OLDOBJ;
	}
      }
    }
    if (psize) *psize = size;
    return SWIG_OK;
  } else {
    swig_type_info* pchar_descriptor = SWIG_pchar_descriptor();
    if (pchar_descriptor) {
      char* vptr = 0; 
      if (SWIG_ConvertPtr(obj, (void**)&vptr, pchar_descriptor, 0) == SWIG_OK) {
	if (cptr) *cptr = vptr;
	if (psize) *psize = vptr ? (strlen(vptr) + 1) : 0;
	if (alloc) *alloc = SWIG_OLDOBJ;
	return SWIG_OK;
      }
    }
  }
  return SWIG_TypeError;
}





SWIGINTERNINLINE SV *
SWIG_From_long  SWIG_PERL_DECL_ARGS_1(long value)
{    
  SV *obj = sv_newmortal();
  sv_setiv(obj, (IV) value);
  return obj;
}


SWIGINTERNINLINE SV *
SWIG_From_int  SWIG_PERL_DECL_ARGS_1(int value)
{    
  return SWIG_From_long  SWIG_PERL_CALL_ARGS_1(value);
}


SWIGINTERNINLINE SV *
SWIG_From_unsigned_SS_long  SWIG_PERL_DECL_ARGS_1(unsigned long value)
{    
  SV *obj = sv_newmortal();
  sv_setuv(obj, (UV) value);
  return obj;
}


SWIGINTERNINLINE SV *
SWIG_From_unsigned_SS_int  SWIG_PERL_DECL_ARGS_1(unsigned int value)
{    
  return SWIG_From_unsigned_SS_long  SWIG_PERL_CALL_ARGS_1(value);
}


#include <limits.h>
#ifndef LLONG_MIN
# define LLONG_MIN	LONG_LONG_MIN
#endif
#ifndef LLONG_MAX
# define LLONG_MAX	LONG_LONG_MAX
#endif
#ifndef ULLONG_MAX
# define ULLONG_MAX	ULONG_LONG_MAX
#endif


SWIGINTERN int
SWIG_AsVal_long SWIG_PERL_DECL_ARGS_2(SV *obj, long* val)
{
  if (SvIOK(obj)) {
    if (val) *val = SvIV(obj);
    return SWIG_OK;
  } else {
    int dispatch = 0;
    const char *nptr = SvPV(obj, PL_na);
    if (nptr) {
      char *endptr;
      long v = strtol(nptr, &endptr,0);
      if (errno == ERANGE) {
	errno = 0;
	return SWIG_OverflowError;
      } else {
	if (*endptr == '\0') {
	  if (val) *val = v;
	  return SWIG_AddCast(SWIG_OK);
	}
      }
    }
    if (!dispatch) {
      double d;
      int res = SWIG_AddCast(SWIG_AsVal_double SWIG_PERL_CALL_ARGS_2(obj,&d));
      if (SWIG_IsOK(res) && SWIG_CanCastAsInteger(&d, LONG_MIN, LONG_MAX)) {
	if (val) *val = (long)(d);
	return res;
      }
    }
  }
  return SWIG_TypeError;
}


SWIGINTERN int
SWIG_AsVal_int SWIG_PERL_DECL_ARGS_2(SV * obj, int *val)
{
  long v;
  int res = SWIG_AsVal_long SWIG_PERL_CALL_ARGS_2(obj, &v);
  if (SWIG_IsOK(res)) {
    if ((v < INT_MIN || v > INT_MAX)) {
      return SWIG_OverflowError;
    } else {
      if (val) *val = static_cast< int >(v);
    }
  }  
  return res;
}


SWIGINTERNINLINE SV *
SWIG_FromCharPtrAndSize(const char* carray, size_t size)
{
  SV *obj = sv_newmortal();
  if (size && carray) {
    if (carray[size - 1] == 0) {
      sv_setpv(obj, carray);
    } else {
      char *tmp = (new char[size + 1]);
      memcpy(tmp, carray, size);
      tmp[size] = 0;
      sv_setpv(obj, tmp);
      delete[] tmp;
    }
  } else {
    sv_setsv(obj, &PL_sv_undef);
  }
  return obj;
}


SWIGINTERNINLINE SV * 
SWIG_FromCharPtr(const char *cptr)
{ 
  return SWIG_FromCharPtrAndSize(cptr, (cptr ? strlen(cptr) : 0));
}


SWIGINTERN int
SWIG_AsVal_unsigned_SS_long SWIG_PERL_DECL_ARGS_2(SV *obj, unsigned long *val) 
{
  if (SvUOK(obj)) {
    if (val) *val = SvUV(obj);
    return SWIG_OK;
  } else  if (SvIOK(obj)) {
    long v = SvIV(obj);
    if (v >= 0) {
      if (val) *val = v;
      return SWIG_OK;
    } else {
      return SWIG_OverflowError;
    }
  } else {
    int dispatch = 0;
    const char *nptr = SvPV(obj, PL_na);
    if (nptr) {
      char *endptr;
      unsigned long v = strtoul(nptr, &endptr,0);
      if (errno == ERANGE) {
	errno = 0;
	return SWIG_OverflowError;
      } else {
	if (*endptr == '\0') {
	  if (val) *val = v;
	  return SWIG_AddCast(SWIG_OK);
	}
      }
    }
    if (!dispatch) {
      double d;
      int res = SWIG_AddCast(SWIG_AsVal_double SWIG_PERL_CALL_ARGS_2(obj,&d));
      if (SWIG_IsOK(res) && SWIG_CanCastAsInteger(&d, 0, ULONG_MAX)) {
	if (val) *val = (unsigned long)(d);
	return res;
      }
    }
  }
  return SWIG_TypeError;
}


SWIGINTERN int
SWIG_AsVal_unsigned_SS_int SWIG_PERL_DECL_ARGS_2(SV * obj, unsigned int *val)
{
  unsigned long v;
  int res = SWIG_AsVal_unsigned_SS_long SWIG_PERL_CALL_ARGS_2(obj, &v);
  if (SWIG_IsOK(res)) {
    if ((v > UINT_MAX)) {
      return SWIG_OverflowError;
    } else {
      if (val) *val = static_cast< unsigned int >(v);
    }
  }  
  return res;
}


#define CATCH_DOM_EXCEPTION         \
    catch (const XMLException& e)   \
    {                               \
        makeXMLException(e);        \
	goto fail;                  \
    }                               \
    catch (const DOMException& e)   \
    {                               \
	makeDOMException(e);        \
	goto fail;                  \
    }                               \
    catch (...)                     \
    {                               \
        SWIG_croak("Handling Unknown exception"); \
        goto fail;                  \
    }


SWIGINTERNINLINE SV *
SWIG_From_short  SWIG_PERL_DECL_ARGS_1(short value)
{    
  return SWIG_From_long  SWIG_PERL_CALL_ARGS_1(value);
}

SWIGINTERN bool XERCES_CPP_NAMESPACE_DOMNode_operator_Se__Se_(XERCES_CPP_NAMESPACE::DOMNode *self,XERCES_CPP_NAMESPACE::DOMNode const *other){
       return self->isSameNode(other);
   }
SWIGINTERN bool XERCES_CPP_NAMESPACE_DOMNode_operator_SN__Se_(XERCES_CPP_NAMESPACE::DOMNode *self,XERCES_CPP_NAMESPACE::DOMNode const *other){
       return !self->isSameNode(other);
   }

SWIGINTERN int
SWIG_AsVal_short SWIG_PERL_DECL_ARGS_2(SV * obj, short *val)
{
  long v;
  int res = SWIG_AsVal_long SWIG_PERL_CALL_ARGS_2(obj, &v);
  if (SWIG_IsOK(res)) {
    if ((v < SHRT_MIN || v > SHRT_MAX)) {
      return SWIG_OverflowError;
    } else {
      if (val) *val = static_cast< short >(v);
    }
  }  
  return res;
}


SWIGINTERNINLINE int
SWIG_AsVal_size_t SWIG_PERL_DECL_ARGS_2(SV * obj, size_t *val)
{
  unsigned long v;
  int res = SWIG_AsVal_unsigned_SS_long SWIG_PERL_CALL_ARGS_2(obj, val ? &v : 0);
  if (SWIG_IsOK(res) && val) *val = static_cast< size_t >(v);
  return res;
}


#define CATCH_SAX_EXCEPTION                           \
    catch (const XMLException& e)                     \
        {                                             \
	    makeXMLException(e);                      \
            goto fail;                                \
        }                                             \
    catch (const SAXNotSupportedException& e)         \
	{                                             \
	    makeSAXNotSupportedException(e);          \
            goto fail;                                \
	}                                             \
    catch (const SAXNotRecognizedException& e)        \
	{                                             \
	    makeSAXNotRecognizedException(e);         \
            goto fail;                                \
	}                                             \
    catch (...)                                       \
        {                                             \
            SWIG_croak("Handling Unknown exception"); \
            goto fail;                                \
        }

#ifdef PERL_OBJECT
#define MAGIC_CLASS _wrap_XML::Xerces_var::
class _wrap_XML::Xerces_var : public CPerlObj {
public:
#else
#define MAGIC_CLASS
#endif
SWIGCLASS_STATIC int swig_magic_readonly(pTHX_ SV *SWIGUNUSEDPARM(sv), MAGIC *SWIGUNUSEDPARM(mg)) {
    MAGIC_PPERL
    croak("Value is read-only.");
    return 0;
}
SWIGCLASS_STATIC int _wrap_DEBUG_UTF8_OUT_set(pTHX_ SV* sv, MAGIC * SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  {
    bool val;
    int res = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(sv, &val);
    if (!SWIG_IsOK(res)) {
      SWIG_exception_fail(SWIG_ArgError(res), "in variable '""DEBUG_UTF8_OUT""' of type '""bool""'");
    }
    DEBUG_UTF8_OUT = static_cast< bool >(val);
  }
fail:
  return 1;
}


SWIGCLASS_STATIC int _wrap_DEBUG_UTF8_OUT_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  sv_setsv(sv,SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(DEBUG_UTF8_OUT)))  ;
  return 1;
}


SWIGCLASS_STATIC int _wrap_DEBUG_UTF8_IN_set(pTHX_ SV* sv, MAGIC * SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  {
    bool val;
    int res = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(sv, &val);
    if (!SWIG_IsOK(res)) {
      SWIG_exception_fail(SWIG_ArgError(res), "in variable '""DEBUG_UTF8_IN""' of type '""bool""'");
    }
    DEBUG_UTF8_IN = static_cast< bool >(val);
  }
fail:
  return 1;
}


SWIGCLASS_STATIC int _wrap_DEBUG_UTF8_IN_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  sv_setsv(sv,SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(DEBUG_UTF8_IN)))  ;
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgAnyString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgAnyString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgAttListString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgAttListString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgCommentString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgCommentString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgCDATAString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgCDATAString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDefaultString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDefaultString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDocTypeString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDocTypeString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgEBCDICEncodingString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEBCDICEncodingString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgElemString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgElemString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgEmptyString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEmptyString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgEncodingString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEncodingString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgEntitString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEntitString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgEntityString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEntityString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgEntitiesString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEntitiesString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgEnumerationString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEnumerationString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgExceptDomain_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgExceptDomain));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgFixedString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgFixedString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIBM037EncodingString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIBM037EncodingString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIBM037EncodingString2_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIBM037EncodingString2));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIBM1047EncodingString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIBM1047EncodingString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIBM1047EncodingString2_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIBM1047EncodingString2));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIBM1140EncodingString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIBM1140EncodingString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIBM1140EncodingString2_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIBM1140EncodingString2));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIBM1140EncodingString3_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIBM1140EncodingString3));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIBM1140EncodingString4_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIBM1140EncodingString4));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIESString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIESString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIDString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIDString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIDRefString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIDRefString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIDRefsString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIDRefsString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgImpliedString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgImpliedString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIgnoreString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIgnoreString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIncludeString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIncludeString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgISO88591EncodingString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgISO88591EncodingString2_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString2));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgISO88591EncodingString3_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString3));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgISO88591EncodingString4_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString4));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgISO88591EncodingString5_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString5));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgISO88591EncodingString6_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString6));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgISO88591EncodingString7_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString7));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgISO88591EncodingString8_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString8));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgISO88591EncodingString9_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString9));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgISO88591EncodingString10_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString10));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgISO88591EncodingString11_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString11));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgISO88591EncodingString12_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgISO88591EncodingString12));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgLocalHostString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgLocalHostString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgNoString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNoString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgNotationString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNotationString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgNDATAString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNDATAString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgNmTokenString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNmTokenString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgNmTokensString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNmTokensString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgPCDATAString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgPCDATAString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgPIString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgPIString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgPubIDString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgPubIDString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgRefString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgRefString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgRequiredString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgRequiredString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgStandaloneString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgStandaloneString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgVersion1_0_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgVersion1_0));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgVersion1_1_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgVersion1_1));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgSysIDString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgSysIDString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUnknownURIName_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUnknownURIName));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUCS4EncodingString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUCS4EncodingString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUCS4EncodingString2_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUCS4EncodingString2));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUCS4EncodingString3_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUCS4EncodingString3));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUCS4BEncodingString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUCS4BEncodingString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUCS4BEncodingString2_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUCS4BEncodingString2));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUCS4LEncodingString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUCS4LEncodingString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUCS4LEncodingString2_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUCS4LEncodingString2));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUSASCIIEncodingString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUSASCIIEncodingString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUSASCIIEncodingString2_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUSASCIIEncodingString2));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUSASCIIEncodingString3_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUSASCIIEncodingString3));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUSASCIIEncodingString4_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUSASCIIEncodingString4));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUTF8EncodingString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF8EncodingString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUTF8EncodingString2_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF8EncodingString2));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUTF16EncodingString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16EncodingString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUTF16EncodingString2_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16EncodingString2));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUTF16EncodingString3_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16EncodingString3));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUTF16EncodingString4_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16EncodingString4));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUTF16EncodingString5_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16EncodingString5));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUTF16EncodingString6_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16EncodingString6));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUTF16EncodingString7_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16EncodingString7));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUTF16BEncodingString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16BEncodingString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUTF16BEncodingString2_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16BEncodingString2));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUTF16LEncodingString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16LEncodingString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUTF16LEncodingString2_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTF16LEncodingString2));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgVersionString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgVersionString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgValidityDomain_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgValidityDomain));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgWin1252EncodingString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgWin1252EncodingString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLChEncodingString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLChEncodingString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLDOMMsgDomain_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDOMMsgDomain));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLStringSpace_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLStringSpace));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLStringHTab_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLStringHTab));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLStringCR_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLStringCR));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLStringLF_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLStringLF));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLStringSpaceU_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLStringSpaceU));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLStringHTabU_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLStringHTabU));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLStringCRU_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLStringCRU));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLStringLFU_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLStringLFU));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLDeclString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLDeclStringSpace_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclStringSpace));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLDeclStringHTab_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclStringHTab));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLDeclStringLF_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclStringLF));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLDeclStringCR_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclStringCR));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLDeclStringSpaceU_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclStringSpaceU));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLDeclStringHTabU_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclStringHTabU));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLDeclStringLFU_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclStringLFU));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLDeclStringCRU_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLDeclStringCRU));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLNSString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLNSString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLNSColonString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLNSColonString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLNSURIName_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLNSURIName));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLErrDomain_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLErrDomain));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLURIName_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLURIName));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgInfosetURIName_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgInfosetURIName));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgYesString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgYesString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgZeroLenString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgZeroLenString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDTDEntityString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDTDEntityString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgAmp_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgAmp));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgLT_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgLT));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgGT_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgGT));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgQuot_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgQuot));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgApos_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgApos));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgWFXMLScanner_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgWFXMLScanner));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIGXMLScanner_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIGXMLScanner));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgSGXMLScanner_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgSGXMLScanner));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDGXMLScanner_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDGXMLScanner));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXSAXMLScanner_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXSAXMLScanner));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgCDataStart_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgCDataStart));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgCDataEnd_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgCDataEnd));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgArrayIndexOutOfBoundsException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgArrayIndexOutOfBoundsException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgEmptyStackException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEmptyStackException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIllegalArgumentException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIllegalArgumentException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgInvalidCastException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgInvalidCastException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIOException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIOException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgNoSuchElementException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNoSuchElementException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgNullPointerException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNullPointerException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXMLPlatformUtilsException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXMLPlatformUtilsException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgRuntimeException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgRuntimeException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgTranscodingException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgTranscodingException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUnexpectedEOFException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUnexpectedEOFException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUnsupportedEncodingException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUnsupportedEncodingException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUTFDataFormatException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUTFDataFormatException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgNetAccessorException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNetAccessorException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgMalformedURLException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgMalformedURLException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgNumberFormatException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNumberFormatException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgParseException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgParseException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgInvalidDatatypeFacetException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgInvalidDatatypeFacetException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgInvalidDatatypeValueException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgInvalidDatatypeValueException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgSchemaDateTimeException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgSchemaDateTimeException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXPathException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXPathException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXSerializationException_Name_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXSerializationException_Name));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgNegINFString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNegINFString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgNegZeroString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNegZeroString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgPosZeroString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgPosZeroString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgPosINFString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgPosINFString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgNaNString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNaNString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgEString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgEString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgZeroString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgZeroString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgNullString_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNullString));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesDynamic_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesDynamic));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesSchema_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesSchema));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesSchemaFullChecking_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesSchemaFullChecking));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesIdentityConstraintChecking_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesIdentityConstraintChecking));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesSchemaExternalSchemaLocation_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesSchemaExternalSchemaLocation));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesSchemaExternalNoNameSpaceSchemaLocation_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesSchemaExternalNoNameSpaceSchemaLocation));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesSecurityManager_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesSecurityManager));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesLoadExternalDTD_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesLoadExternalDTD));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesContinueAfterFatalError_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesContinueAfterFatalError));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesValidationErrorAsFatal_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesValidationErrorAsFatal));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesUserAdoptsDOMDocument_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesUserAdoptsDOMDocument));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesCacheGrammarFromParse_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesCacheGrammarFromParse));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesUseCachedGrammarInParse_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesUseCachedGrammarInParse));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesScannerName_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesScannerName));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesParserUseDocumentFromImplementation_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesParserUseDocumentFromImplementation));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesCalculateSrcOfs_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesCalculateSrcOfs));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesStandardUriConformant_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesStandardUriConformant));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesDOMHasPSVIInfo_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesDOMHasPSVIInfo));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesGenerateSyntheticAnnotations_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesGenerateSyntheticAnnotations));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesValidateAnnotations_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesValidateAnnotations));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesIgnoreCachedDTD_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesIgnoreCachedDTD));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesIgnoreAnnotations_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesIgnoreAnnotations));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesDisableDefaultEntityResolution_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesDisableDefaultEntityResolution));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercesSkipDTDValidation_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercesSkipDTDValidation));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgSAX2CoreValidation_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgSAX2CoreValidation));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgSAX2CoreNameSpaces_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgSAX2CoreNameSpaces));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgSAX2CoreNameSpacePrefixes_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgSAX2CoreNameSpacePrefixes));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMCanonicalForm_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMCanonicalForm));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMCDATASections_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMCDATASections));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMComments_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMComments));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMCharsetOverridesXMLEncoding_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMCharsetOverridesXMLEncoding));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMDatatypeNormalization_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMDatatypeNormalization));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMEntities_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMEntities));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMInfoset_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMInfoset));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMNamespaces_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMNamespaces));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMNamespaceDeclarations_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMNamespaceDeclarations));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMSupportedMediatypesOnly_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMSupportedMediatypesOnly));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMValidateIfSchema_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMValidateIfSchema));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMValidation_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMValidation));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMWhitespaceInElementContent_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWhitespaceInElementContent));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMWRTCanonicalForm_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTCanonicalForm));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMWRTDiscardDefaultContent_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTDiscardDefaultContent));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMWRTEntities_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTEntities));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMWRTFormatPrettyPrint_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTFormatPrettyPrint));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMWRTNormalizeCharacters_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTNormalizeCharacters));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMWRTSplitCdataSections_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTSplitCdataSections));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMWRTValidation_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTValidation));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMWRTWhitespaceInElementContent_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTWhitespaceInElementContent));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMWRTBOM_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMWRTBOM));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDOMXMLDeclaration_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDOMXMLDeclaration));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercescInterfacePSVITypeInfo_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercescInterfacePSVITypeInfo));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercescInterfaceDOMDocumentTypeImpl_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgXercescInterfaceDOMDocumentTypeImpl));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgXercescDefaultLocale_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  sv_setsv(sv,SWIG_FromCharPtr(XERCES_CPP_NAMESPACE::XMLUni::fgXercescDefaultLocale))  ;
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgDefErrMsg_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgDefErrMsg));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgValueZero_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgValueZero));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgNegOne_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgNegOne));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgValueOne_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgValueOne));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgLongMaxInc_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgLongMaxInc));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgLongMinInc_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgLongMinInc));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIntMaxInc_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIntMaxInc));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgIntMinInc_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgIntMinInc));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgShortMaxInc_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgShortMaxInc));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgShortMinInc_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgShortMinInc));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgByteMaxInc_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgByteMaxInc));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgByteMinInc_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgByteMinInc));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgULongMaxInc_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgULongMaxInc));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUIntMaxInc_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUIntMaxInc));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUShortMaxInc_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUShortMaxInc));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgUByteMaxInc_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgUByteMaxInc));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgLangPattern_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLUni::fgLangPattern));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgBooleanValueSpace_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  sv_setiv(SvRV(sv),PTR2IV(XERCES_CPP_NAMESPACE::XMLUni::fgBooleanValueSpace));
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLUni_fgBooleanValueSpaceArraySize_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  sv_setsv(sv,SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(XERCES_CPP_NAMESPACE::XMLUni::fgBooleanValueSpaceArraySize)))  ;
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLElementDecl_fgInvalidElemId_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  sv_setsv(sv,SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(XERCES_CPP_NAMESPACE::XMLElementDecl::fgInvalidElemId)))  ;
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLElementDecl_fgPCDataElemId_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  sv_setsv(sv,SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(XERCES_CPP_NAMESPACE::XMLElementDecl::fgPCDataElemId)))  ;
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLElementDecl_fgPCDataElemName_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  
  sv_setsv((SV*)sv, XMLString2Perl(XERCES_CPP_NAMESPACE::XMLElementDecl::fgPCDataElemName));
  
  return 1;
}


SWIGCLASS_STATIC int _wrap_XMLAttDef_fgInvalidAttrId_get(pTHX_ SV *sv, MAGIC *SWIGUNUSEDPARM(mg)) {
  MAGIC_PPERL
  sv_setsv(sv,SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(XERCES_CPP_NAMESPACE::XMLAttDef::fgInvalidAttrId)))  ;
  return 1;
}




#ifdef PERL_OBJECT
};
#endif

#ifdef __cplusplus
extern "C" {
#endif
XS(_wrap_delete_XMLDeleter) {
  {
    XERCES_CPP_NAMESPACE::XMLDeleter *arg1 = (XERCES_CPP_NAMESPACE::XMLDeleter *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_XMLDeleter(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDeleter, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_XMLDeleter" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLDeleter *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLDeleter * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLPlatformUtils_Initialize__SWIG_0) {
  {
    char *arg1 = (char *) (char *)0 ;
    char *arg2 = (char *) (char *)0 ;
    PanicHandler *arg3 = (PanicHandler *) (PanicHandler *)0 ;
    XERCES_CPP_NAMESPACE::MemoryManager *arg4 = (XERCES_CPP_NAMESPACE::MemoryManager *) (XERCES_CPP_NAMESPACE::MemoryManager *)0 ;
    bool arg5 ;
    int res1 ;
    char *buf1 = 0 ;
    int alloc1 = 0 ;
    int res2 ;
    char *buf2 = 0 ;
    int alloc2 = 0 ;
    void *argp3 = 0 ;
    int res3 = 0 ;
    void *argp4 = 0 ;
    int res4 = 0 ;
    bool val5 ;
    int ecode5 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 5) || (items > 5)) {
      SWIG_croak("Usage: XMLPlatformUtils_Initialize(locale,nlsHome,panicHandler,memoryManager,toInitStatics);");
    }
    res1 = SWIG_AsCharPtrAndSize(ST(0), &buf1, NULL, &alloc1);
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLPlatformUtils_Initialize" "', argument " "1"" of type '" "char const *const""'");
    }
    arg1 = buf1;
    res2 = SWIG_AsCharPtrAndSize(ST(1), &buf2, NULL, &alloc2);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "XMLPlatformUtils_Initialize" "', argument " "2"" of type '" "char const *const""'");
    }
    arg2 = buf2;
    res3 = SWIG_ConvertPtr(ST(2), &argp3,SWIGTYPE_p_PanicHandler, 0 |  0 );
    if (!SWIG_IsOK(res3)) {
      SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "XMLPlatformUtils_Initialize" "', argument " "3"" of type '" "PanicHandler *const""'"); 
    }
    arg3 = reinterpret_cast< PanicHandler * >(argp3);
    res4 = SWIG_ConvertPtr(ST(3), &argp4,SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0 |  0 );
    if (!SWIG_IsOK(res4)) {
      SWIG_exception_fail(SWIG_ArgError(res4), "in method '" "XMLPlatformUtils_Initialize" "', argument " "4"" of type '" "XERCES_CPP_NAMESPACE::MemoryManager *const""'"); 
    }
    arg4 = reinterpret_cast< XERCES_CPP_NAMESPACE::MemoryManager * >(argp4);
    ecode5 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(4), &val5);
    if (!SWIG_IsOK(ecode5)) {
      SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "XMLPlatformUtils_Initialize" "', argument " "5"" of type '" "bool""'");
    } 
    arg5 = static_cast< bool >(val5);
    {
      try 
      {
        XERCES_CPP_NAMESPACE::XMLPlatformUtils::Initialize((char const *)arg1,(char const *)arg2,arg3,arg4,arg5);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    if (alloc1 == SWIG_NEWOBJ) delete[] buf1;
    if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
    
    
    
    XSRETURN(argvi);
  fail:
    if (alloc1 == SWIG_NEWOBJ) delete[] buf1;
    if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLPlatformUtils_Initialize__SWIG_1) {
  {
    char *arg1 = (char *) (char *)0 ;
    char *arg2 = (char *) (char *)0 ;
    int res1 ;
    char *buf1 = 0 ;
    int alloc1 = 0 ;
    int res2 ;
    char *buf2 = 0 ;
    int alloc2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLPlatformUtils_Initialize(locale,nlsHome);");
    }
    res1 = SWIG_AsCharPtrAndSize(ST(0), &buf1, NULL, &alloc1);
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLPlatformUtils_Initialize" "', argument " "1"" of type '" "char const *const""'");
    }
    arg1 = buf1;
    res2 = SWIG_AsCharPtrAndSize(ST(1), &buf2, NULL, &alloc2);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "XMLPlatformUtils_Initialize" "', argument " "2"" of type '" "char const *const""'");
    }
    arg2 = buf2;
    {
      try 
      {
        XERCES_CPP_NAMESPACE::XMLPlatformUtils::Initialize((char const *)arg1,(char const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    if (alloc1 == SWIG_NEWOBJ) delete[] buf1;
    if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
    XSRETURN(argvi);
  fail:
    if (alloc1 == SWIG_NEWOBJ) delete[] buf1;
    if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
    SWIG_croak_null();
  }
}


XS(_wrap_XMLPlatformUtils_Initialize__SWIG_2) {
  {
    char *arg1 = (char *) (char *)0 ;
    int res1 ;
    char *buf1 = 0 ;
    int alloc1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLPlatformUtils_Initialize(locale);");
    }
    res1 = SWIG_AsCharPtrAndSize(ST(0), &buf1, NULL, &alloc1);
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLPlatformUtils_Initialize" "', argument " "1"" of type '" "char const *const""'");
    }
    arg1 = buf1;
    {
      try 
      {
        XERCES_CPP_NAMESPACE::XMLPlatformUtils::Initialize((char const *)arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    if (alloc1 == SWIG_NEWOBJ) delete[] buf1;
    XSRETURN(argvi);
  fail:
    if (alloc1 == SWIG_NEWOBJ) delete[] buf1;
    SWIG_croak_null();
  }
}


XS(_wrap_XMLPlatformUtils_Initialize__SWIG_3) {
  {
    int argvi = 0;
    dXSARGS;
    
    if ((items < 0) || (items > 0)) {
      SWIG_croak("Usage: XMLPlatformUtils_Initialize();");
    }
    {
      try 
      {
        XERCES_CPP_NAMESPACE::XMLPlatformUtils::Initialize();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    XSRETURN(argvi);
  fail:
    SWIG_croak_null();
  }
}


XS(_wrap_XMLPlatformUtils_Initialize) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 0) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        int res = SWIG_AsCharPtrAndSize(ST(0), 0, NULL, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        int res = SWIG_AsCharPtrAndSize(ST(0), 0, NULL, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        int res = SWIG_AsCharPtrAndSize(ST(1), 0, NULL, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 3;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_3:
    
    if (items == 5) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        int res = SWIG_AsCharPtrAndSize(ST(0), 0, NULL, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        int res = SWIG_AsCharPtrAndSize(ST(1), 0, NULL, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(2), &vptr, SWIGTYPE_p_PanicHandler, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(3), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(4), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 4;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_4:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLPlatformUtils_Initialize__SWIG_3); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLPlatformUtils_Initialize__SWIG_2); return;
    case 3:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLPlatformUtils_Initialize__SWIG_1); return;
    case 4:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLPlatformUtils_Initialize__SWIG_0); return;
    }
  }
  
  croak("No matching function for overloaded 'XMLPlatformUtils_Initialize'");
  XSRETURN(0);
}


XS(_wrap_XMLPlatformUtils_Terminate) {
  {
    int argvi = 0;
    dXSARGS;
    
    if ((items < 0) || (items > 0)) {
      SWIG_croak("Usage: XMLPlatformUtils_Terminate();");
    }
    {
      try 
      {
        XERCES_CPP_NAMESPACE::XMLPlatformUtils::Terminate();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    XSRETURN(argvi);
  fail:
    SWIG_croak_null();
  }
}


XS(_wrap_XMLPlatformUtils_panic) {
  {
    PanicHandler::PanicReasons arg1 ;
    void *argp1 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLPlatformUtils_panic(reason);");
    }
    {
      res1 = SWIG_ConvertPtr(ST(0), &argp1, SWIGTYPE_p_PanicHandler__PanicReasons,  0 );
      if (!SWIG_IsOK(res1)) {
        SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLPlatformUtils_panic" "', argument " "1"" of type '" "PanicHandler::PanicReasons const""'"); 
      }  
      if (!argp1) {
        SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "XMLPlatformUtils_panic" "', argument " "1"" of type '" "PanicHandler::PanicReasons const""'");
      } else {
        arg1 = *(reinterpret_cast< PanicHandler::PanicReasons * >(argp1));
      }
    }
    {
      try 
      {
        XERCES_CPP_NAMESPACE::XMLPlatformUtils::panic(arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    XSRETURN(argvi);
  fail:
    SWIG_croak_null();
  }
}


XS(_wrap_delete_XMLPlatformUtils) {
  {
    XERCES_CPP_NAMESPACE::XMLPlatformUtils *arg1 = (XERCES_CPP_NAMESPACE::XMLPlatformUtils *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_XMLPlatformUtils(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLPlatformUtils, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_XMLPlatformUtils" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLPlatformUtils *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLPlatformUtils * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_lookupByName) {
  {
    XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLURL::Protocols result;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLURL_lookupByName(protoName);");
    }
    
    if (ST(0) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",1,"XMLURL_lookupByName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg1 = Perl2XMLString(ST(0));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLURL::Protocols)XERCES_CPP_NAMESPACE::XMLURL::lookupByName((unsigned short const *)arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    delete[] arg1;
    
    XSRETURN(argvi);
  fail:
    
    delete[] arg1;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_parse) {
  {
    XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLURL *arg2 = 0 ;
    bool result;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLURL_parse(urlText,xmlURL);");
    }
    
    if (ST(0) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",1,"XMLURL_parse");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg1 = Perl2XMLString(ST(0));
    }
    
    res2 = SWIG_ConvertPtr(ST(1), &argp2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "XMLURL_parse" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLURL &""'"); 
    }
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "XMLURL_parse" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLURL &""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp2);
    {
      try 
      {
        result = (bool)XERCES_CPP_NAMESPACE::XMLURL::parse((unsigned short const *)arg1,*arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    delete[] arg1;
    
    
    XSRETURN(argvi);
  fail:
    
    delete[] arg1;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_XMLURL__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 0) || (items > 0)) {
      SWIG_croak("Usage: new_XMLURL();");
    }
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLURL *)new XERCES_CPP_NAMESPACE::XMLURL();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    XSRETURN(argvi);
  fail:
    SWIG_croak_null();
  }
}


XS(_wrap_new_XMLURL__SWIG_1) {
  {
    XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLURL *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: new_XMLURL(baseURL,relativeURL);");
    }
    
    if (ST(0) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",1,"new_XMLURL");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg1 = Perl2XMLString(ST(0));
    }
    
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"new_XMLURL");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLURL *)new XERCES_CPP_NAMESPACE::XMLURL((XMLCh const *)arg1,(XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    delete[] arg1;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    delete[] arg1;
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_XMLURL__SWIG_2) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLURL *result = 0 ;
    void *argp1 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: new_XMLURL(baseURL,relativeURL);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_XMLURL" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const &""'"); 
    }
    if (!argp1) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "new_XMLURL" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const &""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"new_XMLURL");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLURL *)new XERCES_CPP_NAMESPACE::XMLURL((XERCES_CPP_NAMESPACE::XMLURL const &)*arg1,(XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_XMLURL__SWIG_3) {
  {
    XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLURL *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: new_XMLURL(urlText);");
    }
    
    if (ST(0) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",1,"new_XMLURL");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg1 = Perl2XMLString(ST(0));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLURL *)new XERCES_CPP_NAMESPACE::XMLURL((XMLCh const *)arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    delete[] arg1;
    
    XSRETURN(argvi);
  fail:
    
    delete[] arg1;
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_XMLURL__SWIG_4) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = 0 ;
    XERCES_CPP_NAMESPACE::XMLURL *result = 0 ;
    void *argp1 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: new_XMLURL(toCopy);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_XMLURL" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const &""'"); 
    }
    if (!argp1) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "new_XMLURL" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const &""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLURL *)new XERCES_CPP_NAMESPACE::XMLURL((XERCES_CPP_NAMESPACE::XMLURL const &)*arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_XMLURL) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 0) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        {
          _v = SvOK(ST(0)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 3;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_3:
    
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 4;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_4:
    
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        {
          _v = SvOK(ST(0)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_5;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_5;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 5;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_5:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLURL__SWIG_0); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLURL__SWIG_4); return;
    case 3:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLURL__SWIG_3); return;
    case 4:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLURL__SWIG_2); return;
    case 5:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLURL__SWIG_1); return;
    }
  }
  
  croak("No matching function for overloaded 'new_XMLURL'");
  XSRETURN(0);
}


XS(_wrap_delete_XMLURL) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_XMLURL(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_XMLURL" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL___eq__) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XERCES_CPP_NAMESPACE::XMLURL *arg2 = 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLURL___eq__(self,toCompare);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL___eq__" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "XMLURL___eq__" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const &""'"); 
    }
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "XMLURL___eq__" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const &""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp2);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->operator ==((XERCES_CPP_NAMESPACE::XMLURL const &)*arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL___ne__) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XERCES_CPP_NAMESPACE::XMLURL *arg2 = 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLURL___ne__(self,toCompare);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL___ne__" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "XMLURL___ne__" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const &""'"); 
    }
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "XMLURL___ne__" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const &""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp2);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->operator !=((XERCES_CPP_NAMESPACE::XMLURL const &)*arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_getFragment) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLURL_getFragment(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_getFragment" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getFragment();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_getHost) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLURL_getHost(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_getHost" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getHost();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_getPassword) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLURL_getPassword(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_getPassword" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getPassword();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_getPath) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLURL_getPath(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_getPath" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getPath();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_getPortNum) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLURL_getPortNum(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_getPortNum" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getPortNum();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_getProtocol) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XERCES_CPP_NAMESPACE::XMLURL::Protocols result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLURL_getProtocol(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_getProtocol" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLURL::Protocols)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getProtocol();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_getProtocolName) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLURL_getProtocolName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_getProtocolName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getProtocolName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_getQuery) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLURL_getQuery(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_getQuery" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getQuery();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_getURLText) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLURL_getURLText(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_getURLText" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getURLText();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_getUser) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLURL_getUser(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_getUser" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getUser();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_getMemoryManager) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XERCES_CPP_NAMESPACE::MemoryManager *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLURL_getMemoryManager(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_getMemoryManager" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->getMemoryManager();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_setURL__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLURL_setURL(self,urlText);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_setURL" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLURL_setURL");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setURL((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_setURL__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: XMLURL_setURL(self,baseURL,relativeURL);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_setURL" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLURL_setURL");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"XMLURL_setURL");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    {
      try 
      {
        (arg1)->setURL((XMLCh const *)arg2,(XMLCh const *)arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_setURL__SWIG_2) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XERCES_CPP_NAMESPACE::XMLURL *arg2 = 0 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: XMLURL_setURL(self,baseURL,relativeURL);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_setURL" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "XMLURL_setURL" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const &""'"); 
    }
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "XMLURL_setURL" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const &""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"XMLURL_setURL");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    {
      try 
      {
        (arg1)->setURL((XERCES_CPP_NAMESPACE::XMLURL const &)*arg2,(XMLCh const *)arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    
    delete[] arg3;
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_setURL__SWIG_3) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLURL *arg4 = 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp4 = 0 ;
    int res4 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 4) || (items > 4)) {
      SWIG_croak("Usage: XMLURL_setURL(self,baseURL,relativeURL,xmlURL);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_setURL" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLURL_setURL");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"XMLURL_setURL");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    res4 = SWIG_ConvertPtr(ST(3), &argp4, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,  0 );
    if (!SWIG_IsOK(res4)) {
      SWIG_exception_fail(SWIG_ArgError(res4), "in method '" "XMLURL_setURL" "', argument " "4"" of type '" "XERCES_CPP_NAMESPACE::XMLURL &""'"); 
    }
    if (!argp4) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "XMLURL_setURL" "', argument " "4"" of type '" "XERCES_CPP_NAMESPACE::XMLURL &""'"); 
    }
    arg4 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp4);
    {
      try 
      {
        result = (bool)(arg1)->setURL((XMLCh const *)arg2,(XMLCh const *)arg3,*arg4);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_setURL) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 3) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(1), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
    if (items == 3) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 3;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_3:
    
    if (items == 4) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(3), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 4;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_4:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLURL_setURL__SWIG_0); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLURL_setURL__SWIG_2); return;
    case 3:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLURL_setURL__SWIG_1); return;
    case 4:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLURL_setURL__SWIG_3); return;
    }
  }
  
  croak("No matching function for overloaded 'XMLURL_setURL'");
  XSRETURN(0);
}


XS(_wrap_XMLURL_isRelative) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLURL_isRelative(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_isRelative" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->isRelative();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_hasInvalidChar) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLURL_hasInvalidChar(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_hasInvalidChar" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->hasInvalidChar();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_makeNewStream) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XERCES_CPP_NAMESPACE::BinInputStream *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLURL_makeNewStream(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_makeNewStream" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::BinInputStream *)((XERCES_CPP_NAMESPACE::XMLURL const *)arg1)->makeNewStream();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__BinInputStream, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_makeRelativeTo__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLURL_makeRelativeTo(self,baseURLText);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_makeRelativeTo" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLURL_makeRelativeTo");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->makeRelativeTo((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_makeRelativeTo__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = (XERCES_CPP_NAMESPACE::XMLURL *) 0 ;
    XERCES_CPP_NAMESPACE::XMLURL *arg2 = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLURL_makeRelativeTo(self,baseURL);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLURL_makeRelativeTo" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "XMLURL_makeRelativeTo" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const &""'"); 
    }
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "XMLURL_makeRelativeTo" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const &""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp2);
    {
      try 
      {
        (arg1)->makeRelativeTo((XERCES_CPP_NAMESPACE::XMLURL const &)*arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLURL_makeRelativeTo) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(1), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLURL_makeRelativeTo__SWIG_1); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLURL_makeRelativeTo__SWIG_0); return;
    }
  }
  
  croak("No matching function for overloaded 'XMLURL_makeRelativeTo'");
  XSRETURN(0);
}


XS(_wrap_new_XMLUri__SWIG_0) {
  {
    XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLUri *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: new_XMLUri(uriSpec);");
    }
    
    if (ST(0) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",1,"new_XMLUri");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg1 = Perl2XMLString(ST(0));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLUri *)new XERCES_CPP_NAMESPACE::XMLUri((XMLCh const *)arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    delete[] arg1;
    
    XSRETURN(argvi);
  fail:
    
    delete[] arg1;
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_XMLUri__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) (XERCES_CPP_NAMESPACE::XMLUri *)0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLUri *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: new_XMLUri(baseURI,uriSpec);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_XMLUri" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri const *const""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"new_XMLUri");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLUri *)new XERCES_CPP_NAMESPACE::XMLUri((XERCES_CPP_NAMESPACE::XMLUri const *)arg1,(XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_XMLUri__SWIG_2) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = 0 ;
    XERCES_CPP_NAMESPACE::XMLUri *result = 0 ;
    void *argp1 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: new_XMLUri(toCopy);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri,  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_XMLUri" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri const &""'"); 
    }
    if (!argp1) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "new_XMLUri" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri const &""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLUri *)new XERCES_CPP_NAMESPACE::XMLUri((XERCES_CPP_NAMESPACE::XMLUri const &)*arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_XMLUri) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_XMLUri(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_XMLUri" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_getUriText) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLUri_getUriText(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_getUriText" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getUriText();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_getScheme) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLUri_getScheme(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_getScheme" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getScheme();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_getUserInfo) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLUri_getUserInfo(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_getUserInfo" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getUserInfo();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_getHost) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLUri_getHost(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_getHost" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getHost();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_getPort) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLUri_getPort(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_getPort" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    {
      try 
      {
        result = (int)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getPort();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_getRegBasedAuthority) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLUri_getRegBasedAuthority(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_getRegBasedAuthority" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getRegBasedAuthority();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_getPath) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLUri_getPath(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_getPath" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getPath();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_getQueryString) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLUri_getQueryString(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_getQueryString" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getQueryString();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_getFragment) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLUri_getFragment(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_getFragment" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLUri const *)arg1)->getFragment();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_setScheme) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLUri_setScheme(self,newScheme);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_setScheme" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLUri_setScheme");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setScheme((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_setUserInfo) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLUri_setUserInfo(self,newUserInfo);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_setUserInfo" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLUri_setUserInfo");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setUserInfo((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_setHost) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLUri_setHost(self,newHost);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_setHost" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLUri_setHost");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setHost((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_setPort) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    int arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLUri_setPort(self,newPort);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_setPort" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    ecode2 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "XMLUri_setPort" "', argument " "2"" of type '" "int""'");
    } 
    arg2 = static_cast< int >(val2);
    {
      try 
      {
        (arg1)->setPort(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_setRegBasedAuthority) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLUri_setRegBasedAuthority(self,newRegAuth);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_setRegBasedAuthority" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLUri_setRegBasedAuthority");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setRegBasedAuthority((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_setPath) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLUri_setPath(self,newPath);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_setPath" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLUri_setPath");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setPath((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_setQueryString) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLUri_setQueryString(self,newQueryString);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_setQueryString" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLUri_setQueryString");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setQueryString((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_setFragment) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLUri_setFragment(self,newFragment);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_setFragment" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLUri_setFragment");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setFragment((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_isURIString) {
  {
    XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
    bool result;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLUri_isURIString(uric);");
    }
    
    if (ST(0) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",1,"XMLUri_isURIString");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg1 = Perl2XMLString(ST(0));
    }
    
    {
      try 
      {
        result = (bool)XERCES_CPP_NAMESPACE::XMLUri::isURIString((unsigned short const *)arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    delete[] arg1;
    
    XSRETURN(argvi);
  fail:
    
    delete[] arg1;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_isValidURI__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *arg1 = (XERCES_CPP_NAMESPACE::XMLUri *) (XERCES_CPP_NAMESPACE::XMLUri *)0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLUri_isValidURI(baseURI,uriStr);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLUri_isValidURI" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUri const *const""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUri * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLUri_isValidURI");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (bool)XERCES_CPP_NAMESPACE::XMLUri::isValidURI((XERCES_CPP_NAMESPACE::XMLUri const *)arg1,(unsigned short const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_isValidURI__SWIG_1) {
  {
    bool arg1 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    bool result;
    bool val1 ;
    int ecode1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLUri_isValidURI(haveBaseURI,uriStr);");
    }
    ecode1 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(0), &val1);
    if (!SWIG_IsOK(ecode1)) {
      SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "XMLUri_isValidURI" "', argument " "1"" of type '" "bool""'");
    } 
    arg1 = static_cast< bool >(val1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLUri_isValidURI");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (bool)XERCES_CPP_NAMESPACE::XMLUri::isValidURI(arg1,(unsigned short const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLUri_isValidURI) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        {
          int res = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(0), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLUri_isValidURI__SWIG_0); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLUri_isValidURI__SWIG_1); return;
    }
  }
  
  croak("No matching function for overloaded 'XMLUri_isValidURI'");
  XSRETURN(0);
}


XS(_wrap_XMLUri_normalizeURI) {
  {
    XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
    XMLBuffer *arg2 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLUri_normalizeURI(systemURI,normalizedURI);");
    }
    
    if (ST(0) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",1,"XMLUri_normalizeURI");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg1 = Perl2XMLString(ST(0));
    }
    
    res2 = SWIG_ConvertPtr(ST(1), &argp2, SWIGTYPE_p_XMLBuffer,  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "XMLUri_normalizeURI" "', argument " "2"" of type '" "XMLBuffer &""'"); 
    }
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "XMLUri_normalizeURI" "', argument " "2"" of type '" "XMLBuffer &""'"); 
    }
    arg2 = reinterpret_cast< XMLBuffer * >(argp2);
    {
      try 
      {
        XERCES_CPP_NAMESPACE::XMLUri::normalizeURI((unsigned short const *)arg1,*arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    delete[] arg1;
    
    
    XSRETURN(argvi);
  fail:
    
    delete[] arg1;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_XMLUri__SWIG_3) {
  {
    XERCES_CPP_NAMESPACE::XMLUri *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 0) || (items > 0)) {
      SWIG_croak("Usage: new_XMLUri();");
    }
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLUri *)new XERCES_CPP_NAMESPACE::XMLUri();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    XSRETURN(argvi);
  fail:
    SWIG_croak_null();
  }
}


XS(_wrap_new_XMLUri) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 0) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        {
          _v = SvOK(ST(0)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 3;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_3:
    
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUri, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 4;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_4:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLUri__SWIG_3); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLUri__SWIG_2); return;
    case 3:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLUri__SWIG_0); return;
    case 4:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLUri__SWIG_1); return;
    }
  }
  
  croak("No matching function for overloaded 'new_XMLUri'");
  XSRETURN(0);
}


XS(_wrap_delete_XMLExcepts) {
  {
    XERCES_CPP_NAMESPACE::XMLExcepts *arg1 = (XERCES_CPP_NAMESPACE::XMLExcepts *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_XMLExcepts(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLExcepts, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_XMLExcepts" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLExcepts *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLExcepts * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_XMLException) {
  {
    XERCES_CPP_NAMESPACE::XMLException *arg1 = (XERCES_CPP_NAMESPACE::XMLException *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_XMLException(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_XMLException" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLException *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLException * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLException_getType) {
  {
    XERCES_CPP_NAMESPACE::XMLException *arg1 = (XERCES_CPP_NAMESPACE::XMLException *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLException_getType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLException_getType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLException const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLException * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLException const *)arg1)->getType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLException_getCode) {
  {
    XERCES_CPP_NAMESPACE::XMLException *arg1 = (XERCES_CPP_NAMESPACE::XMLException *) 0 ;
    XERCES_CPP_NAMESPACE::XMLExcepts::Codes result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLException_getCode(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLException_getCode" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLException const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLException * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLExcepts::Codes)((XERCES_CPP_NAMESPACE::XMLException const *)arg1)->getCode();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLException_getMessage) {
  {
    XERCES_CPP_NAMESPACE::XMLException *arg1 = (XERCES_CPP_NAMESPACE::XMLException *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLException_getMessage(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLException_getMessage" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLException const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLException * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLException const *)arg1)->getMessage();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLException_getSrcFile) {
  {
    XERCES_CPP_NAMESPACE::XMLException *arg1 = (XERCES_CPP_NAMESPACE::XMLException *) 0 ;
    char *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLException_getSrcFile(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLException_getSrcFile" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLException const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLException * >(argp1);
    {
      try 
      {
        result = (char *)((XERCES_CPP_NAMESPACE::XMLException const *)arg1)->getSrcFile();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_FromCharPtr(result); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLException_getSrcLine) {
  {
    XERCES_CPP_NAMESPACE::XMLException *arg1 = (XERCES_CPP_NAMESPACE::XMLException *) 0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLException_getSrcLine(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLException_getSrcLine" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLException const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLException * >(argp1);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLException const *)arg1)->getSrcLine();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLException_getErrorType) {
  {
    XERCES_CPP_NAMESPACE::XMLException *arg1 = (XERCES_CPP_NAMESPACE::XMLException *) 0 ;
    XMLErrorReporter::ErrTypes result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLException_getErrorType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLException_getErrorType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLException const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLException * >(argp1);
    {
      try 
      {
        result = ((XERCES_CPP_NAMESPACE::XMLException const *)arg1)->getErrorType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj((new XMLErrorReporter::ErrTypes(static_cast< const XMLErrorReporter::ErrTypes& >(result))), SWIGTYPE_p_XMLErrorReporter__ErrTypes, SWIG_POINTER_OWN | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLException_setPosition) {
  {
    XERCES_CPP_NAMESPACE::XMLException *arg1 = (XERCES_CPP_NAMESPACE::XMLException *) 0 ;
    char *arg2 = (char *) (char *)0 ;
    unsigned int arg3 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int res2 ;
    char *buf2 = 0 ;
    int alloc2 = 0 ;
    unsigned int val3 ;
    int ecode3 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: XMLException_setPosition(self,file,line);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLException, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLException_setPosition" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLException *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLException * >(argp1);
    res2 = SWIG_AsCharPtrAndSize(ST(1), &buf2, NULL, &alloc2);
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "XMLException_setPosition" "', argument " "2"" of type '" "char const *const""'");
    }
    arg2 = buf2;
    ecode3 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(2), &val3);
    if (!SWIG_IsOK(ecode3)) {
      SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "XMLException_setPosition" "', argument " "3"" of type '" "unsigned int""'");
    } 
    arg3 = static_cast< unsigned int >(val3);
    {
      try 
      {
        (arg1)->setPosition((char const *)arg2,arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
    
    XSRETURN(argvi);
  fail:
    
    if (alloc2 == SWIG_NEWOBJ) delete[] buf2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLException_reinitMsgMutex) {
  {
    int argvi = 0;
    dXSARGS;
    
    if ((items < 0) || (items > 0)) {
      SWIG_croak("Usage: XMLException_reinitMsgMutex();");
    }
    {
      try 
      {
        XERCES_CPP_NAMESPACE::XMLException::reinitMsgMutex();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    XSRETURN(argvi);
  fail:
    SWIG_croak_null();
  }
}


XS(_wrap_XMLException_reinitMsgLoader) {
  {
    int argvi = 0;
    dXSARGS;
    
    if ((items < 0) || (items > 0)) {
      SWIG_croak("Usage: XMLException_reinitMsgLoader();");
    }
    {
      try 
      {
        XERCES_CPP_NAMESPACE::XMLException::reinitMsgLoader();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    XSRETURN(argvi);
  fail:
    SWIG_croak_null();
  }
}


XS(_wrap_delete_XMLUni) {
  {
    XERCES_CPP_NAMESPACE::XMLUni *arg1 = (XERCES_CPP_NAMESPACE::XMLUni *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_XMLUni(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLUni, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_XMLUni" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLUni *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLUni * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_QName__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::QName *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 0) || (items > 0)) {
      SWIG_croak("Usage: new_QName();");
    }
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::QName *)new XERCES_CPP_NAMESPACE::QName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    XSRETURN(argvi);
  fail:
    SWIG_croak_null();
  }
}


XS(_wrap_new_QName__SWIG_1) {
  {
    XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg3 ;
    XERCES_CPP_NAMESPACE::QName *result = 0 ;
    unsigned int val3 ;
    int ecode3 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: new_QName(prefix,localPart,uriId);");
    }
    
    if (ST(0) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",1,"new_QName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg1 = Perl2XMLString(ST(0));
    }
    
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"new_QName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    ecode3 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(2), &val3);
    if (!SWIG_IsOK(ecode3)) {
      SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "new_QName" "', argument " "3"" of type '" "unsigned int""'");
    } 
    arg3 = static_cast< unsigned int >(val3);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::QName *)new XERCES_CPP_NAMESPACE::QName((XMLCh const *)arg1,(XMLCh const *)arg2,arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    delete[] arg1;
    
    
    delete[] arg2;
    
    
    XSRETURN(argvi);
  fail:
    
    delete[] arg1;
    
    
    delete[] arg2;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_QName__SWIG_2) {
  {
    XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg2 ;
    XERCES_CPP_NAMESPACE::QName *result = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: new_QName(rawName,uriId);");
    }
    
    if (ST(0) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",1,"new_QName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg1 = Perl2XMLString(ST(0));
    }
    
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "new_QName" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::QName *)new XERCES_CPP_NAMESPACE::QName((XMLCh const *)arg1,arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    delete[] arg1;
    
    
    XSRETURN(argvi);
  fail:
    
    delete[] arg1;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_QName__SWIG_3) {
  {
    XERCES_CPP_NAMESPACE::QName *arg1 = 0 ;
    XERCES_CPP_NAMESPACE::QName *result = 0 ;
    void *argp1 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: new_QName(qname);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_QName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName const &""'"); 
    }
    if (!argp1) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "new_QName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName const &""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::QName *)new XERCES_CPP_NAMESPACE::QName((XERCES_CPP_NAMESPACE::QName const &)*arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_QName) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 0) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        {
          _v = SvOK(ST(0)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 3;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_3:
    
    if (items == 3) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        {
          _v = SvOK(ST(0)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(2), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 4;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_4:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_QName__SWIG_0); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_QName__SWIG_3); return;
    case 3:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_QName__SWIG_2); return;
    case 4:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_QName__SWIG_1); return;
    }
  }
  
  croak("No matching function for overloaded 'new_QName'");
  XSRETURN(0);
}


XS(_wrap_delete_QName) {
  {
    XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_QName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_QName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_QName_getPrefix) {
  {
    XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: QName_getPrefix(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "QName_getPrefix" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp1);
    {
      try 
      {
        result = (XMLCh *)(arg1)->getPrefix();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_QName_getLocalPart) {
  {
    XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: QName_getLocalPart(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "QName_getLocalPart" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp1);
    {
      try 
      {
        result = (XMLCh *)(arg1)->getLocalPart();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_QName_getURI) {
  {
    XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: QName_getURI(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "QName_getURI" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp1);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::QName const *)arg1)->getURI();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_QName_getRawName) {
  {
    XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: QName_getRawName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "QName_getRawName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp1);
    {
      try 
      {
        result = (XMLCh *)(arg1)->getRawName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_QName_getMemoryManager) {
  {
    XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
    XERCES_CPP_NAMESPACE::MemoryManager *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: QName_getMemoryManager(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "QName_getMemoryManager" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::QName const *)arg1)->getMemoryManager();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_QName_setName__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg4 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val4 ;
    int ecode4 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 4) || (items > 4)) {
      SWIG_croak("Usage: QName_setName(self,prefix,localPart,uriId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "QName_setName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"QName_setName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"QName_setName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    ecode4 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(3), &val4);
    if (!SWIG_IsOK(ecode4)) {
      SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "QName_setName" "', argument " "4"" of type '" "unsigned int""'");
    } 
    arg4 = static_cast< unsigned int >(val4);
    {
      try 
      {
        (arg1)->setName((XMLCh const *)arg2,(XMLCh const *)arg3,arg4);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_QName_setName__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg3 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val3 ;
    int ecode3 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: QName_setName(self,rawName,uriId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "QName_setName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"QName_setName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    ecode3 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(2), &val3);
    if (!SWIG_IsOK(ecode3)) {
      SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "QName_setName" "', argument " "3"" of type '" "unsigned int""'");
    } 
    arg3 = static_cast< unsigned int >(val3);
    {
      try 
      {
        (arg1)->setName((XMLCh const *)arg2,arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_QName_setName) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 3) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(2), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 4) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(3), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_QName_setName__SWIG_1); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_QName_setName__SWIG_0); return;
    }
  }
  
  croak("No matching function for overloaded 'QName_setName'");
  XSRETURN(0);
}


XS(_wrap_QName_setPrefix) {
  {
    XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: QName_setPrefix(self,XMLCh const *);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "QName_setPrefix" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"QName_setPrefix");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setPrefix((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_QName_setLocalPart) {
  {
    XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: QName_setLocalPart(self,XMLCh const *);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "QName_setLocalPart" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"QName_setLocalPart");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setLocalPart((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_QName_setNPrefix) {
  {
    XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    unsigned int arg3 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val3 ;
    int ecode3 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: QName_setNPrefix(self,XMLCh const *,unsigned int const);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "QName_setNPrefix" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"QName_setNPrefix");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    ecode3 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(2), &val3);
    if (!SWIG_IsOK(ecode3)) {
      SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "QName_setNPrefix" "', argument " "3"" of type '" "unsigned int""'");
    } 
    arg3 = static_cast< unsigned int >(val3);
    {
      try 
      {
        (arg1)->setNPrefix((XMLCh const *)arg2,arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_QName_setNLocalPart) {
  {
    XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    unsigned int arg3 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val3 ;
    int ecode3 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: QName_setNLocalPart(self,XMLCh const *,unsigned int const);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "QName_setNLocalPart" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"QName_setNLocalPart");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    ecode3 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(2), &val3);
    if (!SWIG_IsOK(ecode3)) {
      SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "QName_setNLocalPart" "', argument " "3"" of type '" "unsigned int""'");
    } 
    arg3 = static_cast< unsigned int >(val3);
    {
      try 
      {
        (arg1)->setNLocalPart((XMLCh const *)arg2,arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_QName_setURI) {
  {
    XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
    unsigned int arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: QName_setURI(self,unsigned int const);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "QName_setURI" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "QName_setURI" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        (arg1)->setURI(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_QName_setValues) {
  {
    XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
    XERCES_CPP_NAMESPACE::QName *arg2 = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: QName_setValues(self,qname);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "QName_setValues" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "QName_setValues" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::QName const &""'"); 
    }
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "QName_setValues" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::QName const &""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp2);
    {
      try 
      {
        (arg1)->setValues((XERCES_CPP_NAMESPACE::QName const &)*arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_QName___eq__) {
  {
    XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
    XERCES_CPP_NAMESPACE::QName *arg2 = 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: QName___eq__(self,XERCES_CPP_NAMESPACE::QName const &);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "QName___eq__" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName,  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "QName___eq__" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::QName const &""'"); 
    }
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "QName___eq__" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::QName const &""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp2);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::QName const *)arg1)->operator ==((XERCES_CPP_NAMESPACE::QName const &)*arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_QName_cleanUp) {
  {
    XERCES_CPP_NAMESPACE::QName *arg1 = (XERCES_CPP_NAMESPACE::QName *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: QName_cleanUp(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "QName_cleanUp" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::QName *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp1);
    {
      try 
      {
        (arg1)->cleanUp();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_XMLElementDecl) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_XMLElementDecl(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_XMLElementDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_findAttr) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg3 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl::LookupOpts arg6 ;
    bool *arg7 = 0 ;
    XMLAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val3 ;
    int ecode3 = 0 ;
    int val6 ;
    int ecode6 = 0 ;
    void *argp7 = 0 ;
    int res7 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 7) || (items > 7)) {
      SWIG_croak("Usage: XMLElementDecl_findAttr(self,qName,uriId,baseName,prefix,options,wasAdded);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_findAttr" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLElementDecl_findAttr");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    ecode3 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(2), &val3);
    if (!SWIG_IsOK(ecode3)) {
      SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "XMLElementDecl_findAttr" "', argument " "3"" of type '" "unsigned int""'");
    } 
    arg3 = static_cast< unsigned int >(val3);
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"XMLElementDecl_findAttr");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    
    if (ST(4) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",5,"XMLElementDecl_findAttr");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg5 = Perl2XMLString(ST(4));
    }
    
    ecode6 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(5), &val6);
    if (!SWIG_IsOK(ecode6)) {
      SWIG_exception_fail(SWIG_ArgError(ecode6), "in method '" "XMLElementDecl_findAttr" "', argument " "6"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl::LookupOpts""'");
    } 
    arg6 = static_cast< XERCES_CPP_NAMESPACE::XMLElementDecl::LookupOpts >(val6);
    res7 = SWIG_ConvertPtr(ST(6), &argp7, SWIGTYPE_p_bool,  0 );
    if (!SWIG_IsOK(res7)) {
      SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "XMLElementDecl_findAttr" "', argument " "7"" of type '" "bool &""'"); 
    }
    if (!argp7) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "XMLElementDecl_findAttr" "', argument " "7"" of type '" "bool &""'"); 
    }
    arg7 = reinterpret_cast< bool * >(argp7);
    {
      try 
      {
        result = (XMLAttDef *)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->findAttr((XMLCh const *)arg2,arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,*arg7);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    
    delete[] arg2;
    
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_getAttDefList) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XMLAttDefList *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_getAttDefList(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_getAttDefList" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        {
          XMLAttDefList &_result_ref = ((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getAttDefList();
          result = (XMLAttDefList *) &_result_ref;
        }
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_getCharDataOpts) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl::CharDataOpts result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_getCharDataOpts(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_getCharDataOpts" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl::CharDataOpts)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getCharDataOpts();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_hasAttDefs) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_hasAttDefs(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_hasAttDefs" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->hasAttDefs();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_resetDefs) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_resetDefs(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_resetDefs" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (bool)(arg1)->resetDefs();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_getContentSpec) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::ContentSpecNode *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_getContentSpec(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_getContentSpec" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::ContentSpecNode *)(arg1)->getContentSpec();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__ContentSpecNode, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_setContentSpec) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::ContentSpecNode *arg2 = (XERCES_CPP_NAMESPACE::ContentSpecNode *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLElementDecl_setContentSpec(self,toAdopt);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_setContentSpec" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__ContentSpecNode, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "XMLElementDecl_setContentSpec" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::ContentSpecNode *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::ContentSpecNode * >(argp2);
    {
      try 
      {
        (arg1)->setContentSpec(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_getContentModel) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::XMLContentModel *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_getContentModel(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_getContentModel" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLContentModel *)(arg1)->getContentModel();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLContentModel, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_setContentModel) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::XMLContentModel *arg2 = (XERCES_CPP_NAMESPACE::XMLContentModel *) (XERCES_CPP_NAMESPACE::XMLContentModel *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLElementDecl_setContentModel(self,newModelToAdopt);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_setContentModel" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLContentModel, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "XMLElementDecl_setContentModel" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLContentModel *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLContentModel * >(argp2);
    {
      try 
      {
        (arg1)->setContentModel(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_getFormattedContentModel) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_getFormattedContentModel(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_getFormattedContentModel" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getFormattedContentModel();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_getBaseName) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_getBaseName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_getBaseName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)(arg1)->getBaseName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_getURI) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_getURI(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_getURI" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getURI();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_getElementName) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::QName *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_getElementName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_getElementName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::QName *)(arg1)->getElementName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_getFullName) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_getFullName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_getFullName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getFullName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_getCreateReason) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl::CreateReasons result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_getCreateReason(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_getCreateReason" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl::CreateReasons)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getCreateReason();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_getId) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_getId(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_getId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getId();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_getDOMTypeInfoUri) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_getDOMTypeInfoUri(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_getDOMTypeInfoUri" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getDOMTypeInfoUri();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_getDOMTypeInfoName) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_getDOMTypeInfoName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_getDOMTypeInfoName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getDOMTypeInfoName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_isDeclared) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_isDeclared(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_isDeclared" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->isDeclared();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_isExternal) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_isExternal(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_isExternal" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->isExternal();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_getMemoryManager) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::MemoryManager *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_getMemoryManager(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_getMemoryManager" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getMemoryManager();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_setElementName__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    int arg4 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int val4 ;
    int ecode4 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 4) || (items > 4)) {
      SWIG_croak("Usage: XMLElementDecl_setElementName(self,prefix,localPart,uriId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_setElementName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLElementDecl_setElementName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"XMLElementDecl_setElementName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    ecode4 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(3), &val4);
    if (!SWIG_IsOK(ecode4)) {
      SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "XMLElementDecl_setElementName" "', argument " "4"" of type '" "int""'");
    } 
    arg4 = static_cast< int >(val4);
    {
      try 
      {
        (arg1)->setElementName((XMLCh const *)arg2,(XMLCh const *)arg3,arg4);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_setElementName__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    int arg3 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int val3 ;
    int ecode3 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: XMLElementDecl_setElementName(self,rawName,uriId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_setElementName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLElementDecl_setElementName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    ecode3 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(2), &val3);
    if (!SWIG_IsOK(ecode3)) {
      SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "XMLElementDecl_setElementName" "', argument " "3"" of type '" "int""'");
    } 
    arg3 = static_cast< int >(val3);
    {
      try 
      {
        (arg1)->setElementName((XMLCh const *)arg2,arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_setElementName__SWIG_2) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::QName *arg2 = (XERCES_CPP_NAMESPACE::QName *) (XERCES_CPP_NAMESPACE::QName *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLElementDecl_setElementName(self,elementName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_setElementName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "XMLElementDecl_setElementName" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::QName const *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp2);
    {
      try 
      {
        (arg1)->setElementName((XERCES_CPP_NAMESPACE::QName const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_setElementName) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(1), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 3) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(2), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
    if (items == 4) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(3), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 3;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_3:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLElementDecl_setElementName__SWIG_2); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLElementDecl_setElementName__SWIG_1); return;
    case 3:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLElementDecl_setElementName__SWIG_0); return;
    }
  }
  
  croak("No matching function for overloaded 'XMLElementDecl_setElementName'");
  XSRETURN(0);
}


XS(_wrap_XMLElementDecl_setCreateReason) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl::CreateReasons arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLElementDecl_setCreateReason(self,newReason);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_setCreateReason" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    ecode2 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "XMLElementDecl_setCreateReason" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl::CreateReasons""'");
    } 
    arg2 = static_cast< XERCES_CPP_NAMESPACE::XMLElementDecl::CreateReasons >(val2);
    {
      try 
      {
        (arg1)->setCreateReason(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_setId) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    unsigned int arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLElementDecl_setId(self,newId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_setId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "XMLElementDecl_setId" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        (arg1)->setId(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_setExternalElemDeclaration) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    bool arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    bool val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLElementDecl_setExternalElemDeclaration(self,aValue);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_setExternalElemDeclaration" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    ecode2 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "XMLElementDecl_setExternalElemDeclaration" "', argument " "2"" of type '" "bool""'");
    } 
    arg2 = static_cast< bool >(val2);
    {
      try 
      {
        (arg1)->setExternalElemDeclaration(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_getObjectType) {
  {
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl::objectType result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_getObjectType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_getObjectType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl::objectType)((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg1)->getObjectType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_storeElementDecl) {
  {
    XSerializeEngine *arg1 = 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) (XERCES_CPP_NAMESPACE::XMLElementDecl *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLElementDecl_storeElementDecl(serEng,element);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1, SWIGTYPE_p_XSerializeEngine,  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_storeElementDecl" "', argument " "1"" of type '" "XSerializeEngine &""'"); 
    }
    if (!argp1) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "XMLElementDecl_storeElementDecl" "', argument " "1"" of type '" "XSerializeEngine &""'"); 
    }
    arg1 = reinterpret_cast< XSerializeEngine * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "XMLElementDecl_storeElementDecl" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp2);
    {
      try 
      {
        XERCES_CPP_NAMESPACE::XMLElementDecl::storeElementDecl(*arg1,arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLElementDecl_loadElementDecl) {
  {
    XSerializeEngine *arg1 = 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLElementDecl_loadElementDecl(serEng);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1, SWIGTYPE_p_XSerializeEngine,  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLElementDecl_loadElementDecl" "', argument " "1"" of type '" "XSerializeEngine &""'"); 
    }
    if (!argp1) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "XMLElementDecl_loadElementDecl" "', argument " "1"" of type '" "XSerializeEngine &""'"); 
    }
    arg1 = reinterpret_cast< XSerializeEngine * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)XERCES_CPP_NAMESPACE::XMLElementDecl::loadElementDecl(*arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_XMLEntityDecl) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_XMLEntityDecl(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_XMLEntityDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_getDeclaredInIntSubset) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLEntityDecl_getDeclaredInIntSubset(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_getDeclaredInIntSubset" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getDeclaredInIntSubset();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_getIsParameter) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLEntityDecl_getIsParameter(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_getIsParameter" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getIsParameter();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_getIsSpecialChar) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLEntityDecl_getIsSpecialChar(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_getIsSpecialChar" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getIsSpecialChar();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_getId) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLEntityDecl_getId(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_getId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getId();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_getName) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLEntityDecl_getName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_getName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_getNotationName) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLEntityDecl_getNotationName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_getNotationName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getNotationName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_getPublicId) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLEntityDecl_getPublicId(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_getPublicId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getPublicId();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_getSystemId) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLEntityDecl_getSystemId(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_getSystemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getSystemId();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_getBaseURI) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLEntityDecl_getBaseURI(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_getBaseURI" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getBaseURI();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_getValue) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLEntityDecl_getValue(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_getValue" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getValue();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_getValueLen) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLEntityDecl_getValueLen(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_getValueLen" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getValueLen();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_isExternal) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLEntityDecl_isExternal(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_isExternal" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->isExternal();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_isUnparsed) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLEntityDecl_isUnparsed(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_isUnparsed" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->isUnparsed();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_getMemoryManager) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    XERCES_CPP_NAMESPACE::MemoryManager *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLEntityDecl_getMemoryManager(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_getMemoryManager" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getMemoryManager();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_setName) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLEntityDecl_setName(self,entName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_setName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLEntityDecl_setName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setName((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_setNotationName) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLEntityDecl_setNotationName(self,newName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_setNotationName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLEntityDecl_setNotationName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setNotationName((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_setPublicId) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLEntityDecl_setPublicId(self,newId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_setPublicId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLEntityDecl_setPublicId");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setPublicId((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_setSystemId) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLEntityDecl_setSystemId(self,newId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_setSystemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLEntityDecl_setSystemId");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setSystemId((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_setBaseURI) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLEntityDecl_setBaseURI(self,newId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_setBaseURI" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLEntityDecl_setBaseURI");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setBaseURI((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_setValue) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLEntityDecl_setValue(self,newValue);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_setValue" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLEntityDecl_setValue");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setValue((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_setId) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    unsigned int arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLEntityDecl_setId(self,newId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_setId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "XMLEntityDecl_setId" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        (arg1)->setId(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLEntityDecl_getKey) {
  {
    XERCES_CPP_NAMESPACE::XMLEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLEntityDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLEntityDecl_getKey(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLEntityDecl_getKey" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLEntityDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLEntityDecl const *)arg1)->getKey();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_XMLNotationDecl__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::XMLNotationDecl *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 0) || (items > 0)) {
      SWIG_croak("Usage: new_XMLNotationDecl();");
    }
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLNotationDecl *)new XERCES_CPP_NAMESPACE::XMLNotationDecl();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    XSRETURN(argvi);
  fail:
    SWIG_croak_null();
  }
}


XS(_wrap_new_XMLNotationDecl__SWIG_1) {
  {
    XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLNotationDecl *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 4) || (items > 4)) {
      SWIG_croak("Usage: new_XMLNotationDecl(notName,pubId,sysId,baseURI);");
    }
    
    if (ST(0) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",1,"new_XMLNotationDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg1 = Perl2XMLString(ST(0));
    }
    
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"new_XMLNotationDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"new_XMLNotationDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"new_XMLNotationDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLNotationDecl *)new XERCES_CPP_NAMESPACE::XMLNotationDecl((XMLCh const *)arg1,(XMLCh const *)arg2,(XMLCh const *)arg3,(XMLCh const *)arg4);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    delete[] arg1;
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    XSRETURN(argvi);
  fail:
    
    delete[] arg1;
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_XMLNotationDecl__SWIG_2) {
  {
    XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLNotationDecl *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: new_XMLNotationDecl(notName,pubId,sysId);");
    }
    
    if (ST(0) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",1,"new_XMLNotationDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg1 = Perl2XMLString(ST(0));
    }
    
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"new_XMLNotationDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"new_XMLNotationDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLNotationDecl *)new XERCES_CPP_NAMESPACE::XMLNotationDecl((XMLCh const *)arg1,(XMLCh const *)arg2,(XMLCh const *)arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    delete[] arg1;
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    XSRETURN(argvi);
  fail:
    
    delete[] arg1;
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_XMLNotationDecl) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 0) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
    if (items == 3) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        {
          _v = SvOK(ST(0)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
    if (items == 4) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        {
          _v = SvOK(ST(0)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(3)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 3;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_3:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLNotationDecl__SWIG_0); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLNotationDecl__SWIG_2); return;
    case 3:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_XMLNotationDecl__SWIG_1); return;
    }
  }
  
  croak("No matching function for overloaded 'new_XMLNotationDecl'");
  XSRETURN(0);
}


XS(_wrap_delete_XMLNotationDecl) {
  {
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_XMLNotationDecl(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_XMLNotationDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLNotationDecl_getId) {
  {
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLNotationDecl_getId(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLNotationDecl_getId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp1);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLNotationDecl const *)arg1)->getId();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLNotationDecl_getName) {
  {
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLNotationDecl_getName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLNotationDecl_getName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLNotationDecl const *)arg1)->getName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLNotationDecl_getPublicId) {
  {
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLNotationDecl_getPublicId(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLNotationDecl_getPublicId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLNotationDecl const *)arg1)->getPublicId();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLNotationDecl_getSystemId) {
  {
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLNotationDecl_getSystemId(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLNotationDecl_getSystemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLNotationDecl const *)arg1)->getSystemId();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLNotationDecl_getBaseURI) {
  {
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLNotationDecl_getBaseURI(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLNotationDecl_getBaseURI" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLNotationDecl const *)arg1)->getBaseURI();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLNotationDecl_getNameSpaceId) {
  {
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLNotationDecl_getNameSpaceId(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLNotationDecl_getNameSpaceId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp1);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLNotationDecl const *)arg1)->getNameSpaceId();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLNotationDecl_getMemoryManager) {
  {
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
    XERCES_CPP_NAMESPACE::MemoryManager *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLNotationDecl_getMemoryManager(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLNotationDecl_getMemoryManager" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::XMLNotationDecl const *)arg1)->getMemoryManager();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLNotationDecl_setId) {
  {
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
    unsigned int arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLNotationDecl_setId(self,newId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLNotationDecl_setId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "XMLNotationDecl_setId" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        (arg1)->setId(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLNotationDecl_setName) {
  {
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLNotationDecl_setName(self,notName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLNotationDecl_setName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLNotationDecl_setName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setName((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLNotationDecl_setPublicId) {
  {
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLNotationDecl_setPublicId(self,newId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLNotationDecl_setPublicId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLNotationDecl_setPublicId");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setPublicId((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLNotationDecl_setSystemId) {
  {
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLNotationDecl_setSystemId(self,newId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLNotationDecl_setSystemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLNotationDecl_setSystemId");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setSystemId((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLNotationDecl_setBaseURI) {
  {
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLNotationDecl_setBaseURI(self,newId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLNotationDecl_setBaseURI" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLNotationDecl_setBaseURI");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setBaseURI((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLNotationDecl_setNameSpaceId) {
  {
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
    unsigned int arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLNotationDecl_setNameSpaceId(self,newId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLNotationDecl_setNameSpaceId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "XMLNotationDecl_setNameSpaceId" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        (arg1)->setNameSpaceId(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLNotationDecl_getKey) {
  {
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg1 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLNotationDecl_getKey(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLNotationDecl_getKey" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLNotationDecl const *)arg1)->getKey();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_XMLAttDefList) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_XMLAttDefList(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_XMLAttDefList" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDefList * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDefList_hasMoreElements) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDefList_hasMoreElements(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDefList_hasMoreElements" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDefList const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDefList * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::XMLAttDefList const *)arg1)->hasMoreElements();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDefList_isEmpty) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDefList_isEmpty(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDefList_isEmpty" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDefList const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDefList * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::XMLAttDefList const *)arg1)->isEmpty();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDefList_findAttDef__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
    unsigned long arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned long val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: XMLAttDefList_findAttDef(self,uriID,attName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDefList_findAttDef" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDefList * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_long SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "XMLAttDefList_findAttDef" "', argument " "2"" of type '" "unsigned long""'");
    } 
    arg2 = static_cast< unsigned long >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"XMLAttDefList_findAttDef");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLAttDef *)(arg1)->findAttDef(arg2,(XMLCh const *)arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    delete[] arg3;
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDefList_findAttDef__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: XMLAttDefList_findAttDef(self,attURI,attName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDefList_findAttDef" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDefList * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLAttDefList_findAttDef");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"XMLAttDefList_findAttDef");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLAttDef *)(arg1)->findAttDef((XMLCh const *)arg2,(XMLCh const *)arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDefList_findAttDef) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 3) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_long SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 3) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLAttDefList_findAttDef__SWIG_0); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_XMLAttDefList_findAttDef__SWIG_1); return;
    }
  }
  
  croak("No matching function for overloaded 'XMLAttDefList_findAttDef'");
  XSRETURN(0);
}


XS(_wrap_XMLAttDefList_nextElement) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDefList_nextElement(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDefList_nextElement" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDefList * >(argp1);
    {
      try 
      {
        {
          XERCES_CPP_NAMESPACE::XMLAttDef &_result_ref = (arg1)->nextElement();
          result = (XERCES_CPP_NAMESPACE::XMLAttDef *) &_result_ref;
        }
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDefList_Reset) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDefList_Reset(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDefList_Reset" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDefList * >(argp1);
    {
      try 
      {
        (arg1)->Reset();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDefList_getAttDefCount) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDefList_getAttDefCount(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDefList_getAttDefCount" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDefList const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDefList * >(argp1);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLAttDefList const *)arg1)->getAttDefCount();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDefList_getAttDef) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
    unsigned int arg2 ;
    XERCES_CPP_NAMESPACE::XMLAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLAttDefList_getAttDef(self,index);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDefList_getAttDef" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDefList * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "XMLAttDefList_getAttDef" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        {
          XERCES_CPP_NAMESPACE::XMLAttDef &_result_ref = (arg1)->getAttDef(arg2);
          result = (XERCES_CPP_NAMESPACE::XMLAttDef *) &_result_ref;
        }
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDefList_getMemoryManager) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDefList *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDefList *) 0 ;
    XERCES_CPP_NAMESPACE::MemoryManager *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDefList_getMemoryManager(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDefList_getMemoryManager" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDefList const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDefList * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::XMLAttDefList const *)arg1)->getMemoryManager();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_getAttTypeString) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef::AttTypes arg1 ;
    XMLCh *result = 0 ;
    int val1 ;
    int ecode1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDef_getAttTypeString(attrType);");
    }
    ecode1 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(0), &val1);
    if (!SWIG_IsOK(ecode1)) {
      SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "XMLAttDef_getAttTypeString" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef::AttTypes""'");
    } 
    arg1 = static_cast< XERCES_CPP_NAMESPACE::XMLAttDef::AttTypes >(val1);
    {
      try 
      {
        result = (XMLCh *)XERCES_CPP_NAMESPACE::XMLAttDef::getAttTypeString(arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_getDefAttTypeString) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef::DefAttTypes arg1 ;
    XMLCh *result = 0 ;
    int val1 ;
    int ecode1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDef_getDefAttTypeString(attrType);");
    }
    ecode1 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(0), &val1);
    if (!SWIG_IsOK(ecode1)) {
      SWIG_exception_fail(SWIG_ArgError(ecode1), "in method '" "XMLAttDef_getDefAttTypeString" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef::DefAttTypes""'");
    } 
    arg1 = static_cast< XERCES_CPP_NAMESPACE::XMLAttDef::DefAttTypes >(val1);
    {
      try 
      {
        result = (XMLCh *)XERCES_CPP_NAMESPACE::XMLAttDef::getDefAttTypeString(arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_XMLAttDef) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_XMLAttDef(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_XMLAttDef" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_getFullName) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDef_getFullName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_getFullName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getFullName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_reset) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDef_reset(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_reset" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    {
      try 
      {
        (arg1)->reset();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_getDefaultType) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef::DefAttTypes result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDef_getDefaultType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_getDefaultType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLAttDef::DefAttTypes)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getDefaultType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_getEnumeration) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDef_getEnumeration(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_getEnumeration" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getEnumeration();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_getId) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDef_getId(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_getId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getId();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_getProvided) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDef_getProvided(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_getProvided" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getProvided();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_getType) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef::AttTypes result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDef_getType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_getType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLAttDef::AttTypes)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_getValue) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDef_getValue(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_getValue" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getValue();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_getCreateReason) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef::CreateReasons result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDef_getCreateReason(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_getCreateReason" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLAttDef::CreateReasons)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getCreateReason();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_isExternal) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDef_isExternal(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_isExternal" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->isExternal();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_getMemoryManager) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    XERCES_CPP_NAMESPACE::MemoryManager *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDef_getMemoryManager(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_getMemoryManager" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getMemoryManager();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_getDOMTypeInfoUri) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDef_getDOMTypeInfoUri(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_getDOMTypeInfoUri" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getDOMTypeInfoUri();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_getDOMTypeInfoName) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLAttDef_getDOMTypeInfoName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_getDOMTypeInfoName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLAttDef const *)arg1)->getDOMTypeInfoName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_setDefaultType) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef::DefAttTypes arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLAttDef_setDefaultType(self,newValue);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_setDefaultType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    ecode2 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "XMLAttDef_setDefaultType" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef::DefAttTypes""'");
    } 
    arg2 = static_cast< XERCES_CPP_NAMESPACE::XMLAttDef::DefAttTypes >(val2);
    {
      try 
      {
        (arg1)->setDefaultType(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_setId) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    unsigned int arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLAttDef_setId(self,newId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_setId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "XMLAttDef_setId" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        (arg1)->setId(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_setProvided) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    bool arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    bool val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLAttDef_setProvided(self,newValue);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_setProvided" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    ecode2 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "XMLAttDef_setProvided" "', argument " "2"" of type '" "bool""'");
    } 
    arg2 = static_cast< bool >(val2);
    {
      try 
      {
        (arg1)->setProvided(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_setType) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef::AttTypes arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLAttDef_setType(self,newValue);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_setType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    ecode2 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "XMLAttDef_setType" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef::AttTypes""'");
    } 
    arg2 = static_cast< XERCES_CPP_NAMESPACE::XMLAttDef::AttTypes >(val2);
    {
      try 
      {
        (arg1)->setType(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_setValue) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLAttDef_setValue(self,newValue);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_setValue" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLAttDef_setValue");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setValue((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_setEnumeration) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLAttDef_setEnumeration(self,newValue);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_setEnumeration" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLAttDef_setEnumeration");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setEnumeration((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_setCreateReason) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef::CreateReasons arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLAttDef_setCreateReason(self,newReason);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_setCreateReason" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    ecode2 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "XMLAttDef_setCreateReason" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef::CreateReasons""'");
    } 
    arg2 = static_cast< XERCES_CPP_NAMESPACE::XMLAttDef::CreateReasons >(val2);
    {
      try 
      {
        (arg1)->setCreateReason(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLAttDef_setExternalAttDeclaration) {
  {
    XERCES_CPP_NAMESPACE::XMLAttDef *arg1 = (XERCES_CPP_NAMESPACE::XMLAttDef *) 0 ;
    bool arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    bool val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLAttDef_setExternalAttDeclaration(self,aValue);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLAttDef_setExternalAttDeclaration" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp1);
    ecode2 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "XMLAttDef_setExternalAttDeclaration" "', argument " "2"" of type '" "bool""'");
    } 
    arg2 = static_cast< bool >(val2);
    {
      try 
      {
        (arg1)->setExternalAttDeclaration(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_XMLValidator) {
  {
    XERCES_CPP_NAMESPACE::XMLValidator *arg1 = (XERCES_CPP_NAMESPACE::XMLValidator *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_XMLValidator(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLValidator, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_XMLValidator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLValidator *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLValidator * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLValidator_getGrammar) {
  {
    XERCES_CPP_NAMESPACE::XMLValidator *arg1 = (XERCES_CPP_NAMESPACE::XMLValidator *) 0 ;
    XERCES_CPP_NAMESPACE::Grammar *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLValidator_getGrammar(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLValidator_getGrammar" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLValidator const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLValidator * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::Grammar *)((XERCES_CPP_NAMESPACE::XMLValidator const *)arg1)->getGrammar();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, SWIG_as_voidptrptr(&result)), 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLValidator_setGrammar) {
  {
    XERCES_CPP_NAMESPACE::XMLValidator *arg1 = (XERCES_CPP_NAMESPACE::XMLValidator *) 0 ;
    XERCES_CPP_NAMESPACE::Grammar *arg2 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLValidator_setGrammar(self,aGrammar);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLValidator_setGrammar" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLValidator *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLValidator * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "XMLValidator_setGrammar" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::Grammar *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp2);
    {
      try 
      {
        (arg1)->setGrammar(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_Grammar) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_Grammar(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_Grammar" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_getGrammarType) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    XERCES_CPP_NAMESPACE::Grammar::GrammarType result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: Grammar_getGrammarType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_getGrammarType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::Grammar::GrammarType)((XERCES_CPP_NAMESPACE::Grammar const *)arg1)->getGrammarType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_getTargetNamespace) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: Grammar_getTargetNamespace(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_getTargetNamespace" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::Grammar const *)arg1)->getTargetNamespace();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_getValidated) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: Grammar_getValidated(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_getValidated" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::Grammar const *)arg1)->getValidated();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_findOrAddElemDecl) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    unsigned int arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg6 ;
    bool *arg7 = 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    unsigned int val6 ;
    int ecode6 = 0 ;
    void *argp7 = 0 ;
    int res7 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 7) || (items > 7)) {
      SWIG_croak("Usage: Grammar_findOrAddElemDecl(self,uriId,baseName,prefixName,qName,scope,wasAdded);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_findOrAddElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Grammar_findOrAddElemDecl" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"Grammar_findOrAddElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"Grammar_findOrAddElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    
    if (ST(4) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",5,"Grammar_findOrAddElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg5 = Perl2XMLString(ST(4));
    }
    
    ecode6 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(5), &val6);
    if (!SWIG_IsOK(ecode6)) {
      SWIG_exception_fail(SWIG_ArgError(ecode6), "in method '" "Grammar_findOrAddElemDecl" "', argument " "6"" of type '" "unsigned int""'");
    } 
    arg6 = static_cast< unsigned int >(val6);
    res7 = SWIG_ConvertPtr(ST(6), &argp7, SWIGTYPE_p_bool,  0 );
    if (!SWIG_IsOK(res7)) {
      SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "Grammar_findOrAddElemDecl" "', argument " "7"" of type '" "bool &""'"); 
    }
    if (!argp7) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Grammar_findOrAddElemDecl" "', argument " "7"" of type '" "bool &""'"); 
    }
    arg7 = reinterpret_cast< bool * >(argp7);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->findOrAddElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,*arg7);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_getElemId) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    unsigned int arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg5 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    unsigned int val5 ;
    int ecode5 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 5) || (items > 5)) {
      SWIG_croak("Usage: Grammar_getElemId(self,uriId,baseName,qName,scope);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_getElemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Grammar_getElemId" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"Grammar_getElemId");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"Grammar_getElemId");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    ecode5 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(4), &val5);
    if (!SWIG_IsOK(ecode5)) {
      SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "Grammar_getElemId" "', argument " "5"" of type '" "unsigned int""'");
    } 
    arg5 = static_cast< unsigned int >(val5);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::Grammar const *)arg1)->getElemId(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,arg5);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_getElemDecl__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    unsigned int arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg5 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    unsigned int val5 ;
    int ecode5 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 5) || (items > 5)) {
      SWIG_croak("Usage: Grammar_getElemDecl(self,uriId,baseName,qName,scope);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_getElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Grammar_getElemDecl" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"Grammar_getElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"Grammar_getElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    ecode5 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(4), &val5);
    if (!SWIG_IsOK(ecode5)) {
      SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "Grammar_getElemDecl" "', argument " "5"" of type '" "unsigned int""'");
    } 
    arg5 = static_cast< unsigned int >(val5);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->getElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,arg5);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_getElemDecl__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    unsigned int arg2 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: Grammar_getElemDecl(self,elemId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_getElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Grammar_getElemDecl" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->getElemDecl(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_getElemDecl) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 5) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(3)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(4), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_Grammar_getElemDecl__SWIG_1); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_Grammar_getElemDecl__SWIG_0); return;
    }
  }
  
  croak("No matching function for overloaded 'Grammar_getElemDecl'");
  XSRETURN(0);
}


XS(_wrap_Grammar_getNotationDecl) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLNotationDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: Grammar_getNotationDecl(self,notName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_getNotationDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"Grammar_getNotationDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLNotationDecl *)(arg1)->getNotationDecl((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_putElemDecl__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    unsigned int arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg6 ;
    bool arg7 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    unsigned int val6 ;
    int ecode6 = 0 ;
    bool val7 ;
    int ecode7 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 7) || (items > 7)) {
      SWIG_croak("Usage: Grammar_putElemDecl(self,uriId,baseName,prefixName,qName,scope,notDeclared);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_putElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Grammar_putElemDecl" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"Grammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"Grammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    
    if (ST(4) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",5,"Grammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg5 = Perl2XMLString(ST(4));
    }
    
    ecode6 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(5), &val6);
    if (!SWIG_IsOK(ecode6)) {
      SWIG_exception_fail(SWIG_ArgError(ecode6), "in method '" "Grammar_putElemDecl" "', argument " "6"" of type '" "unsigned int""'");
    } 
    arg6 = static_cast< unsigned int >(val6);
    ecode7 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(6), &val7);
    if (!SWIG_IsOK(ecode7)) {
      SWIG_exception_fail(SWIG_ArgError(ecode7), "in method '" "Grammar_putElemDecl" "', argument " "7"" of type '" "bool""'");
    } 
    arg7 = static_cast< bool >(val7);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->putElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,arg7);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_putElemDecl__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    unsigned int arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg6 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    unsigned int val6 ;
    int ecode6 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 6) || (items > 6)) {
      SWIG_croak("Usage: Grammar_putElemDecl(self,uriId,baseName,prefixName,qName,scope);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_putElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Grammar_putElemDecl" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"Grammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"Grammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    
    if (ST(4) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",5,"Grammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg5 = Perl2XMLString(ST(4));
    }
    
    ecode6 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(5), &val6);
    if (!SWIG_IsOK(ecode6)) {
      SWIG_exception_fail(SWIG_ArgError(ecode6), "in method '" "Grammar_putElemDecl" "', argument " "6"" of type '" "unsigned int""'");
    } 
    arg6 = static_cast< unsigned int >(val6);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->putElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_putElemDecl__SWIG_2) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) (XERCES_CPP_NAMESPACE::XMLElementDecl *)0 ;
    bool arg3 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    bool val3 ;
    int ecode3 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: Grammar_putElemDecl(self,elemDecl,notDeclared);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_putElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Grammar_putElemDecl" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp2);
    ecode3 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(2), &val3);
    if (!SWIG_IsOK(ecode3)) {
      SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "Grammar_putElemDecl" "', argument " "3"" of type '" "bool""'");
    } 
    arg3 = static_cast< bool >(val3);
    {
      try 
      {
        result = (unsigned int)(arg1)->putElemDecl(arg2,arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_putElemDecl__SWIG_3) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) (XERCES_CPP_NAMESPACE::XMLElementDecl *)0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: Grammar_putElemDecl(self,elemDecl);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_putElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Grammar_putElemDecl" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp2);
    {
      try 
      {
        result = (unsigned int)(arg1)->putElemDecl(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_putElemDecl) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(1), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 3) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(1), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(2), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
    if (items == 6) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(3)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(4)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(5), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 3;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_3:
    
    if (items == 7) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(3)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(4)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(5), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(6), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 4;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_4:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_Grammar_putElemDecl__SWIG_3); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_Grammar_putElemDecl__SWIG_2); return;
    case 3:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_Grammar_putElemDecl__SWIG_1); return;
    case 4:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_Grammar_putElemDecl__SWIG_0); return;
    }
  }
  
  croak("No matching function for overloaded 'Grammar_putElemDecl'");
  XSRETURN(0);
}


XS(_wrap_Grammar_putNotationDecl) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) (XERCES_CPP_NAMESPACE::XMLNotationDecl *)0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: Grammar_putNotationDecl(self,notationDecl);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_putNotationDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Grammar_putNotationDecl" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp2);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::Grammar const *)arg1)->putNotationDecl(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_setValidated) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    bool arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    bool val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: Grammar_setValidated(self,newState);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_setValidated" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    ecode2 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "Grammar_setValidated" "', argument " "2"" of type '" "bool""'");
    } 
    arg2 = static_cast< bool >(val2);
    {
      try 
      {
        (arg1)->setValidated(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_reset) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: Grammar_reset(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_reset" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    {
      try 
      {
        (arg1)->reset();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_setGrammarDescription) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    XERCES_CPP_NAMESPACE::XMLGrammarDescription *arg2 = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: Grammar_setGrammarDescription(self,XERCES_CPP_NAMESPACE::XMLGrammarDescription *);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_setGrammarDescription" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Grammar_setGrammarDescription" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLGrammarDescription *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLGrammarDescription * >(argp2);
    {
      try 
      {
        (arg1)->setGrammarDescription(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_getGrammarDescription) {
  {
    XERCES_CPP_NAMESPACE::Grammar *arg1 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    XERCES_CPP_NAMESPACE::XMLGrammarDescription *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: Grammar_getGrammarDescription(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_getGrammarDescription" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::Grammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *)((XERCES_CPP_NAMESPACE::Grammar const *)arg1)->getGrammarDescription();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_storeGrammar) {
  {
    XSerializeEngine *arg1 = 0 ;
    XERCES_CPP_NAMESPACE::Grammar *arg2 = (XERCES_CPP_NAMESPACE::Grammar *) (XERCES_CPP_NAMESPACE::Grammar *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: Grammar_storeGrammar(serEng,grammar);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1, SWIGTYPE_p_XSerializeEngine,  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_storeGrammar" "', argument " "1"" of type '" "XSerializeEngine &""'"); 
    }
    if (!argp1) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Grammar_storeGrammar" "', argument " "1"" of type '" "XSerializeEngine &""'"); 
    }
    arg1 = reinterpret_cast< XSerializeEngine * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "Grammar_storeGrammar" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::Grammar *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp2);
    {
      try 
      {
        XERCES_CPP_NAMESPACE::Grammar::storeGrammar(*arg1,arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_Grammar_loadGrammar) {
  {
    XSerializeEngine *arg1 = 0 ;
    XERCES_CPP_NAMESPACE::Grammar *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: Grammar_loadGrammar(serEng);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1, SWIGTYPE_p_XSerializeEngine,  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "Grammar_loadGrammar" "', argument " "1"" of type '" "XSerializeEngine &""'"); 
    }
    if (!argp1) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "Grammar_loadGrammar" "', argument " "1"" of type '" "XSerializeEngine &""'"); 
    }
    arg1 = reinterpret_cast< XSerializeEngine * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::Grammar *)XERCES_CPP_NAMESPACE::Grammar::loadGrammar(*arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, SWIG_as_voidptrptr(&result)), 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_XMLGrammarDescription) {
  {
    XERCES_CPP_NAMESPACE::XMLGrammarDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_XMLGrammarDescription(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_XMLGrammarDescription" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLGrammarDescription *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLGrammarDescription * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLGrammarDescription_getGrammarType) {
  {
    XERCES_CPP_NAMESPACE::XMLGrammarDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *) 0 ;
    XERCES_CPP_NAMESPACE::Grammar::GrammarType result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLGrammarDescription_getGrammarType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLGrammarDescription_getGrammarType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLGrammarDescription const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLGrammarDescription * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::Grammar::GrammarType)((XERCES_CPP_NAMESPACE::XMLGrammarDescription const *)arg1)->getGrammarType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLGrammarDescription_getGrammarKey) {
  {
    XERCES_CPP_NAMESPACE::XMLGrammarDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLGrammarDescription_getGrammarKey(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLGrammarDescription_getGrammarKey" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLGrammarDescription const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLGrammarDescription * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLGrammarDescription const *)arg1)->getGrammarKey();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLGrammarDescription_getMemoryManager) {
  {
    XERCES_CPP_NAMESPACE::XMLGrammarDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *) 0 ;
    XERCES_CPP_NAMESPACE::MemoryManager *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLGrammarDescription_getMemoryManager(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLGrammarDescription_getMemoryManager" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLGrammarDescription const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLGrammarDescription * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::XMLGrammarDescription const *)arg1)->getMemoryManager();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_XMLDTDDescription) {
  {
    XERCES_CPP_NAMESPACE::XMLDTDDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLDTDDescription *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_XMLDTDDescription(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDTDDescription, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_XMLDTDDescription" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLDTDDescription *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLDTDDescription * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLDTDDescription_getGrammarType) {
  {
    XERCES_CPP_NAMESPACE::XMLDTDDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLDTDDescription *) 0 ;
    XERCES_CPP_NAMESPACE::Grammar::GrammarType result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLDTDDescription_getGrammarType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDTDDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLDTDDescription_getGrammarType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLDTDDescription const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLDTDDescription * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::Grammar::GrammarType)((XERCES_CPP_NAMESPACE::XMLDTDDescription const *)arg1)->getGrammarType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLDTDDescription_getRootName) {
  {
    XERCES_CPP_NAMESPACE::XMLDTDDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLDTDDescription *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLDTDDescription_getRootName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDTDDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLDTDDescription_getRootName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLDTDDescription const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLDTDDescription * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLDTDDescription const *)arg1)->getRootName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLDTDDescription_getSystemId) {
  {
    XERCES_CPP_NAMESPACE::XMLDTDDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLDTDDescription *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLDTDDescription_getSystemId(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDTDDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLDTDDescription_getSystemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLDTDDescription const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLDTDDescription * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLDTDDescription const *)arg1)->getSystemId();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLDTDDescription_setRootName) {
  {
    XERCES_CPP_NAMESPACE::XMLDTDDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLDTDDescription *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLDTDDescription_setRootName(self,XMLCh const *const);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDTDDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLDTDDescription_setRootName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLDTDDescription *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLDTDDescription * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLDTDDescription_setRootName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setRootName((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLDTDDescription_setSystemId) {
  {
    XERCES_CPP_NAMESPACE::XMLDTDDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLDTDDescription *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLDTDDescription_setSystemId(self,XMLCh const *const);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLDTDDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLDTDDescription_setSystemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLDTDDescription *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLDTDDescription * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLDTDDescription_setSystemId");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setSystemId((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_XMLSchemaDescription) {
  {
    XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_XMLSchemaDescription(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_XMLSchemaDescription" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLSchemaDescription *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLSchemaDescription * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLSchemaDescription_getGrammarType) {
  {
    XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
    XERCES_CPP_NAMESPACE::Grammar::GrammarType result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLSchemaDescription_getGrammarType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLSchemaDescription_getGrammarType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLSchemaDescription const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLSchemaDescription * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::Grammar::GrammarType)((XERCES_CPP_NAMESPACE::XMLSchemaDescription const *)arg1)->getGrammarType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLSchemaDescription_getContextType) {
  {
    XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
    XERCES_CPP_NAMESPACE::XMLSchemaDescription::ContextType result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLSchemaDescription_getContextType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLSchemaDescription_getContextType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLSchemaDescription const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLSchemaDescription * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLSchemaDescription::ContextType)((XERCES_CPP_NAMESPACE::XMLSchemaDescription const *)arg1)->getContextType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLSchemaDescription_getTargetNamespace) {
  {
    XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLSchemaDescription_getTargetNamespace(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLSchemaDescription_getTargetNamespace" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLSchemaDescription const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLSchemaDescription * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::XMLSchemaDescription const *)arg1)->getTargetNamespace();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLSchemaDescription_getLocationHints) {
  {
    XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
    RefArrayVectorOf<XMLCh > *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLSchemaDescription_getLocationHints(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLSchemaDescription_getLocationHints" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLSchemaDescription const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLSchemaDescription * >(argp1);
    {
      try 
      {
        result = (RefArrayVectorOf<XMLCh > *)((XERCES_CPP_NAMESPACE::XMLSchemaDescription const *)arg1)->getLocationHints();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_RefArrayVectorOfTunsigned_short_t, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLSchemaDescription_getTriggeringComponent) {
  {
    XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
    XERCES_CPP_NAMESPACE::QName *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLSchemaDescription_getTriggeringComponent(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLSchemaDescription_getTriggeringComponent" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLSchemaDescription const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLSchemaDescription * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::QName *)((XERCES_CPP_NAMESPACE::XMLSchemaDescription const *)arg1)->getTriggeringComponent();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLSchemaDescription_getEnclosingElementName) {
  {
    XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
    XERCES_CPP_NAMESPACE::QName *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLSchemaDescription_getEnclosingElementName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLSchemaDescription_getEnclosingElementName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLSchemaDescription const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLSchemaDescription * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::QName *)((XERCES_CPP_NAMESPACE::XMLSchemaDescription const *)arg1)->getEnclosingElementName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLSchemaDescription_getAttributes) {
  {
    XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: XMLSchemaDescription_getAttributes(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLSchemaDescription_getAttributes" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLSchemaDescription const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLSchemaDescription * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLAttDef *)((XERCES_CPP_NAMESPACE::XMLSchemaDescription const *)arg1)->getAttributes();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLSchemaDescription_setContextType) {
  {
    XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
    XERCES_CPP_NAMESPACE::XMLSchemaDescription::ContextType arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLSchemaDescription_setContextType(self,XERCES_CPP_NAMESPACE::XMLSchemaDescription::ContextType);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLSchemaDescription_setContextType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLSchemaDescription *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLSchemaDescription * >(argp1);
    ecode2 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "XMLSchemaDescription_setContextType" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLSchemaDescription::ContextType""'");
    } 
    arg2 = static_cast< XERCES_CPP_NAMESPACE::XMLSchemaDescription::ContextType >(val2);
    {
      try 
      {
        (arg1)->setContextType(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLSchemaDescription_setTargetNamespace) {
  {
    XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLSchemaDescription_setTargetNamespace(self,XMLCh const *const);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLSchemaDescription_setTargetNamespace" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLSchemaDescription *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLSchemaDescription * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLSchemaDescription_setTargetNamespace");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setTargetNamespace((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLSchemaDescription_setLocationHints) {
  {
    XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLSchemaDescription_setLocationHints(self,XMLCh const *const);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLSchemaDescription_setLocationHints" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLSchemaDescription *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLSchemaDescription * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"XMLSchemaDescription_setLocationHints");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setLocationHints((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLSchemaDescription_setTriggeringComponent) {
  {
    XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
    XERCES_CPP_NAMESPACE::QName *arg2 = (XERCES_CPP_NAMESPACE::QName *) (XERCES_CPP_NAMESPACE::QName *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLSchemaDescription_setTriggeringComponent(self,XERCES_CPP_NAMESPACE::QName *const);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLSchemaDescription_setTriggeringComponent" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLSchemaDescription *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLSchemaDescription * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "XMLSchemaDescription_setTriggeringComponent" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::QName *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp2);
    {
      try 
      {
        (arg1)->setTriggeringComponent(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLSchemaDescription_setEnclosingElementName) {
  {
    XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
    XERCES_CPP_NAMESPACE::QName *arg2 = (XERCES_CPP_NAMESPACE::QName *) (XERCES_CPP_NAMESPACE::QName *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLSchemaDescription_setEnclosingElementName(self,XERCES_CPP_NAMESPACE::QName *const);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLSchemaDescription_setEnclosingElementName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLSchemaDescription *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLSchemaDescription * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "XMLSchemaDescription_setEnclosingElementName" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::QName *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::QName * >(argp2);
    {
      try 
      {
        (arg1)->setEnclosingElementName(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_XMLSchemaDescription_setAttributes) {
  {
    XERCES_CPP_NAMESPACE::XMLSchemaDescription *arg1 = (XERCES_CPP_NAMESPACE::XMLSchemaDescription *) 0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef *arg2 = (XERCES_CPP_NAMESPACE::XMLAttDef *) (XERCES_CPP_NAMESPACE::XMLAttDef *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: XMLSchemaDescription_setAttributes(self,XERCES_CPP_NAMESPACE::XMLAttDef *const);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLSchemaDescription, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "XMLSchemaDescription_setAttributes" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLSchemaDescription *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLSchemaDescription * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "XMLSchemaDescription_setAttributes" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLAttDef *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLAttDef * >(argp2);
    {
      try 
      {
        (arg1)->setAttributes(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_DTDElementDecl) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_DTDElementDecl(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_DTDElementDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_findAttr) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg3 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl::LookupOpts arg6 ;
    bool *arg7 = 0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val3 ;
    int ecode3 = 0 ;
    int val6 ;
    int ecode6 = 0 ;
    void *argp7 = 0 ;
    int res7 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 7) || (items > 7)) {
      SWIG_croak("Usage: DTDElementDecl_findAttr(self,qName,uriId,baseName,prefix,options,wasAdded);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_findAttr" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DTDElementDecl_findAttr");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    ecode3 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(2), &val3);
    if (!SWIG_IsOK(ecode3)) {
      SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "DTDElementDecl_findAttr" "', argument " "3"" of type '" "unsigned int""'");
    } 
    arg3 = static_cast< unsigned int >(val3);
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"DTDElementDecl_findAttr");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    
    if (ST(4) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",5,"DTDElementDecl_findAttr");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg5 = Perl2XMLString(ST(4));
    }
    
    ecode6 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(5), &val6);
    if (!SWIG_IsOK(ecode6)) {
      SWIG_exception_fail(SWIG_ArgError(ecode6), "in method '" "DTDElementDecl_findAttr" "', argument " "6"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl::LookupOpts""'");
    } 
    arg6 = static_cast< XERCES_CPP_NAMESPACE::XMLElementDecl::LookupOpts >(val6);
    res7 = SWIG_ConvertPtr(ST(6), &argp7, SWIGTYPE_p_bool,  0 );
    if (!SWIG_IsOK(res7)) {
      SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "DTDElementDecl_findAttr" "', argument " "7"" of type '" "bool &""'"); 
    }
    if (!argp7) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "DTDElementDecl_findAttr" "', argument " "7"" of type '" "bool &""'"); 
    }
    arg7 = reinterpret_cast< bool * >(argp7);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLAttDef *)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->findAttr((XMLCh const *)arg2,arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,*arg7);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    
    delete[] arg2;
    
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_getAttDefList) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::XMLAttDefList *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDElementDecl_getAttDefList(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_getAttDefList" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    {
      try 
      {
        {
          XERCES_CPP_NAMESPACE::XMLAttDefList &_result_ref = ((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->getAttDefList();
          result = (XERCES_CPP_NAMESPACE::XMLAttDefList *) &_result_ref;
        }
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_getCharDataOpts) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl::CharDataOpts result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDElementDecl_getCharDataOpts(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_getCharDataOpts" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl::CharDataOpts)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->getCharDataOpts();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_hasAttDefs) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDElementDecl_hasAttDefs(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_hasAttDefs" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->hasAttDefs();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_resetDefs) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDElementDecl_resetDefs(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_resetDefs" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    {
      try 
      {
        result = (bool)(arg1)->resetDefs();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_getContentSpec) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::ContentSpecNode *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDElementDecl_getContentSpec(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_getContentSpec" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::ContentSpecNode *)(arg1)->getContentSpec();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__ContentSpecNode, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_setContentSpec) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::ContentSpecNode *arg2 = (XERCES_CPP_NAMESPACE::ContentSpecNode *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDElementDecl_setContentSpec(self,toAdopt);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_setContentSpec" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__ContentSpecNode, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DTDElementDecl_setContentSpec" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::ContentSpecNode *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::ContentSpecNode * >(argp2);
    {
      try 
      {
        (arg1)->setContentSpec(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_getContentModel) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::XMLContentModel *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDElementDecl_getContentModel(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_getContentModel" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLContentModel *)(arg1)->getContentModel();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLContentModel, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_setContentModel) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::XMLContentModel *arg2 = (XERCES_CPP_NAMESPACE::XMLContentModel *) (XERCES_CPP_NAMESPACE::XMLContentModel *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDElementDecl_setContentModel(self,newModelToAdopt);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_setContentModel" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLContentModel, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DTDElementDecl_setContentModel" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLContentModel *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLContentModel * >(argp2);
    {
      try 
      {
        (arg1)->setContentModel(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_getFormattedContentModel) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDElementDecl_getFormattedContentModel(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_getFormattedContentModel" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->getFormattedContentModel();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_getKey) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDElementDecl_getKey(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_getKey" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->getKey();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_getAttDef) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    DTDAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDElementDecl_getAttDef(self,attName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_getAttDef" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DTDElementDecl_getAttDef");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (DTDAttDef *)(arg1)->getAttDef((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_getModelType) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::DTDElementDecl::ModelTypes result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDElementDecl_getModelType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_getModelType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DTDElementDecl::ModelTypes)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->getModelType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_getDOMTypeInfoName) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDElementDecl_getDOMTypeInfoName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_getDOMTypeInfoName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->getDOMTypeInfoName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_getDOMTypeInfoUri) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDElementDecl_getDOMTypeInfoUri(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_getDOMTypeInfoUri" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->getDOMTypeInfoUri();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_addAttDef) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    DTDAttDef *arg2 = (DTDAttDef *) (DTDAttDef *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDElementDecl_addAttDef(self,toAdd);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_addAttDef" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DTDElementDecl_addAttDef" "', argument " "2"" of type '" "DTDAttDef *const""'"); 
    }
    arg2 = reinterpret_cast< DTDAttDef * >(argp2);
    {
      try 
      {
        (arg1)->addAttDef(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_setModelType) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::DTDElementDecl::ModelTypes arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDElementDecl_setModelType(self,toSet);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_setModelType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    ecode2 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "DTDElementDecl_setModelType" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl::ModelTypes""'");
    } 
    arg2 = static_cast< XERCES_CPP_NAMESPACE::DTDElementDecl::ModelTypes >(val2);
    {
      try 
      {
        (arg1)->setModelType(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDecl_getObjectType) {
  {
    XERCES_CPP_NAMESPACE::DTDElementDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl::objectType result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDElementDecl_getObjectType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDecl_getObjectType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl::objectType)((XERCES_CPP_NAMESPACE::DTDElementDecl const *)arg1)->getObjectType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_DTDElementDeclEnumerator__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDElementDecl > *) (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDElementDecl > *)0 ;
    XERCES_CPP_NAMESPACE::MemoryManager *arg2 = (XERCES_CPP_NAMESPACE::MemoryManager *) (XERCES_CPP_NAMESPACE::MemoryManager *)0 ;
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    arg2 = XERCES_CPP_NAMESPACE::XMLPlatformUtils::fgMemoryManager;
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: new_DTDElementDeclEnumerator(toEnum);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDElementDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_DTDElementDeclEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDElementDecl > *const""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDElementDecl > * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *)new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl >(arg1,arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_DTDElementDeclEnumerator__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDElementDecl > *) (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDElementDecl > *)0 ;
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: new_DTDElementDeclEnumerator(toEnum);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDElementDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_DTDElementDeclEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDElementDecl > *const""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDElementDecl > * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *)new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl >(arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_DTDElementDeclEnumerator__SWIG_2) {
  {
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *arg1 = 0 ;
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *result = 0 ;
    void *argp1 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: new_DTDElementDeclEnumerator(toCopy);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t,  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_DTDElementDeclEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > const &""'"); 
    }
    if (!argp1) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "new_DTDElementDeclEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > const &""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *)new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl >((XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > const &)*arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_DTDElementDeclEnumerator) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDElementDecl_t, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDElementDecl_t, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 3;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_3:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_DTDElementDeclEnumerator__SWIG_0); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_DTDElementDeclEnumerator__SWIG_1); return;
    case 3:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_DTDElementDeclEnumerator__SWIG_2); return;
    }
  }
  
  croak("No matching function for overloaded 'new_DTDElementDeclEnumerator'");
  XSRETURN(0);
}


XS(_wrap_delete_DTDElementDeclEnumerator) {
  {
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_DTDElementDeclEnumerator(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_DTDElementDeclEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDeclEnumerator_hasMoreElements) {
  {
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDElementDeclEnumerator_hasMoreElements(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDeclEnumerator_hasMoreElements" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > const *)arg1)->hasMoreElements();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDeclEnumerator_nextElement) {
  {
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *) 0 ;
    XERCES_CPP_NAMESPACE::DTDElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDElementDeclEnumerator_nextElement(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDeclEnumerator_nextElement" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > * >(argp1);
    {
      try 
      {
        {
          XERCES_CPP_NAMESPACE::DTDElementDecl &_result_ref = (arg1)->nextElement();
          result = (XERCES_CPP_NAMESPACE::DTDElementDecl *) &_result_ref;
        }
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDeclEnumerator_Reset) {
  {
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDElementDeclEnumerator_Reset(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDeclEnumerator_Reset" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > * >(argp1);
    {
      try 
      {
        (arg1)->Reset();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDElementDeclEnumerator_size) {
  {
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > *) 0 ;
    int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDElementDeclEnumerator_size(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDElementDeclEnumerator_size" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > * >(argp1);
    {
      try 
      {
        result = (int)((XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > const *)arg1)->size();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_DTDEntityDecl) {
  {
    XERCES_CPP_NAMESPACE::DTDEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_DTDEntityDecl(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_DTDEntityDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDEntityDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDEntityDecl * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDEntityDecl_getDeclaredInIntSubset) {
  {
    XERCES_CPP_NAMESPACE::DTDEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDEntityDecl_getDeclaredInIntSubset(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDEntityDecl_getDeclaredInIntSubset" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDEntityDecl * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::DTDEntityDecl const *)arg1)->getDeclaredInIntSubset();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDEntityDecl_getIsParameter) {
  {
    XERCES_CPP_NAMESPACE::DTDEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDEntityDecl_getIsParameter(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDEntityDecl_getIsParameter" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDEntityDecl * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::DTDEntityDecl const *)arg1)->getIsParameter();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDEntityDecl_getIsSpecialChar) {
  {
    XERCES_CPP_NAMESPACE::DTDEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDEntityDecl_getIsSpecialChar(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDEntityDecl_getIsSpecialChar" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDEntityDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDEntityDecl * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::DTDEntityDecl const *)arg1)->getIsSpecialChar();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDEntityDecl_setDeclaredInIntSubset) {
  {
    XERCES_CPP_NAMESPACE::DTDEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) 0 ;
    bool arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    bool val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDEntityDecl_setDeclaredInIntSubset(self,newValue);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDEntityDecl_setDeclaredInIntSubset" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDEntityDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDEntityDecl * >(argp1);
    ecode2 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "DTDEntityDecl_setDeclaredInIntSubset" "', argument " "2"" of type '" "bool""'");
    } 
    arg2 = static_cast< bool >(val2);
    {
      try 
      {
        (arg1)->setDeclaredInIntSubset(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDEntityDecl_setIsParameter) {
  {
    XERCES_CPP_NAMESPACE::DTDEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) 0 ;
    bool arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    bool val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDEntityDecl_setIsParameter(self,newValue);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDEntityDecl_setIsParameter" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDEntityDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDEntityDecl * >(argp1);
    ecode2 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "DTDEntityDecl_setIsParameter" "', argument " "2"" of type '" "bool""'");
    } 
    arg2 = static_cast< bool >(val2);
    {
      try 
      {
        (arg1)->setIsParameter(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDEntityDecl_setIsSpecialChar) {
  {
    XERCES_CPP_NAMESPACE::DTDEntityDecl *arg1 = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) 0 ;
    bool arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    bool val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDEntityDecl_setIsSpecialChar(self,newValue);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDEntityDecl_setIsSpecialChar" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDEntityDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDEntityDecl * >(argp1);
    ecode2 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "DTDEntityDecl_setIsSpecialChar" "', argument " "2"" of type '" "bool""'");
    } 
    arg2 = static_cast< bool >(val2);
    {
      try 
      {
        (arg1)->setIsSpecialChar(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_DTDEntityDeclEnumerator__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *) (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *)0 ;
    XERCES_CPP_NAMESPACE::MemoryManager *arg2 = (XERCES_CPP_NAMESPACE::MemoryManager *) (XERCES_CPP_NAMESPACE::MemoryManager *)0 ;
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    arg2 = XERCES_CPP_NAMESPACE::XMLPlatformUtils::fgMemoryManager;
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: new_DTDEntityDeclEnumerator(toEnum);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_DTDEntityDeclEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *const""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *)new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl >(arg1,arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_DTDEntityDeclEnumerator__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *) (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *)0 ;
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: new_DTDEntityDeclEnumerator(toEnum);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_DTDEntityDeclEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *const""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *)new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl >(arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_DTDEntityDeclEnumerator__SWIG_2) {
  {
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *arg1 = 0 ;
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *result = 0 ;
    void *argp1 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: new_DTDEntityDeclEnumerator(toCopy);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t,  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_DTDEntityDeclEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > const &""'"); 
    }
    if (!argp1) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "new_DTDEntityDeclEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > const &""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *)new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl >((XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > const &)*arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_DTDEntityDeclEnumerator) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 3;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_3:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_DTDEntityDeclEnumerator__SWIG_0); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_DTDEntityDeclEnumerator__SWIG_1); return;
    case 3:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_DTDEntityDeclEnumerator__SWIG_2); return;
    }
  }
  
  croak("No matching function for overloaded 'new_DTDEntityDeclEnumerator'");
  XSRETURN(0);
}


XS(_wrap_delete_DTDEntityDeclEnumerator) {
  {
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_DTDEntityDeclEnumerator(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_DTDEntityDeclEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDEntityDeclEnumerator_hasMoreElements) {
  {
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDEntityDeclEnumerator_hasMoreElements(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDEntityDeclEnumerator_hasMoreElements" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > const *)arg1)->hasMoreElements();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDEntityDeclEnumerator_nextElement) {
  {
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *) 0 ;
    XERCES_CPP_NAMESPACE::DTDEntityDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDEntityDeclEnumerator_nextElement(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDEntityDeclEnumerator_nextElement" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > * >(argp1);
    {
      try 
      {
        {
          XERCES_CPP_NAMESPACE::DTDEntityDecl &_result_ref = (arg1)->nextElement();
          result = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) &_result_ref;
        }
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDEntityDeclEnumerator_Reset) {
  {
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDEntityDeclEnumerator_Reset(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDEntityDeclEnumerator_Reset" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > * >(argp1);
    {
      try 
      {
        (arg1)->Reset();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDEntityDeclEnumerator_size) {
  {
    XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *arg1 = (XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > *) 0 ;
    int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDEntityDeclEnumerator_size(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDEntityDeclEnumerator_size" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > * >(argp1);
    {
      try 
      {
        result = (int)((XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > const *)arg1)->size();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_DTDAttDefList) {
  {
    XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_DTDAttDefList(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_DTDAttDefList" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDAttDefList * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDAttDefList_hasMoreElements) {
  {
    XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDAttDefList_hasMoreElements(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDAttDefList_hasMoreElements" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDAttDefList const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDAttDefList * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::DTDAttDefList const *)arg1)->hasMoreElements();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDAttDefList_isEmpty) {
  {
    XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDAttDefList_isEmpty(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDAttDefList_isEmpty" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDAttDefList const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDAttDefList * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::DTDAttDefList const *)arg1)->isEmpty();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDAttDefList_findAttDef__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
    unsigned long arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned long val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: DTDAttDefList_findAttDef(self,uriID,attName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDAttDefList_findAttDef" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDAttDefList * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_long SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "DTDAttDefList_findAttDef" "', argument " "2"" of type '" "unsigned long""'");
    } 
    arg2 = static_cast< unsigned long >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"DTDAttDefList_findAttDef");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLAttDef *)(arg1)->findAttDef(arg2,(XMLCh const *)arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    delete[] arg3;
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDAttDefList_findAttDef__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: DTDAttDefList_findAttDef(self,attURI,attName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDAttDefList_findAttDef" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDAttDefList * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DTDAttDefList_findAttDef");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"DTDAttDefList_findAttDef");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLAttDef *)(arg1)->findAttDef((XMLCh const *)arg2,(XMLCh const *)arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDAttDefList_findAttDef) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 3) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_long SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 3) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_DTDAttDefList_findAttDef__SWIG_0); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_DTDAttDefList_findAttDef__SWIG_1); return;
    }
  }
  
  croak("No matching function for overloaded 'DTDAttDefList_findAttDef'");
  XSRETURN(0);
}


XS(_wrap_DTDAttDefList_nextElement) {
  {
    XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDAttDefList_nextElement(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDAttDefList_nextElement" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDAttDefList * >(argp1);
    {
      try 
      {
        {
          XERCES_CPP_NAMESPACE::XMLAttDef &_result_ref = (arg1)->nextElement();
          result = (XERCES_CPP_NAMESPACE::XMLAttDef *) &_result_ref;
        }
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDAttDefList_Reset) {
  {
    XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDAttDefList_Reset(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDAttDefList_Reset" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDAttDefList * >(argp1);
    {
      try 
      {
        (arg1)->Reset();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDAttDefList_getAttDefCount) {
  {
    XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDAttDefList_getAttDefCount(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDAttDefList_getAttDefCount" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDAttDefList const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDAttDefList * >(argp1);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::DTDAttDefList const *)arg1)->getAttDefCount();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDAttDefList_getAttDef) {
  {
    XERCES_CPP_NAMESPACE::DTDAttDefList *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDefList *) 0 ;
    unsigned int arg2 ;
    XERCES_CPP_NAMESPACE::XMLAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDAttDefList_getAttDef(self,index);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDAttDefList_getAttDef" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDAttDefList * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "DTDAttDefList_getAttDef" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        {
          XERCES_CPP_NAMESPACE::XMLAttDef &_result_ref = (arg1)->getAttDef(arg2);
          result = (XERCES_CPP_NAMESPACE::XMLAttDef *) &_result_ref;
        }
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_DTDAttDef) {
  {
    XERCES_CPP_NAMESPACE::DTDAttDef *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDef *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_DTDAttDef(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_DTDAttDef" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDAttDef * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDAttDef_getFullName) {
  {
    XERCES_CPP_NAMESPACE::DTDAttDef *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDef *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDAttDef_getFullName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDAttDef_getFullName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDAttDef * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DTDAttDef const *)arg1)->getFullName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDAttDef_reset) {
  {
    XERCES_CPP_NAMESPACE::DTDAttDef *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDef *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDAttDef_reset(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDAttDef_reset" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDAttDef * >(argp1);
    {
      try 
      {
        (arg1)->reset();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDAttDef_getElemId) {
  {
    XERCES_CPP_NAMESPACE::DTDAttDef *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDef *) 0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDAttDef_getElemId(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDAttDef_getElemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDAttDef * >(argp1);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::DTDAttDef const *)arg1)->getElemId();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDAttDef_getDOMTypeInfoName) {
  {
    XERCES_CPP_NAMESPACE::DTDAttDef *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDef *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDAttDef_getDOMTypeInfoName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDAttDef_getDOMTypeInfoName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDAttDef * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DTDAttDef const *)arg1)->getDOMTypeInfoName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDAttDef_getDOMTypeInfoUri) {
  {
    XERCES_CPP_NAMESPACE::DTDAttDef *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDef *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDAttDef_getDOMTypeInfoUri(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDAttDef_getDOMTypeInfoUri" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDAttDef * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DTDAttDef const *)arg1)->getDOMTypeInfoUri();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDAttDef_setElemId) {
  {
    XERCES_CPP_NAMESPACE::DTDAttDef *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDef *) 0 ;
    unsigned int arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDAttDef_setElemId(self,newId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDAttDef_setElemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDAttDef * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "DTDAttDef_setElemId" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        (arg1)->setElemId(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDAttDef_setName) {
  {
    XERCES_CPP_NAMESPACE::DTDAttDef *arg1 = (XERCES_CPP_NAMESPACE::DTDAttDef *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDAttDef_setName(self,newName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDAttDef_setName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDAttDef * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DTDAttDef_setName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setName((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_DTDGrammar) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 0) || (items > 0)) {
      SWIG_croak("Usage: new_DTDGrammar();");
    }
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DTDGrammar *)new XERCES_CPP_NAMESPACE::DTDGrammar();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    XSRETURN(argvi);
  fail:
    SWIG_croak_null();
  }
}


XS(_wrap_delete_DTDGrammar) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_DTDGrammar(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_DTDGrammar" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_getGrammarType) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::Grammar::GrammarType result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDGrammar_getGrammarType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_getGrammarType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::Grammar::GrammarType)((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getGrammarType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_getTargetNamespace) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDGrammar_getTargetNamespace(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_getTargetNamespace" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getTargetNamespace();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_findOrAddElemDecl) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    unsigned int arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg6 ;
    bool *arg7 = 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    unsigned int val6 ;
    int ecode6 = 0 ;
    void *argp7 = 0 ;
    int res7 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 7) || (items > 7)) {
      SWIG_croak("Usage: DTDGrammar_findOrAddElemDecl(self,uriId,baseName,prefixName,qName,scope,wasAdded);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_findOrAddElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "DTDGrammar_findOrAddElemDecl" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"DTDGrammar_findOrAddElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"DTDGrammar_findOrAddElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    
    if (ST(4) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",5,"DTDGrammar_findOrAddElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg5 = Perl2XMLString(ST(4));
    }
    
    ecode6 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(5), &val6);
    if (!SWIG_IsOK(ecode6)) {
      SWIG_exception_fail(SWIG_ArgError(ecode6), "in method '" "DTDGrammar_findOrAddElemDecl" "', argument " "6"" of type '" "unsigned int""'");
    } 
    arg6 = static_cast< unsigned int >(val6);
    res7 = SWIG_ConvertPtr(ST(6), &argp7, SWIGTYPE_p_bool,  0 );
    if (!SWIG_IsOK(res7)) {
      SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "DTDGrammar_findOrAddElemDecl" "', argument " "7"" of type '" "bool &""'"); 
    }
    if (!argp7) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "DTDGrammar_findOrAddElemDecl" "', argument " "7"" of type '" "bool &""'"); 
    }
    arg7 = reinterpret_cast< bool * >(argp7);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->findOrAddElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,*arg7);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_getElemId) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    unsigned int arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg5 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    unsigned int val5 ;
    int ecode5 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 5) || (items > 5)) {
      SWIG_croak("Usage: DTDGrammar_getElemId(self,uriId,baseName,qName,scope);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_getElemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "DTDGrammar_getElemId" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"DTDGrammar_getElemId");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"DTDGrammar_getElemId");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    ecode5 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(4), &val5);
    if (!SWIG_IsOK(ecode5)) {
      SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "DTDGrammar_getElemId" "', argument " "5"" of type '" "unsigned int""'");
    } 
    arg5 = static_cast< unsigned int >(val5);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getElemId(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,arg5);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_getElemDecl__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    unsigned int arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg5 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    unsigned int val5 ;
    int ecode5 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 5) || (items > 5)) {
      SWIG_croak("Usage: DTDGrammar_getElemDecl(self,uriId,baseName,qName,scope);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_getElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "DTDGrammar_getElemDecl" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"DTDGrammar_getElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"DTDGrammar_getElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    ecode5 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(4), &val5);
    if (!SWIG_IsOK(ecode5)) {
      SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "DTDGrammar_getElemDecl" "', argument " "5"" of type '" "unsigned int""'");
    } 
    arg5 = static_cast< unsigned int >(val5);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->getElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,arg5);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_getElemDecl__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    unsigned int arg2 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDGrammar_getElemDecl(self,elemId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_getElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "DTDGrammar_getElemDecl" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->getElemDecl(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_getElemDecl) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 5) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(3)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(4), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_DTDGrammar_getElemDecl__SWIG_1); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_DTDGrammar_getElemDecl__SWIG_0); return;
    }
  }
  
  croak("No matching function for overloaded 'DTDGrammar_getElemDecl'");
  XSRETURN(0);
}


XS(_wrap_DTDGrammar_getNotationDecl) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLNotationDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDGrammar_getNotationDecl(self,notName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_getNotationDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DTDGrammar_getNotationDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLNotationDecl *)(arg1)->getNotationDecl((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_getValidated) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDGrammar_getValidated(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_getValidated" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getValidated();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_putElemDecl__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    unsigned int arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg6 ;
    bool arg7 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    unsigned int val6 ;
    int ecode6 = 0 ;
    bool val7 ;
    int ecode7 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 7) || (items > 7)) {
      SWIG_croak("Usage: DTDGrammar_putElemDecl(self,uriId,baseName,prefixName,qName,scope,notDeclared);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_putElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "DTDGrammar_putElemDecl" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"DTDGrammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"DTDGrammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    
    if (ST(4) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",5,"DTDGrammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg5 = Perl2XMLString(ST(4));
    }
    
    ecode6 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(5), &val6);
    if (!SWIG_IsOK(ecode6)) {
      SWIG_exception_fail(SWIG_ArgError(ecode6), "in method '" "DTDGrammar_putElemDecl" "', argument " "6"" of type '" "unsigned int""'");
    } 
    arg6 = static_cast< unsigned int >(val6);
    ecode7 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(6), &val7);
    if (!SWIG_IsOK(ecode7)) {
      SWIG_exception_fail(SWIG_ArgError(ecode7), "in method '" "DTDGrammar_putElemDecl" "', argument " "7"" of type '" "bool""'");
    } 
    arg7 = static_cast< bool >(val7);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->putElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,arg7);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_putElemDecl__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    unsigned int arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg6 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    unsigned int val6 ;
    int ecode6 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 6) || (items > 6)) {
      SWIG_croak("Usage: DTDGrammar_putElemDecl(self,uriId,baseName,prefixName,qName,scope);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_putElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "DTDGrammar_putElemDecl" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"DTDGrammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"DTDGrammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    
    if (ST(4) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",5,"DTDGrammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg5 = Perl2XMLString(ST(4));
    }
    
    ecode6 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(5), &val6);
    if (!SWIG_IsOK(ecode6)) {
      SWIG_exception_fail(SWIG_ArgError(ecode6), "in method '" "DTDGrammar_putElemDecl" "', argument " "6"" of type '" "unsigned int""'");
    } 
    arg6 = static_cast< unsigned int >(val6);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->putElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_putElemDecl__SWIG_2) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) (XERCES_CPP_NAMESPACE::XMLElementDecl *)0 ;
    bool arg3 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    bool val3 ;
    int ecode3 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: DTDGrammar_putElemDecl(self,elemDecl,notDeclared);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_putElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DTDGrammar_putElemDecl" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp2);
    ecode3 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(2), &val3);
    if (!SWIG_IsOK(ecode3)) {
      SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "DTDGrammar_putElemDecl" "', argument " "3"" of type '" "bool""'");
    } 
    arg3 = static_cast< bool >(val3);
    {
      try 
      {
        result = (unsigned int)(arg1)->putElemDecl(arg2,arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_putElemDecl__SWIG_3) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) (XERCES_CPP_NAMESPACE::XMLElementDecl *)0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDGrammar_putElemDecl(self,elemDecl);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_putElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DTDGrammar_putElemDecl" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp2);
    {
      try 
      {
        result = (unsigned int)(arg1)->putElemDecl(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_putElemDecl) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(1), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 3) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(1), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(2), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
    if (items == 6) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(3)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(4)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(5), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 3;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_3:
    
    if (items == 7) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(3)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(4)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(5), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(6), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 4;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_4:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_DTDGrammar_putElemDecl__SWIG_3); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_DTDGrammar_putElemDecl__SWIG_2); return;
    case 3:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_DTDGrammar_putElemDecl__SWIG_1); return;
    case 4:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_DTDGrammar_putElemDecl__SWIG_0); return;
    }
  }
  
  croak("No matching function for overloaded 'DTDGrammar_putElemDecl'");
  XSRETURN(0);
}


XS(_wrap_DTDGrammar_putNotationDecl) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) (XERCES_CPP_NAMESPACE::XMLNotationDecl *)0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDGrammar_putNotationDecl(self,notationDecl);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_putNotationDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DTDGrammar_putNotationDecl" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp2);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->putNotationDecl(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_setValidated) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    bool arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    bool val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDGrammar_setValidated(self,newState);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_setValidated" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    ecode2 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "DTDGrammar_setValidated" "', argument " "2"" of type '" "bool""'");
    } 
    arg2 = static_cast< bool >(val2);
    {
      try 
      {
        (arg1)->setValidated(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_reset) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDGrammar_reset(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_reset" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    {
      try 
      {
        (arg1)->reset();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_getRootElemId) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDGrammar_getRootElemId(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_getRootElemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getRootElemId();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_getEntityDecl) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::DTDEntityDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDGrammar_getEntityDecl(self,entName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_getEntityDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DTDGrammar_getEntityDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DTDEntityDecl *)(arg1)->getEntityDecl((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_getEntityDeclPool) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDGrammar_getEntityDeclPool(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_getEntityDeclPool" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::NameIdPool<XERCES_CPP_NAMESPACE::DTDEntityDecl > *)(arg1)->getEntityDeclPool();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_getElemEnumerator) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    SwigValueWrapper<XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl > > result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDGrammar_getElemEnumerator(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_getElemEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    {
      try 
      {
        result = ((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getElemEnumerator();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj((new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl >(static_cast< const XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDElementDecl >& >(result))), SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDElementDecl_t, SWIG_POINTER_OWN | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_getEntityEnumerator) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    SwigValueWrapper<XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl > > result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDGrammar_getEntityEnumerator(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_getEntityEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    {
      try 
      {
        result = ((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getEntityEnumerator();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj((new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl >(static_cast< const XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::DTDEntityDecl >& >(result))), SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__DTDEntityDecl_t, SWIG_POINTER_OWN | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_getNotationEnumerator) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    SwigValueWrapper<XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::XMLNotationDecl > > result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDGrammar_getNotationEnumerator(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_getNotationEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    {
      try 
      {
        result = ((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getNotationEnumerator();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj((new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::XMLNotationDecl >(static_cast< const XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::XMLNotationDecl >& >(result))), SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__XMLNotationDecl_t, SWIG_POINTER_OWN | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_setRootElemId) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    unsigned int arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDGrammar_setRootElemId(self,rootElemId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_setRootElemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "DTDGrammar_setRootElemId" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        (arg1)->setRootElemId(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_setGrammarDescription) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::XMLGrammarDescription *arg2 = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDGrammar_setGrammarDescription(self,XERCES_CPP_NAMESPACE::XMLGrammarDescription *);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_setGrammarDescription" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DTDGrammar_setGrammarDescription" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLGrammarDescription *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLGrammarDescription * >(argp2);
    {
      try 
      {
        (arg1)->setGrammarDescription(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_getGrammarDescription) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::XMLGrammarDescription *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDGrammar_getGrammarDescription(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_getGrammarDescription" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *)((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->getGrammarDescription();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_putEntityDecl) {
  {
    XERCES_CPP_NAMESPACE::DTDGrammar *arg1 = (XERCES_CPP_NAMESPACE::DTDGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::DTDEntityDecl *arg2 = (XERCES_CPP_NAMESPACE::DTDEntityDecl *) (XERCES_CPP_NAMESPACE::DTDEntityDecl *)0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDGrammar_putEntityDecl(self,entityDecl);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDGrammar_putEntityDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDGrammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDEntityDecl, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DTDGrammar_putEntityDecl" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DTDEntityDecl *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDEntityDecl * >(argp2);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::DTDGrammar const *)arg1)->putEntityDecl(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDGrammar_reinitDfltEntities) {
  {
    int argvi = 0;
    dXSARGS;
    
    if ((items < 0) || (items > 0)) {
      SWIG_croak("Usage: DTDGrammar_reinitDfltEntities();");
    }
    {
      try 
      {
        XERCES_CPP_NAMESPACE::DTDGrammar::reinitDfltEntities();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    XSRETURN(argvi);
  fail:
    SWIG_croak_null();
  }
}


XS(_wrap_new_DTDValidator__SWIG_0) {
  {
    XMLErrorReporter *arg1 = (XMLErrorReporter *) (XMLErrorReporter *)0 ;
    XERCES_CPP_NAMESPACE::DTDValidator *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: new_DTDValidator(errReporter);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XMLErrorReporter, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_DTDValidator" "', argument " "1"" of type '" "XMLErrorReporter *const""'"); 
    }
    arg1 = reinterpret_cast< XMLErrorReporter * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DTDValidator *)new XERCES_CPP_NAMESPACE::DTDValidator(arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDValidator, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_DTDValidator__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::DTDValidator *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 0) || (items > 0)) {
      SWIG_croak("Usage: new_DTDValidator();");
    }
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DTDValidator *)new XERCES_CPP_NAMESPACE::DTDValidator();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDValidator, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    XSRETURN(argvi);
  fail:
    SWIG_croak_null();
  }
}


XS(_wrap_new_DTDValidator) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 0) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XMLErrorReporter, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_DTDValidator__SWIG_1); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_DTDValidator__SWIG_0); return;
    }
  }
  
  croak("No matching function for overloaded 'new_DTDValidator'");
  XSRETURN(0);
}


XS(_wrap_delete_DTDValidator) {
  {
    XERCES_CPP_NAMESPACE::DTDValidator *arg1 = (XERCES_CPP_NAMESPACE::DTDValidator *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_DTDValidator(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDValidator, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_DTDValidator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDValidator *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDValidator * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDValidator_getGrammar) {
  {
    XERCES_CPP_NAMESPACE::DTDValidator *arg1 = (XERCES_CPP_NAMESPACE::DTDValidator *) 0 ;
    XERCES_CPP_NAMESPACE::Grammar *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DTDValidator_getGrammar(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDValidator_getGrammar" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDValidator const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDValidator * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::Grammar *)((XERCES_CPP_NAMESPACE::DTDValidator const *)arg1)->getGrammar();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, SWIG_as_voidptrptr(&result)), 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DTDValidator_setGrammar) {
  {
    XERCES_CPP_NAMESPACE::DTDValidator *arg1 = (XERCES_CPP_NAMESPACE::DTDValidator *) 0 ;
    XERCES_CPP_NAMESPACE::Grammar *arg2 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DTDValidator_setGrammar(self,aGrammar);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DTDValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DTDValidator_setGrammar" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DTDValidator *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DTDValidator * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DTDValidator_setGrammar" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::Grammar *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp2);
    {
      try 
      {
        (arg1)->setGrammar(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_SchemaElementDecl) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_SchemaElementDecl(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_SchemaElementDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_findAttr) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg3 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl::LookupOpts arg6 ;
    bool *arg7 = 0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val3 ;
    int ecode3 = 0 ;
    int val6 ;
    int ecode6 = 0 ;
    void *argp7 = 0 ;
    int res7 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 7) || (items > 7)) {
      SWIG_croak("Usage: SchemaElementDecl_findAttr(self,qName,uriId,baseName,prefix,options,wasAdded);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_findAttr" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"SchemaElementDecl_findAttr");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    ecode3 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(2), &val3);
    if (!SWIG_IsOK(ecode3)) {
      SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "SchemaElementDecl_findAttr" "', argument " "3"" of type '" "unsigned int""'");
    } 
    arg3 = static_cast< unsigned int >(val3);
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"SchemaElementDecl_findAttr");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    
    if (ST(4) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",5,"SchemaElementDecl_findAttr");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg5 = Perl2XMLString(ST(4));
    }
    
    ecode6 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(5), &val6);
    if (!SWIG_IsOK(ecode6)) {
      SWIG_exception_fail(SWIG_ArgError(ecode6), "in method '" "SchemaElementDecl_findAttr" "', argument " "6"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl::LookupOpts""'");
    } 
    arg6 = static_cast< XERCES_CPP_NAMESPACE::XMLElementDecl::LookupOpts >(val6);
    res7 = SWIG_ConvertPtr(ST(6), &argp7, SWIGTYPE_p_bool,  0 );
    if (!SWIG_IsOK(res7)) {
      SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "SchemaElementDecl_findAttr" "', argument " "7"" of type '" "bool &""'"); 
    }
    if (!argp7) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SchemaElementDecl_findAttr" "', argument " "7"" of type '" "bool &""'"); 
    }
    arg7 = reinterpret_cast< bool * >(argp7);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLAttDef *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->findAttr((XMLCh const *)arg2,arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,*arg7);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    
    delete[] arg2;
    
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getAttDefList) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::XMLAttDefList *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getAttDefList(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getAttDefList" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        {
          XERCES_CPP_NAMESPACE::XMLAttDefList &_result_ref = ((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getAttDefList();
          result = (XERCES_CPP_NAMESPACE::XMLAttDefList *) &_result_ref;
        }
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDefList, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getCharDataOpts) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl::CharDataOpts result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getCharDataOpts(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getCharDataOpts" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl::CharDataOpts)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getCharDataOpts();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_hasAttDefs) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_hasAttDefs(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_hasAttDefs" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->hasAttDefs();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_resetDefs) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_resetDefs(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_resetDefs" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (bool)(arg1)->resetDefs();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getContentSpec) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::ContentSpecNode *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getContentSpec(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getContentSpec" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::ContentSpecNode *)(arg1)->getContentSpec();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__ContentSpecNode, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setContentSpec) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::ContentSpecNode *arg2 = (XERCES_CPP_NAMESPACE::ContentSpecNode *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setContentSpec(self,toAdopt);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setContentSpec" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__ContentSpecNode, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaElementDecl_setContentSpec" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::ContentSpecNode *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::ContentSpecNode * >(argp2);
    {
      try 
      {
        (arg1)->setContentSpec(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getContentModel) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::XMLContentModel *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getContentModel(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getContentModel" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLContentModel *)(arg1)->getContentModel();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLContentModel, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setContentModel) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::XMLContentModel *arg2 = (XERCES_CPP_NAMESPACE::XMLContentModel *) (XERCES_CPP_NAMESPACE::XMLContentModel *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setContentModel(self,newModelToAdopt);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setContentModel" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLContentModel, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaElementDecl_setContentModel" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLContentModel *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLContentModel * >(argp2);
    {
      try 
      {
        (arg1)->setContentModel(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getFormattedContentModel) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getFormattedContentModel(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getFormattedContentModel" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getFormattedContentModel();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getAttDef) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    int arg3 ;
    SchemaAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int val3 ;
    int ecode3 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: SchemaElementDecl_getAttDef(self,baseName,uriId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getAttDef" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"SchemaElementDecl_getAttDef");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    ecode3 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(2), &val3);
    if (!SWIG_IsOK(ecode3)) {
      SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "SchemaElementDecl_getAttDef" "', argument " "3"" of type '" "int""'");
    } 
    arg3 = static_cast< int >(val3);
    {
      try 
      {
        result = (SchemaAttDef *)(arg1)->getAttDef((XMLCh const *)arg2,arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    
    delete[] arg2;
    
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getAttWildCard) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    SchemaAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getAttWildCard(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getAttWildCard" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (SchemaAttDef *)(arg1)->getAttWildCard();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getModelType) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::SchemaElementDecl::ModelTypes result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getModelType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getModelType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::SchemaElementDecl::ModelTypes)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getModelType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getPSVIScope) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    PSVIDefs::PSVIScope result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getPSVIScope(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getPSVIScope" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = ((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getPSVIScope();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj((new PSVIDefs::PSVIScope(static_cast< const PSVIDefs::PSVIScope& >(result))), SWIGTYPE_p_PSVIDefs__PSVIScope, SWIG_POINTER_OWN | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getDatatypeValidator) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    DatatypeValidator *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getDatatypeValidator(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getDatatypeValidator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (DatatypeValidator *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getDatatypeValidator();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getEnclosingScope) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getEnclosingScope(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getEnclosingScope" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (int)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getEnclosingScope();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getFinalSet) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getFinalSet(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getFinalSet" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (int)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getFinalSet();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getBlockSet) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getBlockSet(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getBlockSet" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (int)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getBlockSet();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getMiscFlags) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getMiscFlags(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getMiscFlags" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (int)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getMiscFlags();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getDefaultValue) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getDefaultValue(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getDefaultValue" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getDefaultValue();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getComplexTypeInfo) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    ComplexTypeInfo *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getComplexTypeInfo(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getComplexTypeInfo" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (ComplexTypeInfo *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getComplexTypeInfo();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__ComplexTypeInfo, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_isGlobalDecl) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_isGlobalDecl(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_isGlobalDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->isGlobalDecl();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getSubstitutionGroupElem) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::SchemaElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getSubstitutionGroupElem(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getSubstitutionGroupElem" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::SchemaElementDecl *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getSubstitutionGroupElem();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getValidity) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    PSVIDefs::Validity result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getValidity(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getValidity" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = ((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getValidity();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj((new PSVIDefs::Validity(static_cast< const PSVIDefs::Validity& >(result))), SWIGTYPE_p_PSVIDefs__Validity, SWIG_POINTER_OWN | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getValidationAttempted) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    PSVIDefs::Validation result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getValidationAttempted(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getValidationAttempted" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = ((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getValidationAttempted();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj((new PSVIDefs::Validation(static_cast< const PSVIDefs::Validation& >(result))), SWIGTYPE_p_PSVIDefs__Validation, SWIG_POINTER_OWN | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getTypeType) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    PSVIDefs::Complexity result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getTypeType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getTypeType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = ((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getTypeType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj((new PSVIDefs::Complexity(static_cast< const PSVIDefs::Complexity& >(result))), SWIGTYPE_p_PSVIDefs__Complexity, SWIG_POINTER_OWN | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getTypeUri) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getTypeUri(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getTypeUri" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getTypeUri();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getTypeName) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getTypeName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getTypeName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getTypeName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getTypeAnonymous) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getTypeAnonymous(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getTypeAnonymous" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getTypeAnonymous();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_isTypeDefinitionUnion) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_isTypeDefinitionUnion(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_isTypeDefinitionUnion" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->isTypeDefinitionUnion();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getMemberTypeUri) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getMemberTypeUri(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getMemberTypeUri" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getMemberTypeUri();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getMemberTypeAnonymous) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getMemberTypeAnonymous(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getMemberTypeAnonymous" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getMemberTypeAnonymous();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getMemberTypeName) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getMemberTypeName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getMemberTypeName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getMemberTypeName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getDOMTypeInfoUri) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getDOMTypeInfoUri(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getDOMTypeInfoUri" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getDOMTypeInfoUri();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getDOMTypeInfoName) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getDOMTypeInfoName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getDOMTypeInfoName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getDOMTypeInfoName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setElemId) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    unsigned int arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setElemId(self,elemId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setElemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaElementDecl_setElemId" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        (arg1)->setElemId(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setModelType) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::SchemaElementDecl::ModelTypes arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setModelType(self,toSet);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setModelType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    ecode2 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaElementDecl_setModelType" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl::ModelTypes""'");
    } 
    arg2 = static_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl::ModelTypes >(val2);
    {
      try 
      {
        (arg1)->setModelType(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setPSVIScope) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    PSVIDefs::PSVIScope arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setPSVIScope(self,toSet);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setPSVIScope" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      res2 = SWIG_ConvertPtr(ST(1), &argp2, SWIGTYPE_p_PSVIDefs__PSVIScope,  0 );
      if (!SWIG_IsOK(res2)) {
        SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaElementDecl_setPSVIScope" "', argument " "2"" of type '" "PSVIDefs::PSVIScope const""'"); 
      }  
      if (!argp2) {
        SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SchemaElementDecl_setPSVIScope" "', argument " "2"" of type '" "PSVIDefs::PSVIScope const""'");
      } else {
        arg2 = *(reinterpret_cast< PSVIDefs::PSVIScope * >(argp2));
      }
    }
    {
      try 
      {
        (arg1)->setPSVIScope(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setDatatypeValidator) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    DatatypeValidator *arg2 = (DatatypeValidator *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setDatatypeValidator(self,newDatatypeValidator);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setDatatypeValidator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaElementDecl_setDatatypeValidator" "', argument " "2"" of type '" "DatatypeValidator *""'"); 
    }
    arg2 = reinterpret_cast< DatatypeValidator * >(argp2);
    {
      try 
      {
        (arg1)->setDatatypeValidator(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setEnclosingScope) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    int arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setEnclosingScope(self,enclosingScope);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setEnclosingScope" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    ecode2 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaElementDecl_setEnclosingScope" "', argument " "2"" of type '" "int""'");
    } 
    arg2 = static_cast< int >(val2);
    {
      try 
      {
        (arg1)->setEnclosingScope(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setFinalSet) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    int arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setFinalSet(self,finalSet);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setFinalSet" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    ecode2 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaElementDecl_setFinalSet" "', argument " "2"" of type '" "int""'");
    } 
    arg2 = static_cast< int >(val2);
    {
      try 
      {
        (arg1)->setFinalSet(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setBlockSet) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    int arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setBlockSet(self,blockSet);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setBlockSet" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    ecode2 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaElementDecl_setBlockSet" "', argument " "2"" of type '" "int""'");
    } 
    arg2 = static_cast< int >(val2);
    {
      try 
      {
        (arg1)->setBlockSet(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setMiscFlags) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    int arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setMiscFlags(self,flags);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setMiscFlags" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    ecode2 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaElementDecl_setMiscFlags" "', argument " "2"" of type '" "int""'");
    } 
    arg2 = static_cast< int >(val2);
    {
      try 
      {
        (arg1)->setMiscFlags(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setDefaultValue) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setDefaultValue(self,value);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setDefaultValue" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"SchemaElementDecl_setDefaultValue");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setDefaultValue((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setComplexTypeInfo) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    ComplexTypeInfo *arg2 = (ComplexTypeInfo *) (ComplexTypeInfo *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setComplexTypeInfo(self,typeInfo);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setComplexTypeInfo" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__ComplexTypeInfo, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaElementDecl_setComplexTypeInfo" "', argument " "2"" of type '" "ComplexTypeInfo *const""'"); 
    }
    arg2 = reinterpret_cast< ComplexTypeInfo * >(argp2);
    {
      try 
      {
        (arg1)->setComplexTypeInfo(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setXsiComplexTypeInfo) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    ComplexTypeInfo *arg2 = (ComplexTypeInfo *) (ComplexTypeInfo *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setXsiComplexTypeInfo(self,typeInfo);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setXsiComplexTypeInfo" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__ComplexTypeInfo, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaElementDecl_setXsiComplexTypeInfo" "', argument " "2"" of type '" "ComplexTypeInfo *const""'"); 
    }
    arg2 = reinterpret_cast< ComplexTypeInfo * >(argp2);
    {
      try 
      {
        (arg1)->setXsiComplexTypeInfo(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setXsiSimpleTypeInfo) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    DatatypeValidator *arg2 = (DatatypeValidator *) (DatatypeValidator *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setXsiSimpleTypeInfo(self,dtv);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setXsiSimpleTypeInfo" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaElementDecl_setXsiSimpleTypeInfo" "', argument " "2"" of type '" "DatatypeValidator const *const""'"); 
    }
    arg2 = reinterpret_cast< DatatypeValidator * >(argp2);
    {
      try 
      {
        (arg1)->setXsiSimpleTypeInfo((DatatypeValidator const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setAttWildCard) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    SchemaAttDef *arg2 = (SchemaAttDef *) (SchemaAttDef *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setAttWildCard(self,attWildCard);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setAttWildCard" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaElementDecl_setAttWildCard" "', argument " "2"" of type '" "SchemaAttDef *const""'"); 
    }
    arg2 = reinterpret_cast< SchemaAttDef * >(argp2);
    {
      try 
      {
        (arg1)->setAttWildCard(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setSubstitutionGroupElem) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg2 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) (XERCES_CPP_NAMESPACE::SchemaElementDecl *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setSubstitutionGroupElem(self,elemDecl);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setSubstitutionGroupElem" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaElementDecl_setSubstitutionGroupElem" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp2);
    {
      try 
      {
        (arg1)->setSubstitutionGroupElem(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setValidity) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    PSVIDefs::Validity arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setValidity(self,valid);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setValidity" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      res2 = SWIG_ConvertPtr(ST(1), &argp2, SWIGTYPE_p_PSVIDefs__Validity,  0 );
      if (!SWIG_IsOK(res2)) {
        SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaElementDecl_setValidity" "', argument " "2"" of type '" "PSVIDefs::Validity""'"); 
      }  
      if (!argp2) {
        SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SchemaElementDecl_setValidity" "', argument " "2"" of type '" "PSVIDefs::Validity""'");
      } else {
        arg2 = *(reinterpret_cast< PSVIDefs::Validity * >(argp2));
      }
    }
    {
      try 
      {
        (arg1)->setValidity(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_setValidationAttempted) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    PSVIDefs::Validation arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_setValidationAttempted(self,validation);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_setValidationAttempted" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      res2 = SWIG_ConvertPtr(ST(1), &argp2, SWIGTYPE_p_PSVIDefs__Validation,  0 );
      if (!SWIG_IsOK(res2)) {
        SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaElementDecl_setValidationAttempted" "', argument " "2"" of type '" "PSVIDefs::Validation""'"); 
      }  
      if (!argp2) {
        SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SchemaElementDecl_setValidationAttempted" "', argument " "2"" of type '" "PSVIDefs::Validation""'");
      } else {
        arg2 = *(reinterpret_cast< PSVIDefs::Validation * >(argp2));
      }
    }
    {
      try 
      {
        (arg1)->setValidationAttempted(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_updateValidityFromElement) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::Grammar::GrammarType arg3 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int val3 ;
    int ecode3 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: SchemaElementDecl_updateValidityFromElement(self,decl,eleGrammar);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_updateValidityFromElement" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaElementDecl_updateValidityFromElement" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl const *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp2);
    ecode3 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(2), &val3);
    if (!SWIG_IsOK(ecode3)) {
      SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "SchemaElementDecl_updateValidityFromElement" "', argument " "3"" of type '" "XERCES_CPP_NAMESPACE::Grammar::GrammarType""'");
    } 
    arg3 = static_cast< XERCES_CPP_NAMESPACE::Grammar::GrammarType >(val3);
    {
      try 
      {
        (arg1)->updateValidityFromElement((XERCES_CPP_NAMESPACE::XMLElementDecl const *)arg2,arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_updateValidityFromAttribute) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    SchemaAttDef *arg2 = (SchemaAttDef *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_updateValidityFromAttribute(self,def);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_updateValidityFromAttribute" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaElementDecl_updateValidityFromAttribute" "', argument " "2"" of type '" "SchemaAttDef const *""'"); 
    }
    arg2 = reinterpret_cast< SchemaAttDef * >(argp2);
    {
      try 
      {
        (arg1)->updateValidityFromAttribute((SchemaAttDef const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_reset) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_reset(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_reset" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        (arg1)->reset();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_addIdentityConstraint) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    IdentityConstraint *arg2 = (IdentityConstraint *) (IdentityConstraint *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_addIdentityConstraint(self,ic);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_addIdentityConstraint" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_IdentityConstraint, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaElementDecl_addIdentityConstraint" "', argument " "2"" of type '" "IdentityConstraint *const""'"); 
    }
    arg2 = reinterpret_cast< IdentityConstraint * >(argp2);
    {
      try 
      {
        (arg1)->addIdentityConstraint(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getIdentityConstraintCount) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getIdentityConstraintCount(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getIdentityConstraintCount" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getIdentityConstraintCount();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getIdentityConstraintAt) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    unsigned int arg2 ;
    IdentityConstraint *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaElementDecl_getIdentityConstraintAt(self,index);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getIdentityConstraintAt" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaElementDecl_getIdentityConstraintAt" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        result = (IdentityConstraint *)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getIdentityConstraintAt(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_IdentityConstraint, 0 | 0); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDecl_getObjectType) {
  {
    XERCES_CPP_NAMESPACE::SchemaElementDecl *arg1 = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl::objectType result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDecl_getObjectType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDecl_getObjectType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaElementDecl const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaElementDecl * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl::objectType)((XERCES_CPP_NAMESPACE::SchemaElementDecl const *)arg1)->getObjectType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_SchemaElementDeclEnumerator__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) (XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *)0 ;
    bool arg2 ;
    XERCES_CPP_NAMESPACE::MemoryManager *arg3 = (XERCES_CPP_NAMESPACE::MemoryManager *) (XERCES_CPP_NAMESPACE::MemoryManager *)0 ;
    XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    bool val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    arg3 = XERCES_CPP_NAMESPACE::XMLPlatformUtils::fgMemoryManager;
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: new_SchemaElementDeclEnumerator(toEnum,adopt);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_SchemaElementDeclEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *const""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > * >(argp1);
    ecode2 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "new_SchemaElementDeclEnumerator" "', argument " "2"" of type '" "bool""'");
    } 
    arg2 = static_cast< bool >(val2);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *)new XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl >(arg1,arg2,arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_SchemaElementDeclEnumerator__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) (XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *)0 ;
    bool arg2 ;
    XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    bool val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: new_SchemaElementDeclEnumerator(toEnum,adopt);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_SchemaElementDeclEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *const""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > * >(argp1);
    ecode2 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "new_SchemaElementDeclEnumerator" "', argument " "2"" of type '" "bool""'");
    } 
    arg2 = static_cast< bool >(val2);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *)new XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl >(arg1,arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_SchemaElementDeclEnumerator__SWIG_2) {
  {
    XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) (XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *)0 ;
    XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: new_SchemaElementDeclEnumerator(toEnum);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_SchemaElementDeclEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > *const""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::RefHash3KeysIdPool<XERCES_CPP_NAMESPACE::SchemaElementDecl > * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *)new XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl >(arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_SchemaElementDeclEnumerator) {
  {
    XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_SchemaElementDeclEnumerator(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_SchemaElementDeclEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_SchemaElementDeclEnumerator__SWIG_3) {
  {
    XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = 0 ;
    XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *result = 0 ;
    void *argp1 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: new_SchemaElementDeclEnumerator(XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > const &);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t,  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_SchemaElementDeclEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > const &""'"); 
    }
    if (!argp1) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "new_SchemaElementDeclEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > const &""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *)new XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl >((XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > const &)*arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_SchemaElementDeclEnumerator) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 3;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_3:
    
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 4;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_4:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_SchemaElementDeclEnumerator__SWIG_2); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_SchemaElementDeclEnumerator__SWIG_3); return;
    case 3:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_SchemaElementDeclEnumerator__SWIG_0); return;
    case 4:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_SchemaElementDeclEnumerator__SWIG_1); return;
    }
  }
  
  croak("No matching function for overloaded 'new_SchemaElementDeclEnumerator'");
  XSRETURN(0);
}


XS(_wrap_SchemaElementDeclEnumerator_hasMoreElements) {
  {
    XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDeclEnumerator_hasMoreElements(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDeclEnumerator_hasMoreElements" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > const *)arg1)->hasMoreElements();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDeclEnumerator_nextElement) {
  {
    XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) 0 ;
    XERCES_CPP_NAMESPACE::SchemaElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDeclEnumerator_nextElement(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDeclEnumerator_nextElement" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > * >(argp1);
    {
      try 
      {
        {
          XERCES_CPP_NAMESPACE::SchemaElementDecl &_result_ref = (arg1)->nextElement();
          result = (XERCES_CPP_NAMESPACE::SchemaElementDecl *) &_result_ref;
        }
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDeclEnumerator_Reset) {
  {
    XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDeclEnumerator_Reset(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDeclEnumerator_Reset" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > * >(argp1);
    {
      try 
      {
        (arg1)->Reset();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDeclEnumerator_size) {
  {
    XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) 0 ;
    int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDeclEnumerator_size(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDeclEnumerator_size" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > * >(argp1);
    {
      try 
      {
        result = (int)((XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > const *)arg1)->size();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDeclEnumerator_resetKey) {
  {
    XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDeclEnumerator_resetKey(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDeclEnumerator_resetKey" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > * >(argp1);
    {
      try 
      {
        (arg1)->resetKey();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDeclEnumerator_nextElementKey) {
  {
    XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) 0 ;
    void **arg2 = 0 ;
    int *arg3 = 0 ;
    int *arg4 = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    void *argp3 = 0 ;
    int res3 = 0 ;
    void *argp4 = 0 ;
    int res4 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 4) || (items > 4)) {
      SWIG_croak("Usage: SchemaElementDeclEnumerator_nextElementKey(self,void *&,int &,int &);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDeclEnumerator_nextElementKey" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2, SWIGTYPE_p_p_void,  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaElementDeclEnumerator_nextElementKey" "', argument " "2"" of type '" "void *&""'"); 
    }
    if (!argp2) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SchemaElementDeclEnumerator_nextElementKey" "', argument " "2"" of type '" "void *&""'"); 
    }
    arg2 = reinterpret_cast< void ** >(argp2);
    res3 = SWIG_ConvertPtr(ST(2), &argp3, SWIGTYPE_p_int,  0 );
    if (!SWIG_IsOK(res3)) {
      SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "SchemaElementDeclEnumerator_nextElementKey" "', argument " "3"" of type '" "int &""'"); 
    }
    if (!argp3) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SchemaElementDeclEnumerator_nextElementKey" "', argument " "3"" of type '" "int &""'"); 
    }
    arg3 = reinterpret_cast< int * >(argp3);
    res4 = SWIG_ConvertPtr(ST(3), &argp4, SWIGTYPE_p_int,  0 );
    if (!SWIG_IsOK(res4)) {
      SWIG_exception_fail(SWIG_ArgError(res4), "in method '" "SchemaElementDeclEnumerator_nextElementKey" "', argument " "4"" of type '" "int &""'"); 
    }
    if (!argp4) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SchemaElementDeclEnumerator_nextElementKey" "', argument " "4"" of type '" "int &""'"); 
    }
    arg4 = reinterpret_cast< int * >(argp4);
    {
      try 
      {
        (arg1)->nextElementKey(*arg2,*arg3,*arg4);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaElementDeclEnumerator_hasMoreKeys) {
  {
    XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *arg1 = (XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaElementDeclEnumerator_hasMoreKeys(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaElementDeclEnumerator_hasMoreKeys" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > const *)arg1)->hasMoreKeys();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_SchemaGrammar) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 0) || (items > 0)) {
      SWIG_croak("Usage: new_SchemaGrammar();");
    }
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::SchemaGrammar *)new XERCES_CPP_NAMESPACE::SchemaGrammar();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    XSRETURN(argvi);
  fail:
    SWIG_croak_null();
  }
}


XS(_wrap_delete_SchemaGrammar) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_SchemaGrammar(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_SchemaGrammar" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getGrammarType) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::Grammar::GrammarType result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_getGrammarType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getGrammarType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::Grammar::GrammarType)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getGrammarType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getTargetNamespace) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_getTargetNamespace(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getTargetNamespace" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getTargetNamespace();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_findOrAddElemDecl) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    unsigned int arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg6 ;
    bool *arg7 = 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    unsigned int val6 ;
    int ecode6 = 0 ;
    void *argp7 = 0 ;
    int res7 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 7) || (items > 7)) {
      SWIG_croak("Usage: SchemaGrammar_findOrAddElemDecl(self,uriId,baseName,prefixName,qName,scope,wasAdded);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_findOrAddElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaGrammar_findOrAddElemDecl" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"SchemaGrammar_findOrAddElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"SchemaGrammar_findOrAddElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    
    if (ST(4) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",5,"SchemaGrammar_findOrAddElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg5 = Perl2XMLString(ST(4));
    }
    
    ecode6 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(5), &val6);
    if (!SWIG_IsOK(ecode6)) {
      SWIG_exception_fail(SWIG_ArgError(ecode6), "in method '" "SchemaGrammar_findOrAddElemDecl" "', argument " "6"" of type '" "unsigned int""'");
    } 
    arg6 = static_cast< unsigned int >(val6);
    res7 = SWIG_ConvertPtr(ST(6), &argp7, SWIGTYPE_p_bool,  0 );
    if (!SWIG_IsOK(res7)) {
      SWIG_exception_fail(SWIG_ArgError(res7), "in method '" "SchemaGrammar_findOrAddElemDecl" "', argument " "7"" of type '" "bool &""'"); 
    }
    if (!argp7) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SchemaGrammar_findOrAddElemDecl" "', argument " "7"" of type '" "bool &""'"); 
    }
    arg7 = reinterpret_cast< bool * >(argp7);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->findOrAddElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,*arg7);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getElemId) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    unsigned int arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg5 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    unsigned int val5 ;
    int ecode5 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 5) || (items > 5)) {
      SWIG_croak("Usage: SchemaGrammar_getElemId(self,uriId,baseName,qName,scope);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getElemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaGrammar_getElemId" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"SchemaGrammar_getElemId");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"SchemaGrammar_getElemId");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    ecode5 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(4), &val5);
    if (!SWIG_IsOK(ecode5)) {
      SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "SchemaGrammar_getElemId" "', argument " "5"" of type '" "unsigned int""'");
    } 
    arg5 = static_cast< unsigned int >(val5);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getElemId(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,arg5);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getElemDecl__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    unsigned int arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg5 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    unsigned int val5 ;
    int ecode5 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 5) || (items > 5)) {
      SWIG_croak("Usage: SchemaGrammar_getElemDecl(self,uriId,baseName,qName,scope);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaGrammar_getElemDecl" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"SchemaGrammar_getElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"SchemaGrammar_getElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    ecode5 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(4), &val5);
    if (!SWIG_IsOK(ecode5)) {
      SWIG_exception_fail(SWIG_ArgError(ecode5), "in method '" "SchemaGrammar_getElemDecl" "', argument " "5"" of type '" "unsigned int""'");
    } 
    arg5 = static_cast< unsigned int >(val5);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->getElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,arg5);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getElemDecl__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    unsigned int arg2 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaGrammar_getElemDecl(self,elemId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaGrammar_getElemDecl" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->getElemDecl(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getElemDecl) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 5) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(3)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(4), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaGrammar_getElemDecl__SWIG_1); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaGrammar_getElemDecl__SWIG_0); return;
    }
  }
  
  croak("No matching function for overloaded 'SchemaGrammar_getElemDecl'");
  XSRETURN(0);
}


XS(_wrap_SchemaGrammar_getNotationDecl) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLNotationDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaGrammar_getNotationDecl(self,notName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getNotationDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"SchemaGrammar_getNotationDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLNotationDecl *)(arg1)->getNotationDecl((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getValidated) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_getValidated(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getValidated" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getValidated();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_putElemDecl__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    unsigned int arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg6 ;
    bool arg7 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    unsigned int val6 ;
    int ecode6 = 0 ;
    bool val7 ;
    int ecode7 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 7) || (items > 7)) {
      SWIG_croak("Usage: SchemaGrammar_putElemDecl(self,uriId,baseName,prefixName,qName,scope,notDeclared);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_putElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaGrammar_putElemDecl" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"SchemaGrammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"SchemaGrammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    
    if (ST(4) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",5,"SchemaGrammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg5 = Perl2XMLString(ST(4));
    }
    
    ecode6 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(5), &val6);
    if (!SWIG_IsOK(ecode6)) {
      SWIG_exception_fail(SWIG_ArgError(ecode6), "in method '" "SchemaGrammar_putElemDecl" "', argument " "6"" of type '" "unsigned int""'");
    } 
    arg6 = static_cast< unsigned int >(val6);
    ecode7 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(6), &val7);
    if (!SWIG_IsOK(ecode7)) {
      SWIG_exception_fail(SWIG_ArgError(ecode7), "in method '" "SchemaGrammar_putElemDecl" "', argument " "7"" of type '" "bool""'");
    } 
    arg7 = static_cast< bool >(val7);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->putElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6,arg7);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_putElemDecl__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    unsigned int arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg4 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg5 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg6 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    unsigned int val6 ;
    int ecode6 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 6) || (items > 6)) {
      SWIG_croak("Usage: SchemaGrammar_putElemDecl(self,uriId,baseName,prefixName,qName,scope);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_putElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaGrammar_putElemDecl" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"SchemaGrammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"SchemaGrammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    
    if (ST(4) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",5,"SchemaGrammar_putElemDecl");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg5 = Perl2XMLString(ST(4));
    }
    
    ecode6 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(5), &val6);
    if (!SWIG_IsOK(ecode6)) {
      SWIG_exception_fail(SWIG_ArgError(ecode6), "in method '" "SchemaGrammar_putElemDecl" "', argument " "6"" of type '" "unsigned int""'");
    } 
    arg6 = static_cast< unsigned int >(val6);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLElementDecl *)(arg1)->putElemDecl(arg2,(XMLCh const *)arg3,(XMLCh const *)arg4,(XMLCh const *)arg5,arg6);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    
    delete[] arg5;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_putElemDecl__SWIG_2) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) (XERCES_CPP_NAMESPACE::XMLElementDecl *)0 ;
    bool arg3 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    bool val3 ;
    int ecode3 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: SchemaGrammar_putElemDecl(self,elemDecl,notDeclared);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_putElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaGrammar_putElemDecl" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp2);
    ecode3 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(2), &val3);
    if (!SWIG_IsOK(ecode3)) {
      SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "SchemaGrammar_putElemDecl" "', argument " "3"" of type '" "bool""'");
    } 
    arg3 = static_cast< bool >(val3);
    {
      try 
      {
        result = (unsigned int)(arg1)->putElemDecl(arg2,arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_putElemDecl__SWIG_3) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) (XERCES_CPP_NAMESPACE::XMLElementDecl *)0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaGrammar_putElemDecl(self,elemDecl);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_putElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaGrammar_putElemDecl" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp2);
    {
      try 
      {
        result = (unsigned int)(arg1)->putElemDecl(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_putElemDecl) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(1), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 3) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(1), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(2), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
    if (items == 6) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(3)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(4)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(5), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 3;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_3:
    
    if (items == 7) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(3)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(4)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(5), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(6), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_4;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 4;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_4:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaGrammar_putElemDecl__SWIG_3); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaGrammar_putElemDecl__SWIG_2); return;
    case 3:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaGrammar_putElemDecl__SWIG_1); return;
    case 4:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaGrammar_putElemDecl__SWIG_0); return;
    }
  }
  
  croak("No matching function for overloaded 'SchemaGrammar_putElemDecl'");
  XSRETURN(0);
}


XS(_wrap_SchemaGrammar_putNotationDecl) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::XMLNotationDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLNotationDecl *) (XERCES_CPP_NAMESPACE::XMLNotationDecl *)0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaGrammar_putNotationDecl(self,notationDecl);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_putNotationDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLNotationDecl, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaGrammar_putNotationDecl" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLNotationDecl *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLNotationDecl * >(argp2);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->putNotationDecl(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_setValidated) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    bool arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    bool val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaGrammar_setValidated(self,newState);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_setValidated" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    ecode2 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaGrammar_setValidated" "', argument " "2"" of type '" "bool""'");
    } 
    arg2 = static_cast< bool >(val2);
    {
      try 
      {
        (arg1)->setValidated(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_reset) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_reset(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_reset" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        (arg1)->reset();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getElemEnumerator) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    SwigValueWrapper<XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl > > result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_getElemEnumerator(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getElemEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        result = ((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getElemEnumerator();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj((new XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl >(static_cast< const XERCES_CPP_NAMESPACE::RefHash3KeysIdPoolEnumerator<XERCES_CPP_NAMESPACE::SchemaElementDecl >& >(result))), SWIGTYPE_p_XERCES_CPP_NAMESPACE__RefHash3KeysIdPoolEnumeratorTXERCES_CPP_NAMESPACE__SchemaElementDecl_t, SWIG_POINTER_OWN | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getNotationEnumerator) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    SwigValueWrapper<XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::XMLNotationDecl > > result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_getNotationEnumerator(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getNotationEnumerator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        result = ((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getNotationEnumerator();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj((new XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::XMLNotationDecl >(static_cast< const XERCES_CPP_NAMESPACE::NameIdPoolEnumerator<XERCES_CPP_NAMESPACE::XMLNotationDecl >& >(result))), SWIGTYPE_p_XERCES_CPP_NAMESPACE__NameIdPoolEnumeratorTXERCES_CPP_NAMESPACE__XMLNotationDecl_t, SWIG_POINTER_OWN | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getAttributeDeclRegistry) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    RefHashTableOf<XERCES_CPP_NAMESPACE::XMLAttDef > *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_getAttributeDeclRegistry(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getAttributeDeclRegistry" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        result = (RefHashTableOf<XERCES_CPP_NAMESPACE::XMLAttDef > *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getAttributeDeclRegistry();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XMLAttDef_t, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getComplexTypeRegistry) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    RefHashTableOf<XERCES_CPP_NAMESPACE::ComplexTypeInfo > *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_getComplexTypeRegistry(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getComplexTypeRegistry" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        result = (RefHashTableOf<XERCES_CPP_NAMESPACE::ComplexTypeInfo > *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getComplexTypeRegistry();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__ComplexTypeInfo_t, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getGroupInfoRegistry) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    RefHashTableOf<XERCES_CPP_NAMESPACE::XercesGroupInfo > *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_getGroupInfoRegistry(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getGroupInfoRegistry" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        result = (RefHashTableOf<XERCES_CPP_NAMESPACE::XercesGroupInfo > *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getGroupInfoRegistry();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XercesGroupInfo_t, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getAttGroupInfoRegistry) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    RefHashTableOf<XERCES_CPP_NAMESPACE::XercesAttGroupInfo > *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_getAttGroupInfoRegistry(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getAttGroupInfoRegistry" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        result = (RefHashTableOf<XERCES_CPP_NAMESPACE::XercesAttGroupInfo > *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getAttGroupInfoRegistry();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XercesAttGroupInfo_t, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getDatatypeRegistry) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    DatatypeValidatorFactory *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_getDatatypeRegistry(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getDatatypeRegistry" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        result = (DatatypeValidatorFactory *)(arg1)->getDatatypeRegistry();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_DatatypeValidatorFactory, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getNamespaceScope) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::NamespaceScope *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_getNamespaceScope(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getNamespaceScope" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::NamespaceScope *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getNamespaceScope();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__NamespaceScope, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getValidSubstitutionGroups) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    RefHash2KeysTableOf<XERCES_CPP_NAMESPACE::ElemVector > *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_getValidSubstitutionGroups(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getValidSubstitutionGroups" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        result = (RefHash2KeysTableOf<XERCES_CPP_NAMESPACE::ElemVector > *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getValidSubstitutionGroups();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_RefHash2KeysTableOfTValueVectorOfTXERCES_CPP_NAMESPACE__SchemaElementDecl_p_t_t, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getIDRefList) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    RefHashTableOf<XMLRefInfo > *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_getIDRefList(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getIDRefList" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        result = (RefHashTableOf<XMLRefInfo > *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getIDRefList();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_RefHashTableOfTXMLRefInfo_t, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getValidationContext) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    ValidationContext *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_getValidationContext(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getValidationContext" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        result = (ValidationContext *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getValidationContext();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ValidationContext, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_setTargetNamespace) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaGrammar_setTargetNamespace(self,targetNamespace);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_setTargetNamespace" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"SchemaGrammar_setTargetNamespace");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setTargetNamespace((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_setAttributeDeclRegistry) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    RefHashTableOf<XERCES_CPP_NAMESPACE::XMLAttDef > *arg2 = (RefHashTableOf<XERCES_CPP_NAMESPACE::XMLAttDef > *) (RefHashTableOf<XERCES_CPP_NAMESPACE::XMLAttDef > *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaGrammar_setAttributeDeclRegistry(self,attReg);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_setAttributeDeclRegistry" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XMLAttDef_t, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaGrammar_setAttributeDeclRegistry" "', argument " "2"" of type '" "RefHashTableOf<XERCES_CPP_NAMESPACE::XMLAttDef > *const""'"); 
    }
    arg2 = reinterpret_cast< RefHashTableOf<XERCES_CPP_NAMESPACE::XMLAttDef > * >(argp2);
    {
      try 
      {
        (arg1)->setAttributeDeclRegistry(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_setComplexTypeRegistry) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    RefHashTableOf<XERCES_CPP_NAMESPACE::ComplexTypeInfo > *arg2 = (RefHashTableOf<XERCES_CPP_NAMESPACE::ComplexTypeInfo > *) (RefHashTableOf<XERCES_CPP_NAMESPACE::ComplexTypeInfo > *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaGrammar_setComplexTypeRegistry(self,other);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_setComplexTypeRegistry" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__ComplexTypeInfo_t, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaGrammar_setComplexTypeRegistry" "', argument " "2"" of type '" "RefHashTableOf<XERCES_CPP_NAMESPACE::ComplexTypeInfo > *const""'"); 
    }
    arg2 = reinterpret_cast< RefHashTableOf<XERCES_CPP_NAMESPACE::ComplexTypeInfo > * >(argp2);
    {
      try 
      {
        (arg1)->setComplexTypeRegistry(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_setGroupInfoRegistry) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    RefHashTableOf<XERCES_CPP_NAMESPACE::XercesGroupInfo > *arg2 = (RefHashTableOf<XERCES_CPP_NAMESPACE::XercesGroupInfo > *) (RefHashTableOf<XERCES_CPP_NAMESPACE::XercesGroupInfo > *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaGrammar_setGroupInfoRegistry(self,other);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_setGroupInfoRegistry" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XercesGroupInfo_t, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaGrammar_setGroupInfoRegistry" "', argument " "2"" of type '" "RefHashTableOf<XERCES_CPP_NAMESPACE::XercesGroupInfo > *const""'"); 
    }
    arg2 = reinterpret_cast< RefHashTableOf<XERCES_CPP_NAMESPACE::XercesGroupInfo > * >(argp2);
    {
      try 
      {
        (arg1)->setGroupInfoRegistry(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_setAttGroupInfoRegistry) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    RefHashTableOf<XERCES_CPP_NAMESPACE::XercesAttGroupInfo > *arg2 = (RefHashTableOf<XERCES_CPP_NAMESPACE::XercesAttGroupInfo > *) (RefHashTableOf<XERCES_CPP_NAMESPACE::XercesAttGroupInfo > *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaGrammar_setAttGroupInfoRegistry(self,other);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_setAttGroupInfoRegistry" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XercesAttGroupInfo_t, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaGrammar_setAttGroupInfoRegistry" "', argument " "2"" of type '" "RefHashTableOf<XERCES_CPP_NAMESPACE::XercesAttGroupInfo > *const""'"); 
    }
    arg2 = reinterpret_cast< RefHashTableOf<XERCES_CPP_NAMESPACE::XercesAttGroupInfo > * >(argp2);
    {
      try 
      {
        (arg1)->setAttGroupInfoRegistry(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_setNamespaceScope) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::NamespaceScope *arg2 = (XERCES_CPP_NAMESPACE::NamespaceScope *) (XERCES_CPP_NAMESPACE::NamespaceScope *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaGrammar_setNamespaceScope(self,nsScope);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_setNamespaceScope" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__NamespaceScope, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaGrammar_setNamespaceScope" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::NamespaceScope *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::NamespaceScope * >(argp2);
    {
      try 
      {
        (arg1)->setNamespaceScope(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_setValidSubstitutionGroups) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    RefHash2KeysTableOf<XERCES_CPP_NAMESPACE::ElemVector > *arg2 = (RefHash2KeysTableOf<XERCES_CPP_NAMESPACE::ElemVector > *) (RefHash2KeysTableOf<XERCES_CPP_NAMESPACE::ElemVector > *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaGrammar_setValidSubstitutionGroups(self,RefHash2KeysTableOf<XERCES_CPP_NAMESPACE::ElemVector > *const);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_setValidSubstitutionGroups" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_RefHash2KeysTableOfTValueVectorOfTXERCES_CPP_NAMESPACE__SchemaElementDecl_p_t_t, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaGrammar_setValidSubstitutionGroups" "', argument " "2"" of type '" "RefHash2KeysTableOf<XERCES_CPP_NAMESPACE::ElemVector > *const""'"); 
    }
    arg2 = reinterpret_cast< RefHash2KeysTableOf<XERCES_CPP_NAMESPACE::ElemVector > * >(argp2);
    {
      try 
      {
        (arg1)->setValidSubstitutionGroups(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_setGrammarDescription) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::XMLGrammarDescription *arg2 = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaGrammar_setGrammarDescription(self,XERCES_CPP_NAMESPACE::XMLGrammarDescription *);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_setGrammarDescription" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaGrammar_setGrammarDescription" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLGrammarDescription *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLGrammarDescription * >(argp2);
    {
      try 
      {
        (arg1)->setGrammarDescription(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getGrammarDescription) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::XMLGrammarDescription *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_getGrammarDescription(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getGrammarDescription" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLGrammarDescription *)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->getGrammarDescription();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLGrammarDescription, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_putGroupElemDecl) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::XMLElementDecl *arg2 = (XERCES_CPP_NAMESPACE::XMLElementDecl *) (XERCES_CPP_NAMESPACE::XMLElementDecl *)0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaGrammar_putGroupElemDecl(self,elemDecl);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_putGroupElemDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLElementDecl, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaGrammar_putGroupElemDecl" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XMLElementDecl *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLElementDecl * >(argp2);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::SchemaGrammar const *)arg1)->putGroupElemDecl(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_putAnnotation) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    void *arg2 = (void *) 0 ;
    XERCES_CPP_NAMESPACE::XSAnnotation *arg3 = (XERCES_CPP_NAMESPACE::XSAnnotation *) (XERCES_CPP_NAMESPACE::XSAnnotation *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp3 = 0 ;
    int res3 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: SchemaGrammar_putAnnotation(self,key,annotation);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_putAnnotation" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      arg2 = (void*) ST(1);
    }
    res3 = SWIG_ConvertPtr(ST(2), &argp3,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XSAnnotation, 0 |  0 );
    if (!SWIG_IsOK(res3)) {
      SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "SchemaGrammar_putAnnotation" "', argument " "3"" of type '" "XERCES_CPP_NAMESPACE::XSAnnotation *const""'"); 
    }
    arg3 = reinterpret_cast< XERCES_CPP_NAMESPACE::XSAnnotation * >(argp3);
    {
      try 
      {
        (arg1)->putAnnotation(arg2,arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_addAnnotation) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::XSAnnotation *arg2 = (XERCES_CPP_NAMESPACE::XSAnnotation *) (XERCES_CPP_NAMESPACE::XSAnnotation *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaGrammar_addAnnotation(self,annotation);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_addAnnotation" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__XSAnnotation, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaGrammar_addAnnotation" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::XSAnnotation *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::XSAnnotation * >(argp2);
    {
      try 
      {
        (arg1)->addAnnotation(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getAnnotation__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    void *arg2 = (void *) (void *)0 ;
    XERCES_CPP_NAMESPACE::XSAnnotation *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaGrammar_getAnnotation(self,key);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getAnnotation" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      arg2 = (void*) ST(1);
    }
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XSAnnotation *)(arg1)->getAnnotation((void const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XSAnnotation, 0 | 0); argvi++ ;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getAnnotation__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    XERCES_CPP_NAMESPACE::XSAnnotation *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_getAnnotation(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getAnnotation" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XSAnnotation *)(arg1)->getAnnotation();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XSAnnotation, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaGrammar_getAnnotation) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        void *ptr = 0;
        int res = SWIG_ConvertPtr(ST(1), &ptr, 0, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaGrammar_getAnnotation__SWIG_1); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaGrammar_getAnnotation__SWIG_0); return;
    }
  }
  
  croak("No matching function for overloaded 'SchemaGrammar_getAnnotation'");
  XSRETURN(0);
}


XS(_wrap_SchemaGrammar_getAnnotations) {
  {
    XERCES_CPP_NAMESPACE::SchemaGrammar *arg1 = (XERCES_CPP_NAMESPACE::SchemaGrammar *) 0 ;
    RefHashTableOf<XERCES_CPP_NAMESPACE::XSAnnotation > *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaGrammar_getAnnotations(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaGrammar, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaGrammar_getAnnotations" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaGrammar *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaGrammar * >(argp1);
    {
      try 
      {
        result = (RefHashTableOf<XERCES_CPP_NAMESPACE::XSAnnotation > *)(arg1)->getAnnotations();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_RefHashTableOfTXERCES_CPP_NAMESPACE__XSAnnotation_t, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_SchemaValidator__SWIG_0) {
  {
    XMLErrorReporter *arg1 = (XMLErrorReporter *) (XMLErrorReporter *)0 ;
    XERCES_CPP_NAMESPACE::SchemaValidator *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: new_SchemaValidator(errReporter);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XMLErrorReporter, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_SchemaValidator" "', argument " "1"" of type '" "XMLErrorReporter *const""'"); 
    }
    arg1 = reinterpret_cast< XMLErrorReporter * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::SchemaValidator *)new XERCES_CPP_NAMESPACE::SchemaValidator(arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_SchemaValidator__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::SchemaValidator *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 0) || (items > 0)) {
      SWIG_croak("Usage: new_SchemaValidator();");
    }
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::SchemaValidator *)new XERCES_CPP_NAMESPACE::SchemaValidator();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    XSRETURN(argvi);
  fail:
    SWIG_croak_null();
  }
}


XS(_wrap_new_SchemaValidator) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 0) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XMLErrorReporter, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_SchemaValidator__SWIG_1); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_SchemaValidator__SWIG_0); return;
    }
  }
  
  croak("No matching function for overloaded 'new_SchemaValidator'");
  XSRETURN(0);
}


XS(_wrap_delete_SchemaValidator) {
  {
    XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_SchemaValidator(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_SchemaValidator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaValidator *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaValidator * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaValidator_getGrammar) {
  {
    XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
    XERCES_CPP_NAMESPACE::Grammar *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaValidator_getGrammar(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaValidator_getGrammar" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaValidator const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaValidator * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::Grammar *)((XERCES_CPP_NAMESPACE::SchemaValidator const *)arg1)->getGrammar();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, SWIG_as_voidptrptr(&result)), 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaValidator_setGrammar) {
  {
    XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
    XERCES_CPP_NAMESPACE::Grammar *arg2 = (XERCES_CPP_NAMESPACE::Grammar *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaValidator_setGrammar(self,aGrammar);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaValidator_setGrammar" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaValidator *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaValidator * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__Grammar, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaValidator_setGrammar" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::Grammar *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::Grammar * >(argp2);
    {
      try 
      {
        (arg1)->setGrammar(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaValidator_normalizeWhiteSpace) {
  {
    XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
    XERCES_CPP_NAMESPACE::DatatypeValidator *arg2 = (XERCES_CPP_NAMESPACE::DatatypeValidator *) 0 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XMLBuffer *arg4 = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    void *argp4 = 0 ;
    int res4 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 4) || (items > 4)) {
      SWIG_croak("Usage: SchemaValidator_normalizeWhiteSpace(self,dV,value,toFill);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaValidator_normalizeWhiteSpace" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaValidator *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaValidator * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaValidator_normalizeWhiteSpace" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DatatypeValidator *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::DatatypeValidator * >(argp2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"SchemaValidator_normalizeWhiteSpace");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    res4 = SWIG_ConvertPtr(ST(3), &argp4, SWIGTYPE_p_XMLBuffer,  0 );
    if (!SWIG_IsOK(res4)) {
      SWIG_exception_fail(SWIG_ArgError(res4), "in method '" "SchemaValidator_normalizeWhiteSpace" "', argument " "4"" of type '" "XMLBuffer &""'"); 
    }
    if (!argp4) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SchemaValidator_normalizeWhiteSpace" "', argument " "4"" of type '" "XMLBuffer &""'"); 
    }
    arg4 = reinterpret_cast< XMLBuffer * >(argp4);
    {
      try 
      {
        (arg1)->normalizeWhiteSpace(arg2,(XMLCh const *)arg3,*arg4);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    
    delete[] arg3;
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaValidator_setGrammarResolver) {
  {
    XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
    XERCES_CPP_NAMESPACE::GrammarResolver *arg2 = (XERCES_CPP_NAMESPACE::GrammarResolver *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaValidator_setGrammarResolver(self,grammarResolver);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaValidator_setGrammarResolver" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaValidator *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaValidator * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__GrammarResolver, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaValidator_setGrammarResolver" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::GrammarResolver *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::GrammarResolver * >(argp2);
    {
      try 
      {
        (arg1)->setGrammarResolver(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaValidator_setXsiType) {
  {
    XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    unsigned int arg4 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val4 ;
    int ecode4 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 4) || (items > 4)) {
      SWIG_croak("Usage: SchemaValidator_setXsiType(self,prefix,localPart,uriId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaValidator_setXsiType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaValidator *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaValidator * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"SchemaValidator_setXsiType");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"SchemaValidator_setXsiType");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    ecode4 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(3), &val4);
    if (!SWIG_IsOK(ecode4)) {
      SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "SchemaValidator_setXsiType" "', argument " "4"" of type '" "unsigned int""'");
    } 
    arg4 = static_cast< unsigned int >(val4);
    {
      try 
      {
        (arg1)->setXsiType((XMLCh const *)arg2,(XMLCh const *)arg3,arg4);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaValidator_setNillable) {
  {
    XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
    bool arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    bool val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaValidator_setNillable(self,isNil);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaValidator_setNillable" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaValidator *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaValidator * >(argp1);
    ecode2 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaValidator_setNillable" "', argument " "2"" of type '" "bool""'");
    } 
    arg2 = static_cast< bool >(val2);
    {
      try 
      {
        (arg1)->setNillable(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaValidator_setExitOnFirstFatal) {
  {
    XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
    bool arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    bool val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaValidator_setExitOnFirstFatal(self,newValue);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaValidator_setExitOnFirstFatal" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaValidator *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaValidator * >(argp1);
    ecode2 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaValidator_setExitOnFirstFatal" "', argument " "2"" of type '" "bool""'");
    } 
    arg2 = static_cast< bool >(val2);
    {
      try 
      {
        (arg1)->setExitOnFirstFatal(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaValidator_setDatatypeBuffer) {
  {
    XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaValidator_setDatatypeBuffer(self,value);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaValidator_setDatatypeBuffer" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaValidator *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaValidator * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"SchemaValidator_setDatatypeBuffer");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setDatatypeBuffer((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaValidator_clearDatatypeBuffer) {
  {
    XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaValidator_clearDatatypeBuffer(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaValidator_clearDatatypeBuffer" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaValidator *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaValidator * >(argp1);
    {
      try 
      {
        (arg1)->clearDatatypeBuffer();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaValidator_getCurrentTypeInfo) {
  {
    XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
    XERCES_CPP_NAMESPACE::ComplexTypeInfo *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaValidator_getCurrentTypeInfo(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaValidator_getCurrentTypeInfo" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaValidator const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaValidator * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::ComplexTypeInfo *)((XERCES_CPP_NAMESPACE::SchemaValidator const *)arg1)->getCurrentTypeInfo();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__ComplexTypeInfo, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaValidator_getCurrentDatatypeValidator) {
  {
    XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
    XERCES_CPP_NAMESPACE::DatatypeValidator *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaValidator_getCurrentDatatypeValidator(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaValidator_getCurrentDatatypeValidator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaValidator const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaValidator * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DatatypeValidator *)((XERCES_CPP_NAMESPACE::SchemaValidator const *)arg1)->getCurrentDatatypeValidator();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaValidator_getMostRecentAttrValidator) {
  {
    XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
    XERCES_CPP_NAMESPACE::DatatypeValidator *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaValidator_getMostRecentAttrValidator(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaValidator_getMostRecentAttrValidator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaValidator const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaValidator * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DatatypeValidator *)((XERCES_CPP_NAMESPACE::SchemaValidator const *)arg1)->getMostRecentAttrValidator();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaValidator_getErrorOccurred) {
  {
    XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaValidator_getErrorOccurred(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaValidator_getErrorOccurred" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaValidator const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaValidator * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::SchemaValidator const *)arg1)->getErrorOccurred();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaValidator_getIsElemSpecified) {
  {
    XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaValidator_getIsElemSpecified(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaValidator_getIsElemSpecified" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaValidator const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaValidator * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::SchemaValidator const *)arg1)->getIsElemSpecified();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaValidator_getNormalizedValue) {
  {
    XERCES_CPP_NAMESPACE::SchemaValidator *arg1 = (XERCES_CPP_NAMESPACE::SchemaValidator *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaValidator_getNormalizedValue(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaValidator, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaValidator_getNormalizedValue" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaValidator const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaValidator * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaValidator const *)arg1)->getNormalizedValue();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_SchemaAttDefList) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_SchemaAttDefList(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_SchemaAttDefList" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDefList * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDefList_hasMoreElements) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDefList_hasMoreElements(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDefList_hasMoreElements" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDefList const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDefList * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::SchemaAttDefList const *)arg1)->hasMoreElements();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDefList_isEmpty) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDefList_isEmpty(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDefList_isEmpty" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDefList const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDefList * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::SchemaAttDefList const *)arg1)->isEmpty();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDefList_findAttDef__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
    unsigned long arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned long val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: SchemaAttDefList_findAttDef(self,uriID,attName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDefList_findAttDef" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDefList * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_long SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaAttDefList_findAttDef" "', argument " "2"" of type '" "unsigned long""'");
    } 
    arg2 = static_cast< unsigned long >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"SchemaAttDefList_findAttDef");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLAttDef *)(arg1)->findAttDef(arg2,(XMLCh const *)arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    delete[] arg3;
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDefList_findAttDef__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: SchemaAttDefList_findAttDef(self,attURI,attName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDefList_findAttDef" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDefList * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"SchemaAttDefList_findAttDef");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"SchemaAttDefList_findAttDef");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLAttDef *)(arg1)->findAttDef((XMLCh const *)arg2,(XMLCh const *)arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDefList_findAttDef) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 3) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_unsigned_SS_long SWIG_PERL_CALL_ARGS_2(ST(1), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 3) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaAttDefList_findAttDef__SWIG_0); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaAttDefList_findAttDef__SWIG_1); return;
    }
  }
  
  croak("No matching function for overloaded 'SchemaAttDefList_findAttDef'");
  XSRETURN(0);
}


XS(_wrap_SchemaAttDefList_findAttDefLocalPart) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
    unsigned long arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned long val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: SchemaAttDefList_findAttDefLocalPart(self,uriID,attLocalPart);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDefList_findAttDefLocalPart" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDefList * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_long SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaAttDefList_findAttDefLocalPart" "', argument " "2"" of type '" "unsigned long""'");
    } 
    arg2 = static_cast< unsigned long >(val2);
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"SchemaAttDefList_findAttDefLocalPart");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::XMLAttDef *)(arg1)->findAttDefLocalPart(arg2,(XMLCh const *)arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    delete[] arg3;
    
    XSRETURN(argvi);
  fail:
    
    
    
    delete[] arg3;
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDefList_nextElement) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
    XERCES_CPP_NAMESPACE::XMLAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDefList_nextElement(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDefList_nextElement" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDefList * >(argp1);
    {
      try 
      {
        {
          XERCES_CPP_NAMESPACE::XMLAttDef &_result_ref = (arg1)->nextElement();
          result = (XERCES_CPP_NAMESPACE::XMLAttDef *) &_result_ref;
        }
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDefList_Reset) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDefList_Reset(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDefList_Reset" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDefList * >(argp1);
    {
      try 
      {
        (arg1)->Reset();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDefList_getAttDefCount) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDefList_getAttDefCount(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDefList_getAttDefCount" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDefList const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDefList * >(argp1);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::SchemaAttDefList const *)arg1)->getAttDefCount();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDefList_getAttDef) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDefList *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDefList *) 0 ;
    unsigned int arg2 ;
    XERCES_CPP_NAMESPACE::XMLAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaAttDefList_getAttDef(self,index);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDefList, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDefList_getAttDef" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDefList *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDefList * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaAttDefList_getAttDef" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        {
          XERCES_CPP_NAMESPACE::XMLAttDef &_result_ref = (arg1)->getAttDef(arg2);
          result = (XERCES_CPP_NAMESPACE::XMLAttDef *) &_result_ref;
        }
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_SchemaAttDef) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_SchemaAttDef(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_SchemaAttDef" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getFullName) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getFullName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getFullName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getFullName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_reset) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_reset(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_reset" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        (arg1)->reset();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getValidity) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    PSVIDefs::Validity result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getValidity(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getValidity" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = ((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getValidity();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj((new PSVIDefs::Validity(static_cast< const PSVIDefs::Validity& >(result))), SWIGTYPE_p_PSVIDefs__Validity, SWIG_POINTER_OWN | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getValidationAttempted) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    PSVIDefs::Validation result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getValidationAttempted(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getValidationAttempted" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = ((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getValidationAttempted();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj((new PSVIDefs::Validation(static_cast< const PSVIDefs::Validation& >(result))), SWIGTYPE_p_PSVIDefs__Validation, SWIG_POINTER_OWN | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getTypeType) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    PSVIDefs::Complexity result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getTypeType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getTypeType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = ((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getTypeType();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj((new PSVIDefs::Complexity(static_cast< const PSVIDefs::Complexity& >(result))), SWIGTYPE_p_PSVIDefs__Complexity, SWIG_POINTER_OWN | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getTypeUri) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getTypeUri(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getTypeUri" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getTypeUri();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getTypeName) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getTypeName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getTypeName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getTypeName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getTypeAnonymous) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getTypeAnonymous(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getTypeAnonymous" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getTypeAnonymous();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_isTypeDefinitionUnion) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_isTypeDefinitionUnion(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_isTypeDefinitionUnion" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->isTypeDefinitionUnion();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getMemberTypeUri) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getMemberTypeUri(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getMemberTypeUri" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getMemberTypeUri();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getMemberTypeAnonymous) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getMemberTypeAnonymous(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getMemberTypeAnonymous" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getMemberTypeAnonymous();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getMemberTypeName) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getMemberTypeName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getMemberTypeName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getMemberTypeName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getDOMTypeInfoUri) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getDOMTypeInfoUri(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getDOMTypeInfoUri" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getDOMTypeInfoUri();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getDOMTypeInfoName) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getDOMTypeInfoName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getDOMTypeInfoName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getDOMTypeInfoName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getElemId) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    unsigned int result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getElemId(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getElemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = (unsigned int)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getElemId();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_unsigned_SS_int  SWIG_PERL_CALL_ARGS_1(static_cast< unsigned int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getAttName) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XERCES_CPP_NAMESPACE::QName *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getAttName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getAttName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::QName *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getAttName();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__QName, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getDatatypeValidator) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XERCES_CPP_NAMESPACE::DatatypeValidator *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getDatatypeValidator(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getDatatypeValidator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DatatypeValidator *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getDatatypeValidator();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getNamespaceList) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    ValueVectorOf<unsigned int > *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getNamespaceList(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getNamespaceList" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = (ValueVectorOf<unsigned int > *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getNamespaceList();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_ValueVectorOfTunsigned_int_t, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getBaseAttDecl) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XERCES_CPP_NAMESPACE::SchemaAttDef *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getBaseAttDecl(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getBaseAttDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::SchemaAttDef *)(arg1)->getBaseAttDecl();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getPSVIScope) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    PSVIDefs::PSVIScope result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getPSVIScope(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getPSVIScope" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = ((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getPSVIScope();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj((new PSVIDefs::PSVIScope(static_cast< const PSVIDefs::PSVIScope& >(result))), SWIGTYPE_p_PSVIDefs__PSVIScope, SWIG_POINTER_OWN | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_getEnclosingCT) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XERCES_CPP_NAMESPACE::ComplexTypeInfo *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_getEnclosingCT(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_getEnclosingCT" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::ComplexTypeInfo *)((XERCES_CPP_NAMESPACE::SchemaAttDef const *)arg1)->getEnclosingCT();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__ComplexTypeInfo, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_setElemId) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    unsigned int arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    unsigned int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaAttDef_setElemId(self,newId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_setElemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    ecode2 = SWIG_AsVal_unsigned_SS_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "SchemaAttDef_setElemId" "', argument " "2"" of type '" "unsigned int""'");
    } 
    arg2 = static_cast< unsigned int >(val2);
    {
      try 
      {
        (arg1)->setElemId(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_setAttName__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    int arg4 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int val4 ;
    int ecode4 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 4) || (items > 4)) {
      SWIG_croak("Usage: SchemaAttDef_setAttName(self,prefix,localPart,uriId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_setAttName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"SchemaAttDef_setAttName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"SchemaAttDef_setAttName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    ecode4 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(3), &val4);
    if (!SWIG_IsOK(ecode4)) {
      SWIG_exception_fail(SWIG_ArgError(ecode4), "in method '" "SchemaAttDef_setAttName" "', argument " "4"" of type '" "int""'");
    } 
    arg4 = static_cast< int >(val4);
    {
      try 
      {
        (arg1)->setAttName((XMLCh const *)arg2,(XMLCh const *)arg3,arg4);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_setAttName__SWIG_1) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: SchemaAttDef_setAttName(self,prefix,localPart);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_setAttName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"SchemaAttDef_setAttName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"SchemaAttDef_setAttName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    {
      try 
      {
        (arg1)->setAttName((XMLCh const *)arg2,(XMLCh const *)arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_setAttName) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 3) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 4) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          int res = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(3), NULL);
          _v = SWIG_CheckState(res);
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaAttDef_setAttName__SWIG_1); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_SchemaAttDef_setAttName__SWIG_0); return;
    }
  }
  
  croak("No matching function for overloaded 'SchemaAttDef_setAttName'");
  XSRETURN(0);
}


XS(_wrap_SchemaAttDef_setDatatypeValidator) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XERCES_CPP_NAMESPACE::DatatypeValidator *arg2 = (XERCES_CPP_NAMESPACE::DatatypeValidator *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaAttDef_setDatatypeValidator(self,newDatatypeValidator);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_setDatatypeValidator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaAttDef_setDatatypeValidator" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DatatypeValidator *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::DatatypeValidator * >(argp2);
    {
      try 
      {
        (arg1)->setDatatypeValidator(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_setAnyDatatypeValidator) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XERCES_CPP_NAMESPACE::DatatypeValidator *arg2 = (XERCES_CPP_NAMESPACE::DatatypeValidator *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaAttDef_setAnyDatatypeValidator(self,newDatatypeValidator);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_setAnyDatatypeValidator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaAttDef_setAnyDatatypeValidator" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DatatypeValidator *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::DatatypeValidator * >(argp2);
    {
      try 
      {
        (arg1)->setAnyDatatypeValidator(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_setBaseAttDecl) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg2 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) (XERCES_CPP_NAMESPACE::SchemaAttDef *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaAttDef_setBaseAttDecl(self,attDef);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_setBaseAttDecl" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaAttDef_setBaseAttDecl" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef *const""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp2);
    {
      try 
      {
        (arg1)->setBaseAttDecl(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_setPSVIScope) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    PSVIDefs::PSVIScope arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaAttDef_setPSVIScope(self,toSet);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_setPSVIScope" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      res2 = SWIG_ConvertPtr(ST(1), &argp2, SWIGTYPE_p_PSVIDefs__PSVIScope,  0 );
      if (!SWIG_IsOK(res2)) {
        SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaAttDef_setPSVIScope" "', argument " "2"" of type '" "PSVIDefs::PSVIScope const""'"); 
      }  
      if (!argp2) {
        SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SchemaAttDef_setPSVIScope" "', argument " "2"" of type '" "PSVIDefs::PSVIScope const""'");
      } else {
        arg2 = *(reinterpret_cast< PSVIDefs::PSVIScope * >(argp2));
      }
    }
    {
      try 
      {
        (arg1)->setPSVIScope(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_setMembertypeValidator) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XERCES_CPP_NAMESPACE::DatatypeValidator *arg2 = (XERCES_CPP_NAMESPACE::DatatypeValidator *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaAttDef_setMembertypeValidator(self,newDatatypeValidator);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_setMembertypeValidator" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DatatypeValidator, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaAttDef_setMembertypeValidator" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DatatypeValidator const *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::DatatypeValidator * >(argp2);
    {
      try 
      {
        (arg1)->setMembertypeValidator((XERCES_CPP_NAMESPACE::DatatypeValidator const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_setNamespaceList) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    ValueVectorOf<unsigned int > *arg2 = (ValueVectorOf<unsigned int > *) (ValueVectorOf<unsigned int > *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaAttDef_setNamespaceList(self,toSet);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_setNamespaceList" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_ValueVectorOfTunsigned_int_t, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaAttDef_setNamespaceList" "', argument " "2"" of type '" "ValueVectorOf<unsigned int > const *const""'"); 
    }
    arg2 = reinterpret_cast< ValueVectorOf<unsigned int > * >(argp2);
    {
      try 
      {
        (arg1)->setNamespaceList((ValueVectorOf<unsigned int > const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_resetNamespaceList) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: SchemaAttDef_resetNamespaceList(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_resetNamespaceList" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      try 
      {
        (arg1)->resetNamespaceList();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_setValidity) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    PSVIDefs::Validity arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaAttDef_setValidity(self,valid);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_setValidity" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      res2 = SWIG_ConvertPtr(ST(1), &argp2, SWIGTYPE_p_PSVIDefs__Validity,  0 );
      if (!SWIG_IsOK(res2)) {
        SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaAttDef_setValidity" "', argument " "2"" of type '" "PSVIDefs::Validity""'"); 
      }  
      if (!argp2) {
        SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SchemaAttDef_setValidity" "', argument " "2"" of type '" "PSVIDefs::Validity""'");
      } else {
        arg2 = *(reinterpret_cast< PSVIDefs::Validity * >(argp2));
      }
    }
    {
      try 
      {
        (arg1)->setValidity(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_setValidationAttempted) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    PSVIDefs::Validation arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaAttDef_setValidationAttempted(self,validation);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_setValidationAttempted" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    {
      res2 = SWIG_ConvertPtr(ST(1), &argp2, SWIGTYPE_p_PSVIDefs__Validation,  0 );
      if (!SWIG_IsOK(res2)) {
        SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaAttDef_setValidationAttempted" "', argument " "2"" of type '" "PSVIDefs::Validation""'"); 
      }  
      if (!argp2) {
        SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "SchemaAttDef_setValidationAttempted" "', argument " "2"" of type '" "PSVIDefs::Validation""'");
      } else {
        arg2 = *(reinterpret_cast< PSVIDefs::Validation * >(argp2));
      }
    }
    {
      try 
      {
        (arg1)->setValidationAttempted(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_SchemaAttDef_setEnclosingCT) {
  {
    XERCES_CPP_NAMESPACE::SchemaAttDef *arg1 = (XERCES_CPP_NAMESPACE::SchemaAttDef *) 0 ;
    XERCES_CPP_NAMESPACE::ComplexTypeInfo *arg2 = (XERCES_CPP_NAMESPACE::ComplexTypeInfo *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: SchemaAttDef_setEnclosingCT(self,complexTypeInfo);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__SchemaAttDef, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "SchemaAttDef_setEnclosingCT" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::SchemaAttDef *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::SchemaAttDef * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__ComplexTypeInfo, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "SchemaAttDef_setEnclosingCT" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::ComplexTypeInfo *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::ComplexTypeInfo * >(argp2);
    {
      try 
      {
        (arg1)->setEnclosingCT(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_InputSource) {
  {
    XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_InputSource(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_InputSource" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::InputSource *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::InputSource * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_InputSource_makeStream) {
  {
    XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
    XERCES_CPP_NAMESPACE::BinInputStream *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: InputSource_makeStream(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "InputSource_makeStream" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::InputSource const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::InputSource * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::BinInputStream *)((XERCES_CPP_NAMESPACE::InputSource const *)arg1)->makeStream();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__BinInputStream, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_InputSource_getEncoding) {
  {
    XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: InputSource_getEncoding(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "InputSource_getEncoding" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::InputSource const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::InputSource * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::InputSource const *)arg1)->getEncoding();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_InputSource_getPublicId) {
  {
    XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: InputSource_getPublicId(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "InputSource_getPublicId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::InputSource const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::InputSource * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::InputSource const *)arg1)->getPublicId();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_InputSource_getSystemId) {
  {
    XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: InputSource_getSystemId(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "InputSource_getSystemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::InputSource const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::InputSource * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::InputSource const *)arg1)->getSystemId();
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_InputSource_getIssueFatalErrorIfNotFound) {
  {
    XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: InputSource_getIssueFatalErrorIfNotFound(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "InputSource_getIssueFatalErrorIfNotFound" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::InputSource const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::InputSource * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::InputSource const *)arg1)->getIssueFatalErrorIfNotFound();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_InputSource_getMemoryManager) {
  {
    XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
    XERCES_CPP_NAMESPACE::MemoryManager *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: InputSource_getMemoryManager(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "InputSource_getMemoryManager" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::InputSource const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::InputSource * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::MemoryManager *)((XERCES_CPP_NAMESPACE::InputSource const *)arg1)->getMemoryManager();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemoryManager, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_InputSource_setEncoding) {
  {
    XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: InputSource_setEncoding(self,encodingStr);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "InputSource_setEncoding" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::InputSource *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::InputSource * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"InputSource_setEncoding");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setEncoding((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_InputSource_setPublicId) {
  {
    XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: InputSource_setPublicId(self,publicId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "InputSource_setPublicId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::InputSource *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::InputSource * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"InputSource_setPublicId");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setPublicId((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_InputSource_setSystemId) {
  {
    XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: InputSource_setSystemId(self,systemId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "InputSource_setSystemId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::InputSource *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::InputSource * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"InputSource_setSystemId");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setSystemId((XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_InputSource_setIssueFatalErrorIfNotFound) {
  {
    XERCES_CPP_NAMESPACE::InputSource *arg1 = (XERCES_CPP_NAMESPACE::InputSource *) 0 ;
    bool arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    bool val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: InputSource_setIssueFatalErrorIfNotFound(self,flag);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__InputSource, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "InputSource_setIssueFatalErrorIfNotFound" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::InputSource *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::InputSource * >(argp1);
    ecode2 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "InputSource_setIssueFatalErrorIfNotFound" "', argument " "2"" of type '" "bool""'");
    } 
    arg2 = static_cast< bool >(val2);
    {
      try 
      {
        (arg1)->setIssueFatalErrorIfNotFound(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_LocalFileInputSource__SWIG_0) {
  {
    XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::LocalFileInputSource *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: new_LocalFileInputSource(basePath,relativePath);");
    }
    
    if (ST(0) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",1,"new_LocalFileInputSource");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg1 = Perl2XMLString(ST(0));
    }
    
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"new_LocalFileInputSource");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::LocalFileInputSource *)new XERCES_CPP_NAMESPACE::LocalFileInputSource((XMLCh const *)arg1,(XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__LocalFileInputSource, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    delete[] arg1;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    delete[] arg1;
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_LocalFileInputSource__SWIG_1) {
  {
    XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::LocalFileInputSource *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: new_LocalFileInputSource(filePath);");
    }
    
    if (ST(0) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",1,"new_LocalFileInputSource");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg1 = Perl2XMLString(ST(0));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::LocalFileInputSource *)new XERCES_CPP_NAMESPACE::LocalFileInputSource((XMLCh const *)arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__LocalFileInputSource, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    delete[] arg1;
    
    XSRETURN(argvi);
  fail:
    
    delete[] arg1;
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_LocalFileInputSource) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        {
          _v = SvOK(ST(0)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        {
          _v = SvOK(ST(0)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_LocalFileInputSource__SWIG_1); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_LocalFileInputSource__SWIG_0); return;
    }
  }
  
  croak("No matching function for overloaded 'new_LocalFileInputSource'");
  XSRETURN(0);
}


XS(_wrap_delete_LocalFileInputSource) {
  {
    XERCES_CPP_NAMESPACE::LocalFileInputSource *arg1 = (XERCES_CPP_NAMESPACE::LocalFileInputSource *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_LocalFileInputSource(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__LocalFileInputSource, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_LocalFileInputSource" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::LocalFileInputSource *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::LocalFileInputSource * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_LocalFileInputSource_makeStream) {
  {
    XERCES_CPP_NAMESPACE::LocalFileInputSource *arg1 = (XERCES_CPP_NAMESPACE::LocalFileInputSource *) 0 ;
    XERCES_CPP_NAMESPACE::BinInputStream *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: LocalFileInputSource_makeStream(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__LocalFileInputSource, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "LocalFileInputSource_makeStream" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::LocalFileInputSource const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::LocalFileInputSource * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::BinInputStream *)((XERCES_CPP_NAMESPACE::LocalFileInputSource const *)arg1)->makeStream();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__BinInputStream, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_StdInInputSource) {
  {
    XERCES_CPP_NAMESPACE::StdInInputSource *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 0) || (items > 0)) {
      SWIG_croak("Usage: new_StdInInputSource();");
    }
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::StdInInputSource *)new XERCES_CPP_NAMESPACE::StdInInputSource();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__StdInInputSource, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    XSRETURN(argvi);
  fail:
    SWIG_croak_null();
  }
}


XS(_wrap_delete_StdInInputSource) {
  {
    XERCES_CPP_NAMESPACE::StdInInputSource *arg1 = (XERCES_CPP_NAMESPACE::StdInInputSource *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_StdInInputSource(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__StdInInputSource, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_StdInInputSource" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::StdInInputSource *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::StdInInputSource * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_StdInInputSource_makeStream) {
  {
    XERCES_CPP_NAMESPACE::StdInInputSource *arg1 = (XERCES_CPP_NAMESPACE::StdInInputSource *) 0 ;
    XERCES_CPP_NAMESPACE::BinInputStream *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: StdInInputSource_makeStream(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__StdInInputSource, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "StdInInputSource_makeStream" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::StdInInputSource const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::StdInInputSource * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::BinInputStream *)((XERCES_CPP_NAMESPACE::StdInInputSource const *)arg1)->makeStream();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__BinInputStream, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_URLInputSource__SWIG_0) {
  {
    XERCES_CPP_NAMESPACE::XMLURL *arg1 = 0 ;
    XERCES_CPP_NAMESPACE::URLInputSource *result = 0 ;
    void *argp1 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: new_URLInputSource(urlId);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL,  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "new_URLInputSource" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const &""'"); 
    }
    if (!argp1) {
      SWIG_exception_fail(SWIG_ValueError, "invalid null reference " "in method '" "new_URLInputSource" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::XMLURL const &""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::XMLURL * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::URLInputSource *)new XERCES_CPP_NAMESPACE::URLInputSource((XERCES_CPP_NAMESPACE::XMLURL const &)*arg1);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__URLInputSource, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_URLInputSource__SWIG_1) {
  {
    XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::URLInputSource *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: new_URLInputSource(baseId,systemId);");
    }
    
    if (ST(0) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",1,"new_URLInputSource");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg1 = Perl2XMLString(ST(0));
    }
    
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"new_URLInputSource");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::URLInputSource *)new XERCES_CPP_NAMESPACE::URLInputSource((XMLCh const *)arg1,(XMLCh const *)arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__URLInputSource, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    delete[] arg1;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    delete[] arg1;
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_URLInputSource__SWIG_2) {
  {
    XMLCh *arg1 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg2 = (XMLCh *) (XMLCh *)0 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    XERCES_CPP_NAMESPACE::URLInputSource *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: new_URLInputSource(baseId,systemId,publicId);");
    }
    
    if (ST(0) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",1,"new_URLInputSource");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg1 = Perl2XMLString(ST(0));
    }
    
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"new_URLInputSource");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"new_URLInputSource");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::URLInputSource *)new XERCES_CPP_NAMESPACE::URLInputSource((XMLCh const *)arg1,(XMLCh const *)arg2,(XMLCh const *)arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__URLInputSource, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    delete[] arg1;
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    XSRETURN(argvi);
  fail:
    
    delete[] arg1;
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_URLInputSource) {
  dXSARGS;
  
  {
    unsigned long _index = 0;
    SWIG_TypeRank _rank = 0; 
    if (items == 1) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        void *vptr = 0;
        int res = SWIG_ConvertPtr(ST(0), &vptr, SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0);
        _v = SWIG_CheckState(res);
      }
      if (!_v) goto check_1;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 1;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_1:
    
    if (items == 2) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        {
          _v = SvOK(ST(0)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_2;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 2;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_2:
    
    if (items == 3) {
      SWIG_TypeRank _ranki = 0;
      SWIG_TypeRank _rankm = 0;
      SWIG_TypeRank _pi = 1;
      int _v = 0;
      {
        {
          _v = SvOK(ST(0)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(1)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      {
        {
          _v = SvOK(ST(2)) ? 1 : 0; 
        }
      }
      if (!_v) goto check_3;
      _ranki += _v*_pi;
      _rankm += _pi;
      _pi *= SWIG_MAXCASTRANK;
      if (!_index || (_ranki < _rank)) {
        _rank = _ranki; _index = 3;
        if (_rank == _rankm) goto dispatch;
      }
    }
  check_3:
    
  dispatch:
    switch(_index) {
    case 1:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_URLInputSource__SWIG_0); return;
    case 2:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_URLInputSource__SWIG_1); return;
    case 3:
      (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_new_URLInputSource__SWIG_2); return;
    }
  }
  
  croak("No matching function for overloaded 'new_URLInputSource'");
  XSRETURN(0);
}


XS(_wrap_delete_URLInputSource) {
  {
    XERCES_CPP_NAMESPACE::URLInputSource *arg1 = (XERCES_CPP_NAMESPACE::URLInputSource *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_URLInputSource(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__URLInputSource, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_URLInputSource" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::URLInputSource *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::URLInputSource * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_URLInputSource_makeStream) {
  {
    XERCES_CPP_NAMESPACE::URLInputSource *arg1 = (XERCES_CPP_NAMESPACE::URLInputSource *) 0 ;
    XERCES_CPP_NAMESPACE::BinInputStream *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: URLInputSource_makeStream(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__URLInputSource, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "URLInputSource_makeStream" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::URLInputSource const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::URLInputSource * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::BinInputStream *)((XERCES_CPP_NAMESPACE::URLInputSource const *)arg1)->makeStream();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__BinInputStream, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_URLInputSource_urlSrc) {
  {
    XERCES_CPP_NAMESPACE::URLInputSource *arg1 = (XERCES_CPP_NAMESPACE::URLInputSource *) 0 ;
    XERCES_CPP_NAMESPACE::XMLURL *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: URLInputSource_urlSrc(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__URLInputSource, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "URLInputSource_urlSrc" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::URLInputSource const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::URLInputSource * >(argp1);
    {
      try 
      {
        {
          XERCES_CPP_NAMESPACE::XMLURL const &_result_ref = ((XERCES_CPP_NAMESPACE::URLInputSource const *)arg1)->urlSrc();
          result = (XERCES_CPP_NAMESPACE::XMLURL *) &_result_ref;
        }
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__XMLURL, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_new_MemBufInputSource) {
  {
    XMLByte *arg1 = (XMLByte *) (XMLByte *)0 ;
    unsigned int arg2 ;
    XMLCh *arg3 = (XMLCh *) (XMLCh *)0 ;
    bool arg4 ;
    XERCES_CPP_NAMESPACE::MemBufInputSource *result = 0 ;
    int argvi = 0;
    dXSARGS;
    
    arg4 = true;
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: new_MemBufInputSource(srcDocBytes,byteCount,bufId);");
    }
    {
      if (SvPOK(ST(0))||SvIOK(ST(0))||SvNOK(ST(0))) {
        STRLEN len;
        XMLByte *xmlbytes = (XMLByte *)SvPV(ST(0), len);
        arg2 = len;
        arg1 = new XMLByte[len];
        memcpy(arg1, xmlbytes, len);
      } else {
        SWIG_croak("Type error in argument 2 of new_MemBufInputSource, Expected perl-string.");
      }
    }
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"new_MemBufInputSource");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::MemBufInputSource *)new XERCES_CPP_NAMESPACE::MemBufInputSource((XMLByte const *)arg1,arg2,(XMLCh const *)arg3,arg4);
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemBufInputSource, SWIG_OWNER | SWIG_SHADOW); argvi++ ;
    
    delete[] arg3;
    
    
    XSRETURN(argvi);
  fail:
    
    delete[] arg3;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_MemBufInputSource) {
  {
    XERCES_CPP_NAMESPACE::MemBufInputSource *arg1 = (XERCES_CPP_NAMESPACE::MemBufInputSource *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_MemBufInputSource(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemBufInputSource, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_MemBufInputSource" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::MemBufInputSource *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::MemBufInputSource * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_MemBufInputSource_makeStream) {
  {
    XERCES_CPP_NAMESPACE::MemBufInputSource *arg1 = (XERCES_CPP_NAMESPACE::MemBufInputSource *) 0 ;
    XERCES_CPP_NAMESPACE::BinInputStream *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: MemBufInputSource_makeStream(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemBufInputSource, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MemBufInputSource_makeStream" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::MemBufInputSource const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::MemBufInputSource * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::BinInputStream *)((XERCES_CPP_NAMESPACE::MemBufInputSource const *)arg1)->makeStream();
        
      } 
      CATCH_XML_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__BinInputStream, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_MemBufInputSource_setCopyBufToStream) {
  {
    XERCES_CPP_NAMESPACE::MemBufInputSource *arg1 = (XERCES_CPP_NAMESPACE::MemBufInputSource *) 0 ;
    bool arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    bool val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: MemBufInputSource_setCopyBufToStream(self,newState);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemBufInputSource, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MemBufInputSource_setCopyBufToStream" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::MemBufInputSource *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::MemBufInputSource * >(argp1);
    ecode2 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "MemBufInputSource_setCopyBufToStream" "', argument " "2"" of type '" "bool""'");
    } 
    arg2 = static_cast< bool >(val2);
    {
      try 
      {
        (arg1)->setCopyBufToStream(arg2);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_MemBufInputSource_resetMemBufInputSource) {
  {
    XERCES_CPP_NAMESPACE::MemBufInputSource *arg1 = (XERCES_CPP_NAMESPACE::MemBufInputSource *) 0 ;
    XMLByte *arg2 = (XMLByte *) (XMLByte *)0 ;
    unsigned int arg3 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: MemBufInputSource_resetMemBufInputSource(self,srcDocBytes,byteCount);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__MemBufInputSource, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "MemBufInputSource_resetMemBufInputSource" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::MemBufInputSource *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::MemBufInputSource * >(argp1);
    {
      if (SvPOK(ST(1))||SvIOK(ST(1))||SvNOK(ST(1))) {
        STRLEN len;
        XMLByte *xmlbytes = (XMLByte *)SvPV(ST(1), len);
        arg3 = len;
        arg2 = new XMLByte[len];
        memcpy(arg2, xmlbytes, len);
      } else {
        SWIG_croak("Type error in argument 2 of MemBufInputSource_resetMemBufInputSource, Expected perl-string.");
      }
    }
    {
      try 
      {
        (arg1)->resetMemBufInputSource((XMLByte const *)arg2,arg3);
        
      } 
      CATCH_XML_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_DOMException) {
  {
    XERCES_CPP_NAMESPACE::DOMException *arg1 = (XERCES_CPP_NAMESPACE::DOMException *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_DOMException(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMException, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_DOMException" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMException *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMException * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMException_getMessage) {
  {
    XERCES_CPP_NAMESPACE::DOMException *arg1 = (XERCES_CPP_NAMESPACE::DOMException *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMException_getMessage(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMException, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMException_getMessage" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMException const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMException * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMException const *)arg1)->getMessage();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMException_code_set) {
  {
    XERCES_CPP_NAMESPACE::DOMException *arg1 = (XERCES_CPP_NAMESPACE::DOMException *) 0 ;
    XERCES_CPP_NAMESPACE::DOMException::ExceptionCode arg2 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMException_code_set(self,code);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMException, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMException_code_set" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMException *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMException * >(argp1);
    ecode2 = SWIG_AsVal_int SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "DOMException_code_set" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DOMException::ExceptionCode""'");
    } 
    arg2 = static_cast< XERCES_CPP_NAMESPACE::DOMException::ExceptionCode >(val2);
    if (arg1) (arg1)->code = arg2;
    
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMException_code_get) {
  {
    XERCES_CPP_NAMESPACE::DOMException *arg1 = (XERCES_CPP_NAMESPACE::DOMException *) 0 ;
    XERCES_CPP_NAMESPACE::DOMException::ExceptionCode result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMException_code_get(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMException, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMException_code_get" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMException *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMException * >(argp1);
    result = (XERCES_CPP_NAMESPACE::DOMException::ExceptionCode) ((arg1)->code);
    
    ST(argvi) = SWIG_From_int  SWIG_PERL_CALL_ARGS_1(static_cast< int >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMException_msg_set) {
  {
    XERCES_CPP_NAMESPACE::DOMException *arg1 = (XERCES_CPP_NAMESPACE::DOMException *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMException_msg_set(self,msg);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMException, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMException_msg_set" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMException *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMException * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMException_msg_set");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    if (arg1) (arg1)->msg = (XMLCh const *)arg2;
    
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMException_msg_get) {
  {
    XERCES_CPP_NAMESPACE::DOMException *arg1 = (XERCES_CPP_NAMESPACE::DOMException *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMException_msg_get(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMException, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMException_msg_get" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMException *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMException * >(argp1);
    result = (XMLCh *) ((arg1)->msg);
    
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_DOMNode) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_DOMNode(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_DOMNode" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_getNodeName) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_getNodeName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_getNodeName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getNodeName();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_getNodeValue) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_getNodeValue(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_getNodeValue" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getNodeValue();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_getNodeType) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    short result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_getNodeType(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_getNodeType" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        result = (short)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getNodeType();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_From_short  SWIG_PERL_CALL_ARGS_1(static_cast< short >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_getParentNode) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_getParentNode(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_getParentNode" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMNode *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getParentNode();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, SWIG_as_voidptrptr(&result)), 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_getChildNodes) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNodeList *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_getChildNodes(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_getChildNodes" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMNodeList *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getChildNodes();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNodeList, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_getFirstChild) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_getFirstChild(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_getFirstChild" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMNode *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getFirstChild();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, SWIG_as_voidptrptr(&result)), 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_getLastChild) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_getLastChild(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_getLastChild" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMNode *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getLastChild();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, SWIG_as_voidptrptr(&result)), 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_getPreviousSibling) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_getPreviousSibling(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_getPreviousSibling" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMNode *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getPreviousSibling();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, SWIG_as_voidptrptr(&result)), 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_getNextSibling) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_getNextSibling(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_getNextSibling" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMNode *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getNextSibling();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, SWIG_as_voidptrptr(&result)), 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_getAttributes) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNamedNodeMap *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_getAttributes(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_getAttributes" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMNamedNodeMap *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getAttributes();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNamedNodeMap, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_getOwnerDocument) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMDocument *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_getOwnerDocument(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_getOwnerDocument" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMDocument *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getOwnerDocument();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMDocument, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_cloneNode) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    bool arg2 ;
    XERCES_CPP_NAMESPACE::DOMNode *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    bool val2 ;
    int ecode2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMNode_cloneNode(self,deep);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_cloneNode" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    ecode2 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(1), &val2);
    if (!SWIG_IsOK(ecode2)) {
      SWIG_exception_fail(SWIG_ArgError(ecode2), "in method '" "DOMNode_cloneNode" "', argument " "2"" of type '" "bool""'");
    } 
    arg2 = static_cast< bool >(val2);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMNode *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->cloneNode(arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, SWIG_as_voidptrptr(&result)), 0 | SWIG_SHADOW); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_insertBefore) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *arg2 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *arg3 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    void *argp3 = 0 ;
    int res3 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: DOMNode_insertBefore(self,newChild,refChild);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_insertBefore" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DOMNode_insertBefore" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp2);
    res3 = SWIG_ConvertPtr(ST(2), &argp3,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res3)) {
      SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "DOMNode_insertBefore" "', argument " "3"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg3 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp3);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMNode *)(arg1)->insertBefore(arg2,arg3);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, SWIG_as_voidptrptr(&result)), 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_replaceChild) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *arg2 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *arg3 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    void *argp3 = 0 ;
    int res3 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: DOMNode_replaceChild(self,newChild,oldChild);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_replaceChild" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DOMNode_replaceChild" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp2);
    res3 = SWIG_ConvertPtr(ST(2), &argp3,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res3)) {
      SWIG_exception_fail(SWIG_ArgError(res3), "in method '" "DOMNode_replaceChild" "', argument " "3"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg3 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp3);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMNode *)(arg1)->replaceChild(arg2,arg3);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, SWIG_as_voidptrptr(&result)), 0 | SWIG_SHADOW); argvi++ ;
    
    
    
    XSRETURN(argvi);
  fail:
    
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_removeChild) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *arg2 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMNode_removeChild(self,oldChild);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_removeChild" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DOMNode_removeChild" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp2);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMNode *)(arg1)->removeChild(arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, SWIG_as_voidptrptr(&result)), 0 | SWIG_SHADOW); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_appendChild) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *arg2 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMNode_appendChild(self,newChild);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_appendChild" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DOMNode_appendChild" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp2);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMNode *)(arg1)->appendChild(arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, SWIG_as_voidptrptr(&result)), 0 | SWIG_SHADOW); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_hasChildNodes) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_hasChildNodes(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_hasChildNodes" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->hasChildNodes();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_setNodeValue) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMNode_setNodeValue(self,nodeValue);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_setNodeValue" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMNode_setNodeValue");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setNodeValue((XMLCh const *)arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_normalize) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_normalize(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_normalize" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        (arg1)->normalize();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_isSupported) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    XMLCh *arg3 = (XMLCh *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: DOMNode_isSupported(self,feature,version);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_isSupported" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMNode_isSupported");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"DOMNode_isSupported");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->isSupported((XMLCh const *)arg2,(XMLCh const *)arg3);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_getNamespaceURI) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_getNamespaceURI(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_getNamespaceURI" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getNamespaceURI();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_getLocalName) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_getLocalName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_getLocalName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getLocalName();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_setPrefix) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMNode_setPrefix(self,prefix);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_setPrefix" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMNode_setPrefix");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setPrefix((XMLCh const *)arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_hasAttributes) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_hasAttributes(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_hasAttributes" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->hasAttributes();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_isSameNode) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *arg2 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMNode_isSameNode(self,other);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_isSameNode" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DOMNode_isSameNode" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp2);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->isSameNode((XERCES_CPP_NAMESPACE::DOMNode const *)arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_isEqualNode) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *arg2 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMNode_isEqualNode(self,arg);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_isEqualNode" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DOMNode_isEqualNode" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp2);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->isEqualNode((XERCES_CPP_NAMESPACE::DOMNode const *)arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_setUserData) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    void *arg3 = (void *) 0 ;
    XERCES_CPP_NAMESPACE::DOMUserDataHandler *arg4 = (XERCES_CPP_NAMESPACE::DOMUserDataHandler *) 0 ;
    void *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp4 = 0 ;
    int res4 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 4) || (items > 4)) {
      SWIG_croak("Usage: DOMNode_setUserData(self,key,data,handler);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_setUserData" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMNode_setUserData");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      arg3 = (void*) ST(2);
    }
    res4 = SWIG_ConvertPtr(ST(3), &argp4,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMUserDataHandler, 0 |  0 );
    if (!SWIG_IsOK(res4)) {
      SWIG_exception_fail(SWIG_ArgError(res4), "in method '" "DOMNode_setUserData" "', argument " "4"" of type '" "XERCES_CPP_NAMESPACE::DOMUserDataHandler *""'"); 
    }
    arg4 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMUserDataHandler * >(argp4);
    {
      try 
      {
        result = (void *)(arg1)->setUserData((XMLCh const *)arg2,arg3,arg4);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_void, 0 | 0); argvi++ ;
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_getUserData) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    void *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMNode_getUserData(self,key);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_getUserData" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMNode_getUserData");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (void *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getUserData((XMLCh const *)arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_void, 0 | 0); argvi++ ;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_getBaseURI) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_getBaseURI(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_getBaseURI" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getBaseURI();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_compareTreePosition) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *arg2 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    short result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMNode_compareTreePosition(self,other);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_compareTreePosition" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DOMNode_compareTreePosition" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp2);
    {
      try 
      {
        result = (short)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->compareTreePosition((XERCES_CPP_NAMESPACE::DOMNode const *)arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_From_short  SWIG_PERL_CALL_ARGS_1(static_cast< short >(result)); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_getTextContent) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_getTextContent(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_getTextContent" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->getTextContent();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_setTextContent) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMNode_setTextContent(self,textContent);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_setTextContent" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMNode_setTextContent");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setTextContent((XMLCh const *)arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_lookupNamespacePrefix) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    bool arg3 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    bool val3 ;
    int ecode3 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: DOMNode_lookupNamespacePrefix(self,namespaceURI,useDefault);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_lookupNamespacePrefix" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMNode_lookupNamespacePrefix");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    ecode3 = SWIG_AsVal_bool SWIG_PERL_CALL_ARGS_2(ST(2), &val3);
    if (!SWIG_IsOK(ecode3)) {
      SWIG_exception_fail(SWIG_ArgError(ecode3), "in method '" "DOMNode_lookupNamespacePrefix" "', argument " "3"" of type '" "bool""'");
    } 
    arg3 = static_cast< bool >(val3);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->lookupNamespacePrefix((XMLCh const *)arg2,arg3);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    
    delete[] arg2;
    
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_isDefaultNamespace) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMNode_isDefaultNamespace(self,namespaceURI);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_isDefaultNamespace" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMNode_isDefaultNamespace");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->isDefaultNamespace((XMLCh const *)arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_lookupNamespaceURI) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMNode_lookupNamespaceURI(self,prefix);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_lookupNamespaceURI" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMNode_lookupNamespaceURI");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMNode const *)arg1)->lookupNamespaceURI((XMLCh const *)arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_getInterface) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMNode_getInterface(self,feature);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_getInterface" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMNode_getInterface");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMNode *)(arg1)->getInterface((XMLCh const *)arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIG_TypeDynamicCast(SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, SWIG_as_voidptrptr(&result)), 0 | SWIG_SHADOW); argvi++ ;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode_release) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMNode_release(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode_release" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    {
      try 
      {
        (arg1)->release();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode___eq__) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *arg2 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMNode___eq__(self,other);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode___eq__" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DOMNode___eq__" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp2);
    {
      try 
      {
        result = (bool)XERCES_CPP_NAMESPACE_DOMNode_operator_Se__Se_(arg1,(XERCES_CPP_NAMESPACE::DOMNode const *)arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMNode___ne__) {
  {
    XERCES_CPP_NAMESPACE::DOMNode *arg1 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNode *arg2 = (XERCES_CPP_NAMESPACE::DOMNode *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMNode___ne__(self,other);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMNode___ne__" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMNode *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNode, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DOMNode___ne__" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DOMNode const *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMNode * >(argp2);
    {
      try 
      {
        result = (bool)XERCES_CPP_NAMESPACE_DOMNode_operator_SN__Se_(arg1,(XERCES_CPP_NAMESPACE::DOMNode const *)arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_DOMAttr) {
  {
    XERCES_CPP_NAMESPACE::DOMAttr *arg1 = (XERCES_CPP_NAMESPACE::DOMAttr *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_DOMAttr(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_DOMAttr" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMAttr *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMAttr * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMAttr_getName) {
  {
    XERCES_CPP_NAMESPACE::DOMAttr *arg1 = (XERCES_CPP_NAMESPACE::DOMAttr *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMAttr_getName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMAttr_getName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMAttr const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMAttr * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMAttr const *)arg1)->getName();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMAttr_getSpecified) {
  {
    XERCES_CPP_NAMESPACE::DOMAttr *arg1 = (XERCES_CPP_NAMESPACE::DOMAttr *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMAttr_getSpecified(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMAttr_getSpecified" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMAttr const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMAttr * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::DOMAttr const *)arg1)->getSpecified();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMAttr_getValue) {
  {
    XERCES_CPP_NAMESPACE::DOMAttr *arg1 = (XERCES_CPP_NAMESPACE::DOMAttr *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMAttr_getValue(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMAttr_getValue" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMAttr const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMAttr * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMAttr const *)arg1)->getValue();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMAttr_setValue) {
  {
    XERCES_CPP_NAMESPACE::DOMAttr *arg1 = (XERCES_CPP_NAMESPACE::DOMAttr *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMAttr_setValue(self,value);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMAttr_setValue" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMAttr *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMAttr * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMAttr_setValue");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->setValue((XMLCh const *)arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMAttr_getOwnerElement) {
  {
    XERCES_CPP_NAMESPACE::DOMAttr *arg1 = (XERCES_CPP_NAMESPACE::DOMAttr *) 0 ;
    XERCES_CPP_NAMESPACE::DOMElement *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMAttr_getOwnerElement(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMAttr_getOwnerElement" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMAttr const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMAttr * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMElement *)((XERCES_CPP_NAMESPACE::DOMAttr const *)arg1)->getOwnerElement();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement, 0 | SWIG_SHADOW); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMAttr_isId) {
  {
    XERCES_CPP_NAMESPACE::DOMAttr *arg1 = (XERCES_CPP_NAMESPACE::DOMAttr *) 0 ;
    bool result;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMAttr_isId(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMAttr_isId" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMAttr const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMAttr * >(argp1);
    {
      try 
      {
        result = (bool)((XERCES_CPP_NAMESPACE::DOMAttr const *)arg1)->isId();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_From_bool  SWIG_PERL_CALL_ARGS_1(static_cast< bool >(result)); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMAttr_getTypeInfo) {
  {
    XERCES_CPP_NAMESPACE::DOMAttr *arg1 = (XERCES_CPP_NAMESPACE::DOMAttr *) 0 ;
    XERCES_CPP_NAMESPACE::DOMTypeInfo *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMAttr_getTypeInfo(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMAttr_getTypeInfo" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMAttr const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMAttr * >(argp1);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMTypeInfo *)((XERCES_CPP_NAMESPACE::DOMAttr const *)arg1)->getTypeInfo();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMTypeInfo, 0 | 0); argvi++ ;
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_delete_DOMElement) {
  {
    XERCES_CPP_NAMESPACE::DOMElement *arg1 = (XERCES_CPP_NAMESPACE::DOMElement *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: delete_DOMElement(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement, SWIG_POINTER_DISOWN |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "delete_DOMElement" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMElement *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMElement * >(argp1);
    {
      try 
      {
        delete arg1;
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMElement_getTagName) {
  {
    XERCES_CPP_NAMESPACE::DOMElement *arg1 = (XERCES_CPP_NAMESPACE::DOMElement *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 1) || (items > 1)) {
      SWIG_croak("Usage: DOMElement_getTagName(self);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMElement_getTagName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMElement const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMElement * >(argp1);
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMElement const *)arg1)->getTagName();
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    XSRETURN(argvi);
  fail:
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMElement_getAttribute) {
  {
    XERCES_CPP_NAMESPACE::DOMElement *arg1 = (XERCES_CPP_NAMESPACE::DOMElement *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMElement_getAttribute(self,name);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMElement_getAttribute" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMElement const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMElement * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMElement_getAttribute");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMElement const *)arg1)->getAttribute((XMLCh const *)arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMElement_getAttributeNode) {
  {
    XERCES_CPP_NAMESPACE::DOMElement *arg1 = (XERCES_CPP_NAMESPACE::DOMElement *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    XERCES_CPP_NAMESPACE::DOMAttr *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMElement_getAttributeNode(self,name);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMElement_getAttributeNode" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMElement const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMElement * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMElement_getAttributeNode");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMAttr *)((XERCES_CPP_NAMESPACE::DOMElement const *)arg1)->getAttributeNode((XMLCh const *)arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr, 0 | SWIG_SHADOW); argvi++ ;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMElement_getElementsByTagName) {
  {
    XERCES_CPP_NAMESPACE::DOMElement *arg1 = (XERCES_CPP_NAMESPACE::DOMElement *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    XERCES_CPP_NAMESPACE::DOMNodeList *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMElement_getElementsByTagName(self,name);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMElement_getElementsByTagName" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMElement const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMElement * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMElement_getElementsByTagName");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMNodeList *)((XERCES_CPP_NAMESPACE::DOMElement const *)arg1)->getElementsByTagName((XMLCh const *)arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMNodeList, 0 | SWIG_SHADOW); argvi++ ;
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMElement_setAttribute) {
  {
    XERCES_CPP_NAMESPACE::DOMElement *arg1 = (XERCES_CPP_NAMESPACE::DOMElement *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    XMLCh *arg3 = (XMLCh *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: DOMElement_setAttribute(self,name,value);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMElement_setAttribute" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMElement *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMElement * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMElement_setAttribute");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"DOMElement_setAttribute");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    {
      try 
      {
        (arg1)->setAttribute((XMLCh const *)arg2,(XMLCh const *)arg3);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMElement_setAttributeNode) {
  {
    XERCES_CPP_NAMESPACE::DOMElement *arg1 = (XERCES_CPP_NAMESPACE::DOMElement *) 0 ;
    XERCES_CPP_NAMESPACE::DOMAttr *arg2 = (XERCES_CPP_NAMESPACE::DOMAttr *) 0 ;
    XERCES_CPP_NAMESPACE::DOMAttr *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMElement_setAttributeNode(self,newAttr);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMElement_setAttributeNode" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMElement *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMElement * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DOMElement_setAttributeNode" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DOMAttr *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMAttr * >(argp2);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMAttr *)(arg1)->setAttributeNode(arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr, 0 | SWIG_SHADOW); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMElement_removeAttributeNode) {
  {
    XERCES_CPP_NAMESPACE::DOMElement *arg1 = (XERCES_CPP_NAMESPACE::DOMElement *) 0 ;
    XERCES_CPP_NAMESPACE::DOMAttr *arg2 = (XERCES_CPP_NAMESPACE::DOMAttr *) 0 ;
    XERCES_CPP_NAMESPACE::DOMAttr *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    void *argp2 = 0 ;
    int res2 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMElement_removeAttributeNode(self,oldAttr);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMElement_removeAttributeNode" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMElement *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMElement * >(argp1);
    res2 = SWIG_ConvertPtr(ST(1), &argp2,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr, 0 |  0 );
    if (!SWIG_IsOK(res2)) {
      SWIG_exception_fail(SWIG_ArgError(res2), "in method '" "DOMElement_removeAttributeNode" "', argument " "2"" of type '" "XERCES_CPP_NAMESPACE::DOMAttr *""'"); 
    }
    arg2 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMAttr * >(argp2);
    {
      try 
      {
        result = (XERCES_CPP_NAMESPACE::DOMAttr *)(arg1)->removeAttributeNode(arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    ST(argvi) = SWIG_NewPointerObj(SWIG_as_voidptr(result), SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMAttr, 0 | SWIG_SHADOW); argvi++ ;
    
    
    XSRETURN(argvi);
  fail:
    
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMElement_removeAttribute) {
  {
    XERCES_CPP_NAMESPACE::DOMElement *arg1 = (XERCES_CPP_NAMESPACE::DOMElement *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 2) || (items > 2)) {
      SWIG_croak("Usage: DOMElement_removeAttribute(self,name);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMElement_removeAttribute" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMElement *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMElement * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMElement_removeAttribute");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    {
      try 
      {
        (arg1)->removeAttribute((XMLCh const *)arg2);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMElement_getAttributeNS) {
  {
    XERCES_CPP_NAMESPACE::DOMElement *arg1 = (XERCES_CPP_NAMESPACE::DOMElement *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    XMLCh *arg3 = (XMLCh *) 0 ;
    XMLCh *result = 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: DOMElement_getAttributeNS(self,namespaceURI,localName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMElement_getAttributeNS" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMElement const *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMElement * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMElement_getAttributeNS");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"DOMElement_getAttributeNS");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    {
      try 
      {
        result = (XMLCh *)((XERCES_CPP_NAMESPACE::DOMElement const *)arg1)->getAttributeNS((XMLCh const *)arg2,(XMLCh const *)arg3);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    ST(argvi) = XMLString2Perl(result);
    ++argvi;
    
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMElement_setAttributeNS) {
  {
    XERCES_CPP_NAMESPACE::DOMElement *arg1 = (XERCES_CPP_NAMESPACE::DOMElement *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    XMLCh *arg3 = (XMLCh *) 0 ;
    XMLCh *arg4 = (XMLCh *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 4) || (items > 4)) {
      SWIG_croak("Usage: DOMElement_setAttributeNS(self,namespaceURI,qualifiedName,value);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMElement_setAttributeNS" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMElement *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMElement * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMElement_setAttributeNS");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"DOMElement_setAttributeNS");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    
    if (ST(3) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",4,"DOMElement_setAttributeNS");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg4 = Perl2XMLString(ST(3));
    }
    
    {
      try 
      {
        (arg1)->setAttributeNS((XMLCh const *)arg2,(XMLCh const *)arg3,(XMLCh const *)arg4);
        
      } 
      CATCH_DOM_EXCEPTION
    }
    
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    XSRETURN(argvi);
  fail:
    
    
    delete[] arg2;
    
    
    delete[] arg3;
    
    
    delete[] arg4;
    
    SWIG_croak_null();
  }
}


XS(_wrap_DOMElement_removeAttributeNS) {
  {
    XERCES_CPP_NAMESPACE::DOMElement *arg1 = (XERCES_CPP_NAMESPACE::DOMElement *) 0 ;
    XMLCh *arg2 = (XMLCh *) 0 ;
    XMLCh *arg3 = (XMLCh *) 0 ;
    void *argp1 = 0 ;
    int res1 = 0 ;
    int argvi = 0;
    dXSARGS;
    
    if ((items < 3) || (items > 3)) {
      SWIG_croak("Usage: DOMElement_removeAttributeNS(self,namespaceURI,localName);");
    }
    res1 = SWIG_ConvertPtr(ST(0), &argp1,SWIGTYPE_p_XERCES_CPP_NAMESPACE__DOMElement, 0 |  0 );
    if (!SWIG_IsOK(res1)) {
      SWIG_exception_fail(SWIG_ArgError(res1), "in method '" "DOMElement_removeAttributeNS" "', argument " "1"" of type '" "XERCES_CPP_NAMESPACE::DOMElement *""'"); 
    }
    arg1 = reinterpret_cast< XERCES_CPP_NAMESPACE::DOMElement * >(argp1);
    
    if (ST(1) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",2,"DOMElement_removeAttributeNS");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg2 = Perl2XMLString(ST(1));
    }
    
    
    if (ST(2) == &PL_sv_undef) {
      SWIG_Perl_NullRef("perl-string",3,"DOMElement_removeAttributeNS");
      goto fail;
    } else {
      // we convert *everything* into a string that isn't undef
      arg3 = Perl2XMLString(ST(2));
    }
    
    {
      try 
      {
        (arg1)->removeAttributeNS((XMLCh const *)arg2,(XMLCh con