/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;
import org.openqa.selenium.Platform;

public class ExecutableFinder {
    private static final ImmutableSet<String> ENDINGS = Platform.getCurrent().is(Platform.WINDOWS) ? ImmutableSet.of("", ".cmd", ".exe", ".com", ".bat") : ImmutableSet.of("");
    private final ImmutableSet.Builder<String> pathSegmentBuilder = new ImmutableSet.Builder();

    public String find(String named) {
        File file = new File(named);
        if (ExecutableFinder.canExecute(file)) {
            return named;
        }
        if (Platform.getCurrent().is(Platform.WINDOWS) && ExecutableFinder.canExecute(file = new File(named + ".exe"))) {
            return named + ".exe";
        }
        this.addPathFromEnvironment();
        if (Platform.getCurrent().is(Platform.MAC)) {
            this.addMacSpecificPath();
        }
        for (String pathSegment : this.pathSegmentBuilder.build()) {
            for (String ending : ENDINGS) {
                file = new File(pathSegment, named + ending);
                if (!ExecutableFinder.canExecute(file)) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    private void addPathFromEnvironment() {
        String path;
        String pathName = "PATH";
        Map<String, String> env = System.getenv();
        if (!env.containsKey(pathName)) {
            for (String key : env.keySet()) {
                if (!pathName.equalsIgnoreCase(key)) continue;
                pathName = key;
                break;
            }
        }
        if ((path = env.get(pathName)) != null) {
            this.pathSegmentBuilder.add(path.split(File.pathSeparator));
        }
    }

    private void addMacSpecificPath() {
        File pathFile = new File("/etc/paths");
        if (pathFile.exists()) {
            try {
                this.pathSegmentBuilder.addAll(Files.readAllLines(pathFile.toPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static boolean canExecute(File file) {
        return file.exists() && !file.isDirectory() && file.canExecute();
    }
}

