# Generated by default/object.tt
package Paws::SageMaker::RedshiftDatasetDefinition;
  use Moose;
  has ClusterId => (is => 'ro', isa => 'Str', required => 1);
  has ClusterRoleArn => (is => 'ro', isa => 'Str', required => 1);
  has Database => (is => 'ro', isa => 'Str', required => 1);
  has DbUser => (is => 'ro', isa => 'Str', required => 1);
  has KmsKeyId => (is => 'ro', isa => 'Str');
  has OutputCompression => (is => 'ro', isa => 'Str');
  has OutputFormat => (is => 'ro', isa => 'Str', required => 1);
  has OutputS3Uri => (is => 'ro', isa => 'Str', required => 1);
  has QueryString => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::RedshiftDatasetDefinition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::RedshiftDatasetDefinition object:

  $service_obj->Method(Att1 => { ClusterId => $value, ..., QueryString => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::RedshiftDatasetDefinition object:

  $result = $service_obj->Method(...);
  $result->Att1->ClusterId

=head1 DESCRIPTION

Configuration for Redshift Dataset Definition input.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ClusterId => Str




=head2 B<REQUIRED> ClusterRoleArn => Str

The IAM role attached to your Redshift cluster that Amazon SageMaker
uses to generate datasets.


=head2 B<REQUIRED> Database => Str




=head2 B<REQUIRED> DbUser => Str




=head2 KmsKeyId => Str

The Amazon Web Services Key Management Service (Amazon Web Services
KMS) key that Amazon SageMaker uses to encrypt data from a Redshift
execution.


=head2 OutputCompression => Str




=head2 B<REQUIRED> OutputFormat => Str




=head2 B<REQUIRED> OutputS3Uri => Str

The location in Amazon S3 where the Redshift query results are stored.


=head2 B<REQUIRED> QueryString => Str





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

