# Generated by default/object.tt
package Paws::WAFV2::FieldToMatch;
  use Moose;
  has AllQueryArguments => (is => 'ro', isa => 'Paws::WAFV2::AllQueryArguments');
  has Body => (is => 'ro', isa => 'Paws::WAFV2::Body');
  has JsonBody => (is => 'ro', isa => 'Paws::WAFV2::JsonBody');
  has Method => (is => 'ro', isa => 'Paws::WAFV2::Method');
  has QueryString => (is => 'ro', isa => 'Paws::WAFV2::QueryString');
  has SingleHeader => (is => 'ro', isa => 'Paws::WAFV2::SingleHeader');
  has SingleQueryArgument => (is => 'ro', isa => 'Paws::WAFV2::SingleQueryArgument');
  has UriPath => (is => 'ro', isa => 'Paws::WAFV2::UriPath');

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::FieldToMatch

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::FieldToMatch object:

  $service_obj->Method(Att1 => { AllQueryArguments => $value, ..., UriPath => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::FieldToMatch object:

  $result = $service_obj->Method(...);
  $result->Att1->AllQueryArguments

=head1 DESCRIPTION

The part of a web request that you want WAF to inspect. Include the
single C<FieldToMatch> type that you want to inspect, with additional
specifications as needed, according to the type. You specify a single
request component in C<FieldToMatch> for each rule statement that
requires it. To inspect more than one component of a web request,
create a separate rule statement for each component.

=head1 ATTRIBUTES


=head2 AllQueryArguments => L<Paws::WAFV2::AllQueryArguments>

Inspect all query arguments.


=head2 Body => L<Paws::WAFV2::Body>

Inspect the request body as plain text. The request body immediately
follows the request headers. This is the part of a request that
contains any additional data that you want to send to your web server
as the HTTP request body, such as data from a form.

Note that only the first 8 KB (8192 bytes) of the request body are
forwarded to WAF for inspection by the underlying host service. If you
don't need to inspect more than 8 KB, you can guarantee that you don't
allow additional bytes in by combining a statement that inspects the
body of the web request, such as ByteMatchStatement or
RegexPatternSetReferenceStatement, with a SizeConstraintStatement that
enforces an 8 KB size limit on the body of the request. WAF doesn't
support inspecting the entire contents of web requests whose bodies
exceed the 8 KB limit.


=head2 JsonBody => L<Paws::WAFV2::JsonBody>

Inspect the request body as JSON. The request body immediately follows
the request headers. This is the part of a request that contains any
additional data that you want to send to your web server as the HTTP
request body, such as data from a form.

Note that only the first 8 KB (8192 bytes) of the request body are
forwarded to WAF for inspection by the underlying host service. If you
don't need to inspect more than 8 KB, you can guarantee that you don't
allow additional bytes in by combining a statement that inspects the
body of the web request, such as ByteMatchStatement or
RegexPatternSetReferenceStatement, with a SizeConstraintStatement that
enforces an 8 KB size limit on the body of the request. WAF doesn't
support inspecting the entire contents of web requests whose bodies
exceed the 8 KB limit.


=head2 Method => L<Paws::WAFV2::Method>

Inspect the HTTP method. The method indicates the type of operation
that the request is asking the origin to perform.


=head2 QueryString => L<Paws::WAFV2::QueryString>

Inspect the query string. This is the part of a URL that appears after
a C<?> character, if any.


=head2 SingleHeader => L<Paws::WAFV2::SingleHeader>

Inspect a single header. Provide the name of the header to inspect, for
example, C<User-Agent> or C<Referer>. This setting isn't case
sensitive.

Example JSON: C<"SingleHeader": { "Name": "haystack" }>


=head2 SingleQueryArgument => L<Paws::WAFV2::SingleQueryArgument>

Inspect a single query argument. Provide the name of the query argument
to inspect, such as I<UserName> or I<SalesRegion>. The name can be up
to 30 characters long and isn't case sensitive.

This is used only to indicate the web request component for WAF to
inspect, in the FieldToMatch specification.

Example JSON: C<"SingleQueryArgument": { "Name": "myArgument" }>


=head2 UriPath => L<Paws::WAFV2::UriPath>

Inspect the request URI path. This is the part of a web request that
identifies a resource, for example, C</images/daily-ad.jpg>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

