package Wikibase::Datatype::Print;

use strict;
use warnings;

our $VERSION = 0.10;

1;

__END__

=pod

=encoding utf8

=head1 NAME

Wikibase::Datatype::Print - Wikibase datatype print helpers.

=head1 DESCRIPTION

This distributions is set of print helpers for Wikibase::Datatype objects.

=head1 SEE ALSO

=over

=item L<Wikibase::Datatype::Print::Form>

Wikibase form pretty print helpers.

=item L<Wikibase::Datatype::Print::Item>

TODO

=item L<Wikibase::Datatype::Print::Lexeme>

Wikibase lexeme pretty print helpers.

=item L<Wikibase::Datatype::Print::Mediainfo>

TODO

=item L<Wikibase::Datatype::Print::MediainfoSnak>

Wikibase mediainfo snak pretty print helpers.

=item L<Wikibase::Datatype::Print::MediainfoStatement>

Wikibase mediainfo statement pretty print helpers.

=item L<Wikibase::Datatype::Print::Property>

TODO

=item L<Wikibase::Datatype::Print::Reference>

Wikibase reference pretty print helpers.

=item L<Wikibase::Datatype::Print::Sense>

Wikibase sense pretty print helpers.

=item L<Wikibase::Datatype::Print::Sitelink>

Wikibase sitelink pretty print helpers.

=item L<Wikibase::Datatype::Print::Snak>

Wikibase snak pretty print helpers.

=item L<Wikibase::Datatype::Print::Statement>

Wikibase statement pretty print helpers.

=item L<Wikibase::Datatype::Print::Utils>

Wikibase pretty print helper utils.

=item L<Wikibase::Datatype::Print::Value>

Wikibase value pretty print helpers.

=item L<Wikibase::Datatype::Print::Value::Globecoordinate>

Wikibase globe coordinate item pretty print helpers.

=item L<Wikibase::Datatype::Print::Value::Item>

Wikibase item value pretty print helpers.

=item L<Wikibase::Datatype::Print::Value::Monolingual>

Wikibase monolingual value pretty print helpers.

=item L<Wikibase::Datatype::Print::Value::Property>

Wikibase property value pretty print helpers.

=item L<Wikibase::Datatype::Print::Value::Quantity>

Wikibase quantity value pretty print helpers.

=item L<Wikibase::Datatype::Print::Value::String>

Wikibase string value pretty print helpers.

=item L<Wikibase::Datatype::Print::Value::Time>

Wikibase time value pretty print helpers.

=back

=head1 SEE ALSO

=over

=item L<Wikibase::Datatype>

Wikibase datatypes.

=item L<Wikibase::Datatype::JSON>

Wikibase structure JSON serialization.

=item L<Wikibase::Datatype::Struct>

Wikibase structure serialization.

=back

=head1 REPOSITORY

L<https://github.com/michal-josef-spacek/Wikibase-Datatype-Print>

=head1 AUTHOR

Michal Josef Špaček L<mailto:skim@cpan.org>

L<http://skim.cz>

=head1 LICENSE AND COPYRIGHT

© 2020-2023 Michal Josef Špaček

BSD 2-Clause License

=head1 VERSION

0.10

=cut
