/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import java.util.regex.Pattern;

class ArabicUnknownWordSignatures {
    private static final Pattern adjectivalSuffixPattern = Pattern.compile("[y\u064a][y\u064a](?:[t\u062a]?[n\u0646])?$");
    private static Pattern singularPastTenseSuffixPattern = Pattern.compile("[t\u062a]$");
    private static Pattern pluralFirstPersonPastTenseSuffixPattern = Pattern.compile("[n\u0646][A\u0627]$");
    private static Pattern pluralThirdPersonMasculinePastTenseSuffixPattern = Pattern.compile("[w\u0648]$");
    private static Pattern pluralThirdPersonMasculinePresentTenseSuffixPattern = Pattern.compile("[w\u0648][\u0646n]$");
    private static Pattern taaMarbuuTaSuffixPattern = Pattern.compile("[\u0629p]$");
    private static Pattern abstractionNounSuffixPattern = Pattern.compile("[y\u064a][p\u0629]$");
    private static Pattern masdarPrefixPattern = Pattern.compile("^[t\u062a]");

    ArabicUnknownWordSignatures() {
    }

    static boolean allDigitPlus(String word) {
        boolean allDigitPlus = true;
        boolean seenDigit = false;
        int wlen = word.length();
        for (int i = 0; i < wlen; ++i) {
            char ch = word.charAt(i);
            if (Character.isDigit(ch)) {
                seenDigit = true;
                continue;
            }
            if (ch == '-' || ch == '.' || ch == ',' || ch == '\u066b' || ch == '\u066c' || ch == '\u2212') continue;
            allDigitPlus = false;
        }
        return allDigitPlus && seenDigit;
    }

    static String likelyAdjectivalSuffix(String word) {
        if (adjectivalSuffixPattern.matcher(word).find()) {
            return "-AdjSuffix";
        }
        return "";
    }

    static String pastTenseVerbNumberSuffix(String word) {
        if (singularPastTenseSuffixPattern.matcher(word).find()) {
            return "-PV.sg";
        }
        if (pluralFirstPersonPastTenseSuffixPattern.matcher(word).find()) {
            return "-PV.pl1";
        }
        if (pluralThirdPersonMasculinePastTenseSuffixPattern.matcher(word).find()) {
            return "-PV.pl3m";
        }
        return "";
    }

    static String presentTenseVerbNumberSuffix(String word) {
        return pluralThirdPersonMasculinePresentTenseSuffixPattern.matcher(word).find() ? "-IV.pl3m" : "";
    }

    static String taaMarbuuTaSuffix(String word) {
        return taaMarbuuTaSuffixPattern.matcher(word).find() ? "-taaMarbuuTa" : "";
    }

    static String abstractionNounSuffix(String word) {
        return abstractionNounSuffixPattern.matcher(word).find() ? "-AbstractionSuffix" : "";
    }

    static String masdarPrefix(String word) {
        return masdarPrefixPattern.matcher(word).find() ? "-maSdr" : "";
    }
}

