# Generated by default/object.tt
package Paws::IoTSiteWise::Identity;
  use Moose;
  has Group => (is => 'ro', isa => 'Paws::IoTSiteWise::GroupIdentity', request_name => 'group', traits => ['NameInRequest']);
  has IamRole => (is => 'ro', isa => 'Paws::IoTSiteWise::IAMRoleIdentity', request_name => 'iamRole', traits => ['NameInRequest']);
  has IamUser => (is => 'ro', isa => 'Paws::IoTSiteWise::IAMUserIdentity', request_name => 'iamUser', traits => ['NameInRequest']);
  has User => (is => 'ro', isa => 'Paws::IoTSiteWise::UserIdentity', request_name => 'user', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::Identity

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::Identity object:

  $service_obj->Method(Att1 => { Group => $value, ..., User => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::Identity object:

  $result = $service_obj->Method(...);
  $result->Att1->Group

=head1 DESCRIPTION

Contains an identity that can access an AWS IoT SiteWise Monitor
resource.

Currently, you can't use AWS APIs to retrieve AWS SSO identity IDs. You
can find the AWS SSO identity IDs in the URL of user and group pages in
the AWS SSO console (https://console.aws.amazon.com/singlesignon).

=head1 ATTRIBUTES


=head2 Group => L<Paws::IoTSiteWise::GroupIdentity>

An AWS SSO group identity.


=head2 IamRole => L<Paws::IoTSiteWise::IAMRoleIdentity>

An IAM role identity.


=head2 IamUser => L<Paws::IoTSiteWise::IAMUserIdentity>

An IAM user identity.


=head2 User => L<Paws::IoTSiteWise::UserIdentity>

An AWS SSO user identity.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

