package Basic::Types::XS;

use 5.006;
use strict;
use warnings;

our $VERSION = '0.03';

require XSLoader;
XSLoader::load("Basic::Types::XS", $VERSION);

sub import {
	my ($caller, $pkg, @export) = (scalar caller(), @_);
	_install($caller, @export);
}

1;

__END__

=head1 NAME

Basic::Types::XS - The great new Basic::Types::XS!

=head1 VERSION

Version 0.03

=cut

=head1 SYNOPSIS

	use Basic::Types::XS qw/Str/;

	Str->("abc");

	Str->({ a => 1 }); # dies


=head1 EXPORT

=head2 Defined

=head2 Str

=head2 Num

=head2 Int

=head2 Ref

=head2 ScalarRef

=head2 ArrayRef

=head2 HashRef

=cut

=head1 METHODS

=head2 validate

=head1 AUTHOR

LNATION, C<< <email at lnation.org> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-basic-types-xs at rt.cpan.org>, or through
the web interface at L<https://rt.cpan.org/NoAuth/ReportBug.html?Queue=Basic-Types-XS>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.


=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Basic::Types::XS


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<https://rt.cpan.org/NoAuth/Bugs.html?Dist=Basic-Types-XS>

=item * Search CPAN

L<https://metacpan.org/release/Basic-Types-XS>

=back


=head1 ACKNOWLEDGEMENTS


=head1 LICENSE AND COPYRIGHT

This software is Copyright (c) 2025 by LNATION.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)


=cut

1; # End of Basic::Types::XS
