# Generated by default/object.tt
package Paws::SecurityHub::IcmpTypeCode;
  use Moose;
  has Code => (is => 'ro', isa => 'Int');
  has Type => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::IcmpTypeCode

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::IcmpTypeCode object:

  $service_obj->Method(Att1 => { Code => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::IcmpTypeCode object:

  $result = $service_obj->Method(...);
  $result->Att1->Code

=head1 DESCRIPTION

An Internet Control Message Protocol (ICMP) type and code.

=head1 ATTRIBUTES


=head2 Code => Int

The ICMP code for which to deny or allow access. To deny or allow all
codes, use the value -1.


=head2 Type => Int

The ICMP type for which to deny or allow access. To deny or allow all
types, use the value -1.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

