/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.couchbase.mock.BucketConfiguration;
import org.couchbase.mock.CouchbaseBucket;
import org.couchbase.mock.CouchbaseMock;
import org.couchbase.mock.MemcachedBucket;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.VBucketInfo;

public abstract class Bucket {
    protected final VBucketInfo[] vbInfo;
    protected final MemcachedServer[] servers;
    protected final int numVBuckets;
    protected final int numReplicas;
    protected final String poolName = "default";
    protected final String name;
    protected final CouchbaseMock cluster;
    protected final String password;
    protected final ReentrantReadWriteLock configurationRwLock;
    private final UUID uuid;

    public String getBucketUri() {
        return "/pools/default/bucketsStreaming/" + this.name;
    }

    public VBucketInfo[] getVBucketInfo() {
        return this.vbInfo;
    }

    public MemcachedServer[] getServers() {
        return this.servers;
    }

    public short getVbIndexForKey(String key) {
        return -1;
    }

    public Bucket(CouchbaseMock cluster, BucketConfiguration config) throws IOException {
        int ii;
        if (config.numVBuckets < 0) {
            throw new IllegalArgumentException("Vbucket count must be > 0");
        }
        if ((config.numVBuckets & config.numVBuckets - 1) != 0) {
            throw new IllegalArgumentException("vBucket count must be a power of 2");
        }
        this.cluster = cluster;
        this.name = config.name;
        this.numVBuckets = config.numVBuckets;
        this.numReplicas = config.numReplicas;
        this.password = config.password;
        this.vbInfo = new VBucketInfo[this.numVBuckets];
        this.servers = new MemcachedServer[config.numNodes];
        this.uuid = UUID.randomUUID();
        this.configurationRwLock = new ReentrantReadWriteLock();
        for (ii = 0; ii < this.vbInfo.length; ++ii) {
            this.vbInfo[ii] = new VBucketInfo();
        }
        if (this.getClass() != MemcachedBucket.class && this.getClass() != CouchbaseBucket.class) {
            throw new FileNotFoundException("I don't know about this type...");
        }
        for (ii = 0; ii < this.servers.length; ++ii) {
            this.servers[ii] = new MemcachedServer(this, config.hostname, config.bucketStartPort == 0 ? 0 : config.bucketStartPort + ii, this.vbInfo);
        }
        this.rebalance();
    }

    public static Bucket create(CouchbaseMock mock, BucketConfiguration config) throws IOException {
        switch (config.type) {
            case MEMCACHED: {
                return new MemcachedBucket(mock, config);
            }
            case COUCHBASE: {
                return new CouchbaseBucket(mock, config);
            }
        }
        throw new FileNotFoundException("I don't know about this type...");
    }

    public abstract BucketType getType();

    public abstract String getJSON();

    public void configReadLock() {
        this.configurationRwLock.readLock().lock();
    }

    public void configReadUnlock() {
        this.configurationRwLock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failSome(float percentage) {
        this.configurationRwLock.writeLock().lock();
        try {
            for (int ii = 0; ii < this.servers.length; ++ii) {
                if ((float)ii % percentage != 0.0f) continue;
                this.servers[ii].shutdown();
            }
        }
        finally {
            this.configurationRwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fixSome(float percentage) {
        this.configurationRwLock.writeLock().lock();
        try {
            for (int ii = 0; ii < this.servers.length; ++ii) {
                if ((float)ii % percentage != 0.0f) continue;
                this.servers[ii].startup();
            }
        }
        finally {
            this.configurationRwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failover(int index) {
        this.configurationRwLock.writeLock().lock();
        try {
            if (index >= 0 && index < this.servers.length) {
                this.servers[index].shutdown();
            }
            this.rebalance();
        }
        finally {
            this.configurationRwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void respawn(int index) {
        this.configurationRwLock.writeLock().lock();
        try {
            if (index >= 0 && index < this.servers.length) {
                this.servers[index].startup();
            }
            this.rebalance();
        }
        finally {
            this.configurationRwLock.writeLock().unlock();
        }
    }

    void start(List<Thread> threads) {
        for (int ii = 0; ii < this.servers.length; ++ii) {
            Thread t = new Thread((Runnable)this.servers[ii], "mock memcached " + ii);
            t.setDaemon(true);
            t.start();
            threads.add(t);
        }
    }

    public List<MemcachedServer> activeServers() {
        ArrayList<MemcachedServer> active = new ArrayList<MemcachedServer>(this.servers.length);
        for (MemcachedServer server : this.servers) {
            if (!server.isActive()) continue;
            active.add(server);
        }
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void rebalance() {
        this.configurationRwLock.writeLock().lock();
        try {
            List<MemcachedServer> nodes = this.activeServers();
            for (int ii = 0; ii < this.numVBuckets; ++ii) {
                Collections.shuffle(nodes);
                this.vbInfo[ii].setOwner(nodes.get(0));
                if (nodes.size() < 2) continue;
                List<MemcachedServer> replicas = nodes.subList(1, nodes.size());
                if (replicas.size() > this.numReplicas) {
                    replicas = replicas.subList(0, this.numReplicas);
                }
                this.vbInfo[ii].setReplicas(replicas);
            }
        }
        finally {
            this.configurationRwLock.writeLock().unlock();
        }
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.name;
    }

    public String getUUID() {
        return this.uuid.toString();
    }

    public CouchbaseMock getCluster() {
        return this.cluster;
    }

    public static enum BucketType {
        MEMCACHED,
        COUCHBASE;

    }
}

