/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.SingletonItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonIterator<T extends Item>
implements SequenceIterator<T>,
UnfailingIterator<T>,
ReversibleIterator<T>,
LastPositionFinder<T>,
GroundedIterator<T>,
LookaheadIterator<T> {
    private T item;
    private int position = 0;

    private SingletonIterator(T value) {
        this.item = value;
    }

    public static <T extends Item> UnfailingIterator<T> makeIterator(T item) {
        if (item == null) {
            return EmptyIterator.emptyIterator();
        }
        return new SingletonIterator<T>(item);
    }

    @Override
    public boolean hasNext() {
        return this.position == 0;
    }

    @Override
    public T next() {
        if (this.position == 0) {
            this.position = 1;
            return this.item;
        }
        if (this.position == 1) {
            this.position = -1;
            return null;
        }
        return null;
    }

    @Override
    public T current() {
        if (this.position == 1) {
            return this.item;
        }
        return null;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public void close() {
    }

    @Override
    public SingletonIterator<T> getAnother() {
        return new SingletonIterator<T>(this.item);
    }

    @Override
    public SingletonIterator<T> getReverseIterator() {
        return new SingletonIterator<T>(this.item);
    }

    public T getValue() {
        return this.item;
    }

    @Override
    public GroundedValue materialize() {
        if (this.item instanceof GroundedValue) {
            return (GroundedValue)this.item;
        }
        return new SingletonItem<T>(this.item);
    }

    @Override
    public int getProperties() {
        return 7;
    }
}

