/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.preprocess.namefind;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import opennlp.common.util.ObjectIntPair;
import opennlp.common.util.Pair;
import opennlp.grok.preprocess.namefind.NFContextGenerator;
import opennlp.maxent.ContextGenerator;
import opennlp.maxent.Event;
import opennlp.maxent.EventCollector;

public class NFEventCollector
implements EventCollector {
    private BufferedReader br;
    private ContextGenerator cg = new NFContextGenerator();

    public NFEventCollector(Reader data) {
        this.br = new BufferedReader(data);
    }

    public static Pair convertAnnotatedString(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<String> outcomes = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str);
        boolean inName = false;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("{@")) {
                outcomes.add("T");
                tokens.add(st.nextToken());
                inName = true;
                continue;
            }
            if (tok.equals("@}")) {
                inName = false;
                continue;
            }
            if (inName) {
                outcomes.add("T");
                tokens.add(tok);
                continue;
            }
            outcomes.add("F");
            tokens.add(tok);
        }
        return new Pair(tokens, outcomes);
    }

    public Event[] getEvents() {
        return this.getEvents(false);
    }

    public Event[] getEvents(boolean evalMode) {
        ArrayList<Event> elist = new ArrayList<Event>();
        try {
            String s = this.br.readLine();
            while (s != null) {
                Pair p = NFEventCollector.convertAnnotatedString(s);
                ArrayList tokenList = (ArrayList)p.a;
                String[] tokens = new String[tokenList.size()];
                tokenList.toArray(tokens);
                ArrayList outcomes = (ArrayList)p.b;
                int i = 0;
                while (i < tokens.length) {
                    String[] context = this.cg.getContext((Object)new ObjectIntPair((Object)tokens, i));
                    Event e = new Event((String)outcomes.get(i), context);
                    elist.add(e);
                    ++i;
                }
                s = this.br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Event[] events = new Event[elist.size()];
        int i = 0;
        while (i < events.length) {
            events[i] = (Event)elist.get(i);
            ++i;
        }
        return events;
    }
}

