#!/usr/bin/perl

package eBay::API::XML::DataType::ThemeGroupType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ThemeGroupType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ThemeGroupType

=head1 DESCRIPTION

Data for one theme group. Returned for GetDescriptionTemplates
if theme groups are requested.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ThemeGroupType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'GroupID', 'xs:int', '', '', '' ]
	, [ 'GroupName', 'xs:string', '', '', '' ]
	, [ 'ThemeID', 'xs:int', '1', '', '' ]
	, [ 'ThemeTotal', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setGroupID()

Unique identifier for this theme group.

#    Argument: 'xs:int'

=cut

sub setGroupID {
  my $self = shift;
  $self->{'GroupID'} = shift
}

=head2 getGroupID()

  Calls: GetDescriptionTemplates
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getGroupID {
  my $self = shift;
  return $self->{'GroupID'};
}


=head2 setGroupName()

Name of this theme group (localized to the language associated 
with the eBay site).

#    Argument: 'xs:string'

=cut

sub setGroupName {
  my $self = shift;
  $self->{'GroupName'} = shift
}

=head2 getGroupName()

  Calls: GetDescriptionTemplates
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getGroupName {
  my $self = shift;
  return $self->{'GroupName'};
}


=head2 setThemeID()

Unique identifier for each theme in this group. There
is at least one theme in a theme group.

#    Argument: reference to an array  
                      of 'xs:int'

=cut

sub setThemeID {
  my $self = shift;
  $self->{'ThemeID'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getThemeID()

  Calls: GetDescriptionTemplates
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'xs:int'

=cut

sub getThemeID {
  my $self = shift;
  return $self->_getDataTypeArray('ThemeID');
}


=head2 setThemeTotal()

The number of ThemeID elements in this group.

#    Argument: 'xs:int'

=cut

sub setThemeTotal {
  my $self = shift;
  $self->{'ThemeTotal'} = shift
}

=head2 getThemeTotal()

  Calls: GetDescriptionTemplates
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getThemeTotal {
  my $self = shift;
  return $self->{'ThemeTotal'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
