#!/usr/bin/perl

package eBay::API::XML::DataType::NotificationUserDataType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. NotificationUserDataType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::NotificationUserDataType

=head1 DESCRIPTION

User data related to notifications.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::NotificationUserDataType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::SMSSubscriptionType;
use eBay::API::XML::DataType::SummaryEventScheduleType;


my @gaProperties = ( [ 'SMSSubscription', 'ns:SMSSubscriptionType', ''
	     ,'eBay::API::XML::DataType::SMSSubscriptionType', '1' ]
	, [ 'SummarySchedule', 'ns:SummaryEventScheduleType', '1'
	     ,'eBay::API::XML::DataType::SummaryEventScheduleType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setSMSSubscription()

User data related to SMS notifications. SMS is currently reserved for future use.

  Calls: SetNotificationPreferences
  RequiredInput: Conditionally

#    Argument: 'ns:SMSSubscriptionType'

=cut

sub setSMSSubscription {
  my $self = shift;
  $self->{'SMSSubscription'} = shift
}

=head2 getSMSSubscription()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'ns:SMSSubscriptionType'

=cut

sub getSMSSubscription {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SMSSubscription'
		,'eBay::API::XML::DataType::SMSSubscriptionType');
}


=head2 setSummarySchedule()

User account activity summary alert delivery schedule.
Returned if PreferenceLevel is set to UserData in
GetNotificationPreferences.
See "Working with Platform Notifications" for instructions on
"Informational Alerts".

  Calls: SetNotificationPreferences
  RequiredInput: Conditionally

#    Argument: reference to an array  
                      of 'ns:SummaryEventScheduleType'

=cut

sub setSummarySchedule {
  my $self = shift;
  $self->{'SummarySchedule'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getSummarySchedule()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:SummaryEventScheduleType'

=cut

sub getSummarySchedule {
  my $self = shift;
  return $self->_getDataTypeArray('SummarySchedule');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
