/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.hp;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.gcc.AbstractLdLinker;

public final class HPLinker
extends AbstractLdLinker {
    private static final String[] objFiles = new String[]{".o", ".a", ".lib", ".dll", ".so", ".sl"};
    private static final String[] discardFiles = new String[0];
    private static final HPLinker instance = new HPLinker("ld", objFiles, discardFiles, "", "");
    private static final HPLinker dllLinker = new HPLinker("ld", objFiles, discardFiles, "lib", ".sl");
    private static final HPLinker arLinker = new HPLinker("ld", objFiles, discardFiles, "", ".a");
    private File[] libDirs;

    private HPLinker(String command, String[] extensions, String[] ignoredExtensions, String outputPrefix, String outputSuffix) {
        super(command, "-help", extensions, ignoredExtensions, outputPrefix, outputSuffix, false, null);
    }

    public static HPLinker getInstance() {
        return instance;
    }

    public File[] getLibraryPath() {
        if (this.libDirs == null) {
            File compilerLib;
            File CCloc = CUtil.getExecutableLocation("ld");
            if (CCloc != null && (compilerLib = new File(new File(CCloc, "../lib").getAbsolutePath())).exists()) {
                this.libDirs = new File[2];
                this.libDirs[0] = compilerLib;
            }
            if (this.libDirs == null) {
                this.libDirs = new File[1];
            }
        }
        this.libDirs[this.libDirs.length - 1] = new File("/usr/lib");
        return this.libDirs;
    }

    public void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        if (linkType.isSharedLibrary()) {
            args.addElement("-b");
        }
    }

    public Linker getLinker(LinkType type) {
        if (type.isStaticLibrary()) {
            return arLinker;
        }
        if (type.isSharedLibrary()) {
            return dllLinker;
        }
        return instance;
    }

    public void addIncremental(boolean incremental, Vector args) {
    }
}

