/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.51 from the
 * contents of GLUT.xs. Do not edit this file, edit GLUT.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "lib/OpenGL/GLUT.xs"
/*  Copyright (c) 1998 Kenneth Albanowski. All rights reserved.
 *  Copyright (c) 2007 Bob Free. All rights reserved.
 *  Copyright (c) 2009 Chris Marshall. All rights reserved.
 *  Copyright (c) 2015 Bob Free. All rights reserved.
 *  This program is free software; you can redistribute it and/or
 *  modify it under the same terms as Perl itself.
 */

#include <stdio.h>

#include "pgopogl.h"


/* glut_util.h is where you include the appropriate GLUT header
 * file based on what is available.  It also defines some constants
 * that may not be defined everywhere.  Replace this by user
 * specified include information for the include and compile-time
 * perl constants rather than some special cases
 */
#include "glut_util.h"


/* TODO: calculate this from the actual GLUT include file */
#ifndef GLUT_API_VERSION
#define GLUT_API_VERSION 4
#endif

static int _done_glutInit = 0;
static int _done_glutCloseFunc_warn = 0;

/* Macros for GLUT callback and handler declarations */
#  define DO_perl_call_sv(handler, flag) perl_call_sv(handler, flag)
#  define ENSURE_callback_thread
#  define GLUT_PUSH_NEW_SV(sv)		XPUSHs(sv_2mortal(newSVsv(sv)))
#  define GLUT_PUSH_NEW_IV(i)		XPUSHs(sv_2mortal(newSViv(i)))
#  define GLUT_PUSH_NEW_U8(c)		XPUSHs(sv_2mortal(newSViv((int)c)))
#  define GLUT_EXTEND_STACK(sp,n)
#  define GLUT_PUSHMARK(sp)		PUSHMARK(sp)


/* Set up for all the GLUT callback handlers */
static AV * glut_handlers = 0;

/* Attach a handler to a window */
static void set_glut_win_handler(int win, int type, SV * data)
{
	SV ** h;
	AV * a;

	if (!glut_handlers)
		glut_handlers = newAV();

	h = av_fetch(glut_handlers, win, FALSE);

	if (!h) {
		a = newAV();
		av_store(glut_handlers, win, newRV_inc((SV*)a));
		SvREFCNT_dec(a);
	} else if (!SvOK(*h) || !SvROK(*h))
		croak("Unable to establish glut handler");
	else
		a = (AV*)SvRV(*h);

	av_store(a, type, newRV_inc(data));
	SvREFCNT_dec(data);
}

/* Get a window's handler */
static SV * get_glut_win_handler(int win, int type)
{
	SV ** h;

	if (!glut_handlers)
		croak("Unable to locate glut handlers list");

	h = av_fetch(glut_handlers, win, FALSE);

	if (!h || !SvOK(*h) || !SvROK(*h))
		croak("Unable to locate glut handler list for window %d", win);

	h = av_fetch((AV*)SvRV(*h), type, FALSE);

	if (!h || !SvOK(*h) || !SvROK(*h))
		croak("Unable to locate glut handler type=%d for window %d", type, win);

	return SvRV(*h);
}

/* Release a window's handlers */
static void destroy_glut_win_handlers(int win)
{
	SV ** h;
	if (!glut_handlers)
		return;

	h = av_fetch(glut_handlers, win, FALSE);

	if (!h || !SvOK(*h) || !SvROK(*h))
		return;

	av_store(glut_handlers, win, newSVsv(&PL_sv_undef));
}

/* Release a handler */
static void destroy_glut_win_handler(int win, int type)
{
	SV ** h;
	AV * a;

	if (!glut_handlers)
		glut_handlers = newAV();

	h = av_fetch(glut_handlers, win, FALSE);

	if (!h || !SvOK(*h) || !SvROK(*h))
		return;

	a = (AV*)SvRV(*h);

	av_store(a, type, newSVsv(&PL_sv_undef));
}

/* Begin window callback definition */
#define begin_decl_gwh(type, params, nparam)				\
									\
static void generic_glut_ ## type ## _handler params			\
{									\
	int win = glutGetWindow();					\
	AV * handler_data = (AV*)get_glut_win_handler(win, HANDLE_GLUT_ ## type);\
	SV * handler;							\
	int i;								\
	dSP;								\
									\
	handler = *av_fetch(handler_data, 0, 0);			\
									\
	GLUT_PUSHMARK(sp);						\
	GLUT_EXTEND_STACK(sp,av_len(handler_data)+nparam);		\
	for (i=1;i<=av_len(handler_data);i++)				\
		GLUT_PUSH_NEW_SV(*av_fetch(handler_data, i, 0));

/* End window callback definition */
#define end_decl_gwh()							\
	PUTBACK;							\
	DO_perl_call_sv(handler, G_DISCARD);				\
}

/* Activate a window callback handler */
#define decl_gwh_xs(type)						\
	{								\
		int win = glutGetWindow();				\
									\
		if (!handler || !SvOK(handler)) {			\
			destroy_glut_win_handler(win, HANDLE_GLUT_ ## type);\
			glut ## type ## Func(NULL);			\
		} else {						\
			AV * handler_data = newAV();			\
									\
			PackCallbackST(handler_data, 0);		\
									\
			set_glut_win_handler(win, HANDLE_GLUT_ ## type, (SV*)handler_data);\
									\
			glut ## type ## Func(generic_glut_ ## type ## _handler);\
		}							\
	ENSURE_callback_thread;}

/* Activate a window callback handler; die on failure */
#define decl_gwh_xs_nullfail(type, fail)				\
	{								\
		int win = glutGetWindow();				\
									\
		if (!handler || !SvOK(handler)) {			\
			croak fail;					\
		} else {						\
			AV * handler_data = newAV();			\
									\
			PackCallbackST(handler_data, 0);		\
									\
			set_glut_win_handler(win, HANDLE_GLUT_ ## type, (SV*)handler_data);\
									\
			glut ## type ## Func(generic_glut_ ## type ## _handler);\
		}							\
	ENSURE_callback_thread;}


/* Activate a global state callback handler */
#define decl_ggh_xs(type)						\
	{								\
		if (glut_ ## type ## _handler_data)			\
			SvREFCNT_dec(glut_ ## type ## _handler_data);	\
									\
		if (!handler || !SvOK(handler)) {			\
			glut_ ## type ## _handler_data = 0;		\
			glut ## type ## Func(NULL);			\
		} else {						\
			AV * handler_data = newAV();			\
									\
			PackCallbackST(handler_data, 0);		\
									\
			glut_ ## type ## _handler_data = handler_data;	\
									\
			glut ## type ## Func(generic_glut_ ## type ## _handler);\
		}							\
	ENSURE_callback_thread;}


/* Begin a global state callback definition */
#define begin_decl_ggh(type, params, nparam)				\
									\
static AV * glut_ ## type ## _handler_data = 0;				\
									\
static void generic_glut_ ## type ## _handler params			\
{									\
	AV * handler_data = glut_ ## type ## _handler_data;		\
	SV * handler;							\
	int i;								\
	dSP;								\
									\
	handler = *av_fetch(handler_data, 0, 0);			\
									\
	GLUT_PUSHMARK(sp);						\
	GLUT_EXTEND_STACK(sp,av_len(handler_data)+nparam);		\
	for (i=1;i<=av_len(handler_data);i++)				\
		GLUT_PUSH_NEW_SV(*av_fetch(handler_data, i, 0));

/* End a global state callback definition */
#define end_decl_ggh()							\
	PUTBACK;							\
	DO_perl_call_sv(handler, G_DISCARD);				\
}

/* Define callbacks */
enum {
	HANDLE_GLUT_Display,
	HANDLE_GLUT_OverlayDisplay,
	HANDLE_GLUT_Reshape,
	HANDLE_GLUT_Keyboard,
	HANDLE_GLUT_KeyboardUp,
	HANDLE_GLUT_Mouse,
    HANDLE_GLUT_MouseWheel,             /* Open/FreeGLUT -chm */
	HANDLE_GLUT_Motion,
	HANDLE_GLUT_PassiveMotion,
	HANDLE_GLUT_Entry,
	HANDLE_GLUT_Visibility,
	HANDLE_GLUT_WindowStatus,
	HANDLE_GLUT_Special,
	HANDLE_GLUT_SpecialUp,
    HANDLE_GLUT_Joystick,               /* Open/FreeGLUT -chm */
	HANDLE_GLUT_SpaceballMotion,
	HANDLE_GLUT_SpaceballRotate,
	HANDLE_GLUT_SpaceballButton,
	HANDLE_GLUT_ButtonBox,
	HANDLE_GLUT_Dials,
	HANDLE_GLUT_TabletMotion,
	HANDLE_GLUT_TabletButton,
    HANDLE_GLUT_MenuDestroy,            /* Open/FreeGLUT -chm */
	HANDLE_GLUT_Close,                  /* Open/FreeGLUT -chm */
	HANDLE_GLUT_WMClose,                /* AGL GLUT      -chm */
};

/* Callback for glutDisplayFunc */
begin_decl_gwh(Display, (void), 0)
end_decl_gwh()

/* Callback for glutOverlayDisplayFunc */
begin_decl_gwh(OverlayDisplay, (void), 0)
end_decl_gwh()

/* Callback for glutReshapeFunc */
begin_decl_gwh(Reshape, (int width, int height), 2)
	GLUT_PUSH_NEW_IV(width);
	GLUT_PUSH_NEW_IV(height);
end_decl_gwh()

/* Callback for glutKeyboardFunc */
begin_decl_gwh(Keyboard, (unsigned char key, int width, int height), 3)
	GLUT_PUSH_NEW_U8(key);
	GLUT_PUSH_NEW_IV(width);
	GLUT_PUSH_NEW_IV(height);
end_decl_gwh()

/* Callback for glutKeyboardUpFunc */
begin_decl_gwh(KeyboardUp, (unsigned char key, int width, int height), 3)
	GLUT_PUSH_NEW_U8(key);
	GLUT_PUSH_NEW_IV(width);
	GLUT_PUSH_NEW_IV(height);
end_decl_gwh()

/* Callback for glutMouseFunc */
begin_decl_gwh(Mouse, (int button, int state, int x, int y), 4)
	GLUT_PUSH_NEW_IV(button);
	GLUT_PUSH_NEW_IV(state);
	GLUT_PUSH_NEW_IV(x);
	GLUT_PUSH_NEW_IV(y);
end_decl_gwh()

/* Callback for glutMouseWheelFunc */	/* Open/FreeGLUT -chm */
begin_decl_gwh(MouseWheel, (int wheel, int direction, int x, int y), 4)
	GLUT_PUSH_NEW_IV(wheel);
	GLUT_PUSH_NEW_IV(direction);
	GLUT_PUSH_NEW_IV(x);
	GLUT_PUSH_NEW_IV(y);
end_decl_gwh()

/* Callback for glutPassiveMotionFunc */
begin_decl_gwh(PassiveMotion, (int x, int y), 2)
	GLUT_PUSH_NEW_IV(x);
	GLUT_PUSH_NEW_IV(y);
end_decl_gwh()

/* Callback for glutMotionFunc */
begin_decl_gwh(Motion, (int x, int y), 2)
	GLUT_PUSH_NEW_IV(x);
	GLUT_PUSH_NEW_IV(y);
end_decl_gwh()

/* Callback for glutVisibilityFunc */
begin_decl_gwh(Visibility, (int state), 1)
	GLUT_PUSH_NEW_IV(state);
end_decl_gwh()

/* Callback for glutWindowStatusFunc */
begin_decl_gwh(WindowStatus, (int state), 1)
	GLUT_PUSH_NEW_IV(state);
end_decl_gwh()

/* Callback for glutEntryFunc */
begin_decl_gwh(Entry, (int state), 1)
	GLUT_PUSH_NEW_IV(state);
end_decl_gwh()

/* Callback for glutSpecialFunc */
begin_decl_gwh(Special, (int key, int width, int height), 3)
	GLUT_PUSH_NEW_IV(key);
	GLUT_PUSH_NEW_IV(width);
	GLUT_PUSH_NEW_IV(height);
end_decl_gwh()

/* Callback for glutSpecialUpFunc */
begin_decl_gwh(SpecialUp, (int key, int width, int height), 3)
	GLUT_PUSH_NEW_IV(key);
	GLUT_PUSH_NEW_IV(width);
	GLUT_PUSH_NEW_IV(height);
end_decl_gwh()

/* Callback for glutJoystickFunc */	/* Open/FreeGLUT -chm */
begin_decl_gwh(Joystick, (unsigned int buttons, int xaxis, int yaxis, int zaxis), 4)
	GLUT_PUSH_NEW_IV(buttons);
	GLUT_PUSH_NEW_IV(xaxis);
	GLUT_PUSH_NEW_IV(yaxis);
	GLUT_PUSH_NEW_IV(zaxis);
end_decl_gwh()


/* Callback for glutSpaceballMotionFunc */
begin_decl_gwh(SpaceballMotion, (int x, int y, int z), 3)
	GLUT_PUSH_NEW_IV(x);
	GLUT_PUSH_NEW_IV(y);
	GLUT_PUSH_NEW_IV(z);
end_decl_gwh()

/* Callback for glutSpaceballRotateFunc */
begin_decl_gwh(SpaceballRotate, (int x, int y, int z), 3)
	GLUT_PUSH_NEW_IV(x);
	GLUT_PUSH_NEW_IV(y);
	GLUT_PUSH_NEW_IV(z);
end_decl_gwh()

/* Callback for glutSpaceballButtonFunc */
begin_decl_gwh(SpaceballButton, (int button, int state), 2)
	GLUT_PUSH_NEW_IV(button);
	GLUT_PUSH_NEW_IV(state);
end_decl_gwh()

/* Callback for glutButtonBoxFunc */
begin_decl_gwh(ButtonBox, (int button, int state), 2)
	GLUT_PUSH_NEW_IV(button);
	GLUT_PUSH_NEW_IV(state);
end_decl_gwh()

/* Callback for glutDialsFunc */
begin_decl_gwh(Dials, (int dial, int value), 2)
	GLUT_PUSH_NEW_IV(dial);
	GLUT_PUSH_NEW_IV(value);
end_decl_gwh()

/* Callback for glutTabletMotionFunc */
begin_decl_gwh(TabletMotion, (int x, int y), 2)
	GLUT_PUSH_NEW_IV(x);
	GLUT_PUSH_NEW_IV(y);
end_decl_gwh()

/* Callback for glutTabletButtonFunc */
begin_decl_gwh(TabletButton, (int button, int state, int x, int y), 4)
	GLUT_PUSH_NEW_IV(button);
	GLUT_PUSH_NEW_IV(state);
	GLUT_PUSH_NEW_IV(x);
	GLUT_PUSH_NEW_IV(y);
end_decl_gwh()

/* Callback for glutIdleFunc */
begin_decl_ggh(Idle, (void), 0)
end_decl_ggh()

/* Callback for glutMenuStatusFunc */
begin_decl_ggh(MenuStatus, (int status, int x, int y), 3)
	GLUT_PUSH_NEW_IV(status);
	GLUT_PUSH_NEW_IV(x);
	GLUT_PUSH_NEW_IV(y);
end_decl_ggh()

/* Callback for glutMenuStateFunc */
begin_decl_ggh(MenuState, (int status), 1)
	GLUT_PUSH_NEW_IV(status);
end_decl_ggh()

/* Callback for glutMenuDestroyFunc */		/* Open/FreeGLUT -chm */
begin_decl_gwh(MenuDestroy, (void), 0)
end_decl_gwh()

/* Callback for glutCloseFunc */
#ifdef HAVE_AGL_GLUT
static void generic_glut_WMClose_handler(void)
#else
static void generic_glut_Close_handler(void)
#endif
{
	int win = glutGetWindow();
	AV * handler_data = (AV*)get_glut_win_handler(win, HANDLE_GLUT_Close);
	SV * handler = *av_fetch(handler_data, 0, 0);
	dSP;

	GLUT_PUSHMARK(sp);
	GLUT_EXTEND_STACK(sp,1);
	GLUT_PUSH_NEW_IV(win);

	PUTBACK;
	DO_perl_call_sv(handler, G_DISCARD);
}

/* glut_timer_handlers is an allocation buffer.
   All unused elements are SVivs forming a linked-list,
   starting at glut_timer_handlers_next_free.
   The end of the list is marked by a -1.
   If no element is free when one is needed, the buffer will grow.
*/
static AV * glut_timer_handlers = 0;
static int glut_timer_handlers_next_free = -1;

/* Callback for glutTimerFunc */
static void generic_glut_timer_handler(int value)
{
	if (!glut_timer_handlers)
		croak("Timer handler called, but no timers have ever been set up");
	SV** h = av_fetch(glut_timer_handlers,value,FALSE);
	if (!h || !SvOK(*h) || !SvROK(*h))
		croak("Timer handler called for unregistered timer");
	AV * handler_data = (AV*)SvRV(*h);
	sv_setiv(*h,glut_timer_handlers_next_free);
	glut_timer_handlers_next_free = value;

	SV * handler;
	int i;
	dSP;

	handler = *av_fetch(handler_data, 0, 0);

	GLUT_PUSHMARK(sp);
	GLUT_EXTEND_STACK(sp,av_len(handler_data));
	for (i=1;i<=av_len(handler_data);i++)
		GLUT_PUSH_NEW_SV(*av_fetch(handler_data, i, 0));

	PUTBACK;
	DO_perl_call_sv(handler, G_DISCARD);

	SvREFCNT_dec(handler_data);
}

static AV * glut_menu_handlers = 0;

/* Callback for glutMenuFunc */
static void generic_glut_menu_handler(int value)
{
	AV * handler_data;
	SV * handler;
	SV ** h;
	int i;
	dSP;

	h = av_fetch(glut_menu_handlers, glutGetMenu(), FALSE);
	if (!h || !SvOK(*h) || !SvROK(*h))
		croak("Unable to locate menu handler");

	handler_data = (AV*)SvRV(*h);

	handler = *av_fetch(handler_data, 0, 0);

	GLUT_PUSHMARK(sp);
	GLUT_EXTEND_STACK(sp,av_len(handler_data) + 1);
	for (i=1;i<=av_len(handler_data);i++)
		GLUT_PUSH_NEW_SV(*av_fetch(handler_data, i, 0));

	GLUT_PUSH_NEW_IV(value);

	PUTBACK;
	DO_perl_call_sv(handler, G_DISCARD);
}
/* End of set up for GLUT callback stuff */


#line 520 "lib/OpenGL/GLUT.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 664 "lib/OpenGL/GLUT.c"

XS_EUPXS(XS_OpenGL__GLUT_glpHasGLUT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glpHasGLUT)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 516 "lib/OpenGL/GLUT.xs"
        {
#if defined(HAVE_GLUT) || defined(HAVE_FREEGLUT)
                RETVAL = 1;
#else
                RETVAL = 0;
#endif /* defined HAVE_GLUT or HAVE_FREEGLUT */
        }
#line 683 "lib/OpenGL/GLUT.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT__have_glut); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT__have_glut)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 530 "lib/OpenGL/GLUT.xs"
#if defined(HAVE_GLUT) || defined(HAVE_FREEGLUT)
        RETVAL = 1;
#else
        RETVAL = 0;
#endif /* defined HAVE_GLUT or HAVE_FREEGLUT */
#line 706 "lib/OpenGL/GLUT.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT__have_freeglut); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT__have_freeglut)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 542 "lib/OpenGL/GLUT.xs"
#if defined(HAVE_FREEGLUT)
        RETVAL = 1;
#else
        RETVAL = 0;
#endif /* defined HAVE_FREEGLUT */
#line 729 "lib/OpenGL/GLUT.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT_done_glutInit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_done_glutInit)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 554 "lib/OpenGL/GLUT.xs"
	RETVAL = _done_glutInit;
#line 748 "lib/OpenGL/GLUT.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT_glutInit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutInit)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 565 "lib/OpenGL/GLUT.xs"
	{
	int argc;
	char ** argv;
	AV * ARGV;
	SV * ARGV0;
	SV * sv;
	int i;

			if (_done_glutInit)
				croak("illegal glutInit() reinitialization attempt");

			argv  = 0;
			ARGV = perl_get_av("ARGV", FALSE);
			ARGV0 = perl_get_sv("0", FALSE);

			argc = av_len(ARGV)+2;
			if (argc) {
				argv = malloc(sizeof(char*)*argc);
				argv[0] = SvPV(ARGV0, PL_na);
				for(i=0;i<=av_len(ARGV);i++)
					argv[i+1] = SvPV(*av_fetch(ARGV, i, 0), PL_na);
			}

			i = argc;
			glutInit(&argc, argv);

			_done_glutInit = 1;

			while(argc<i--)
				sv = av_shift(ARGV);

			if (argv)
				free(argv);
	}
#line 798 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutInitWindowSize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutInitWindowSize)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "width, height");
    {
	int	width = (int)SvIV(ST(0))
;
	int	height = (int)SvIV(ST(1))
;

	glutInitWindowSize(width, height);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutInitWindowPosition); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutInitWindowPosition)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, y");
    {
	int	x = (int)SvIV(ST(0))
;
	int	y = (int)SvIV(ST(1))
;

	glutInitWindowPosition(x, y);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutInitDisplayMode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutInitDisplayMode)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "mode");
    {
	int	mode = (int)SvIV(ST(0))
;

	glutInitDisplayMode(mode);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutInitDisplayString); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutInitDisplayString)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "string");
    {
	char *	string = (char *)SvPV_nolen(ST(0))
;

	glutInitDisplayString(string);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutMainLoop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutMainLoop)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutMainLoop();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutCreateWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutCreateWindow)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
	char *	name = (char *)SvPV_nolen(ST(0))
;
	int	RETVAL;
	dXSTARG;
#line 631 "lib/OpenGL/GLUT.xs"
	RETVAL = glutCreateWindow(name);
	destroy_glut_win_handlers(RETVAL);
#line 900 "lib/OpenGL/GLUT.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT_glutCreateSubWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutCreateSubWindow)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "win, x, y, width, height");
    {
	int	win = (int)SvIV(ST(0))
;
	int	x = (int)SvIV(ST(1))
;
	int	y = (int)SvIV(ST(2))
;
	int	width = (int)SvIV(ST(3))
;
	int	height = (int)SvIV(ST(4))
;
	int	RETVAL;
	dXSTARG;
#line 645 "lib/OpenGL/GLUT.xs"
	RETVAL = glutCreateSubWindow(win, x, y, width, height);
	destroy_glut_win_handlers(RETVAL);
#line 930 "lib/OpenGL/GLUT.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT_glutSetWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSetWindow)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "win");
    {
	int	win = (int)SvIV(ST(0))
;

	glutSetWindow(win);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutGetWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutGetWindow)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = glutGetWindow();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT_glutDestroyWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutDestroyWindow)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "win");
    {
	int	win = (int)SvIV(ST(0))
;
#line 664 "lib/OpenGL/GLUT.xs"
	glutDestroyWindow(win);
	destroy_glut_win_handlers(win);
#line 984 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutPostRedisplay); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutPostRedisplay)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutPostRedisplay();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSwapBuffers); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSwapBuffers)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutSwapBuffers();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutPositionWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutPositionWindow)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, y");
    {
	int	x = (int)SvIV(ST(0))
;
	int	y = (int)SvIV(ST(1))
;

	glutPositionWindow(x, y);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutReshapeWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutReshapeWindow)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "width, height");
    {
	int	width = (int)SvIV(ST(0))
;
	int	height = (int)SvIV(ST(1))
;

	glutReshapeWindow(width, height);
    }
    XSRETURN_EMPTY;
}

#if GLUT_API_VERSION >= 3
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_OpenGL__GLUT_glutFullScreen); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutFullScreen)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutFullScreen();
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_OpenGL__GLUT_glutPopWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutPopWindow)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutPopWindow();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutPushWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutPushWindow)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutPushWindow();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutShowWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutShowWindow)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutShowWindow();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutHideWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutHideWindow)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutHideWindow();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutIconifyWindow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutIconifyWindow)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutIconifyWindow();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSetWindowTitle); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSetWindowTitle)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "title");
    {
	char *	title = (char *)SvPV_nolen(ST(0))
;

	glutSetWindowTitle(title);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSetIconTitle); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSetIconTitle)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "title");
    {
	char *	title = (char *)SvPV_nolen(ST(0))
;

	glutSetIconTitle(title);
    }
    XSRETURN_EMPTY;
}

#if GLUT_API_VERSION >= 3
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_OpenGL__GLUT_glutSetCursor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSetCursor)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cursor");
    {
	int	cursor = (int)SvIV(ST(0))
;

	glutSetCursor(cursor);
    }
    XSRETURN_EMPTY;
}

#endif
#if GLUT_API_VERSION >= 3
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_OpenGL__GLUT_glutEstablishOverlay); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutEstablishOverlay)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutEstablishOverlay();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutUseLayer); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutUseLayer)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "layer");
    {
	GLenum	layer = (int)SvIV(ST(0))
;

	glutUseLayer(layer);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutRemoveOverlay); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutRemoveOverlay)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutRemoveOverlay();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutPostOverlayRedisplay); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutPostOverlayRedisplay)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutPostOverlayRedisplay();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutShowOverlay); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutShowOverlay)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutShowOverlay();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutHideOverlay); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutHideOverlay)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutHideOverlay();
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_OpenGL__GLUT_glutCreateMenu); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutCreateMenu)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;
	int	RETVAL;
	dXSTARG;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 773 "lib/OpenGL/GLUT.xs"
	{
		if (!handler || !SvOK(handler)) {
			croak("A handler must be specified");
		} else {
			AV * handler_data = newAV();

			PackCallbackST(handler_data, 0);

			RETVAL = glutCreateMenu(generic_glut_menu_handler);

			if (!glut_menu_handlers)
				glut_menu_handlers = newAV();

			av_store(glut_menu_handlers, RETVAL, newRV_inc((SV*)handler_data));

			SvREFCNT_dec(handler_data);

		}
	}
#line 1321 "lib/OpenGL/GLUT.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT_glutSetMenu); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSetMenu)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "menu");
    {
	int	menu = (int)SvIV(ST(0))
;

	glutSetMenu(menu);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutGetMenu); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutGetMenu)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = glutGetMenu();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT_glutDestroyMenu); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutDestroyMenu)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "menu");
    {
	int	menu = (int)SvIV(ST(0))
;
#line 809 "lib/OpenGL/GLUT.xs"
	{
		glutDestroyMenu(menu);
		av_store(glut_menu_handlers, menu, newSVsv(&PL_sv_undef));
	}
#line 1377 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutAddMenuEntry); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutAddMenuEntry)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "name, value");
    {
	char *	name = (char *)SvPV_nolen(ST(0))
;
	int	value = (int)SvIV(ST(1))
;

	glutAddMenuEntry(name, value);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutAddSubMenu); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutAddSubMenu)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "name, menu");
    {
	char *	name = (char *)SvPV_nolen(ST(0))
;
	int	menu = (int)SvIV(ST(1))
;

	glutAddSubMenu(name, menu);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutChangeToMenuEntry); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutChangeToMenuEntry)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "entry, name, value");
    {
	int	entry = (int)SvIV(ST(0))
;
	char *	name = (char *)SvPV_nolen(ST(1))
;
	int	value = (int)SvIV(ST(2))
;

	glutChangeToMenuEntry(entry, name, value);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutChangeToSubMenu); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutChangeToSubMenu)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "entry, name, menu");
    {
	int	entry = (int)SvIV(ST(0))
;
	char *	name = (char *)SvPV_nolen(ST(1))
;
	int	menu = (int)SvIV(ST(2))
;

	glutChangeToSubMenu(entry, name, menu);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutRemoveMenuItem); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutRemoveMenuItem)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "entry");
    {
	int	entry = (int)SvIV(ST(0))
;

	glutRemoveMenuItem(entry);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutAttachMenu); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutAttachMenu)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "button");
    {
	int	button = (int)SvIV(ST(0))
;

	glutAttachMenu(button);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutDetachMenu); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutDetachMenu)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "button");
    {
	int	button = (int)SvIV(ST(0))
;

	glutDetachMenu(button);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutDisplayFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutDisplayFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 862 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs_nullfail(Display, ("Display function must be specified"))
#line 1524 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}

#if GLUT_API_VERSION >= 3
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_OpenGL__GLUT_glutOverlayDisplayFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutOverlayDisplayFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 871 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs(OverlayDisplay)
#line 1550 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_OpenGL__GLUT_glutReshapeFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutReshapeFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 880 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs(Reshape)
#line 1574 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutKeyboardFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutKeyboardFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 887 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs(Keyboard)
#line 1597 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}

#if GLUT_API_VERSION >= 4
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_OpenGL__GLUT_glutKeyboardUpFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutKeyboardUpFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 896 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs(KeyboardUp)
#line 1623 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutWindowStatusFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutWindowStatusFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 903 "lib/OpenGL/GLUT.xs"
        {
#if defined HAVE_FREEGLUT
		decl_gwh_xs(WindowStatus)
#endif
	}
#line 1650 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_OpenGL__GLUT_glutMouseFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutMouseFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 916 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs(Mouse)
#line 1674 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutMouseWheelFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutMouseWheelFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 923 "lib/OpenGL/GLUT.xs"
        {
#if defined HAVE_FREEGLUT
		decl_gwh_xs(MouseWheel)
#endif
	}
#line 1701 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutMotionFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutMotionFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 934 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs(Motion)
#line 1724 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutPassiveMotionFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutPassiveMotionFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 941 "lib/OpenGL/GLUT.xs"
	{
#if defined HAVE_FREEGLUT
		decl_gwh_xs(PassiveMotion)
#endif
	}
#line 1751 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutVisibilityFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutVisibilityFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 952 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs(Visibility)
#line 1774 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutEntryFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutEntryFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 959 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs(Entry)
#line 1797 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}

#if GLUT_API_VERSION >= 2
#define XSubPPtmpAAAF 1


XS_EUPXS(XS_OpenGL__GLUT_glutSpecialFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSpecialFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 968 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs(Special)
#line 1823 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSpaceballMotionFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSpaceballMotionFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 982 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs(SpaceballMotion)
#line 1846 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSpaceballRotateFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSpaceballRotateFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 989 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs(SpaceballRotate)
#line 1869 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSpaceballButtonFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSpaceballButtonFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 996 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs(SpaceballButton)
#line 1892 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutButtonBoxFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutButtonBoxFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 1003 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs(ButtonBox)
#line 1915 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutDialsFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutDialsFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 1010 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs(Dials)
#line 1938 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutTabletMotionFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutTabletMotionFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 1017 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs(TabletMotion)
#line 1961 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutTabletButtonFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutTabletButtonFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 1024 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs(TabletButton)
#line 1984 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}

#endif
#if GLUT_API_VERSION >= 3
#define XSubPPtmpAAAG 1


XS_EUPXS(XS_OpenGL__GLUT_glutMenuStatusFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutMenuStatusFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 1035 "lib/OpenGL/GLUT.xs"
	decl_ggh_xs(MenuStatus)
#line 2011 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_OpenGL__GLUT_glutMenuStateFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutMenuStateFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 1044 "lib/OpenGL/GLUT.xs"
	{
#if defined HAVE_FREEGLUT
		decl_ggh_xs(MenuState)
#endif
	}
#line 2039 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutIdleFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutIdleFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 1055 "lib/OpenGL/GLUT.xs"
	decl_ggh_xs(Idle)
#line 2062 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutTimerFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutTimerFunc)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "msecs, handler=0, ...");
    {
	unsigned int	msecs = (unsigned int)SvUV(ST(0))
;
	SV *	handler;

	if (items < 2)
	    handler = 0;
	else {
	    handler = ST(1)
;
	}
#line 1063 "lib/OpenGL/GLUT.xs"
	{
		if (!handler || !SvOK(handler)) {
			croak("A handler must be specified");
		} else {
			AV * handler_data = newAV();

			PackCallbackST(handler_data, 1);

			SV * handler_data_sv = newRV_inc((SV*)handler_data);

			if (!glut_timer_handlers)
				glut_timer_handlers = newAV();

			int handler_id = glut_timer_handlers_next_free;
			if (handler_id == -1) {
			  handler_id = ((int) av_len(glut_timer_handlers))+1;
			  if (handler_id < 0)
			    croak("Limit of concurrent timers reached (MAX_INT)");
			  av_push(glut_timer_handlers, handler_data_sv);
			} else {
			  SV** entry = av_fetch(glut_timer_handlers,handler_id,FALSE);
			  glut_timer_handlers_next_free = SvIV(*entry);
			  sv_setsv(*entry,sv_2mortal(handler_data_sv));
			}

			glutTimerFunc(msecs, generic_glut_timer_handler, handler_id);
		}
	ENSURE_callback_thread;}
#line 2114 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSetColor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSetColor)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "cell, red, green, blue");
    {
	int	cell = (int)SvIV(ST(0))
;
	GLfloat	red = (float)SvNV(ST(1))
;
	GLfloat	green = (float)SvNV(ST(2))
;
	GLfloat	blue = (float)SvNV(ST(3))
;

	glutSetColor(cell, red, green, blue);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutGetColor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutGetColor)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cell, component");
    {
	int	cell = (int)SvIV(ST(0))
;
	int	component = (int)SvIV(ST(1))
;
	GLfloat	RETVAL;
	dXSTARG;

	RETVAL = glutGetColor(cell, component);
	XSprePUSH;
	PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT_glutCopyColormap); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutCopyColormap)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "win");
    {
	int	win = (int)SvIV(ST(0))
;

	glutCopyColormap(win);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutGet); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutGet)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "state");
    {
	GLenum	state = (int)SvIV(ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = glutGet(state);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if GLUT_API_VERSION >= 3
#define XSubPPtmpAAAH 1


XS_EUPXS(XS_OpenGL__GLUT_glutLayerGet); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutLayerGet)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "info");
    {
	GLenum	info = (int)SvIV(ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = glutLayerGet(info);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_OpenGL__GLUT_glutDeviceGet); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutDeviceGet)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "info");
    {
	GLenum	info = (int)SvIV(ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = glutDeviceGet(info);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if GLUT_API_VERSION >= 3
#define XSubPPtmpAAAI 1


XS_EUPXS(XS_OpenGL__GLUT_glutGetModifiers); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutGetModifiers)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = glutGetModifiers();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif
#if GLUT_API_VERSION >= 2
#define XSubPPtmpAAAJ 1


XS_EUPXS(XS_OpenGL__GLUT_glutExtensionSupported); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutExtensionSupported)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "extension");
    {
	char *	extension = (char *)SvPV_nolen(ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = glutExtensionSupported(extension);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_OpenGL__GLUT_glutBitmapCharacter); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutBitmapCharacter)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "font, character");
    {
	void *	font = INT2PTR(void *,SvIV(ST(0)))
;
	int	character = (int)SvIV(ST(1))
;

	glutBitmapCharacter(font, character);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutStrokeCharacter); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutStrokeCharacter)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "font, character");
    {
	void *	font = INT2PTR(void *,SvIV(ST(0)))
;
	int	character = (int)SvIV(ST(1))
;

	glutStrokeCharacter(font, character);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutBitmapWidth); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutBitmapWidth)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "font, character");
    {
	void *	font = INT2PTR(void *,SvIV(ST(0)))
;
	int	character = (int)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = glutBitmapWidth(font, character);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT_glutStrokeWidth); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutStrokeWidth)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "font, character");
    {
	void *	font = INT2PTR(void *,SvIV(ST(0)))
;
	int	character = (int)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = glutStrokeWidth(font, character);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if GLUT_API_VERSION >= 3
#define XSubPPtmpAAAK 1


XS_EUPXS(XS_OpenGL__GLUT_glutIgnoreKeyRepeat); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutIgnoreKeyRepeat)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "ignore");
    {
	int	ignore = (int)SvIV(ST(0))
;

	glutIgnoreKeyRepeat(ignore);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSetKeyRepeat); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSetKeyRepeat)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "repeatMode");
    {
	int	repeatMode = (int)SvIV(ST(0))
;

	glutSetKeyRepeat(repeatMode);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutForceJoystickFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutForceJoystickFunc)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutForceJoystickFunc();
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_OpenGL__GLUT_glutSolidSphere); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSolidSphere)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "radius, slices, stacks");
    {
	GLdouble	radius = (double)SvNV(ST(0))
;
	GLint	slices = (int)SvIV(ST(1))
;
	GLint	stacks = (int)SvIV(ST(2))
;

	glutSolidSphere(radius, slices, stacks);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutWireSphere); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutWireSphere)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "radius, slices, stacks");
    {
	GLdouble	radius = (double)SvNV(ST(0))
;
	GLint	slices = (int)SvIV(ST(1))
;
	GLint	stacks = (int)SvIV(ST(2))
;

	glutWireSphere(radius, slices, stacks);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSolidCube); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSolidCube)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "size");
    {
	GLdouble	size = (double)SvNV(ST(0))
;

	glutSolidCube(size);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutWireCube); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutWireCube)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "size");
    {
	GLdouble	size = (double)SvNV(ST(0))
;

	glutWireCube(size);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSolidCone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSolidCone)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "base, height, slices, stacks");
    {
	GLdouble	base = (double)SvNV(ST(0))
;
	GLdouble	height = (double)SvNV(ST(1))
;
	GLint	slices = (int)SvIV(ST(2))
;
	GLint	stacks = (int)SvIV(ST(3))
;

	glutSolidCone(base, height, slices, stacks);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutWireCone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutWireCone)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "base, height, slices, stacks");
    {
	GLdouble	base = (double)SvNV(ST(0))
;
	GLdouble	height = (double)SvNV(ST(1))
;
	GLint	slices = (int)SvIV(ST(2))
;
	GLint	stacks = (int)SvIV(ST(3))
;

	glutWireCone(base, height, slices, stacks);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSolidTorus); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSolidTorus)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "innerRadius, outerRadius, nsides, rings");
    {
	GLdouble	innerRadius = (double)SvNV(ST(0))
;
	GLdouble	outerRadius = (double)SvNV(ST(1))
;
	GLint	nsides = (int)SvIV(ST(2))
;
	GLint	rings = (int)SvIV(ST(3))
;

	glutSolidTorus(innerRadius, outerRadius, nsides, rings);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutWireTorus); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutWireTorus)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "innerRadius, outerRadius, nsides, rings");
    {
	GLdouble	innerRadius = (double)SvNV(ST(0))
;
	GLdouble	outerRadius = (double)SvNV(ST(1))
;
	GLint	nsides = (int)SvIV(ST(2))
;
	GLint	rings = (int)SvIV(ST(3))
;

	glutWireTorus(innerRadius, outerRadius, nsides, rings);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSolidDodecahedron); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSolidDodecahedron)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutSolidDodecahedron();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutWireDodecahedron); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutWireDodecahedron)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutWireDodecahedron();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSolidOctahedron); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSolidOctahedron)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutSolidOctahedron();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutWireOctahedron); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutWireOctahedron)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutWireOctahedron();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSolidTetrahedron); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSolidTetrahedron)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutSolidTetrahedron();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutWireTetrahedron); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutWireTetrahedron)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutWireTetrahedron();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSolidIcosahedron); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSolidIcosahedron)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutSolidIcosahedron();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutWireIcosahedron); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutWireIcosahedron)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutWireIcosahedron();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSolidTeapot); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSolidTeapot)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "size");
    {
	GLdouble	size = (double)SvNV(ST(0))
;

	glutSolidTeapot(size);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutWireTeapot); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutWireTeapot)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "size");
    {
	GLdouble	size = (double)SvNV(ST(0))
;

	glutWireTeapot(size);
    }
    XSRETURN_EMPTY;
}

#if GLUT_API_VERSION >= 4
#define XSubPPtmpAAAL 1


XS_EUPXS(XS_OpenGL__GLUT_glutSpecialUpFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSpecialUpFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 1302 "lib/OpenGL/GLUT.xs"
	decl_gwh_xs(SpecialUp)
#line 2744 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutGameModeString); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutGameModeString)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "string");
    {
	char *	string = (char *)SvPV_nolen(ST(0))
;
	GLboolean	RETVAL;
#line 1309 "lib/OpenGL/GLUT.xs"
	{
		char mode[1024];
		if (!string || !string[0])
		{
			int w = glutGet(0x00C8);	// GLUT_SCREEN_WIDTH
			int h = glutGet(0x00C9);	// GLUT_SCREEN_HEIGHT

			sprintf(mode,"%dx%d:%d@%d",w,h,32,60);
			string = mode;
		}

		glutGameModeString(string);
		RETVAL = glutGameModeGet(0x0001);	// GLUT_GAME_MODE_POSSIBLE
	}
#line 2775 "lib/OpenGL/GLUT.c"
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT_glutEnterGameMode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutEnterGameMode)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = glutEnterGameMode();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT_glutLeaveGameMode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutLeaveGameMode)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutLeaveGameMode();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutGameModeGet); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutGameModeGet)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "mode");
    {
	GLenum	mode = (int)SvIV(ST(0))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = glutGameModeGet(mode);
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT_glutBitmapHeight); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutBitmapHeight)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "font");
    {
	void *	font = INT2PTR(void *,SvIV(ST(0)))
;
	int	RETVAL;
	dXSTARG;
#line 1345 "lib/OpenGL/GLUT.xs"
	{
#if defined HAVE_FREEGLUT
		RETVAL = glutBitmapHeight(font);
#endif
	}
#line 2851 "lib/OpenGL/GLUT.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT_glutBitmapLength); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutBitmapLength)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "font, string");
    {
	void *	font = INT2PTR(void *,SvIV(ST(0)))
;
	const unsigned char *	string = (const unsigned char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;
#line 1360 "lib/OpenGL/GLUT.xs"
	{
#if defined HAVE_FREEGLUT
		RETVAL = glutBitmapLength(font, string);
#endif
	}
#line 2878 "lib/OpenGL/GLUT.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT_glutBitmapString); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutBitmapString)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "font, string");
    {
	void *	font = INT2PTR(void *,SvIV(ST(0)))
;
	const unsigned char *	string = (const unsigned char *)SvPV_nolen(ST(1))
;
#line 1375 "lib/OpenGL/GLUT.xs"
    {
#if defined HAVE_FREEGLUT
	    glutBitmapString(font, string);
#else
    	int len, i;
    	len = (int) strlen((char *)string);
    	for (i = 0; i < len; i++) {
    		glutBitmapCharacter(font, string[i]);
    	}
#endif
    }
#line 2909 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutMainLoopEvent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutMainLoopEvent)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 1398 "lib/OpenGL/GLUT.xs"
	{
#if defined HAVE_AGL_GLUT
		glutCheckLoop();
#elif defined HAVE_FREEGLUT
		glutMainLoopEvent();
#endif
	}
#line 2930 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutPostWindowOverlayRedisplay); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutPostWindowOverlayRedisplay)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "windowID");
    {
	int	windowID = (int)SvIV(ST(0))
;

	glutPostWindowOverlayRedisplay(windowID);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutPostWindowRedisplay); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutPostWindowRedisplay)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "windowID");
    {
	int	windowID = (int)SvIV(ST(0))
;

	glutPostWindowRedisplay(windowID);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutReportErrors); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutReportErrors)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	glutReportErrors();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSolidCylinder); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSolidCylinder)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "radius, height, slices, stacks");
    {
	GLdouble	radius = (double)SvNV(ST(0))
;
	GLdouble	height = (double)SvNV(ST(1))
;
	GLint	slices = (int)SvIV(ST(2))
;
	GLint	stacks = (int)SvIV(ST(3))
;
#line 1428 "lib/OpenGL/GLUT.xs"
	{
#if defined HAVE_FREEGLUT
		glutSolidCylinder(radius, height, slices, stacks);
#endif
	}
#line 3003 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutSolidRhombicDodecahedron); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSolidRhombicDodecahedron)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 1438 "lib/OpenGL/GLUT.xs"
	{
#if defined HAVE_FREEGLUT
		glutSolidRhombicDodecahedron();
#endif
	}
#line 3022 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutStrokeHeight); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutStrokeHeight)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "font");
    {
	void *	font = INT2PTR(void *,SvIV(ST(0)))
;
	GLfloat	RETVAL;
	dXSTARG;
#line 1449 "lib/OpenGL/GLUT.xs"
	{
#if defined HAVE_FREEGLUT
		RETVAL = glutStrokeHeight(font);
#endif
	}
#line 3045 "lib/OpenGL/GLUT.c"
	XSprePUSH;
	PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT_glutStrokeLength); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutStrokeLength)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "font, string");
    {
	void *	font = INT2PTR(void *,SvIV(ST(0)))
;
	const unsigned char *	string = (const unsigned char *)SvPV_nolen(ST(1))
;
	GLfloat	RETVAL;
	dXSTARG;
#line 1464 "lib/OpenGL/GLUT.xs"
	{
#if defined HAVE_FREEGLUT
		glutStrokeLength(font, string);
#endif
	}
#line 3072 "lib/OpenGL/GLUT.c"
	XSprePUSH;
	PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_OpenGL__GLUT_glutStrokeString); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutStrokeString)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "font, string");
    {
	void *	font = INT2PTR(void *,SvIV(ST(0)))
;
	const unsigned char *	string = (const unsigned char *)SvPV_nolen(ST(1))
;
#line 1478 "lib/OpenGL/GLUT.xs"
	{
#if defined HAVE_FREEGLUT
		glutStrokeString(font, string);
#endif
	}
#line 3097 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutWarpPointer); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutWarpPointer)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "x, y");
    {
	int	x = (int)SvIV(ST(0))
;
	int	y = (int)SvIV(ST(1))
;

	glutWarpPointer(x, y);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutWireCylinder); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutWireCylinder)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "radius, height, slices, stacks");
    {
	GLdouble	radius = (double)SvNV(ST(0))
;
	GLdouble	height = (double)SvNV(ST(1))
;
	GLint	slices = (int)SvIV(ST(2))
;
	GLint	stacks = (int)SvIV(ST(3))
;
#line 1498 "lib/OpenGL/GLUT.xs"
	{
#if defined HAVE_FREEGLUT
		glutWireCylinder(radius, height, slices, stacks);
#endif
	}
#line 3142 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutWireRhombicDodecahedron); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutWireRhombicDodecahedron)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 1508 "lib/OpenGL/GLUT.xs"
	{
#if defined HAVE_FREEGLUT
		glutWireRhombicDodecahedron();
#endif
	}
#line 3161 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_OpenGL__GLUT_glutSetOption); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutSetOption)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "option_flag, value");
    {
	GLenum	option_flag = (int)SvIV(ST(0))
;
	int	value = (int)SvIV(ST(1))
;
#line 1524 "lib/OpenGL/GLUT.xs"
	{
#if defined HAVE_FREEGLUT
		glutSetOption(option_flag, value);
#endif
	}
#line 3185 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutLeaveMainLoop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutLeaveMainLoop)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 1534 "lib/OpenGL/GLUT.xs"
	{
#if defined HAVE_FREEGLUT
		glutLeaveMainLoop();
#else
		int win = glutGetWindow();
		glutDestroyWindow(win);
		destroy_glut_win_handlers(win);
#endif
	}
#line 3208 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutMenuDestroyFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutMenuDestroyFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 1549 "lib/OpenGL/GLUT.xs"
    {
#if defined HAVE_FREEGLUT
		decl_gwh_xs(MenuDestroy)
#endif
	}
#line 3235 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutCloseFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutCloseFunc)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    {
	SV *	handler;

	if (items < 1)
	    handler = 0;
	else {
	    handler = ST(0)
;
	}
#line 1560 "lib/OpenGL/GLUT.xs"
	{
#ifdef HAVE_AGL_GLUT
		decl_gwh_xs(WMClose)
#elif defined HAVE_FREEGLUT
		decl_gwh_xs(Close)
#else
		if (_done_glutCloseFunc_warn == 0) {
			warn("glutCloseFunc: not implemented\n");
			_done_glutCloseFunc_warn++;
		}
#endif
	}
#line 3269 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutInitContextVersion); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutInitContextVersion)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "majorVersion, minorVersion");
    {
	int	majorVersion = (int)SvIV(ST(0))
;
	int	minorVersion = (int)SvIV(ST(1))
;
#line 1579 "lib/OpenGL/GLUT.xs"
	{
#if defined HAVE_FREEGLUT
		glutInitContextVersion(majorVersion, minorVersion);
#endif
	}
#line 3292 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutInitContextFlags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutInitContextFlags)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "flags");
    {
	int	flags = (int)SvIV(ST(0))
;
#line 1590 "lib/OpenGL/GLUT.xs"
	{
#if defined HAVE_FREEGLUT
		glutInitContextFlags(flags);
#endif
	}
#line 3313 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_OpenGL__GLUT_glutInitContextProfile); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_OpenGL__GLUT_glutInitContextProfile)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "profile");
    {
	int	profile = (int)SvIV(ST(0))
;
#line 1601 "lib/OpenGL/GLUT.xs"
	{
#if defined HAVE_FREEGLUT
		glutInitContextProfile(profile);
#endif
	}
#line 3334 "lib/OpenGL/GLUT.c"
    }
    XSRETURN_EMPTY;
}

#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_OpenGL__GLUT); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_OpenGL__GLUT)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("OpenGL::GLUT::glpHasGLUT", XS_OpenGL__GLUT_glpHasGLUT);
        newXS_deffile("OpenGL::GLUT::_have_glut", XS_OpenGL__GLUT__have_glut);
        newXS_deffile("OpenGL::GLUT::_have_freeglut", XS_OpenGL__GLUT__have_freeglut);
        newXS_deffile("OpenGL::GLUT::done_glutInit", XS_OpenGL__GLUT_done_glutInit);
        newXS_deffile("OpenGL::GLUT::glutInit", XS_OpenGL__GLUT_glutInit);
        newXS_deffile("OpenGL::GLUT::glutInitWindowSize", XS_OpenGL__GLUT_glutInitWindowSize);
        newXS_deffile("OpenGL::GLUT::glutInitWindowPosition", XS_OpenGL__GLUT_glutInitWindowPosition);
        newXS_deffile("OpenGL::GLUT::glutInitDisplayMode", XS_OpenGL__GLUT_glutInitDisplayMode);
        newXS_deffile("OpenGL::GLUT::glutInitDisplayString", XS_OpenGL__GLUT_glutInitDisplayString);
        newXS_deffile("OpenGL::GLUT::glutMainLoop", XS_OpenGL__GLUT_glutMainLoop);
        newXS_deffile("OpenGL::GLUT::glutCreateWindow", XS_OpenGL__GLUT_glutCreateWindow);
        newXS_deffile("OpenGL::GLUT::glutCreateSubWindow", XS_OpenGL__GLUT_glutCreateSubWindow);
        newXS_deffile("OpenGL::GLUT::glutSetWindow", XS_OpenGL__GLUT_glutSetWindow);
        newXS_deffile("OpenGL::GLUT::glutGetWindow", XS_OpenGL__GLUT_glutGetWindow);
        newXS_deffile("OpenGL::GLUT::glutDestroyWindow", XS_OpenGL__GLUT_glutDestroyWindow);
        newXS_deffile("OpenGL::GLUT::glutPostRedisplay", XS_OpenGL__GLUT_glutPostRedisplay);
        newXS_deffile("OpenGL::GLUT::glutSwapBuffers", XS_OpenGL__GLUT_glutSwapBuffers);
        newXS_deffile("OpenGL::GLUT::glutPositionWindow", XS_OpenGL__GLUT_glutPositionWindow);
        newXS_deffile("OpenGL::GLUT::glutReshapeWindow", XS_OpenGL__GLUT_glutReshapeWindow);
#if XSubPPtmpAAAA
        newXS_deffile("OpenGL::GLUT::glutFullScreen", XS_OpenGL__GLUT_glutFullScreen);
#endif
        newXS_deffile("OpenGL::GLUT::glutPopWindow", XS_OpenGL__GLUT_glutPopWindow);
        newXS_deffile("OpenGL::GLUT::glutPushWindow", XS_OpenGL__GLUT_glutPushWindow);
        newXS_deffile("OpenGL::GLUT::glutShowWindow", XS_OpenGL__GLUT_glutShowWindow);
        newXS_deffile("OpenGL::GLUT::glutHideWindow", XS_OpenGL__GLUT_glutHideWindow);
        newXS_deffile("OpenGL::GLUT::glutIconifyWindow", XS_OpenGL__GLUT_glutIconifyWindow);
        newXS_deffile("OpenGL::GLUT::glutSetWindowTitle", XS_OpenGL__GLUT_glutSetWindowTitle);
        newXS_deffile("OpenGL::GLUT::glutSetIconTitle", XS_OpenGL__GLUT_glutSetIconTitle);
#if XSubPPtmpAAAB
        newXS_deffile("OpenGL::GLUT::glutSetCursor", XS_OpenGL__GLUT_glutSetCursor);
#endif
#if XSubPPtmpAAAC
        newXS_deffile("OpenGL::GLUT::glutEstablishOverlay", XS_OpenGL__GLUT_glutEstablishOverlay);
        newXS_deffile("OpenGL::GLUT::glutUseLayer", XS_OpenGL__GLUT_glutUseLayer);
        newXS_deffile("OpenGL::GLUT::glutRemoveOverlay", XS_OpenGL__GLUT_glutRemoveOverlay);
        newXS_deffile("OpenGL::GLUT::glutPostOverlayRedisplay", XS_OpenGL__GLUT_glutPostOverlayRedisplay);
        newXS_deffile("OpenGL::GLUT::glutShowOverlay", XS_OpenGL__GLUT_glutShowOverlay);
        newXS_deffile("OpenGL::GLUT::glutHideOverlay", XS_OpenGL__GLUT_glutHideOverlay);
#endif
        newXS_deffile("OpenGL::GLUT::glutCreateMenu", XS_OpenGL__GLUT_glutCreateMenu);
        newXS_deffile("OpenGL::GLUT::glutSetMenu", XS_OpenGL__GLUT_glutSetMenu);
        newXS_deffile("OpenGL::GLUT::glutGetMenu", XS_OpenGL__GLUT_glutGetMenu);
        newXS_deffile("OpenGL::GLUT::glutDestroyMenu", XS_OpenGL__GLUT_glutDestroyMenu);
        newXS_deffile("OpenGL::GLUT::glutAddMenuEntry", XS_OpenGL__GLUT_glutAddMenuEntry);
        newXS_deffile("OpenGL::GLUT::glutAddSubMenu", XS_OpenGL__GLUT_glutAddSubMenu);
        newXS_deffile("OpenGL::GLUT::glutChangeToMenuEntry", XS_OpenGL__GLUT_glutChangeToMenuEntry);
        newXS_deffile("OpenGL::GLUT::glutChangeToSubMenu", XS_OpenGL__GLUT_glutChangeToSubMenu);
        newXS_deffile("OpenGL::GLUT::glutRemoveMenuItem", XS_OpenGL__GLUT_glutRemoveMenuItem);
        newXS_deffile("OpenGL::GLUT::glutAttachMenu", XS_OpenGL__GLUT_glutAttachMenu);
        newXS_deffile("OpenGL::GLUT::glutDetachMenu", XS_OpenGL__GLUT_glutDetachMenu);
        newXS_deffile("OpenGL::GLUT::glutDisplayFunc", XS_OpenGL__GLUT_glutDisplayFunc);
#if XSubPPtmpAAAD
        newXS_deffile("OpenGL::GLUT::glutOverlayDisplayFunc", XS_OpenGL__GLUT_glutOverlayDisplayFunc);
#endif
        newXS_deffile("OpenGL::GLUT::glutReshapeFunc", XS_OpenGL__GLUT_glutReshapeFunc);
        newXS_deffile("OpenGL::GLUT::glutKeyboardFunc", XS_OpenGL__GLUT_glutKeyboardFunc);
#if XSubPPtmpAAAE
        newXS_deffile("OpenGL::GLUT::glutKeyboardUpFunc", XS_OpenGL__GLUT_glutKeyboardUpFunc);
        newXS_deffile("OpenGL::GLUT::glutWindowStatusFunc", XS_OpenGL__GLUT_glutWindowStatusFunc);
#endif
        newXS_deffile("OpenGL::GLUT::glutMouseFunc", XS_OpenGL__GLUT_glutMouseFunc);
        newXS_deffile("OpenGL::GLUT::glutMouseWheelFunc", XS_OpenGL__GLUT_glutMouseWheelFunc);
        newXS_deffile("OpenGL::GLUT::glutMotionFunc", XS_OpenGL__GLUT_glutMotionFunc);
        newXS_deffile("OpenGL::GLUT::glutPassiveMotionFunc", XS_OpenGL__GLUT_glutPassiveMotionFunc);
        newXS_deffile("OpenGL::GLUT::glutVisibilityFunc", XS_OpenGL__GLUT_glutVisibilityFunc);
        newXS_deffile("OpenGL::GLUT::glutEntryFunc", XS_OpenGL__GLUT_glutEntryFunc);
#if XSubPPtmpAAAF
        newXS_deffile("OpenGL::GLUT::glutSpecialFunc", XS_OpenGL__GLUT_glutSpecialFunc);
        newXS_deffile("OpenGL::GLUT::glutSpaceballMotionFunc", XS_OpenGL__GLUT_glutSpaceballMotionFunc);
        newXS_deffile("OpenGL::GLUT::glutSpaceballRotateFunc", XS_OpenGL__GLUT_glutSpaceballRotateFunc);
        newXS_deffile("OpenGL::GLUT::glutSpaceballButtonFunc", XS_OpenGL__GLUT_glutSpaceballButtonFunc);
        newXS_deffile("OpenGL::GLUT::glutButtonBoxFunc", XS_OpenGL__GLUT_glutButtonBoxFunc);
        newXS_deffile("OpenGL::GLUT::glutDialsFunc", XS_OpenGL__GLUT_glutDialsFunc);
        newXS_deffile("OpenGL::GLUT::glutTabletMotionFunc", XS_OpenGL__GLUT_glutTabletMotionFunc);
        newXS_deffile("OpenGL::GLUT::glutTabletButtonFunc", XS_OpenGL__GLUT_glutTabletButtonFunc);
#endif
#if XSubPPtmpAAAG
        newXS_deffile("OpenGL::GLUT::glutMenuStatusFunc", XS_OpenGL__GLUT_glutMenuStatusFunc);
#endif
        newXS_deffile("OpenGL::GLUT::glutMenuStateFunc", XS_OpenGL__GLUT_glutMenuStateFunc);
        newXS_deffile("OpenGL::GLUT::glutIdleFunc", XS_OpenGL__GLUT_glutIdleFunc);
        newXS_deffile("OpenGL::GLUT::glutTimerFunc", XS_OpenGL__GLUT_glutTimerFunc);
        newXS_deffile("OpenGL::GLUT::glutSetColor", XS_OpenGL__GLUT_glutSetColor);
        newXS_deffile("OpenGL::GLUT::glutGetColor", XS_OpenGL__GLUT_glutGetColor);
        newXS_deffile("OpenGL::GLUT::glutCopyColormap", XS_OpenGL__GLUT_glutCopyColormap);
        newXS_deffile("OpenGL::GLUT::glutGet", XS_OpenGL__GLUT_glutGet);
#if XSubPPtmpAAAH
        newXS_deffile("OpenGL::GLUT::glutLayerGet", XS_OpenGL__GLUT_glutLayerGet);
#endif
        newXS_deffile("OpenGL::GLUT::glutDeviceGet", XS_OpenGL__GLUT_glutDeviceGet);
#if XSubPPtmpAAAI
        newXS_deffile("OpenGL::GLUT::glutGetModifiers", XS_OpenGL__GLUT_glutGetModifiers);
#endif
#if XSubPPtmpAAAJ
        newXS_deffile("OpenGL::GLUT::glutExtensionSupported", XS_OpenGL__GLUT_glutExtensionSupported);
#endif
        newXS_deffile("OpenGL::GLUT::glutBitmapCharacter", XS_OpenGL__GLUT_glutBitmapCharacter);
        newXS_deffile("OpenGL::GLUT::glutStrokeCharacter", XS_OpenGL__GLUT_glutStrokeCharacter);
        newXS_deffile("OpenGL::GLUT::glutBitmapWidth", XS_OpenGL__GLUT_glutBitmapWidth);
        newXS_deffile("OpenGL::GLUT::glutStrokeWidth", XS_OpenGL__GLUT_glutStrokeWidth);
#if XSubPPtmpAAAK
        newXS_deffile("OpenGL::GLUT::glutIgnoreKeyRepeat", XS_OpenGL__GLUT_glutIgnoreKeyRepeat);
        newXS_deffile("OpenGL::GLUT::glutSetKeyRepeat", XS_OpenGL__GLUT_glutSetKeyRepeat);
        newXS_deffile("OpenGL::GLUT::glutForceJoystickFunc", XS_OpenGL__GLUT_glutForceJoystickFunc);
#endif
        newXS_deffile("OpenGL::GLUT::glutSolidSphere", XS_OpenGL__GLUT_glutSolidSphere);
        newXS_deffile("OpenGL::GLUT::glutWireSphere", XS_OpenGL__GLUT_glutWireSphere);
        newXS_deffile("OpenGL::GLUT::glutSolidCube", XS_OpenGL__GLUT_glutSolidCube);
        newXS_deffile("OpenGL::GLUT::glutWireCube", XS_OpenGL__GLUT_glutWireCube);
        newXS_deffile("OpenGL::GLUT::glutSolidCone", XS_OpenGL__GLUT_glutSolidCone);
        newXS_deffile("OpenGL::GLUT::glutWireCone", XS_OpenGL__GLUT_glutWireCone);
        newXS_deffile("OpenGL::GLUT::glutSolidTorus", XS_OpenGL__GLUT_glutSolidTorus);
        newXS_deffile("OpenGL::GLUT::glutWireTorus", XS_OpenGL__GLUT_glutWireTorus);
        newXS_deffile("OpenGL::GLUT::glutSolidDodecahedron", XS_OpenGL__GLUT_glutSolidDodecahedron);
        newXS_deffile("OpenGL::GLUT::glutWireDodecahedron", XS_OpenGL__GLUT_glutWireDodecahedron);
        newXS_deffile("OpenGL::GLUT::glutSolidOctahedron", XS_OpenGL__GLUT_glutSolidOctahedron);
        newXS_deffile("OpenGL::GLUT::glutWireOctahedron", XS_OpenGL__GLUT_glutWireOctahedron);
        newXS_deffile("OpenGL::GLUT::glutSolidTetrahedron", XS_OpenGL__GLUT_glutSolidTetrahedron);
        newXS_deffile("OpenGL::GLUT::glutWireTetrahedron", XS_OpenGL__GLUT_glutWireTetrahedron);
        newXS_deffile("OpenGL::GLUT::glutSolidIcosahedron", XS_OpenGL__GLUT_glutSolidIcosahedron);
        newXS_deffile("OpenGL::GLUT::glutWireIcosahedron", XS_OpenGL__GLUT_glutWireIcosahedron);
        newXS_deffile("OpenGL::GLUT::glutSolidTeapot", XS_OpenGL__GLUT_glutSolidTeapot);
        newXS_deffile("OpenGL::GLUT::glutWireTeapot", XS_OpenGL__GLUT_glutWireTeapot);
#if XSubPPtmpAAAL
        newXS_deffile("OpenGL::GLUT::glutSpecialUpFunc", XS_OpenGL__GLUT_glutSpecialUpFunc);
        newXS_deffile("OpenGL::GLUT::glutGameModeString", XS_OpenGL__GLUT_glutGameModeString);
        newXS_deffile("OpenGL::GLUT::glutEnterGameMode", XS_OpenGL__GLUT_glutEnterGameMode);
        newXS_deffile("OpenGL::GLUT::glutLeaveGameMode", XS_OpenGL__GLUT_glutLeaveGameMode);
        newXS_deffile("OpenGL::GLUT::glutGameModeGet", XS_OpenGL__GLUT_glutGameModeGet);
        newXS_deffile("OpenGL::GLUT::glutBitmapHeight", XS_OpenGL__GLUT_glutBitmapHeight);
        newXS_deffile("OpenGL::GLUT::glutBitmapLength", XS_OpenGL__GLUT_glutBitmapLength);
        newXS_deffile("OpenGL::GLUT::glutBitmapString", XS_OpenGL__GLUT_glutBitmapString);
        newXS_deffile("OpenGL::GLUT::glutMainLoopEvent", XS_OpenGL__GLUT_glutMainLoopEvent);
        newXS_deffile("OpenGL::GLUT::glutPostWindowOverlayRedisplay", XS_OpenGL__GLUT_glutPostWindowOverlayRedisplay);
        newXS_deffile("OpenGL::GLUT::glutPostWindowRedisplay", XS_OpenGL__GLUT_glutPostWindowRedisplay);
        newXS_deffile("OpenGL::GLUT::glutReportErrors", XS_OpenGL__GLUT_glutReportErrors);
        newXS_deffile("OpenGL::GLUT::glutSolidCylinder", XS_OpenGL__GLUT_glutSolidCylinder);
        newXS_deffile("OpenGL::GLUT::glutSolidRhombicDodecahedron", XS_OpenGL__GLUT_glutSolidRhombicDodecahedron);
        newXS_deffile("OpenGL::GLUT::glutStrokeHeight", XS_OpenGL__GLUT_glutStrokeHeight);
        newXS_deffile("OpenGL::GLUT::glutStrokeLength", XS_OpenGL__GLUT_glutStrokeLength);
        newXS_deffile("OpenGL::GLUT::glutStrokeString", XS_OpenGL__GLUT_glutStrokeString);
        newXS_deffile("OpenGL::GLUT::glutWarpPointer", XS_OpenGL__GLUT_glutWarpPointer);
        newXS_deffile("OpenGL::GLUT::glutWireCylinder", XS_OpenGL__GLUT_glutWireCylinder);
        newXS_deffile("OpenGL::GLUT::glutWireRhombicDodecahedron", XS_OpenGL__GLUT_glutWireRhombicDodecahedron);
#endif
        newXS_deffile("OpenGL::GLUT::glutSetOption", XS_OpenGL__GLUT_glutSetOption);
        newXS_deffile("OpenGL::GLUT::glutLeaveMainLoop", XS_OpenGL__GLUT_glutLeaveMainLoop);
        newXS_deffile("OpenGL::GLUT::glutMenuDestroyFunc", XS_OpenGL__GLUT_glutMenuDestroyFunc);
        newXS_deffile("OpenGL::GLUT::glutCloseFunc", XS_OpenGL__GLUT_glutCloseFunc);
        newXS_deffile("OpenGL::GLUT::glutInitContextVersion", XS_OpenGL__GLUT_glutInitContextVersion);
        newXS_deffile("OpenGL::GLUT::glutInitContextFlags", XS_OpenGL__GLUT_glutInitContextFlags);
        newXS_deffile("OpenGL::GLUT::glutInitContextProfile", XS_OpenGL__GLUT_glutInitContextProfile);

    /* Initialisation Section */

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#if XSubPPtmpAAAE
#endif
#if XSubPPtmpAAAF
#endif
#if XSubPPtmpAAAG
#endif
#if XSubPPtmpAAAH
#endif
#if XSubPPtmpAAAI
#endif
#if XSubPPtmpAAAJ
#endif
#if XSubPPtmpAAAK
#endif
#if XSubPPtmpAAAL
#endif
#line 1608 "lib/OpenGL/GLUT.xs"
{
   HV *stash = gv_stashpvn("OpenGL::GLUT", strlen("OpenGL::GLUT"), TRUE);
#include "glut_const.h"
}

#line 3553 "lib/OpenGL/GLUT.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
