/*
 * $Id: dvinfo.c 21 2007-03-08 10:59:42Z zito $
 *
 * dvinfo.c -- displaying of a metadata from DV
 * Copyright (C) 2006 Vaclav Ovsik <zito@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "config.h"
#include "dvinfo.h"

int print_ssyb_packets(FILE *output, char const *prefix, dv_decoder_t *dec)
{
    if ( !prefix )
	prefix = "";
    for(int id = 0; id < 256; id++ )
    {
	uint8_t data[4];
	if ( dv_get_ssyb_pack(dec, (uint8_t)id, data) == 0 )
	{
	    fprintf(output, "%sssyb id=0x%02x "
		    "data=[0x%02x, 0x%02x, 0x%02x, 0x%02x]\n",
		    prefix, id, data[0], data[1], data[2], data[3]);
	}
    }
    return 0;
}

int print_vaux_packets(FILE *output, char const *prefix, dv_decoder_t *dec)
{
    if ( !prefix )
	prefix = "";
    for(int id = 0; id < 256; id++ )
    {
	uint8_t data[4];
	if ( dv_get_vaux_pack(dec, (uint8_t)id, data) == 0 )
	{
	    fprintf(output, "%svaux id=0x%02x "
		    "data=[0x%02x, 0x%02x, 0x%02x, 0x%02x]\n",
		    prefix, id, data[0], data[1], data[2], data[3]);
	}
    }
    return 0;
}
