### 1004 - Cmd Property Removed

**Description**: Checks whether an existing property of a cmd is removed from the previous cli version. 

**Analysis**: Not all configured properties removed from a cmd are considered breaking changes. The properties listed in CMD_PROPERTY_REMOVE_BREAK_LIST below are thought to influence or interrupt current workflow and be breaking changes.
For now, removed properties in cmd level does not break workflow.
* CMD_PROPERTY_REMOVE_BREAK_LIST = [] 

**Example**: In new cli version, cmd `az monitor diagnostic-setting delete` is changed from `is_preview` to stable, which does not disrupt users' actions.

#### Before
```json5
{
  "module_name": "monitor",
  "name": "az",
  "commands": {},
  "sub_groups": {
      "monitor": {
          "name": "monitor",
          "commands": {},
          "sub_groups": {
              "monitor private-link-scope": {
                  "name": "monitor private-link-scope",
                  "commands": {},
                  "sub_groups": {
                      "monitor private-link-scope scoped-resource": {
                          "name": "monitor private-link-scope scoped-resource",
                          "commands": {
                              "monitor private-link-scope scoped-resource delete": {
                                  "name": "monitor private-link-scope scoped-resource delete",
                                  "is_preview": true,
                                  "parameters": [
                                    {
                                      "name": "resource_group_name",
                                      "options": ["--resource-group", "-g"],
                                      "required": true,
                                      "id_part": "resource_group"
                                    }
                                    ...
                                    ...
                                  ]
                              }
                          }
                      }
                  }
              }
          }
      },
    ...
  }
}
```

#### After 
```json5
{
  "module_name": "monitor",
  "name": "az",
  "commands": {},
  "sub_groups": {
      "monitor": {
          "name": "monitor",
          "commands": {},
          "sub_groups": {
              "monitor private-link-scope": {
                  "name": "monitor private-link-scope",
                  "commands": {},
                  "sub_groups": {
                      "monitor private-link-scope scoped-resource": {
                          "name": "monitor private-link-scope scoped-resource",
                          "commands": {
                              "monitor private-link-scope scoped-resource delete": {
                                  "name": "monitor private-link-scope scoped-resource delete",
                                  "parameters": [
                                    {
                                      "name": "resource_group_name",
                                      "options": ["--resource-group", "-g"],
                                      "required": true,
                                      "id_part": "resource_group"
                                    }
                                    ...
                                    ...
                                  ]
                              }
                          }
                      }
                  }
              }
          }
      },
    ...
  }
}
```
