-- autogenerated from https://www.unicode.org/Public/15.1.0/ucd/UnicodeData.txt
-- |
-- Module      : Unicode.Internal.Char.UnicodeData.Compositions
-- Copyright   : (c) 2020 Composewell Technologies and Contributors
-- License     : Apache-2.0
-- Maintainer  : streamly@composewell.com
-- Stability   : experimental

{-# OPTIONS_HADDOCK hide #-}

module Unicode.Internal.Char.UnicodeData.Compositions
(compose, composeStarters, isSecondStarter)
where

import Data.Bits (Bits(..))
import Data.Char (ord)
import Data.Int (Int8)
import Data.Word (Word16, Word8)
import GHC.Exts (Ptr(..))
import Unicode.Internal.Bits (lookupBit, lookupWord16AsInt, lookupWord8AsInt)

{-# NOINLINE compose #-}
compose :: Char -> Char -> Maybe Char
compose 'A' '\768' = Just '\192'
compose 'A' '\769' = Just '\193'
compose 'A' '\770' = Just '\194'
compose 'A' '\771' = Just '\195'
compose 'A' '\776' = Just '\196'
compose 'A' '\778' = Just '\197'
compose 'C' '\807' = Just '\199'
compose 'E' '\768' = Just '\200'
compose 'E' '\769' = Just '\201'
compose 'E' '\770' = Just '\202'
compose 'E' '\776' = Just '\203'
compose 'I' '\768' = Just '\204'
compose 'I' '\769' = Just '\205'
compose 'I' '\770' = Just '\206'
compose 'I' '\776' = Just '\207'
compose 'N' '\771' = Just '\209'
compose 'O' '\768' = Just '\210'
compose 'O' '\769' = Just '\211'
compose 'O' '\770' = Just '\212'
compose 'O' '\771' = Just '\213'
compose 'O' '\776' = Just '\214'
compose 'U' '\768' = Just '\217'
compose 'U' '\769' = Just '\218'
compose 'U' '\770' = Just '\219'
compose 'U' '\776' = Just '\220'
compose 'Y' '\769' = Just '\221'
compose 'a' '\768' = Just '\224'
compose 'a' '\769' = Just '\225'
compose 'a' '\770' = Just '\226'
compose 'a' '\771' = Just '\227'
compose 'a' '\776' = Just '\228'
compose 'a' '\778' = Just '\229'
compose 'c' '\807' = Just '\231'
compose 'e' '\768' = Just '\232'
compose 'e' '\769' = Just '\233'
compose 'e' '\770' = Just '\234'
compose 'e' '\776' = Just '\235'
compose 'i' '\768' = Just '\236'
compose 'i' '\769' = Just '\237'
compose 'i' '\770' = Just '\238'
compose 'i' '\776' = Just '\239'
compose 'n' '\771' = Just '\241'
compose 'o' '\768' = Just '\242'
compose 'o' '\769' = Just '\243'
compose 'o' '\770' = Just '\244'
compose 'o' '\771' = Just '\245'
compose 'o' '\776' = Just '\246'
compose 'u' '\768' = Just '\249'
compose 'u' '\769' = Just '\250'
compose 'u' '\770' = Just '\251'
compose 'u' '\776' = Just '\252'
compose 'y' '\769' = Just '\253'
compose 'y' '\776' = Just '\255'
compose 'A' '\772' = Just '\256'
compose 'a' '\772' = Just '\257'
compose 'A' '\774' = Just '\258'
compose 'a' '\774' = Just '\259'
compose 'A' '\808' = Just '\260'
compose 'a' '\808' = Just '\261'
compose 'C' '\769' = Just '\262'
compose 'c' '\769' = Just '\263'
compose 'C' '\770' = Just '\264'
compose 'c' '\770' = Just '\265'
compose 'C' '\775' = Just '\266'
compose 'c' '\775' = Just '\267'
compose 'C' '\780' = Just '\268'
compose 'c' '\780' = Just '\269'
compose 'D' '\780' = Just '\270'
compose 'd' '\780' = Just '\271'
compose 'E' '\772' = Just '\274'
compose 'e' '\772' = Just '\275'
compose 'E' '\774' = Just '\276'
compose 'e' '\774' = Just '\277'
compose 'E' '\775' = Just '\278'
compose 'e' '\775' = Just '\279'
compose 'E' '\808' = Just '\280'
compose 'e' '\808' = Just '\281'
compose 'E' '\780' = Just '\282'
compose 'e' '\780' = Just '\283'
compose 'G' '\770' = Just '\284'
compose 'g' '\770' = Just '\285'
compose 'G' '\774' = Just '\286'
compose 'g' '\774' = Just '\287'
compose 'G' '\775' = Just '\288'
compose 'g' '\775' = Just '\289'
compose 'G' '\807' = Just '\290'
compose 'g' '\807' = Just '\291'
compose 'H' '\770' = Just '\292'
compose 'h' '\770' = Just '\293'
compose 'I' '\771' = Just '\296'
compose 'i' '\771' = Just '\297'
compose 'I' '\772' = Just '\298'
compose 'i' '\772' = Just '\299'
compose 'I' '\774' = Just '\300'
compose 'i' '\774' = Just '\301'
compose 'I' '\808' = Just '\302'
compose 'i' '\808' = Just '\303'
compose 'I' '\775' = Just '\304'
compose 'J' '\770' = Just '\308'
compose 'j' '\770' = Just '\309'
compose 'K' '\807' = Just '\310'
compose 'k' '\807' = Just '\311'
compose 'L' '\769' = Just '\313'
compose 'l' '\769' = Just '\314'
compose 'L' '\807' = Just '\315'
compose 'l' '\807' = Just '\316'
compose 'L' '\780' = Just '\317'
compose 'l' '\780' = Just '\318'
compose 'N' '\769' = Just '\323'
compose 'n' '\769' = Just '\324'
compose 'N' '\807' = Just '\325'
compose 'n' '\807' = Just '\326'
compose 'N' '\780' = Just '\327'
compose 'n' '\780' = Just '\328'
compose 'O' '\772' = Just '\332'
compose 'o' '\772' = Just '\333'
compose 'O' '\774' = Just '\334'
compose 'o' '\774' = Just '\335'
compose 'O' '\779' = Just '\336'
compose 'o' '\779' = Just '\337'
compose 'R' '\769' = Just '\340'
compose 'r' '\769' = Just '\341'
compose 'R' '\807' = Just '\342'
compose 'r' '\807' = Just '\343'
compose 'R' '\780' = Just '\344'
compose 'r' '\780' = Just '\345'
compose 'S' '\769' = Just '\346'
compose 's' '\769' = Just '\347'
compose 'S' '\770' = Just '\348'
compose 's' '\770' = Just '\349'
compose 'S' '\807' = Just '\350'
compose 's' '\807' = Just '\351'
compose 'S' '\780' = Just '\352'
compose 's' '\780' = Just '\353'
compose 'T' '\807' = Just '\354'
compose 't' '\807' = Just '\355'
compose 'T' '\780' = Just '\356'
compose 't' '\780' = Just '\357'
compose 'U' '\771' = Just '\360'
compose 'u' '\771' = Just '\361'
compose 'U' '\772' = Just '\362'
compose 'u' '\772' = Just '\363'
compose 'U' '\774' = Just '\364'
compose 'u' '\774' = Just '\365'
compose 'U' '\778' = Just '\366'
compose 'u' '\778' = Just '\367'
compose 'U' '\779' = Just '\368'
compose 'u' '\779' = Just '\369'
compose 'U' '\808' = Just '\370'
compose 'u' '\808' = Just '\371'
compose 'W' '\770' = Just '\372'
compose 'w' '\770' = Just '\373'
compose 'Y' '\770' = Just '\374'
compose 'y' '\770' = Just '\375'
compose 'Y' '\776' = Just '\376'
compose 'Z' '\769' = Just '\377'
compose 'z' '\769' = Just '\378'
compose 'Z' '\775' = Just '\379'
compose 'z' '\775' = Just '\380'
compose 'Z' '\780' = Just '\381'
compose 'z' '\780' = Just '\382'
compose 'O' '\795' = Just '\416'
compose 'o' '\795' = Just '\417'
compose 'U' '\795' = Just '\431'
compose 'u' '\795' = Just '\432'
compose 'A' '\780' = Just '\461'
compose 'a' '\780' = Just '\462'
compose 'I' '\780' = Just '\463'
compose 'i' '\780' = Just '\464'
compose 'O' '\780' = Just '\465'
compose 'o' '\780' = Just '\466'
compose 'U' '\780' = Just '\467'
compose 'u' '\780' = Just '\468'
compose '\220' '\772' = Just '\469'
compose '\252' '\772' = Just '\470'
compose '\220' '\769' = Just '\471'
compose '\252' '\769' = Just '\472'
compose '\220' '\780' = Just '\473'
compose '\252' '\780' = Just '\474'
compose '\220' '\768' = Just '\475'
compose '\252' '\768' = Just '\476'
compose '\196' '\772' = Just '\478'
compose '\228' '\772' = Just '\479'
compose '\550' '\772' = Just '\480'
compose '\551' '\772' = Just '\481'
compose '\198' '\772' = Just '\482'
compose '\230' '\772' = Just '\483'
compose 'G' '\780' = Just '\486'
compose 'g' '\780' = Just '\487'
compose 'K' '\780' = Just '\488'
compose 'k' '\780' = Just '\489'
compose 'O' '\808' = Just '\490'
compose 'o' '\808' = Just '\491'
compose '\490' '\772' = Just '\492'
compose '\491' '\772' = Just '\493'
compose '\439' '\780' = Just '\494'
compose '\658' '\780' = Just '\495'
compose 'j' '\780' = Just '\496'
compose 'G' '\769' = Just '\500'
compose 'g' '\769' = Just '\501'
compose 'N' '\768' = Just '\504'
compose 'n' '\768' = Just '\505'
compose '\197' '\769' = Just '\506'
compose '\229' '\769' = Just '\507'
compose '\198' '\769' = Just '\508'
compose '\230' '\769' = Just '\509'
compose '\216' '\769' = Just '\510'
compose '\248' '\769' = Just '\511'
compose 'A' '\783' = Just '\512'
compose 'a' '\783' = Just '\513'
compose 'A' '\785' = Just '\514'
compose 'a' '\785' = Just '\515'
compose 'E' '\783' = Just '\516'
compose 'e' '\783' = Just '\517'
compose 'E' '\785' = Just '\518'
compose 'e' '\785' = Just '\519'
compose 'I' '\783' = Just '\520'
compose 'i' '\783' = Just '\521'
compose 'I' '\785' = Just '\522'
compose 'i' '\785' = Just '\523'
compose 'O' '\783' = Just '\524'
compose 'o' '\783' = Just '\525'
compose 'O' '\785' = Just '\526'
compose 'o' '\785' = Just '\527'
compose 'R' '\783' = Just '\528'
compose 'r' '\783' = Just '\529'
compose 'R' '\785' = Just '\530'
compose 'r' '\785' = Just '\531'
compose 'U' '\783' = Just '\532'
compose 'u' '\783' = Just '\533'
compose 'U' '\785' = Just '\534'
compose 'u' '\785' = Just '\535'
compose 'S' '\806' = Just '\536'
compose 's' '\806' = Just '\537'
compose 'T' '\806' = Just '\538'
compose 't' '\806' = Just '\539'
compose 'H' '\780' = Just '\542'
compose 'h' '\780' = Just '\543'
compose 'A' '\775' = Just '\550'
compose 'a' '\775' = Just '\551'
compose 'E' '\807' = Just '\552'
compose 'e' '\807' = Just '\553'
compose '\214' '\772' = Just '\554'
compose '\246' '\772' = Just '\555'
compose '\213' '\772' = Just '\556'
compose '\245' '\772' = Just '\557'
compose 'O' '\775' = Just '\558'
compose 'o' '\775' = Just '\559'
compose '\558' '\772' = Just '\560'
compose '\559' '\772' = Just '\561'
compose 'Y' '\772' = Just '\562'
compose 'y' '\772' = Just '\563'
compose '\168' '\769' = Just '\901'
compose '\913' '\769' = Just '\902'
compose '\917' '\769' = Just '\904'
compose '\919' '\769' = Just '\905'
compose '\921' '\769' = Just '\906'
compose '\927' '\769' = Just '\908'
compose '\933' '\769' = Just '\910'
compose '\937' '\769' = Just '\911'
compose '\970' '\769' = Just '\912'
compose '\921' '\776' = Just '\938'
compose '\933' '\776' = Just '\939'
compose '\945' '\769' = Just '\940'
compose '\949' '\769' = Just '\941'
compose '\951' '\769' = Just '\942'
compose '\953' '\769' = Just '\943'
compose '\971' '\769' = Just '\944'
compose '\953' '\776' = Just '\970'
compose '\965' '\776' = Just '\971'
compose '\959' '\769' = Just '\972'
compose '\965' '\769' = Just '\973'
compose '\969' '\769' = Just '\974'
compose '\978' '\769' = Just '\979'
compose '\978' '\776' = Just '\980'
compose '\1045' '\768' = Just '\1024'
compose '\1045' '\776' = Just '\1025'
compose '\1043' '\769' = Just '\1027'
compose '\1030' '\776' = Just '\1031'
compose '\1050' '\769' = Just '\1036'
compose '\1048' '\768' = Just '\1037'
compose '\1059' '\774' = Just '\1038'
compose '\1048' '\774' = Just '\1049'
compose '\1080' '\774' = Just '\1081'
compose '\1077' '\768' = Just '\1104'
compose '\1077' '\776' = Just '\1105'
compose '\1075' '\769' = Just '\1107'
compose '\1110' '\776' = Just '\1111'
compose '\1082' '\769' = Just '\1116'
compose '\1080' '\768' = Just '\1117'
compose '\1091' '\774' = Just '\1118'
compose '\1140' '\783' = Just '\1142'
compose '\1141' '\783' = Just '\1143'
compose '\1046' '\774' = Just '\1217'
compose '\1078' '\774' = Just '\1218'
compose '\1040' '\774' = Just '\1232'
compose '\1072' '\774' = Just '\1233'
compose '\1040' '\776' = Just '\1234'
compose '\1072' '\776' = Just '\1235'
compose '\1045' '\774' = Just '\1238'
compose '\1077' '\774' = Just '\1239'
compose '\1240' '\776' = Just '\1242'
compose '\1241' '\776' = Just '\1243'
compose '\1046' '\776' = Just '\1244'
compose '\1078' '\776' = Just '\1245'
compose '\1047' '\776' = Just '\1246'
compose '\1079' '\776' = Just '\1247'
compose '\1048' '\772' = Just '\1250'
compose '\1080' '\772' = Just '\1251'
compose '\1048' '\776' = Just '\1252'
compose '\1080' '\776' = Just '\1253'
compose '\1054' '\776' = Just '\1254'
compose '\1086' '\776' = Just '\1255'
compose '\1256' '\776' = Just '\1258'
compose '\1257' '\776' = Just '\1259'
compose '\1069' '\776' = Just '\1260'
compose '\1101' '\776' = Just '\1261'
compose '\1059' '\772' = Just '\1262'
compose '\1091' '\772' = Just '\1263'
compose '\1059' '\776' = Just '\1264'
compose '\1091' '\776' = Just '\1265'
compose '\1059' '\779' = Just '\1266'
compose '\1091' '\779' = Just '\1267'
compose '\1063' '\776' = Just '\1268'
compose '\1095' '\776' = Just '\1269'
compose '\1067' '\776' = Just '\1272'
compose '\1099' '\776' = Just '\1273'
compose '\1575' '\1619' = Just '\1570'
compose '\1575' '\1620' = Just '\1571'
compose '\1608' '\1620' = Just '\1572'
compose '\1575' '\1621' = Just '\1573'
compose '\1610' '\1620' = Just '\1574'
compose '\1749' '\1620' = Just '\1728'
compose '\1729' '\1620' = Just '\1730'
compose '\1746' '\1620' = Just '\1747'
compose '\2344' '\2364' = Just '\2345'
compose '\2352' '\2364' = Just '\2353'
compose '\2355' '\2364' = Just '\2356'
compose '\2503' '\2494' = Just '\2507'
compose '\2503' '\2519' = Just '\2508'
compose '\2887' '\2902' = Just '\2888'
compose '\2887' '\2878' = Just '\2891'
compose '\2887' '\2903' = Just '\2892'
compose '\2962' '\3031' = Just '\2964'
compose '\3014' '\3006' = Just '\3018'
compose '\3015' '\3006' = Just '\3019'
compose '\3014' '\3031' = Just '\3020'
compose '\3142' '\3158' = Just '\3144'
compose '\3263' '\3285' = Just '\3264'
compose '\3270' '\3285' = Just '\3271'
compose '\3270' '\3286' = Just '\3272'
compose '\3270' '\3266' = Just '\3274'
compose '\3274' '\3285' = Just '\3275'
compose '\3398' '\3390' = Just '\3402'
compose '\3399' '\3390' = Just '\3403'
compose '\3398' '\3415' = Just '\3404'
compose '\3545' '\3530' = Just '\3546'
compose '\3545' '\3535' = Just '\3548'
compose '\3548' '\3530' = Just '\3549'
compose '\3545' '\3551' = Just '\3550'
compose '\4133' '\4142' = Just '\4134'
compose '\6917' '\6965' = Just '\6918'
compose '\6919' '\6965' = Just '\6920'
compose '\6921' '\6965' = Just '\6922'
compose '\6923' '\6965' = Just '\6924'
compose '\6925' '\6965' = Just '\6926'
compose '\6929' '\6965' = Just '\6930'
compose '\6970' '\6965' = Just '\6971'
compose '\6972' '\6965' = Just '\6973'
compose '\6974' '\6965' = Just '\6976'
compose '\6975' '\6965' = Just '\6977'
compose '\6978' '\6965' = Just '\6979'
compose 'A' '\805' = Just '\7680'
compose 'a' '\805' = Just '\7681'
compose 'B' '\775' = Just '\7682'
compose 'b' '\775' = Just '\7683'
compose 'B' '\803' = Just '\7684'
compose 'b' '\803' = Just '\7685'
compose 'B' '\817' = Just '\7686'
compose 'b' '\817' = Just '\7687'
compose '\199' '\769' = Just '\7688'
compose '\231' '\769' = Just '\7689'
compose 'D' '\775' = Just '\7690'
compose 'd' '\775' = Just '\7691'
compose 'D' '\803' = Just '\7692'
compose 'd' '\803' = Just '\7693'
compose 'D' '\817' = Just '\7694'
compose 'd' '\817' = Just '\7695'
compose 'D' '\807' = Just '\7696'
compose 'd' '\807' = Just '\7697'
compose 'D' '\813' = Just '\7698'
compose 'd' '\813' = Just '\7699'
compose '\274' '\768' = Just '\7700'
compose '\275' '\768' = Just '\7701'
compose '\274' '\769' = Just '\7702'
compose '\275' '\769' = Just '\7703'
compose 'E' '\813' = Just '\7704'
compose 'e' '\813' = Just '\7705'
compose 'E' '\816' = Just '\7706'
compose 'e' '\816' = Just '\7707'
compose '\552' '\774' = Just '\7708'
compose '\553' '\774' = Just '\7709'
compose 'F' '\775' = Just '\7710'
compose 'f' '\775' = Just '\7711'
compose 'G' '\772' = Just '\7712'
compose 'g' '\772' = Just '\7713'
compose 'H' '\775' = Just '\7714'
compose 'h' '\775' = Just '\7715'
compose 'H' '\803' = Just '\7716'
compose 'h' '\803' = Just '\7717'
compose 'H' '\776' = Just '\7718'
compose 'h' '\776' = Just '\7719'
compose 'H' '\807' = Just '\7720'
compose 'h' '\807' = Just '\7721'
compose 'H' '\814' = Just '\7722'
compose 'h' '\814' = Just '\7723'
compose 'I' '\816' = Just '\7724'
compose 'i' '\816' = Just '\7725'
compose '\207' '\769' = Just '\7726'
compose '\239' '\769' = Just '\7727'
compose 'K' '\769' = Just '\7728'
compose 'k' '\769' = Just '\7729'
compose 'K' '\803' = Just '\7730'
compose 'k' '\803' = Just '\7731'
compose 'K' '\817' = Just '\7732'
compose 'k' '\817' = Just '\7733'
compose 'L' '\803' = Just '\7734'
compose 'l' '\803' = Just '\7735'
compose '\7734' '\772' = Just '\7736'
compose '\7735' '\772' = Just '\7737'
compose 'L' '\817' = Just '\7738'
compose 'l' '\817' = Just '\7739'
compose 'L' '\813' = Just '\7740'
compose 'l' '\813' = Just '\7741'
compose 'M' '\769' = Just '\7742'
compose 'm' '\769' = Just '\7743'
compose 'M' '\775' = Just '\7744'
compose 'm' '\775' = Just '\7745'
compose 'M' '\803' = Just '\7746'
compose 'm' '\803' = Just '\7747'
compose 'N' '\775' = Just '\7748'
compose 'n' '\775' = Just '\7749'
compose 'N' '\803' = Just '\7750'
compose 'n' '\803' = Just '\7751'
compose 'N' '\817' = Just '\7752'
compose 'n' '\817' = Just '\7753'
compose 'N' '\813' = Just '\7754'
compose 'n' '\813' = Just '\7755'
compose '\213' '\769' = Just '\7756'
compose '\245' '\769' = Just '\7757'
compose '\213' '\776' = Just '\7758'
compose '\245' '\776' = Just '\7759'
compose '\332' '\768' = Just '\7760'
compose '\333' '\768' = Just '\7761'
compose '\332' '\769' = Just '\7762'
compose '\333' '\769' = Just '\7763'
compose 'P' '\769' = Just '\7764'
compose 'p' '\769' = Just '\7765'
compose 'P' '\775' = Just '\7766'
compose 'p' '\775' = Just '\7767'
compose 'R' '\775' = Just '\7768'
compose 'r' '\775' = Just '\7769'
compose 'R' '\803' = Just '\7770'
compose 'r' '\803' = Just '\7771'
compose '\7770' '\772' = Just '\7772'
compose '\7771' '\772' = Just '\7773'
compose 'R' '\817' = Just '\7774'
compose 'r' '\817' = Just '\7775'
compose 'S' '\775' = Just '\7776'
compose 's' '\775' = Just '\7777'
compose 'S' '\803' = Just '\7778'
compose 's' '\803' = Just '\7779'
compose '\346' '\775' = Just '\7780'
compose '\347' '\775' = Just '\7781'
compose '\352' '\775' = Just '\7782'
compose '\353' '\775' = Just '\7783'
compose '\7778' '\775' = Just '\7784'
compose '\7779' '\775' = Just '\7785'
compose 'T' '\775' = Just '\7786'
compose 't' '\775' = Just '\7787'
compose 'T' '\803' = Just '\7788'
compose 't' '\803' = Just '\7789'
compose 'T' '\817' = Just '\7790'
compose 't' '\817' = Just '\7791'
compose 'T' '\813' = Just '\7792'
compose 't' '\813' = Just '\7793'
compose 'U' '\804' = Just '\7794'
compose 'u' '\804' = Just '\7795'
compose 'U' '\816' = Just '\7796'
compose 'u' '\816' = Just '\7797'
compose 'U' '\813' = Just '\7798'
compose 'u' '\813' = Just '\7799'
compose '\360' '\769' = Just '\7800'
compose '\361' '\769' = Just '\7801'
compose '\362' '\776' = Just '\7802'
compose '\363' '\776' = Just '\7803'
compose 'V' '\771' = Just '\7804'
compose 'v' '\771' = Just '\7805'
compose 'V' '\803' = Just '\7806'
compose 'v' '\803' = Just '\7807'
compose 'W' '\768' = Just '\7808'
compose 'w' '\768' = Just '\7809'
compose 'W' '\769' = Just '\7810'
compose 'w' '\769' = Just '\7811'
compose 'W' '\776' = Just '\7812'
compose 'w' '\776' = Just '\7813'
compose 'W' '\775' = Just '\7814'
compose 'w' '\775' = Just '\7815'
compose 'W' '\803' = Just '\7816'
compose 'w' '\803' = Just '\7817'
compose 'X' '\775' = Just '\7818'
compose 'x' '\775' = Just '\7819'
compose 'X' '\776' = Just '\7820'
compose 'x' '\776' = Just '\7821'
compose 'Y' '\775' = Just '\7822'
compose 'y' '\775' = Just '\7823'
compose 'Z' '\770' = Just '\7824'
compose 'z' '\770' = Just '\7825'
compose 'Z' '\803' = Just '\7826'
compose 'z' '\803' = Just '\7827'
compose 'Z' '\817' = Just '\7828'
compose 'z' '\817' = Just '\7829'
compose 'h' '\817' = Just '\7830'
compose 't' '\776' = Just '\7831'
compose 'w' '\778' = Just '\7832'
compose 'y' '\778' = Just '\7833'
compose '\383' '\775' = Just '\7835'
compose 'A' '\803' = Just '\7840'
compose 'a' '\803' = Just '\7841'
compose 'A' '\777' = Just '\7842'
compose 'a' '\777' = Just '\7843'
compose '\194' '\769' = Just '\7844'
compose '\226' '\769' = Just '\7845'
compose '\194' '\768' = Just '\7846'
compose '\226' '\768' = Just '\7847'
compose '\194' '\777' = Just '\7848'
compose '\226' '\777' = Just '\7849'
compose '\194' '\771' = Just '\7850'
compose '\226' '\771' = Just '\7851'
compose '\7840' '\770' = Just '\7852'
compose '\7841' '\770' = Just '\7853'
compose '\258' '\769' = Just '\7854'
compose '\259' '\769' = Just '\7855'
compose '\258' '\768' = Just '\7856'
compose '\259' '\768' = Just '\7857'
compose '\258' '\777' = Just '\7858'
compose '\259' '\777' = Just '\7859'
compose '\258' '\771' = Just '\7860'
compose '\259' '\771' = Just '\7861'
compose '\7840' '\774' = Just '\7862'
compose '\7841' '\774' = Just '\7863'
compose 'E' '\803' = Just '\7864'
compose 'e' '\803' = Just '\7865'
compose 'E' '\777' = Just '\7866'
compose 'e' '\777' = Just '\7867'
compose 'E' '\771' = Just '\7868'
compose 'e' '\771' = Just '\7869'
compose '\202' '\769' = Just '\7870'
compose '\234' '\769' = Just '\7871'
compose '\202' '\768' = Just '\7872'
compose '\234' '\768' = Just '\7873'
compose '\202' '\777' = Just '\7874'
compose '\234' '\777' = Just '\7875'
compose '\202' '\771' = Just '\7876'
compose '\234' '\771' = Just '\7877'
compose '\7864' '\770' = Just '\7878'
compose '\7865' '\770' = Just '\7879'
compose 'I' '\777' = Just '\7880'
compose 'i' '\777' = Just '\7881'
compose 'I' '\803' = Just '\7882'
compose 'i' '\803' = Just '\7883'
compose 'O' '\803' = Just '\7884'
compose 'o' '\803' = Just '\7885'
compose 'O' '\777' = Just '\7886'
compose 'o' '\777' = Just '\7887'
compose '\212' '\769' = Just '\7888'
compose '\244' '\769' = Just '\7889'
compose '\212' '\768' = Just '\7890'
compose '\244' '\768' = Just '\7891'
compose '\212' '\777' = Just '\7892'
compose '\244' '\777' = Just '\7893'
compose '\212' '\771' = Just '\7894'
compose '\244' '\771' = Just '\7895'
compose '\7884' '\770' = Just '\7896'
compose '\7885' '\770' = Just '\7897'
compose '\416' '\769' = Just '\7898'
compose '\417' '\769' = Just '\7899'
compose '\416' '\768' = Just '\7900'
compose '\417' '\768' = Just '\7901'
compose '\416' '\777' = Just '\7902'
compose '\417' '\777' = Just '\7903'
compose '\416' '\771' = Just '\7904'
compose '\417' '\771' = Just '\7905'
compose '\416' '\803' = Just '\7906'
compose '\417' '\803' = Just '\7907'
compose 'U' '\803' = Just '\7908'
compose 'u' '\803' = Just '\7909'
compose 'U' '\777' = Just '\7910'
compose 'u' '\777' = Just '\7911'
compose '\431' '\769' = Just '\7912'
compose '\432' '\769' = Just '\7913'
compose '\431' '\768' = Just '\7914'
compose '\432' '\768' = Just '\7915'
compose '\431' '\777' = Just '\7916'
compose '\432' '\777' = Just '\7917'
compose '\431' '\771' = Just '\7918'
compose '\432' '\771' = Just '\7919'
compose '\431' '\803' = Just '\7920'
compose '\432' '\803' = Just '\7921'
compose 'Y' '\768' = Just '\7922'
compose 'y' '\768' = Just '\7923'
compose 'Y' '\803' = Just '\7924'
compose 'y' '\803' = Just '\7925'
compose 'Y' '\777' = Just '\7926'
compose 'y' '\777' = Just '\7927'
compose 'Y' '\771' = Just '\7928'
compose 'y' '\771' = Just '\7929'
compose '\945' '\787' = Just '\7936'
compose '\945' '\788' = Just '\7937'
compose '\7936' '\768' = Just '\7938'
compose '\7937' '\768' = Just '\7939'
compose '\7936' '\769' = Just '\7940'
compose '\7937' '\769' = Just '\7941'
compose '\7936' '\834' = Just '\7942'
compose '\7937' '\834' = Just '\7943'
compose '\913' '\787' = Just '\7944'
compose '\913' '\788' = Just '\7945'
compose '\7944' '\768' = Just '\7946'
compose '\7945' '\768' = Just '\7947'
compose '\7944' '\769' = Just '\7948'
compose '\7945' '\769' = Just '\7949'
compose '\7944' '\834' = Just '\7950'
compose '\7945' '\834' = Just '\7951'
compose '\949' '\787' = Just '\7952'
compose '\949' '\788' = Just '\7953'
compose '\7952' '\768' = Just '\7954'
compose '\7953' '\768' = Just '\7955'
compose '\7952' '\769' = Just '\7956'
compose '\7953' '\769' = Just '\7957'
compose '\917' '\787' = Just '\7960'
compose '\917' '\788' = Just '\7961'
compose '\7960' '\768' = Just '\7962'
compose '\7961' '\768' = Just '\7963'
compose '\7960' '\769' = Just '\7964'
compose '\7961' '\769' = Just '\7965'
compose '\951' '\787' = Just '\7968'
compose '\951' '\788' = Just '\7969'
compose '\7968' '\768' = Just '\7970'
compose '\7969' '\768' = Just '\7971'
compose '\7968' '\769' = Just '\7972'
compose '\7969' '\769' = Just '\7973'
compose '\7968' '\834' = Just '\7974'
compose '\7969' '\834' = Just '\7975'
compose '\919' '\787' = Just '\7976'
compose '\919' '\788' = Just '\7977'
compose '\7976' '\768' = Just '\7978'
compose '\7977' '\768' = Just '\7979'
compose '\7976' '\769' = Just '\7980'
compose '\7977' '\769' = Just '\7981'
compose '\7976' '\834' = Just '\7982'
compose '\7977' '\834' = Just '\7983'
compose '\953' '\787' = Just '\7984'
compose '\953' '\788' = Just '\7985'
compose '\7984' '\768' = Just '\7986'
compose '\7985' '\768' = Just '\7987'
compose '\7984' '\769' = Just '\7988'
compose '\7985' '\769' = Just '\7989'
compose '\7984' '\834' = Just '\7990'
compose '\7985' '\834' = Just '\7991'
compose '\921' '\787' = Just '\7992'
compose '\921' '\788' = Just '\7993'
compose '\7992' '\768' = Just '\7994'
compose '\7993' '\768' = Just '\7995'
compose '\7992' '\769' = Just '\7996'
compose '\7993' '\769' = Just '\7997'
compose '\7992' '\834' = Just '\7998'
compose '\7993' '\834' = Just '\7999'
compose '\959' '\787' = Just '\8000'
compose '\959' '\788' = Just '\8001'
compose '\8000' '\768' = Just '\8002'
compose '\8001' '\768' = Just '\8003'
compose '\8000' '\769' = Just '\8004'
compose '\8001' '\769' = Just '\8005'
compose '\927' '\787' = Just '\8008'
compose '\927' '\788' = Just '\8009'
compose '\8008' '\768' = Just '\8010'
compose '\8009' '\768' = Just '\8011'
compose '\8008' '\769' = Just '\8012'
compose '\8009' '\769' = Just '\8013'
compose '\965' '\787' = Just '\8016'
compose '\965' '\788' = Just '\8017'
compose '\8016' '\768' = Just '\8018'
compose '\8017' '\768' = Just '\8019'
compose '\8016' '\769' = Just '\8020'
compose '\8017' '\769' = Just '\8021'
compose '\8016' '\834' = Just '\8022'
compose '\8017' '\834' = Just '\8023'
compose '\933' '\788' = Just '\8025'
compose '\8025' '\768' = Just '\8027'
compose '\8025' '\769' = Just '\8029'
compose '\8025' '\834' = Just '\8031'
compose '\969' '\787' = Just '\8032'
compose '\969' '\788' = Just '\8033'
compose '\8032' '\768' = Just '\8034'
compose '\8033' '\768' = Just '\8035'
compose '\8032' '\769' = Just '\8036'
compose '\8033' '\769' = Just '\8037'
compose '\8032' '\834' = Just '\8038'
compose '\8033' '\834' = Just '\8039'
compose '\937' '\787' = Just '\8040'
compose '\937' '\788' = Just '\8041'
compose '\8040' '\768' = Just '\8042'
compose '\8041' '\768' = Just '\8043'
compose '\8040' '\769' = Just '\8044'
compose '\8041' '\769' = Just '\8045'
compose '\8040' '\834' = Just '\8046'
compose '\8041' '\834' = Just '\8047'
compose '\945' '\768' = Just '\8048'
compose '\949' '\768' = Just '\8050'
compose '\951' '\768' = Just '\8052'
compose '\953' '\768' = Just '\8054'
compose '\959' '\768' = Just '\8056'
compose '\965' '\768' = Just '\8058'
compose '\969' '\768' = Just '\8060'
compose '\7936' '\837' = Just '\8064'
compose '\7937' '\837' = Just '\8065'
compose '\7938' '\837' = Just '\8066'
compose '\7939' '\837' = Just '\8067'
compose '\7940' '\837' = Just '\8068'
compose '\7941' '\837' = Just '\8069'
compose '\7942' '\837' = Just '\8070'
compose '\7943' '\837' = Just '\8071'
compose '\7944' '\837' = Just '\8072'
compose '\7945' '\837' = Just '\8073'
compose '\7946' '\837' = Just '\8074'
compose '\7947' '\837' = Just '\8075'
compose '\7948' '\837' = Just '\8076'
compose '\7949' '\837' = Just '\8077'
compose '\7950' '\837' = Just '\8078'
compose '\7951' '\837' = Just '\8079'
compose '\7968' '\837' = Just '\8080'
compose '\7969' '\837' = Just '\8081'
compose '\7970' '\837' = Just '\8082'
compose '\7971' '\837' = Just '\8083'
compose '\7972' '\837' = Just '\8084'
compose '\7973' '\837' = Just '\8085'
compose '\7974' '\837' = Just '\8086'
compose '\7975' '\837' = Just '\8087'
compose '\7976' '\837' = Just '\8088'
compose '\7977' '\837' = Just '\8089'
compose '\7978' '\837' = Just '\8090'
compose '\7979' '\837' = Just '\8091'
compose '\7980' '\837' = Just '\8092'
compose '\7981' '\837' = Just '\8093'
compose '\7982' '\837' = Just '\8094'
compose '\7983' '\837' = Just '\8095'
compose '\8032' '\837' = Just '\8096'
compose '\8033' '\837' = Just '\8097'
compose '\8034' '\837' = Just '\8098'
compose '\8035' '\837' = Just '\8099'
compose '\8036' '\837' = Just '\8100'
compose '\8037' '\837' = Just '\8101'
compose '\8038' '\837' = Just '\8102'
compose '\8039' '\837' = Just '\8103'
compose '\8040' '\837' = Just '\8104'
compose '\8041' '\837' = Just '\8105'
compose '\8042' '\837' = Just '\8106'
compose '\8043' '\837' = Just '\8107'
compose '\8044' '\837' = Just '\8108'
compose '\8045' '\837' = Just '\8109'
compose '\8046' '\837' = Just '\8110'
compose '\8047' '\837' = Just '\8111'
compose '\945' '\774' = Just '\8112'
compose '\945' '\772' = Just '\8113'
compose '\8048' '\837' = Just '\8114'
compose '\945' '\837' = Just '\8115'
compose '\940' '\837' = Just '\8116'
compose '\945' '\834' = Just '\8118'
compose '\8118' '\837' = Just '\8119'
compose '\913' '\774' = Just '\8120'
compose '\913' '\772' = Just '\8121'
compose '\913' '\768' = Just '\8122'
compose '\913' '\837' = Just '\8124'
compose '\168' '\834' = Just '\8129'
compose '\8052' '\837' = Just '\8130'
compose '\951' '\837' = Just '\8131'
compose '\942' '\837' = Just '\8132'
compose '\951' '\834' = Just '\8134'
compose '\8134' '\837' = Just '\8135'
compose '\917' '\768' = Just '\8136'
compose '\919' '\768' = Just '\8138'
compose '\919' '\837' = Just '\8140'
compose '\8127' '\768' = Just '\8141'
compose '\8127' '\769' = Just '\8142'
compose '\8127' '\834' = Just '\8143'
compose '\953' '\774' = Just '\8144'
compose '\953' '\772' = Just '\8145'
compose '\970' '\768' = Just '\8146'
compose '\953' '\834' = Just '\8150'
compose '\970' '\834' = Just '\8151'
compose '\921' '\774' = Just '\8152'
compose '\921' '\772' = Just '\8153'
compose '\921' '\768' = Just '\8154'
compose '\8190' '\768' = Just '\8157'
compose '\8190' '\769' = Just '\8158'
compose '\8190' '\834' = Just '\8159'
compose '\965' '\774' = Just '\8160'
compose '\965' '\772' = Just '\8161'
compose '\971' '\768' = Just '\8162'
compose '\961' '\787' = Just '\8164'
compose '\961' '\788' = Just '\8165'
compose '\965' '\834' = Just '\8166'
compose '\971' '\834' = Just '\8167'
compose '\933' '\774' = Just '\8168'
compose '\933' '\772' = Just '\8169'
compose '\933' '\768' = Just '\8170'
compose '\929' '\788' = Just '\8172'
compose '\168' '\768' = Just '\8173'
compose '\8060' '\837' = Just '\8178'
compose '\969' '\837' = Just '\8179'
compose '\974' '\837' = Just '\8180'
compose '\969' '\834' = Just '\8182'
compose '\8182' '\837' = Just '\8183'
compose '\927' '\768' = Just '\8184'
compose '\937' '\768' = Just '\8186'
compose '\937' '\837' = Just '\8188'
compose '\8592' '\824' = Just '\8602'
compose '\8594' '\824' = Just '\8603'
compose '\8596' '\824' = Just '\8622'
compose '\8656' '\824' = Just '\8653'
compose '\8660' '\824' = Just '\8654'
compose '\8658' '\824' = Just '\8655'
compose '\8707' '\824' = Just '\8708'
compose '\8712' '\824' = Just '\8713'
compose '\8715' '\824' = Just '\8716'
compose '\8739' '\824' = Just '\8740'
compose '\8741' '\824' = Just '\8742'
compose '\8764' '\824' = Just '\8769'
compose '\8771' '\824' = Just '\8772'
compose '\8773' '\824' = Just '\8775'
compose '\8776' '\824' = Just '\8777'
compose '=' '\824' = Just '\8800'
compose '\8801' '\824' = Just '\8802'
compose '\8781' '\824' = Just '\8813'
compose '<' '\824' = Just '\8814'
compose '>' '\824' = Just '\8815'
compose '\8804' '\824' = Just '\8816'
compose '\8805' '\824' = Just '\8817'
compose '\8818' '\824' = Just '\8820'
compose '\8819' '\824' = Just '\8821'
compose '\8822' '\824' = Just '\8824'
compose '\8823' '\824' = Just '\8825'
compose '\8826' '\824' = Just '\8832'
compose '\8827' '\824' = Just '\8833'
compose '\8834' '\824' = Just '\8836'
compose '\8835' '\824' = Just '\8837'
compose '\8838' '\824' = Just '\8840'
compose '\8839' '\824' = Just '\8841'
compose '\8866' '\824' = Just '\8876'
compose '\8872' '\824' = Just '\8877'
compose '\8873' '\824' = Just '\8878'
compose '\8875' '\824' = Just '\8879'
compose '\8828' '\824' = Just '\8928'
compose '\8829' '\824' = Just '\8929'
compose '\8849' '\824' = Just '\8930'
compose '\8850' '\824' = Just '\8931'
compose '\8882' '\824' = Just '\8938'
compose '\8883' '\824' = Just '\8939'
compose '\8884' '\824' = Just '\8940'
compose '\8885' '\824' = Just '\8941'
compose '\12363' '\12441' = Just '\12364'
compose '\12365' '\12441' = Just '\12366'
compose '\12367' '\12441' = Just '\12368'
compose '\12369' '\12441' = Just '\12370'
compose '\12371' '\12441' = Just '\12372'
compose '\12373' '\12441' = Just '\12374'
compose '\12375' '\12441' = Just '\12376'
compose '\12377' '\12441' = Just '\12378'
compose '\12379' '\12441' = Just '\12380'
compose '\12381' '\12441' = Just '\12382'
compose '\12383' '\12441' = Just '\12384'
compose '\12385' '\12441' = Just '\12386'
compose '\12388' '\12441' = Just '\12389'
compose '\12390' '\12441' = Just '\12391'
compose '\12392' '\12441' = Just '\12393'
compose '\12399' '\12441' = Just '\12400'
compose '\12399' '\12442' = Just '\12401'
compose '\12402' '\12441' = Just '\12403'
compose '\12402' '\12442' = Just '\12404'
compose '\12405' '\12441' = Just '\12406'
compose '\12405' '\12442' = Just '\12407'
compose '\12408' '\12441' = Just '\12409'
compose '\12408' '\12442' = Just '\12410'
compose '\12411' '\12441' = Just '\12412'
compose '\12411' '\12442' = Just '\12413'
compose '\12358' '\12441' = Just '\12436'
compose '\12445' '\12441' = Just '\12446'
compose '\12459' '\12441' = Just '\12460'
compose '\12461' '\12441' = Just '\12462'
compose '\12463' '\12441' = Just '\12464'
compose '\12465' '\12441' = Just '\12466'
compose '\12467' '\12441' = Just '\12468'
compose '\12469' '\12441' = Just '\12470'
compose '\12471' '\12441' = Just '\12472'
compose '\12473' '\12441' = Just '\12474'
compose '\12475' '\12441' = Just '\12476'
compose '\12477' '\12441' = Just '\12478'
compose '\12479' '\12441' = Just '\12480'
compose '\12481' '\12441' = Just '\12482'
compose '\12484' '\12441' = Just '\12485'
compose '\12486' '\12441' = Just '\12487'
compose '\12488' '\12441' = Just '\12489'
compose '\12495' '\12441' = Just '\12496'
compose '\12495' '\12442' = Just '\12497'
compose '\12498' '\12441' = Just '\12499'
compose '\12498' '\12442' = Just '\12500'
compose '\12501' '\12441' = Just '\12502'
compose '\12501' '\12442' = Just '\12503'
compose '\12504' '\12441' = Just '\12505'
compose '\12504' '\12442' = Just '\12506'
compose '\12507' '\12441' = Just '\12508'
compose '\12507' '\12442' = Just '\12509'
compose '\12454' '\12441' = Just '\12532'
compose '\12527' '\12441' = Just '\12535'
compose '\12528' '\12441' = Just '\12536'
compose '\12529' '\12441' = Just '\12537'
compose '\12530' '\12441' = Just '\12538'
compose '\12541' '\12441' = Just '\12542'
compose '\69785' '\69818' = Just '\69786'
compose '\69787' '\69818' = Just '\69788'
compose '\69797' '\69818' = Just '\69803'
compose '\69937' '\69927' = Just '\69934'
compose '\69938' '\69927' = Just '\69935'
compose '\70471' '\70462' = Just '\70475'
compose '\70471' '\70487' = Just '\70476'
compose '\70841' '\70842' = Just '\70843'
compose '\70841' '\70832' = Just '\70844'
compose '\70841' '\70845' = Just '\70846'
compose '\71096' '\71087' = Just '\71098'
compose '\71097' '\71087' = Just '\71099'
compose '\71989' '\71984' = Just '\71992'

compose _ _ = Nothing


composeStarters :: Char -> Char -> Maybe Char
composeStarters '\2503' '\2494' = Just '\2507'
composeStarters '\2503' '\2519' = Just '\2508'
composeStarters '\2887' '\2902' = Just '\2888'
composeStarters '\2887' '\2878' = Just '\2891'
composeStarters '\2887' '\2903' = Just '\2892'
composeStarters '\2962' '\3031' = Just '\2964'
composeStarters '\3014' '\3006' = Just '\3018'
composeStarters '\3015' '\3006' = Just '\3019'
composeStarters '\3014' '\3031' = Just '\3020'
composeStarters '\3263' '\3285' = Just '\3264'
composeStarters '\3270' '\3285' = Just '\3271'
composeStarters '\3270' '\3286' = Just '\3272'
composeStarters '\3270' '\3266' = Just '\3274'
composeStarters '\3274' '\3285' = Just '\3275'
composeStarters '\3398' '\3390' = Just '\3402'
composeStarters '\3399' '\3390' = Just '\3403'
composeStarters '\3398' '\3415' = Just '\3404'
composeStarters '\3545' '\3535' = Just '\3548'
composeStarters '\3545' '\3551' = Just '\3550'
composeStarters '\4133' '\4142' = Just '\4134'
composeStarters '\6917' '\6965' = Just '\6918'
composeStarters '\6919' '\6965' = Just '\6920'
composeStarters '\6921' '\6965' = Just '\6922'
composeStarters '\6923' '\6965' = Just '\6924'
composeStarters '\6925' '\6965' = Just '\6926'
composeStarters '\6929' '\6965' = Just '\6930'
composeStarters '\6970' '\6965' = Just '\6971'
composeStarters '\6972' '\6965' = Just '\6973'
composeStarters '\6974' '\6965' = Just '\6976'
composeStarters '\6975' '\6965' = Just '\6977'
composeStarters '\6978' '\6965' = Just '\6979'
composeStarters '\69937' '\69927' = Just '\69934'
composeStarters '\69938' '\69927' = Just '\69935'
composeStarters '\70471' '\70462' = Just '\70475'
composeStarters '\70471' '\70487' = Just '\70476'
composeStarters '\70841' '\70842' = Just '\70843'
composeStarters '\70841' '\70832' = Just '\70844'
composeStarters '\70841' '\70845' = Just '\70846'
composeStarters '\71096' '\71087' = Just '\71098'
composeStarters '\71097' '\71087' = Just '\71099'
composeStarters '\71989' '\71984' = Just '\71992'

composeStarters _ _ = Nothing


{-# INLINE isSecondStarter #-}
isSecondStarter :: Char -> Bool
isSecondStarter c = c >= '\x09BE' && c <= '\x11930' && lookupIsSecondStarterBitMap (ord c)

{-# INLINE lookupIsSecondStarterBitMap #-}
lookupIsSecondStarterBitMap :: Int -> Bool
lookupIsSecondStarterBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets1# (
            lookupWord8AsInt offsets2# (
                n `shiftR` 11
            ) + ((n `shiftR` 9) .&. maskOffsets)
        ) + ((n `shiftR` 3) .&. maskData)
    ) (n .&. 7)
    where
    maskData = (1 `shiftL` 6) - 1
    maskOffsets = (1 `shiftL` 2) - 1
    !(Ptr data#) = isSecondStarterDataBitMap
    !(Ptr offsets1#) = isSecondStarterOffsets1BitMap
    !(Ptr offsets2#) = isSecondStarterOffsets2BitMap

isSecondStarterDataBitMap :: Ptr Int8
isSecondStarterDataBitMap = Ptr
    "\0\0\0\0\0\64\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\64\0\0\128\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\4\0\
    \\96\0\0\0\0\0\0\0\0\0\0\0\0\64\0\0\128\0\0\0\0\0\0\0\0\0\0\0\0\0\0\128\0\128\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\128\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\32\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\64\0\0\192\0\0\0\0\0\0\0\0\0\0\0\0\64\0\0\128\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\36\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\128\0\0\
    \\0\0\0\0\0\0\0\0"#

isSecondStarterOffsets1BitMap :: Ptr Word16
isSecondStarterOffsets1BitMap = Ptr
    "\15\0\214\0\74\0\6\0\6\0\6\0\6\0\0\0\6\0\6\0\6\0\175\0\6\0\6\0\138\0\31\0\38\1\6\0\175\0\6\0\6\0\22\1"#

isSecondStarterOffsets2BitMap :: Ptr Word8
isSecondStarterOffsets2BitMap = Ptr
    "\3\0\7\10\3\3\3\3\3\3\3\3\3\3\3\3\3\3\3\3\3\3\3\3\3\3\3\3\3\3\3\3\3\3\14\21"#

