--TEST--
Document type (DBRef sub-documents): Sub-document resembles DBRef but $ref is not a string
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/basic.inc';

$canonicalBson = hex2bin('2c000000036462726566002000000010247265660001000000072469640058921b3e6e32ab156a22b59e0000');
$canonicalExtJson = '{"dbref": {"$ref": {"$numberInt": "1"}, "$id": {"$oid": "58921b3e6e32ab156a22b59e"}}}';

// Canonical BSON -> BSON object -> Canonical BSON
echo bin2hex((string) MongoDB\BSON\Document::fromBSON($canonicalBson)), "\n";

// Canonical BSON -> BSON object -> Canonical extJSON
echo json_canonicalize(MongoDB\BSON\Document::fromBSON($canonicalBson)->toCanonicalExtendedJSON()), "\n";

// Canonical extJSON -> BSON object -> Canonical BSON
echo bin2hex((string) MongoDB\BSON\Document::fromJSON($canonicalExtJson)), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
2c000000036462726566002000000010247265660001000000072469640058921b3e6e32ab156a22b59e0000
{"dbref":{"$ref":{"$numberInt":"1"},"$id":{"$oid":"58921b3e6e32ab156a22b59e"}}}
2c000000036462726566002000000010247265660001000000072469640058921b3e6e32ab156a22b59e0000
===DONE===