/*
 * 86Box    A hypervisor and IBM PC system emulator that specializes in
 *          running old operating systems and software designed for IBM
 *          PC systems and compatibles from 1981 through fairly recent
 *          system designs based on the PCI bus.
 *
 *          This file is part of the 86Box distribution.
 *
 *          Define all known processor types.
 *
 *
 *
 * Authors: Sarah Walker, <https://pcem-emulator.co.uk/>
 *          leilei,
 *          Miran Grca, <mgrca8@gmail.com>
 *          Fred N. van Kempen, <decwiz@yahoo.com>
 *          RichardG, <richardg867@gmail.com>
 *          dob205,
 *          Jasmine Iwanek, <jriwanek@gmail.com>
 *
 *          Copyright 2008-2019 Sarah Walker.
 *          Copyright 2016-2019 leilei.
 *          Copyright 2016-2024 Miran Grca.
 *          Copyright 2017-2020 Fred N. van Kempen.
 *          Copyright 2020      RichardG.
 *          Copyright 2021      dob205.
 *          Copyright 2022-2024 Jasmine Iwanek.
 */
#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <wchar.h>
#include <86box/86box.h>
#include "cpu.h"
#include <86box/machine.h>

FPU fpus_none[] = {
    { .name = "None", .internal_name = "none", .type = FPU_NONE },
    { .name = NULL,   .internal_name = NULL,   .type = 0        }
};
FPU fpus_8088[] = {
    { .name = "None", .internal_name = "none", .type = FPU_NONE },
    { .name = "8087", .internal_name = "8087", .type = FPU_8087 },
    { .name = NULL,   .internal_name = NULL,   .type = 0        }
};
FPU fpus_80186[] = {
    { .name = "None",  .internal_name = "none",  .type = FPU_NONE  },
    { .name = "8087",  .internal_name = "8087",  .type = FPU_8087  },
    { .name = "80187", .internal_name = "80187", .type = FPU_80187 },
    { .name = NULL,    .internal_name = NULL,    .type = 0         }
};
FPU fpus_80286[] = {
    { .name = "None",  .internal_name = "none",  .type = FPU_NONE  },
    { .name = "287",   .internal_name = "287",   .type = FPU_287   },
    { .name = "287XL", .internal_name = "287xl", .type = FPU_287XL },
    { .name = NULL,    .internal_name = NULL,    .type = 0         }
};
FPU fpus_80386[] = {
    { .name = "None", .internal_name = "none", .type = FPU_NONE },
    { .name = "387",  .internal_name = "387",  .type = FPU_387  },
    { .name = NULL,   .internal_name = NULL,   .type = 0        }
};
FPU fpus_486sx[] = {
    { .name = "None",  .internal_name = "none",  .type = FPU_NONE  },
    { .name = "487SX", .internal_name = "487sx", .type = FPU_487SX },
    { .name = NULL,    .internal_name = NULL,    .type = 0         }
};
FPU fpus_internal[] = {
    { .name = "Internal", .internal_name = "internal", .type = FPU_INTERNAL },
    { .name = NULL,       .internal_name = NULL,       .type = 0            }
};

const cpu_family_t cpu_families[] = {
  // clang-format off
    {
        .package       = CPU_PKG_8088,
        .manufacturer  = "Intel",
        .name          = "8088",
        .internal_name = "8088",
        .cpus          = (const CPU[]) {
            {
                .name               = "4.77",
                .cpu_type           = CPU_8088,
                .fpus               = fpus_8088,
                .rspeed             = 4772728,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "7.16",
                .cpu_type           = CPU_8088,
                .fpus               = fpus_8088,
                .rspeed             = 7159092,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "8",
                .cpu_type           = CPU_8088,
                .fpus               = fpus_8088,
                .rspeed             = 8000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
#if 0
            {
                .name               = "9.54",
                .cpu_type           = CPU_8088,
                .fpus               = fpus_8088,
                .rspeed             = 9545456,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
#endif
            {
                .name               = "10",
                .cpu_type           = CPU_8088,
                .fpus               = fpus_8088,
                .rspeed             = 10000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "12",
                .cpu_type           = CPU_8088,
                .fpus               = fpus_8088,
                .rspeed             = 12000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "16",
                .cpu_type           = CPU_8088,
                .fpus               = fpus_8088,
                .rspeed             = 16000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_8088_EUROPC,
        .manufacturer  = "Intel",
        .name          = "8088",
        .internal_name = "8088_europc",
        .cpus          = (const CPU[]) {
            {
                .name               = "4.77",
                .cpu_type           = CPU_8088,
                .fpus               = fpus_8088,
                .rspeed             = 4772728,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_ALTERNATE_XTAL,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "7.16",
                .cpu_type           = CPU_8088,
                .fpus               = fpus_8088,
                .rspeed             = 7159092,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_ALTERNATE_XTAL,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "9.54",
                .cpu_type           = CPU_8088,
                .fpus               = fpus_8088,
                .rspeed             = 9545456,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_8088_VTECH,
        .manufacturer  = "Intel",
        .name          = "8088",
        .internal_name = "8088_vtech",
        .cpus          = (const CPU[]) {
            {
                .name               = "4.77",
                .cpu_type           = CPU_8088,
                .fpus               = fpus_8088,
                .rspeed             = 4772728,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },

            {
                .name               = "10",
                .cpu_type           = CPU_8088,
                .fpus               = fpus_8088,
                .rspeed             = 10000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_8086,
        .manufacturer  = "Intel",
        .name          = "8086",
        .internal_name = "8086",
        .cpus          = (const CPU[]) {
            {
                .name               = "7.16",
                .cpu_type           = CPU_8086,
                .fpus               = fpus_8088,
                .rspeed             = 7159092,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_ALTERNATE_XTAL,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "8",
                .cpu_type           = CPU_8086,
                .fpus               = fpus_8088,
                .rspeed             = 8000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "9.54",
                .cpu_type           = CPU_8086,
                .fpus               = fpus_8088,
                .rspeed             = 9545456,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_ALTERNATE_XTAL,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "10",
                .cpu_type           = CPU_8086,
                .fpus               = fpus_8088,
                .rspeed             = 10000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "12",
                .cpu_type           = CPU_8086,
                .fpus               = fpus_8088,
                .rspeed             = 12000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "16",
                .cpu_type           = CPU_8086,
                .fpus               = fpus_8088,
                .rspeed             = 16000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 2
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_8086_MAZOVIA,
        .manufacturer  = "Kyiv Research Institute of Microdevices",
        .name          = "K1810VM86",
        .internal_name = "8086_mazovia",
        .cpus          = (const CPU[]) {
            {
                .name               = "4.77",
                .cpu_type           = CPU_8086_MAZOVIA,
                .fpus               = fpus_8088,
                .rspeed             = 4772728,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_ALTERNATE_XTAL,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_8086_VTECH,
        .manufacturer  = "Intel",
        .name          = "8086",
        .internal_name = "8086_vtech",
        .cpus          = (const CPU[]) {
            {
                .name               = "4.77",
                .cpu_type           = CPU_8086,
                .fpus               = fpus_8088,
                .rspeed             = 4772728,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "10",
                .cpu_type           = CPU_8086,
                .fpus               = fpus_8088,
                .rspeed             = 10000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_188,
        .manufacturer  = "Intel",
        .name          = "80188",
        .internal_name = "80188",
        .cpus          = (const CPU[]) {
            {
                .name               = "6",
                .cpu_type           = CPU_188,
                .fpus               = fpus_8088,
                .rspeed             = 6000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "7.16",
                .cpu_type           = CPU_188,
                .fpus               = fpus_8088,
                .rspeed             = 7159092,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_ALTERNATE_XTAL,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "8",
                .cpu_type           = CPU_188,
                .fpus               = fpus_8088,
                .rspeed             = 8000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "9.54",
                .cpu_type           = CPU_188,
                .fpus               = fpus_8088,
                .rspeed             = 9545456,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_ALTERNATE_XTAL,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "10",
                .cpu_type           = CPU_188,
                .fpus               = fpus_8088,
                .rspeed             = 10000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "12",
                .cpu_type           = CPU_188,
                .fpus               = fpus_8088,
                .rspeed             = 12000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "16",
                .cpu_type           = CPU_188,
                .fpus               = fpus_8088,
                .rspeed             = 16000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 2
            },
            {
                .name               = "20",
                .cpu_type           = CPU_188,
                .fpus               = fpus_8088,
                .rspeed             = 20000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 3
            },
            {
                .name               = "25",
                .cpu_type           = CPU_188,
                .fpus               = fpus_8088,
                .rspeed             = 25000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 3
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_8088,
        .manufacturer  = "NEC",
        .name          = "V20",
        .internal_name = "necv20",
        .cpus          = (const CPU[]) {
            {
                .name               = "4.77",
                .cpu_type           = CPU_V20,
                .fpus               = fpus_8088,
                .rspeed             = 4772728,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "7.16",
                .cpu_type           = CPU_V20,
                .fpus               = fpus_8088,
                .rspeed             = 7159092,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "8",
                .cpu_type           = CPU_V20,
                .fpus               = fpus_8088,
                .rspeed             = 8000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "10",
                .cpu_type           = CPU_V20,
                .fpus               = fpus_8088,
                .rspeed             = 10000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "12",
                .cpu_type           = CPU_V20,
                .fpus               = fpus_8088,
                .rspeed             = 12000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "16",
                .cpu_type           = CPU_V20,
                .fpus               = fpus_8088,
                .rspeed             = 16000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 2
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_186,
        .manufacturer  = "Intel",
        .name          = "80186",
        .internal_name = "80186",
        .cpus          = (const CPU[]) {
            {
                .name               = "6",
                .cpu_type           = CPU_186,
                .fpus               = fpus_80186,
                .rspeed             = 6000000,
                .multi              = 1,
                .voltage            = 0,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "7.16",
                .cpu_type           = CPU_186,
                .fpus               = fpus_80186,
                .rspeed             = 7159092,
                .multi              = 1,
                .voltage            = 0,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_ALTERNATE_XTAL,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "8",
                .cpu_type           = CPU_186,
                .fpus               = fpus_80186,
                .rspeed             = 8000000,
                .multi              = 1,
                .voltage            = 0,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "9.54",
                .cpu_type           = CPU_186,
                .fpus               = fpus_80186,
                .rspeed             = 9545456,
                .multi              = 1,
                .voltage            = 0,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_ALTERNATE_XTAL,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "10",
                .cpu_type           = CPU_186,
                .fpus               = fpus_80186,
                .rspeed             = 10000000,
                .multi              = 1,
                .voltage            = 0,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "12",
                .cpu_type           = CPU_186,
                .fpus               = fpus_80186,
                .rspeed             = 12000000,
                .multi              = 1,
                .voltage            = 0,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "16",
                .cpu_type           = CPU_186,
                .fpus               = fpus_80186,
                .rspeed             = 16000000,
                .multi              = 1,
                .voltage            = 0,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 2
            },
            {
                .name               = "20",
                .cpu_type           = CPU_186,
                .fpus               = fpus_80186,
                .rspeed             = 20000000,
                .multi              = 1,
                .voltage            = 0,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 3
            },
            {
                .name               = "25",
                .cpu_type           = CPU_186,
                .fpus               = fpus_80186,
                .rspeed             = 25000000,
                .multi              = 1,
                .voltage            = 0,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 3
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_8086,
        .manufacturer  = "NEC",
        .name          = "V30",
        .internal_name = "necv30",
        .cpus          = (const CPU[]) {
            {
                .name               = "7.16",
                .cpu_type           = CPU_V30,
                .fpus               = fpus_80186,
                .rspeed             = 7159092,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "8",
                .cpu_type           = CPU_V30,
                .fpus               = fpus_80186,
                .rspeed             = 8000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "9.54",
                .cpu_type           = CPU_V30,
                .fpus               = fpus_80186,
                .rspeed             = 9545456,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "10",
                .cpu_type           = CPU_V30,
                .fpus               = fpus_80186,
                .rspeed             = 10000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "12",
                .cpu_type           = CPU_V30,
                .fpus               = fpus_80186,
                .rspeed             = 12000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 1
            },
            {
                .name               = "16",
                .cpu_type           = CPU_V30,
                .fpus               = fpus_80186,
                .rspeed             = 16000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 0,
                .mem_write_cycles   = 0,
                .cache_read_cycles  = 0,
                .cache_write_cycles = 0,
                .atclk_div          = 2
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_286,
        .manufacturer  = "Intel",
        .name          = "80286",
        .internal_name = "286",
        .cpus          = (const CPU[]) {
            {
                .name               = "6",
                .cpu_type           = CPU_286,
                .fpus               = fpus_80286,
                .rspeed             = 6000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 2,
                .mem_write_cycles   = 2,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 1
            },
            {
                .name               = "8",
                .cpu_type           = CPU_286,
                .fpus               = fpus_80286,
                .rspeed             = 8000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 2,
                .mem_write_cycles   = 2,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 1
            },
            {
                .name               = "10",
                .cpu_type           = CPU_286,
                .fpus               = fpus_80286,
                .rspeed             = 10000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 2,
                .mem_write_cycles   = 2,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 1
            },
            {
                .name               = "12",
                .cpu_type           = CPU_286,
                .fpus               = fpus_80286,
                .rspeed             = 12500000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 3,
                .mem_write_cycles   = 3,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 2
            },
            {
                .name               = "16",
                .cpu_type           = CPU_286,
                .fpus               = fpus_80286,
                .rspeed             = 16000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 3,
                .mem_write_cycles   = 3,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 2
            },
            {
                .name               = "20",
                .cpu_type           = CPU_286,
                .fpus               = fpus_80286,
                .rspeed             = 20000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 3
            },
            {
                .name               = "25",
                .cpu_type           = CPU_286,
                .fpus               = fpus_80286,
                .rspeed             = 25000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 3
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_386SX,
        .manufacturer  = "Intel",
        .name          = "i386SX",
        .internal_name = "i386sx",
        .cpus          = (const CPU[]) {
            {
                .name               = "16",
                .cpu_type           = CPU_386SX,
                .fpus               = fpus_80386,
                .rspeed             = 16000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x2308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 3,
                .mem_write_cycles   = 3,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 2
            },
            {
                .name               = "20",
                .cpu_type           = CPU_386SX,
                .fpus               = fpus_80386,
                .rspeed             = 20000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x2308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 3
            },
            {
                .name               = "25",
                .cpu_type           = CPU_386SX,
                .fpus               = fpus_80386,
                .rspeed             = 25000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x2308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 3
            },
            {
                .name               = "33",
                .cpu_type           = CPU_386SX,
                .fpus               = fpus_80386,
                .rspeed             = 33333333,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x2308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 4
            },
            {
                .name               = "40",
                .cpu_type           = CPU_386SX,
                .fpus               = fpus_80386,
                .rspeed             = 40000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x2308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 5
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_386SX,
        .manufacturer  = "AMD",
        .name          = "Am386SX",
        .internal_name = "am386sx",
        .cpus          = (const CPU[]) {
            {
                .name               = "16",
                .cpu_type           = CPU_386SX,
                .fpus               = fpus_80386,
                .rspeed             = 16000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x2308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 3,
                .mem_write_cycles   = 3,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 2
            },
            {
                .name               = "20",
                .cpu_type           = CPU_386SX,
                .fpus               = fpus_80386,
                .rspeed             = 20000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x2308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 3
            },
            {
                .name               = "25",
                .cpu_type           = CPU_386SX,
                .fpus               = fpus_80386,
                .rspeed             = 25000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x2308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 3
            },
            {
                .name               = "33",
                .cpu_type           = CPU_386SX,
                .fpus               = fpus_80386,
                .rspeed             = 33333333,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x2308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 4
            },
            {
                .name               = "40",
                .cpu_type           = CPU_386SX,
                .fpus               = fpus_80386,
                .rspeed             = 40000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x2308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 5
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_386DX,
        .manufacturer  = "Intel",
        .name          = "i386DX",
        .internal_name = "i386dx",
        .cpus          = (const CPU[]) {
            {
                .name               = "16",
                .cpu_type           = CPU_386DX,
                .fpus               = fpus_80386,
                .rspeed             = 16000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x0308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 3,
                .mem_write_cycles   = 3,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 2
            },
            {
                .name               = "20",
                .cpu_type           = CPU_386DX,
                .fpus               = fpus_80386,
                .rspeed             = 20000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x0308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 3
            },
            {
                .name               = "25",
                .cpu_type           = CPU_386DX,
                .fpus               = fpus_80386,
                .rspeed             = 25000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x0308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 3
            },
            {
                .name               = "33",
                .cpu_type           = CPU_386DX,
                .fpus               = fpus_80386,
                .rspeed             = 33333333,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x0308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 4
            },
            {
                .name               = "40",
                .cpu_type           = CPU_386DX,
                .fpus               = fpus_80386,
                .rspeed             = 40000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x0308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 5
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_386DX_DESKPRO386,
        .manufacturer  = "Intel",
        .name          = "i386DX",
        .internal_name = "i386dx_deskpro386",
        .cpus          = (const CPU[]) {
            {
                .name               = "16",
                .cpu_type           = CPU_386DX,
                .fpus               = fpus_80286,
                .rspeed             = 16000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x0308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 3,
                .mem_write_cycles   = 3,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 2
            },
            {
                .name               = "20",
                .cpu_type           = CPU_386DX,
                .fpus               = fpus_80386,
                .rspeed             = 20000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x0308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 3
            },
            {
                .name               = "25",
                .cpu_type           = CPU_386DX,
                .fpus               = fpus_80386,
                .rspeed             = 25000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x0308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 3
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_386DX,
        .manufacturer  = "Intel",
        .name          = "RapidCAD",
        .internal_name = "rapidcad",
        .cpus          = (const CPU[]) {
            {
                .name               = "25",
                .cpu_type           = CPU_RAPIDCAD,
                .fpus               = fpus_internal,
                .rspeed             = 25000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x0340,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 3
            },
            {
                .name               = "33",
                .cpu_type           = CPU_RAPIDCAD,
                .fpus               = fpus_internal,
                .rspeed             = 33333333,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x0340,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 4
            },
            {
                .name               = "40",
                .cpu_type           = CPU_RAPIDCAD,
                .fpus               = fpus_internal,
                .rspeed             = 40000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x0340,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 5
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_386DX,
        .manufacturer  = "AMD",
        .name          = "Am386DX",
        .internal_name = "am386dx",
        .cpus          = (const CPU[]) {
            {
                .name               = "25",
                .cpu_type           = CPU_386DX,
                .fpus               = fpus_80386,
                .rspeed             = 25000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x0308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 3
            },
            {
                .name               = "33",
                .cpu_type           = CPU_386DX,
                .fpus               = fpus_80386,
                .rspeed             = 33333333,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x0308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 4
            },
            {
                .name               = "40",
                .cpu_type           = CPU_386DX,
                .fpus               = fpus_80386,
                .rspeed             = 40000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x0308,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 5
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_M6117,
        .manufacturer  = "ALi",
        .name          = "M6117",
        .internal_name = "m6117",
        .cpus          = (const CPU[]) { /* All timings and edx_reset values assumed. */
            {
                .name               = "33",
                .cpu_type           = CPU_386SX,
                .fpus               = fpus_none,
                .rspeed             = 33333333,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x2309,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 4
            },
            {
                .name               = "40",
                .cpu_type           = CPU_386SX,
                .fpus               = fpus_none,
                .rspeed             = 40000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x2309,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 5
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_386SLC_IBM,
        .manufacturer  = "IBM",
        .name          = "386SLC",
        .internal_name = "ibm386slc",
        .cpus          = (const CPU[]) {
            {
                .name               = "16",
                .cpu_type           = CPU_IBM386SLC,
                .fpus               = fpus_80386,
                .rspeed             = 16000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0xA301,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 3,
                .mem_write_cycles   = 3,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 2
            },
            {
                .name               = "20",
                .cpu_type           = CPU_IBM386SLC,
                .fpus               = fpus_80386,
                .rspeed             = 20000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0xA301,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 3
            },
            {
                .name               = "25",
                .cpu_type           = CPU_IBM386SLC,
                .fpus               = fpus_80386,
                .rspeed             = 25000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0xA301,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 3
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_386SX,
        .manufacturer  = "Cyrix",
        .name          = "Cx486SLC",
        .internal_name = "cx486slc",
        .cpus          = (const CPU[]) {
            {
                .name               = "20",
                .cpu_type           = CPU_486SLC,
                .fpus               = fpus_80386,
                .rspeed             = 20000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x400,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0000,
                .cpu_flags          = 0,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 3
            },
            {
                .name               = "25",
                .cpu_type           = CPU_486SLC,
                .fpus               = fpus_80386,
                .rspeed             = 25000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x400,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0000,
                .cpu_flags          = 0,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 3
            },
            {
                .name               = "33",
                .cpu_type           = CPU_486SLC,
                .fpus               = fpus_80386,
                .rspeed             = 33333333,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x400,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0000,
                .cpu_flags          = 0,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 4
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_386SX,
        .manufacturer  = "Cyrix",
        .name          = "Cx486SRx2",
        .internal_name = "cx486srx2",
        .cpus          = (const CPU[]) {
            {
                .name               = "32",
                .cpu_type           = CPU_486SLC,
                .fpus               = fpus_80386,
                .rspeed             = 32000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x406,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0006,
                .cpu_flags          = 0,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 4
            },
            {
                .name               = "40",
                .cpu_type           = CPU_486SLC,
                .fpus               = fpus_80386,
                .rspeed             = 40000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x406,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0006,
                .cpu_flags          = 0,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 6
            },
            {
                .name               = "50",
                .cpu_type           = CPU_486SLC,
                .fpus               = fpus_80386,
                .rspeed             = 50000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x406,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0006,
                .cpu_flags          = 0,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 6
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_486SLC_IBM,
        .manufacturer  = "IBM",
        .name          = "486SLC",
        .internal_name = "ibm486slc",
        .cpus          = (const CPU[]) {
            {
                .name               = "33",
                .cpu_type           = CPU_IBM486SLC,
                .fpus               = fpus_80386,
                .rspeed             = 33333333,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0xA401,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 4
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_486SLC_IBM,
        .manufacturer  = "IBM",
        .name          = "486SLC2",
        .internal_name = "ibm486slc2",
        .cpus          = (const CPU[]) {
            {
                .name               = "40",
                .cpu_type           = CPU_IBM486SLC,
                .fpus               = fpus_80386,
                .rspeed             = 40000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0xA421,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 5
            },
            {
                .name               = "50",
                .cpu_type           = CPU_IBM486SLC,
                .fpus               = fpus_80386,
                .rspeed             = 50000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0xA421,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 6
            },
            {
                .name               = "66",
                .cpu_type           = CPU_IBM486SLC,
                .fpus               = fpus_80386,
                .rspeed             = 66666666,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0xA421,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 8
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_486SLC_IBM,
        .manufacturer  = "IBM",
        .name          = "486SLC3",
        .internal_name = "ibm486slc3",
        .cpus          = (const CPU[]) {
            {
                .name               = "60",
                .cpu_type           = CPU_IBM486SLC,
                .fpus               = fpus_80386,
                .rspeed             = 60000000,
                .multi              = 3,
                .voltage            = 5000,
                .edx_reset          = 0xA439,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 7
            },
            {
                .name               = "75",
                .cpu_type           = CPU_IBM486SLC,
                .fpus               = fpus_80386,
                .rspeed             = 75000000,
                .multi              = 3,
                .voltage            = 5000,
                .edx_reset          = 0xA439,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 9
            },
            {
                .name               = "100",
                .cpu_type           = CPU_IBM486SLC,
                .fpus               = fpus_80386,
                .rspeed             = 100000000,
                .multi              = 3,
                .voltage            = 5000,
                .edx_reset          = 0xA439,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 12
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_486BL,
        .manufacturer  = "IBM",
        .name          = "486BL2",
        .internal_name = "ibm486bl2",
        .cpus          = (const CPU[]) {
            {
                .name               = "50",
                .cpu_type           = CPU_IBM486BL,
                .fpus               = fpus_80386,
                .rspeed             = 50000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x8439,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 6
            },
            {
                .name               = "66",
                .cpu_type           = CPU_IBM486BL,
                .fpus               = fpus_80386,
                .rspeed             = 66666666,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x8439,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 8
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_486BL,
        .manufacturer  = "IBM",
        .name          = "486BL3",
        .internal_name = "ibm486bl3",
        .cpus          = (const CPU[]) {
            {
                .name               = "75",
                .cpu_type           = CPU_IBM486BL,
                .fpus               = fpus_80386,
                .rspeed             = 75000000,
                .multi              = 3,
                .voltage            = 5000,
                .edx_reset          = 0x8439,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 9
            },
            {
                .name               = "100",
                .cpu_type           = CPU_IBM486BL,
                .fpus               = fpus_80386,
                .rspeed             = 100000000,
                .multi              = 3,
                .voltage            = 5000,
                .edx_reset          = 0x8439,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = 0,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 12
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_386DX,
        .manufacturer  = "Cyrix",
        .name          = "Cx486DLC",
        .internal_name = "cx486dlc",
        .cpus          = (const CPU[]) {
            {
                .name               = "25",
                .cpu_type           = CPU_486DLC,
                .fpus               = fpus_80386,
                .rspeed             = 25000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x401,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0001,
                .cpu_flags          = 0,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 3,
                .atclk_div          = 3
            },
            {
                .name               = "33",
                .cpu_type           = CPU_486DLC,
                .fpus               = fpus_80386,
                .rspeed             = 33333333,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x401,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0001,
                .cpu_flags          = 0,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 4
            },
            {
                .name               = "40",
                .cpu_type           = CPU_486DLC,
                .fpus               = fpus_80386,
                .rspeed             = 40000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x401,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0001,
                .cpu_flags          = 0,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 2,
                .cache_write_cycles = 2,
                .atclk_div          = 5
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_386DX,
        .manufacturer  = "Cyrix",
        .name          = "Cx486DRx2",
        .internal_name = "cx486drx2",
        .cpus          = (const CPU[]) {
            {
                .name               = "32",
                .cpu_type           = CPU_486DLC,
                .fpus               = fpus_80386,
                .rspeed             = 32000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x407,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0007,
                .cpu_flags          = 0,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 4
            },
            {
                .name               = "40",
                .cpu_type           = CPU_486DLC,
                .fpus               = fpus_80386,
                .rspeed             = 40000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x407,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0007,
                .cpu_flags          = 0,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 6
            },
            {
                .name               = "50",
                .cpu_type           = CPU_486DLC,
                .fpus               = fpus_80386,
                .rspeed             = 50000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x407,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0007,
                .cpu_flags          = 0,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 6
            },
            {
                .name               = "66",
                .cpu_type           = CPU_486DLC,
                .fpus               = fpus_80386,
                .rspeed             = 66666666,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x407,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0007,
                .cpu_flags          = 0,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 8
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET1,
        .manufacturer  = "Intel",
        .name          = "i486SX",
        .internal_name = "i486sx",
        .cpus          = (const CPU[]) {
            {
                .name               = "16",
                .cpu_type           = CPU_i486SX,
                .fpus               = fpus_486sx,
                .rspeed             = 16000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x420,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 3,
                .mem_write_cycles   = 3,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 2
            },
            {
                .name               = "20",
                .cpu_type           = CPU_i486SX,
                .fpus               = fpus_486sx,
                .rspeed             = 20000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x420,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 3
            },
            {
                .name               = "25",
                .cpu_type           = CPU_i486SX,
                .fpus               = fpus_486sx,
                .rspeed             = 25000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x422,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 3
            },
            {
                .name               = "33",
                .cpu_type           = CPU_i486SX,
                .fpus               = fpus_486sx,
                .rspeed             = 33333333,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x422,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 4
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET1,
        .manufacturer  = "Intel",
        .name          = "i486SX-S",
        .internal_name = "i486sx_slenh",
        .cpus          = (const CPU[]) {
            {
                .name               = "25",
                .cpu_type           = CPU_i486SX_SLENH,
                .fpus               = fpus_486sx,
                .rspeed             = 25000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x423,
                .cpuid_model        = 0x423,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 3
            },
            {
                .name               = "33",
                .cpu_type           = CPU_i486SX_SLENH,
                .fpus               = fpus_486sx,
                .rspeed             = 33333333,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x42a,
                .cpuid_model        = 0x42a,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 4
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET1,
        .manufacturer  = "Intel",
        .name          = "i486SX2",
        .internal_name = "i486sx2",
        .cpus          = (const CPU[]) {
            {
                .name               = "50",
                .cpu_type           = CPU_i486SX_SLENH,
                .fpus               = fpus_486sx,
                .rspeed             = 50000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x45b,
                .cpuid_model        = 0x45b,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 6
            },
            {
                .name               = "66 (Q0569)",
                .cpu_type           = CPU_i486SX_SLENH,
                .fpus               = fpus_486sx,
                .rspeed             = 66666666,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x45b,
                .cpuid_model        = 0x45b,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 8
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET1,
        .manufacturer  = "Intel",
        .name          = "i486DX",
        .internal_name = "i486dx",
        .cpus          = (const CPU[]) {
            {
                .name               = "25",
                .cpu_type           = CPU_i486DX,
                .fpus               = fpus_internal,
                .rspeed             = 25000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x404,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 3
            },
            {
                .name               = "33",
                .cpu_type           = CPU_i486DX,
                .fpus               = fpus_internal,
                .rspeed             = 33333333,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x404,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 4
            },
            {
                .name               = "50",
                .cpu_type           = CPU_i486DX,
                .fpus               = fpus_internal,
                .rspeed             = 50000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x411,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 6
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET1,
        .manufacturer  = "Intel",
        .name          = "i486DX-S",
        .internal_name = "i486dx_slenh",
        .cpus          = (const CPU[]) {
            {
                .name               = "33",
                .cpu_type           = CPU_i486DX_SLENH,
                .fpus               = fpus_internal,
                .rspeed             = 33333333,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x414,
                .cpuid_model        = 0x414,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 4
            },
            {
                .name               = "50",
                .cpu_type           = CPU_i486DX_SLENH,
                .fpus               = fpus_internal,
                .rspeed             = 50000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x414,
                .cpuid_model        = 0x414,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 6
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET1,
        .manufacturer  = "Intel",
        .name          = "i486DX2",
        .internal_name = "i486dx2",
        .cpus          = (const CPU[]) {
            {
                .name               = "40",
                .cpu_type           = CPU_i486DX,
                .fpus               = fpus_internal,
                .rspeed             = 40000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x430,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 5
            },
            {
                .name               = "50",
                .cpu_type           = CPU_i486DX,
                .fpus               = fpus_internal,
                .rspeed             = 50000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x433,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 6
            },
            {
                .name               = "66",
                .cpu_type           = CPU_i486DX,
                .fpus               = fpus_internal,
                .rspeed             = 66666666,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x433,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 8
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET1,
        .manufacturer  = "Intel",
        .name          = "i486DX2-S",
        .internal_name = "i486dx2_slenh",
        .cpus          = (const CPU[]) {
            {
                .name               = "40",
                .cpu_type           = CPU_i486DX_SLENH,
                .fpus               = fpus_internal,
                .rspeed             = 40000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x435,
                .cpuid_model        = 0x435,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 5
            },
            {
                .name               = "50",
                .cpu_type           = CPU_i486DX_SLENH,
                .fpus               = fpus_internal,
                .rspeed             = 50000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x435,
                .cpuid_model        = 0x435,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 6
            },
            {
                .name               = "66",
                .cpu_type           = CPU_i486DX_SLENH,
                .fpus               = fpus_internal,
                .rspeed             = 66666666,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x435,
                .cpuid_model        = 0x435,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 8
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET1 | CPU_PKG_SOCKET3_PC330,
        .manufacturer  = "Intel",
        .name          = "i486DX2 WB",
        .internal_name = "i486dx2_pc330",
        .cpus          = (const CPU[]) {
            {
                .name               = "50",
                .cpu_type           = CPU_i486DX_SLENH,
                .fpus               = fpus_internal,
                .rspeed             = 50000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x436,
                .cpuid_model        = 0x436,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 6
            },
            {
                .name               = "66",
                .cpu_type           = CPU_i486DX_SLENH,
                .fpus               = fpus_internal,
                .rspeed             = 66666666,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x436,
                .cpuid_model        = 0x436,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 8
            },
            { .name = "", 0 }
        }
    },
    { /*OEM versions are 3.3V, Retail versions are 3.3V with a 5V regulator for installation in older boards. They are functionally identical*/
        .package       = CPU_PKG_SOCKET1 | CPU_PKG_SOCKET3_PC330,
        .manufacturer  = "Intel",
        .name          = "iDX4",
        .internal_name = "idx4",
        .cpus          = (const CPU[]) {
            {
                .name               = "75",
                .cpu_type           = CPU_i486DX_SLENH,
                .fpus               = fpus_internal,
                .rspeed             = 75000000,
                .multi              = 3.0,
                .voltage            = 5000,
                .edx_reset          = 0x480,
                .cpuid_model        = 0x480,
                .cyrix_id           = 0x0000,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 9
            },
            {
                .name               = "100",
                .cpu_type           = CPU_i486DX_SLENH,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 3.0,
                .voltage            = 5000,
                .edx_reset          = 0x483,
                .cpuid_model        = 0x483,
                .cyrix_id           = 0x0000,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 12
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET3 | CPU_PKG_SOCKET3_PC330,
        .manufacturer  = "Intel",
        .name          = "Pentium OverDrive",
        .internal_name = "pentium_p24t",
        .cpus          = (const CPU[]) {
            {
                .name               = "63",
                .cpu_type           = CPU_P24T,
                .fpus               = fpus_internal,
                .rspeed             = 62500000,
                .multi              = 2.5,
                .voltage            = 5000,
                .edx_reset          = 0x1531,
                .cpuid_model        = 0x1531,
                .cyrix_id           = 0x0000,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 10,
                .mem_write_cycles   = 10,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 15/2
            },
            {
                .name               = "83",
                .cpu_type           = CPU_P24T,
                .fpus               = fpus_internal,
                .rspeed             = 83333333,
                .multi              = 2.5,
                .voltage            = 5000,
                .edx_reset          = 0x1532,
                .cpuid_model        = 0x1532,
                .cyrix_id           = 0x0000,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 8,
                .cache_write_cycles = 8,
                .atclk_div          = 10
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET1,
        .manufacturer  = "AMD",
        .name          = "Am486SX",
        .internal_name = "am486sx",
        .cpus          = (const CPU[]) {
            {
                .name               = "33",
                .cpu_type           = CPU_Am486SX,
                .fpus               = fpus_486sx,
                .rspeed             = 33333333,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x422,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 4
            },
            {
                .name               = "40",
                .cpu_type           = CPU_Am486SX,
                .fpus               = fpus_486sx,
                .rspeed             = 40000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x422,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 5
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET1,
        .manufacturer  = "AMD",
        .name          = "Am486SX2",
        .internal_name = "am486sx2",
        .cpus          = (const CPU[]) {
            {
                .name               = "50",
                .cpu_type           = CPU_Am486SX,
                .fpus               = fpus_486sx,
                .rspeed             = 50000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x45b,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 6
            },
            {
                .name               = "66",
                .cpu_type           = CPU_Am486SX,
                .fpus               = fpus_486sx,
                .rspeed             = 66666666,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x45b,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 8
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET1,
        .manufacturer  = "AMD",
        .name          = "Am486DX",
        .internal_name = "am486dx",
        .cpus          = (const CPU[]) {
            {
                .name               = "33",
                .cpu_type           = CPU_Am486DX,
                .fpus               = fpus_internal,
                .rspeed             = 33333333,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x412,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 4
            },
            {
                .name               = "40",
                .cpu_type           = CPU_Am486DX,
                .fpus               = fpus_internal,
                .rspeed             = 40000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x412,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 5
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET1,
        .manufacturer  = "AMD",
        .name          = "Am486DX2",
        .internal_name = "am486dx2",
        .cpus          = (const CPU[]) {
            {
                .name               = "50",
                .cpu_type           = CPU_Am486DX,
                .fpus               = fpus_internal,
                .rspeed             = 50000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x432,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 6
            },
            {
                .name               = "66",
                .cpu_type           = CPU_Am486DX,
                .fpus               = fpus_internal,
                .rspeed             = 66666666,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x432,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 8
            },
            {
                .name               = "80",
                .cpu_type           = CPU_Am486DX,
                .fpus               = fpus_internal,
                .rspeed             = 80000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x432,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 14,
                .mem_write_cycles   = 14,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 10
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET1,
        .manufacturer  = "AMD",
        .name          = "Am486DXL",
        .internal_name = "am486dxl",
        .cpus          = (const CPU[]) {
            {
                .name               = "33",
                .cpu_type           = CPU_Am486DXL,
                .fpus               = fpus_internal,
                .rspeed             = 33333333,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x422,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 4
            },
            {
                .name               = "40",
                .cpu_type           = CPU_Am486DXL,
                .fpus               = fpus_internal,
                .rspeed             = 40000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x422,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 5
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET1,
        .manufacturer  = "AMD",
        .name          = "Am486DXL2",
        .internal_name = "am486dxl2",
        .cpus          = (const CPU[]) {
            {
                .name               = "50",
                .cpu_type           = CPU_Am486DXL,
                .fpus               = fpus_internal,
                .rspeed             = 50000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x432,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 6
            },
            {
                .name               = "66",
                .cpu_type           = CPU_Am486DXL,
                .fpus               = fpus_internal,
                .rspeed             = 66666666,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x432,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 8
            },
            {
                .name               = "80",
                .cpu_type           = CPU_Am486DXL,
                .fpus               = fpus_internal,
                .rspeed             = 80000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x432,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 14,
                .mem_write_cycles   = 14,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 10
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET3,
        .manufacturer  = "AMD",
        .name          = "Am486DX4",
        .internal_name = "am486dx4",
        .cpus          = (const CPU[]) {
            {
                .name               = "75",
                .cpu_type           = CPU_Am486DX,
                .fpus               = fpus_internal,
                .rspeed             = 75000000,
                .multi              = 3.0,
                .voltage            = 5000,
                .edx_reset          = 0x432,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 9
            },
            {
                .name               = "90",
                .cpu_type           = CPU_Am486DX,
                .fpus               = fpus_internal,
                .rspeed             = 90000000,
                .multi              = 3.0,
                .voltage            = 5000,
                .edx_reset          = 0x432,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 12
            },
            {
                .name               = "100",
                .cpu_type           = CPU_Am486DX,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 3.0,
                .voltage            = 5000,
                .edx_reset          = 0x432,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 12
            },
            {
                .name               = "120",
                .cpu_type           = CPU_Am486DX,
                .fpus               = fpus_internal,
                .rspeed             = 120000000,
                .multi              = 3.0,
                .voltage            = 5000,
                .edx_reset          = 0x432,
                .cpuid_model        = 0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 15
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET3,
        .manufacturer  = "AMD",
        .name          = "Am486DX2 (Enhanced)",
        .internal_name = "am486dx2_slenh",
        .cpus          = (const CPU[]) {
            {
                .name               = "66",
                .cpu_type           = CPU_ENH_Am486DX,
                .fpus               = fpus_internal,
                .rspeed             = 66666666,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x435,
                .cpuid_model        = 0x435,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 8
            },
            {
                .name               = "80",
                .cpu_type           = CPU_ENH_Am486DX,
                .fpus               = fpus_internal,
                .rspeed             = 80000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x435,
                .cpuid_model        = 0x435,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 14,
                .mem_write_cycles   = 14,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 10
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET3,
        .manufacturer  = "AMD",
        .name          = "Am486DX4 (Enhanced)",
        .internal_name = "am486dx4_slenh",
        .cpus          = (const CPU[]) {
            {
                .name               = "75",
                .cpu_type           = CPU_ENH_Am486DX,
                .fpus               = fpus_internal,
                .rspeed             = 75000000,
                .multi              = 3.0,
                .voltage            = 5000,
                .edx_reset          = 0x482,
                .cpuid_model        = 0x482,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 9
            },
            {
                .name               = "100",
                .cpu_type           = CPU_ENH_Am486DX,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 3.0,
                .voltage            = 5000,
                .edx_reset          = 0x482,
                .cpuid_model        = 0x482,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 12
            },
            {
                .name               = "120",
                .cpu_type           = CPU_ENH_Am486DX,
                .fpus               = fpus_internal,
                .rspeed             = 120000000,
                .multi              = 3.0,
                .voltage            = 5000,
                .edx_reset          = 0x482,
                .cpuid_model        = 0x482,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 15
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET3,
        .manufacturer  = "AMD",
        .name          = "Am5x86",
        .internal_name = "am5x86",
        .cpus          = (const CPU[]) {
            {
                .name               = "133 (P75)",
                .cpu_type           = CPU_ENH_Am486DX,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 4.0,
                .voltage            = 5000,
                .edx_reset          = 0x4e0,
                .cpuid_model        = 0x4e0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 24,
                .mem_write_cycles   = 24,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 16
            },
            { /*The rare P75+ was indeed a triple-clocked 150 MHz according to research*/
                .name               = "150 (P75+)",
                .cpu_type           = CPU_ENH_Am486DX,
                .fpus               = fpus_internal,
                .rspeed             = 150000000,
                .multi              = 3.0,
                .voltage            = 5000,
                .edx_reset          = 0x482,
                .cpuid_model        = 0x482,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 28,
                .mem_write_cycles   = 28,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 20
            },
            { /*160 MHz on a 40 MHz bus was a common overclock and "5x86/P90" was used by a number of BIOSes to refer to that configuration*/
                .name               = "160 (P90)",
                .cpu_type           = CPU_ENH_Am486DX,
                .fpus               = fpus_internal,
                .rspeed             = 160000000,
                .multi              = 4.0,
                .voltage            = 5000,
                .edx_reset          = 0x4e0,
                .cpuid_model        = 0x4e0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 28,
                .mem_write_cycles   = 28,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 20
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET1,
        .manufacturer  = "Cyrix",
        .name          = "Cx486S",
        .internal_name = "cx486s",
        .cpus          = (const CPU[]) {
            {
                .name               = "25",
                .cpu_type           = CPU_Cx486S,
                .fpus               = fpus_486sx,
                .rspeed             = 25000000,
                .multi              = 1.0,
                .voltage            = 5000,
                .edx_reset          = 0x420,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0010,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 3
            },
            {
                .name               = "33",
                .cpu_type           = CPU_Cx486S,
                .fpus               = fpus_486sx,
                .rspeed             = 33333333,
                .multi              = 1.0,
                .voltage            = 5000,
                .edx_reset          = 0x420,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0010,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 4
            },
            {
                .name               = "40",
                .cpu_type           = CPU_Cx486S,
                .fpus               = fpus_486sx,
                .rspeed             = 40000000,
                .multi              = 1.0,
                .voltage            = 5000,
                .edx_reset          = 0x420,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0010,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 5
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET1,
        .manufacturer  = "Cyrix",
        .name          = "Cx486DX",
        .internal_name = "cx486dx",
        .cpus          = (const CPU[]) {
            {
                .name               = "33",
                .cpu_type           = CPU_Cx486DX,
                .fpus               = fpus_internal,
                .rspeed             = 33333333,
                .multi              = 1.0,
                .voltage            = 5000,
                .edx_reset          = 0x430,
                .cpuid_model        = 0,
                .cyrix_id           = 0x051a,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 4
            },
            {
                .name               = "40",
                .cpu_type           = CPU_Cx486DX,
                .fpus               = fpus_internal,
                .rspeed             = 40000000,
                .multi              = 1.0,
                .voltage            = 5000,
                .edx_reset          = 0x430,
                .cpuid_model        = 0,
                .cyrix_id           = 0x051a,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 5
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET1,
        .manufacturer  = "Cyrix",
        .name          = "Cx486DX2",
        .internal_name = "cx486dx2",
        .cpus          = (const CPU[]) {
            {
                .name               = "50",
                .cpu_type           = CPU_Cx486DX,
                .fpus               = fpus_internal,
                .rspeed             = 50000000,
                .multi              = 2.0,
                .voltage            = 5000,
                .edx_reset          = 0x430,
                .cpuid_model        = 0,
                .cyrix_id           = 0x081b,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 6
            },
            {
                .name               = "66",
                .cpu_type           = CPU_Cx486DX,
                .fpus               = fpus_internal,
                .rspeed             = 66666666,
                .multi              = 2.0,
                .voltage            = 5000,
                .edx_reset          = 0x430,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0b1b,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 8
            },
            {
                .name               = "80",
                .cpu_type           = CPU_Cx486DX,
                .fpus               = fpus_internal,
                .rspeed             = 80000000,
                .multi              = 2.0,
                .voltage            = 5000,
                .edx_reset          = 0x430,
                .cpuid_model        = 0,
                .cyrix_id           = 0x311b,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 14,
                .mem_write_cycles   = 14,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 10
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET3,
        .manufacturer  = "Cyrix",
        .name          = "Cx486DX4",
        .internal_name = "cx486dx4",
        .cpus          = (const CPU[]) {
            {
                .name               = "75",
                .cpu_type           = CPU_Cx486DX,
                .fpus               = fpus_internal,
                .rspeed             = 75000000,
                .multi              = 3.0,
                .voltage            = 5000,
                .edx_reset          = 0x480,
                .cpuid_model        = 0,
                .cyrix_id           = 0x361f,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 9
            },
            {
                .name               = "100",
                .cpu_type           = CPU_Cx486DX,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 3.0,
                .voltage            = 5000,
                .edx_reset          = 0x480,
                .cpuid_model        = 0,
                .cyrix_id           = 0x361f,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 12
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET3,
        .manufacturer  = "Cyrix",
        .name          = "Cx5x86",
        .internal_name = "cx5x86",
        .cpus          = (const CPU[]) {
            { /*If we're including the Pentium 50, might as well include this*/
                .name               = "80",
                .cpu_type           = CPU_Cx5x86,
                .fpus               = fpus_internal,
                .rspeed             = 80000000,
                .multi              = 2.0,
                .voltage            = 5000,
                .edx_reset          = 0x480,
                .cpuid_model        = 0,
                .cyrix_id           = 0x002f,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 14,
                .mem_write_cycles   = 14,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 10
            },
            {
                .name               = "100",
                .cpu_type           = CPU_Cx5x86,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 3.0,
                .voltage            = 5000,
                .edx_reset          = 0x480,
                .cpuid_model        = 0,
                .cyrix_id           = 0x002f,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 12
            },
            {
                .name               = "120",
                .cpu_type           = CPU_Cx5x86,
                .fpus               = fpus_internal,
                .rspeed             = 120000000,
                .multi              = 3.0,
                .voltage            = 5000,
                .edx_reset          = 0x480,
                .cpuid_model        = 0,
                .cyrix_id           = 0x002f,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 15
            },
            {
                .name               = "133",
                .cpu_type           = CPU_Cx5x86,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 4.0,
                .voltage            = 5000,
                .edx_reset          = 0x480,
                .cpuid_model        = 0,
                .cyrix_id           = 0x002f,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 24,
                .mem_write_cycles   = 24,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 16
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_STPC,
        .manufacturer  = "ST",
        .name          = "STPC-DX",
        .internal_name = "stpc_dx",
        .cpus          = (const CPU[]) {
            {
                .name               = "66",
                .cpu_type           = CPU_STPC,
                .fpus               = fpus_internal,
                .rspeed             = 66666666,
                .multi              = 1.0,
                .voltage            = 3300,
                .edx_reset          = 0x430,
                .cpuid_model        = 0,
                .cyrix_id           = 0x051a,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 5
            },
            {
                .name               = "75",
                .cpu_type           = CPU_STPC,
                .fpus               = fpus_internal,
                .rspeed             = 75000000,
                .multi              = 1.0,
                .voltage            = 3300,
                .edx_reset          = 0x430,
                .cpuid_model        = 0,
                .cyrix_id           = 0x051a,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 5
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_STPC,
        .manufacturer  = "ST",
        .name          = "STPC-DX2",
        .internal_name = "stpc_dx2",
        .cpus          = (const CPU[]) {
            {
                .name               = "133",
                .cpu_type           = CPU_STPC,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 3300,
                .edx_reset          = 0x430,
                .cpuid_model        = 0,
                .cyrix_id           = 0x0b1b,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 14,
                .mem_write_cycles   = 14,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 10
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET4,
        .manufacturer  = "Intel",
        .name          = "Pentium",
        .internal_name = "pentium_p5",
        .cpus          = (const CPU[]) {
            {
                .name               = "50 (Q0399)",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 50000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x513,
                .cpuid_model        = 0x513,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 4,
                .mem_write_cycles   = 4,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 6
            },
            {
                .name               = "60",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 60000000,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x517,
                .cpuid_model        = 0x517,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 7
            },
            {
                .name               = "66",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 66666666,
                .multi              = 1,
                .voltage            = 5000,
                .edx_reset          = 0x517,
                .cpuid_model        = 0x517,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 8
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET4,
        .manufacturer  = "Intel",
        .name          = "Pentium OverDrive",
        .internal_name = "pentium_p54c_od5v",
        .cpus          = (const CPU[]) {
            {
                .name               = "100",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x51A,
                .cpuid_model        = 0x51A,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 12
            },
            {
                .name               = "120",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 120000000,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x51A,
                .cpuid_model        = 0x51A,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 14
            },
            {
                .name               = "133",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2,
                .voltage            = 5000,
                .edx_reset          = 0x51A,
                .cpuid_model        = 0x51A,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "Intel",
        .name          = "Pentium",
        .internal_name = "pentium_p54c",
        .cpus          = (const CPU[]) {
            {
                .name               = "75",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 75000000,
                .multi              = 1.5,
                .voltage            = 3520,
                .edx_reset          = 0x522,
                .cpuid_model        = 0x522,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 9
            },
            {
                .name               = "90",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 90000000,
                .multi              = 1.5,
                .voltage            = 3520,
                .edx_reset          = 0x524,
                .cpuid_model        = 0x524,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 21/2
            },
            {
                .name               = "100/50",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 2.0,
                .voltage            = 3520,
                .edx_reset          = 0x524,
                .cpuid_model        = 0x524,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 10,
                .mem_write_cycles   = 10,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 12
            },
            {
                .name               = "100/66",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 1.5,
                .voltage            = 3520,
                .edx_reset          = 0x526,
                .cpuid_model        = 0x526,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 12
            },
            {
                .name               = "120",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 120000000,
                .multi              = 2.0,
                .voltage            = 3520,
                .edx_reset          = 0x526,
                .cpuid_model        = 0x526,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 14
            },
            {
                .name               = "133",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 3520,
                .edx_reset          = 0x52c,
                .cpuid_model        = 0x52c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            {
                .name               = "150",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 150000000,
                .multi              = 2.5,
                .voltage            = 3520,
                .edx_reset          = 0x52c,
                .cpuid_model        = 0x52c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 35/2
            },
            {
                .name               = "166",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 3520,
                .edx_reset          = 0x52c,
                .cpuid_model        = 0x52c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            {
                .name               = "200",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 3520,
                .edx_reset          = 0x52c,
                .cpuid_model        = 0x52c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 24
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "Intel",
        .name          = "Pentium MMX",
        .internal_name = "pentium_p55c",
        .cpus          = (const CPU[]) {
            {
                .name               = "166",
                .cpu_type           = CPU_PENTIUMMMX,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 2800,
                .edx_reset          = 0x543,
                .cpuid_model        = 0x543,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            {
                .name               = "200",
                .cpu_type           = CPU_PENTIUMMMX,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 2800,
                .edx_reset          = 0x543,
                .cpuid_model        = 0x543,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 24
            },
            {
                .name               = "233",
                .cpu_type           = CPU_PENTIUMMMX,
                .fpus               = fpus_internal,
                .rspeed             = 233333333,
                .multi              = 3.5,
                .voltage            = 2800,
                .edx_reset          = 0x543,
                .cpuid_model        = 0x543,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 10,
                .cache_write_cycles = 10,
                .atclk_div          = 28
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "Intel",
        .name          = "Mobile Pentium MMX",
        .internal_name = "pentium_tillamook",
        .cpus          = (const CPU[]) {
            {
                .name               = "120",
                .cpu_type           = CPU_PENTIUMMMX,
                .fpus               = fpus_internal,
                .rspeed             = 120000000,
                .multi              = 2.0,
                .voltage            = 2800,
                .edx_reset          = 0x543,
                .cpuid_model        = 0x543,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 14
            },
            {
                .name               = "133",
                .cpu_type           = CPU_PENTIUMMMX,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 2800,
                .edx_reset          = 0x543,
                .cpuid_model        = 0x543,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            {
                .name               = "150",
                .cpu_type           = CPU_PENTIUMMMX,
                .fpus               = fpus_internal,
                .rspeed             = 150000000,
                .multi              = 2.5,
                .voltage            = 2800,
                .edx_reset          = 0x544,
                .cpuid_model        = 0x544,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 35/2
            },
            {
                .name               = "166",
                .cpu_type           = CPU_PENTIUMMMX,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 2800,
                .edx_reset          = 0x544,
                .cpuid_model        = 0x544,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            {
                .name               = "200",
                .cpu_type           = CPU_PENTIUMMMX,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 2800,
                .edx_reset          = 0x581,
                .cpuid_model        = 0x581,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 24
            },
            {
                .name               = "233",
                .cpu_type           = CPU_PENTIUMMMX,
                .fpus               = fpus_internal,
                .rspeed             = 233333333,
                .multi              = 3.5,
                .voltage            = 2800,
                .edx_reset          = 0x581,
                .cpuid_model        = 0x581,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 10,
                .cache_write_cycles = 10,
                .atclk_div          = 28
            },
            {
                .name               = "266",
                .cpu_type           = CPU_PENTIUMMMX,
                .fpus               = fpus_internal,
                .rspeed             = 266666666,
                .multi              = 4.0,
                .voltage            = 2800,
                .edx_reset          = 0x582,
                .cpuid_model        = 0x582,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 24,
                .mem_write_cycles   = 24,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 32
            },
            {
                .name               = "300",
                .cpu_type           = CPU_PENTIUMMMX,
                .fpus               = fpus_internal,
                .rspeed             = 300000000,
                .multi              = 4.5,
                .voltage            = 2800,
                .edx_reset          = 0x582,
                .cpuid_model        = 0x582,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 27,
                .mem_write_cycles   = 27,
                .cache_read_cycles  = 13,
                .cache_write_cycles = 13,
                .atclk_div          = 36
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "Intel",
        .name          = "Pentium OverDrive",
        .internal_name = "pentium_p54c_od3v",
        .cpus          = (const CPU[]) {
            {
                .name               = "125",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 125000000,
                .multi              = 3.0,
                .voltage            = 3520,
                .edx_reset          = 0x52c,
                .cpuid_model        = 0x52c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 15
            },
            {
                .name               = "150",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 150000000,
                .multi              = 2.5,
                .voltage            = 3520,
                .edx_reset          = 0x52c,
                .cpuid_model        = 0x52c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 35/2
            },
            {
                .name               = "166",
                .cpu_type           = CPU_PENTIUM,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 3520,
                .edx_reset          = 0x52c,
                .cpuid_model        = 0x52c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "Intel",
        .name          = "Pentium OverDrive MMX",
        .internal_name = "pentium_p55c_od",
        .cpus          = (const CPU[]) {
            {
                .name               = "75",
                .cpu_type           = CPU_PENTIUMMMX,
                .fpus               = fpus_internal,
                .rspeed             = 75000000,
                .multi              = 1.5,
                .voltage            = 3520,
				.edx_reset = 0x1542,
				.cpuid_model = 0x1542,
				.cyrix_id = 0,
				.cpu_flags = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
				.mem_read_cycles = 7,
				.mem_write_cycles = 7,
				.cache_read_cycles = 4,
				.cache_write_cycles = 4,
				.atclk_div = 9
			},
            {
                .name               = "125",
                .cpu_type           = CPU_PENTIUMMMX,
                .fpus               = fpus_internal,
                .rspeed             = 125000000,
                .multi              = 2.5,
                .voltage            = 3520,
                .edx_reset          = 0x1542,
                .cpuid_model        = 0x1542,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 15
            },
            {
                .name               = "150/60",
                .cpu_type           = CPU_PENTIUMMMX,
                .fpus               = fpus_internal,
                .rspeed             = 150000000,
                .multi              = 2.5,
                .voltage            = 3520,
                .edx_reset          = 0x1542,
                .cpuid_model        = 0x1542,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 35/2
            },
            {
                .name               = "166",
                .cpu_type           = CPU_PENTIUMMMX,
                .fpus               = fpus_internal,
                .rspeed             = 166000000,
                .multi              = 2.5,
                .voltage            = 3520,
                .edx_reset          = 0x1542,
                .cpuid_model        = 0x1542,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            {
                .name               = "180",
                .cpu_type           = CPU_PENTIUMMMX,
                .fpus               = fpus_internal,
                .rspeed             = 180000000,
                .multi              = 3.0,
                .voltage            = 3520,
                .edx_reset          = 0x1542,
                .cpuid_model        = 0x1542,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 21
            },
            {
                .name               = "200",
                .cpu_type           = CPU_PENTIUMMMX,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 3520,
                .edx_reset          = 0x1542,
                .cpuid_model        = 0x1542,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 24
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "IDT",
        .name          = "WinChip",
        .internal_name = "winchip",
        .cpus          = (const CPU[]) {
            {
                .name               = "75",
                .cpu_type           = CPU_WINCHIP,
                .fpus               = fpus_internal,
                .rspeed             = 75000000,
                .multi              = 1.5,
                .voltage            = 3520,
                .edx_reset          = 0x540,
                .cpuid_model        = 0x540,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 9
            },
            {
                .name               = "90",
                .cpu_type           = CPU_WINCHIP,
                .fpus               = fpus_internal,
                .rspeed             = 90000000,
                .multi              = 1.5,
                .voltage            = 3520,
                .edx_reset          = 0x540,
                .cpuid_model        = 0x540,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 21/2
            },
            {
                .name               = "100",
                .cpu_type           = CPU_WINCHIP,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 1.5,
                .voltage            = 3520,
                .edx_reset          = 0x540,
                .cpuid_model        = 0x540,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 12
            },
            {
                .name               = "120",
                .cpu_type           = CPU_WINCHIP,
                .fpus               = fpus_internal,
                .rspeed             = 120000000,
                .multi              = 2.0,
                .voltage            = 3520,
                .edx_reset          = 0x540,
                .cpuid_model        = 0x540,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 14
            },
            {
                .name               = "133",
                .cpu_type           = CPU_WINCHIP,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 3520,
                .edx_reset          = 0x540,
                .cpuid_model        = 0x540,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            {
                .name               = "150",
                .cpu_type           = CPU_WINCHIP,
                .fpus               = fpus_internal,
                .rspeed             = 150000000,
                .multi              = 2.5,
                .voltage            = 3520,
                .edx_reset          = 0x540,
                .cpuid_model        = 0x540,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 35/2
            },
            {
                .name               = "166",
                .cpu_type           = CPU_WINCHIP,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 3520,
                .edx_reset          = 0x540,
                .cpuid_model        = 0x540,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 40
            },
            {
                .name               = "180",
                .cpu_type           = CPU_WINCHIP,
                .fpus               = fpus_internal,
                .rspeed             = 180000000,
                .multi              = 3.0,
                .voltage            = 3520,
                .edx_reset          = 0x540,
                .cpuid_model        = 0x540,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 21
            },
            {
                .name               = "200",
                .cpu_type           = CPU_WINCHIP,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 3520,
                .edx_reset          = 0x540,
                .cpuid_model        = 0x540,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 24
            },
            {
                .name               = "225",
                .cpu_type           = CPU_WINCHIP,
                .fpus               = fpus_internal,
                .rspeed             = 225000000,
                .multi              = 3.0,
                .voltage            = 3520,
                .edx_reset          = 0x540,
                .cpuid_model        = 0x540,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 27
            },
            {
                .name               = "240",
                .cpu_type           = CPU_WINCHIP,
                .fpus               = fpus_internal,
                .rspeed             = 240000000,
                .multi              = 4.0,
                .voltage            = 3520,
                .edx_reset          = 0x540,
                .cpuid_model        = 0x540,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 24,
                .mem_write_cycles   = 24,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 28
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "IDT",
        .name          = "WinChip 2",
        .internal_name = "winchip2",
        .cpus          = (const CPU[]) {
            {
                .name               = "200",
                .cpu_type           = CPU_WINCHIP2,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 3520,
                .edx_reset          = 0x580,
                .cpuid_model        = 0x580,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 3*8
            },
            {
                .name               = "225",
                .cpu_type           = CPU_WINCHIP2,
                .fpus               = fpus_internal,
                .rspeed             = 225000000,
                .multi              = 3.0,
                .voltage            = 3520,
                .edx_reset          = 0x580,
                .cpuid_model        = 0x580,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 3*9
            },
            {
                .name               = "240",
                .cpu_type           = CPU_WINCHIP2,
                .fpus               = fpus_internal,
                .rspeed             = 240000000,
                .multi              = 4.0,
                .voltage            = 3520,
                .edx_reset          = 0x580,
                .cpuid_model        = 0x580,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 24,
                .mem_write_cycles   = 24,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 30
            },
            {
                .name               = "250",
                .cpu_type           = CPU_WINCHIP2,
                .fpus               = fpus_internal,
                .rspeed             = 250000000,
                .multi              = 3.0,
                .voltage            = 3520,
                .edx_reset          = 0x580,
                .cpuid_model        = 0x580,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 24,
                .mem_write_cycles   = 24,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 30
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "IDT",
        .name          = "WinChip 2A",
        .internal_name = "winchip2a",
        .cpus          = (const CPU[]) {
            {
                .name               = "200",
                .cpu_type           = CPU_WINCHIP2,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 3520,
                .edx_reset          = 0x587,
                .cpuid_model        = 0x587,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 3*8
            },
            {
                .name               = "233",
                .cpu_type           = CPU_WINCHIP2,
                .fpus               = fpus_internal,
                .rspeed             = 233333333,
                .multi              = 3.5,
                .voltage            = 3520,
                .edx_reset          = 0x587,
                .cpuid_model        = 0x587,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = (7*8)/2
            },
            {
                .name               = "266",
                .cpu_type           = CPU_WINCHIP2,
                .fpus               = fpus_internal,
                .rspeed             = 233333333,
                .multi              = 7.0/3.0,
                .voltage            = 3520,
                .edx_reset          = 0x587,
                .cpuid_model        = 0x587,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 28
            },
            {
                .name               = "300",
                .cpu_type           = CPU_WINCHIP2,
                .fpus               = fpus_internal,
                .rspeed             = 250000000,
                .multi              = 2.5,
                .voltage            = 3520,
                .edx_reset          = 0x587,
                .cpuid_model        = 0x587,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC,
                .mem_read_cycles    = 24,
                .mem_write_cycles   = 24,
                .cache_read_cycles  = 8,
                .cache_write_cycles = 8,
                .atclk_div          = 30
            },
            { .name = "", 0 }
        }
    },
#ifdef USE_AMD_K5
    {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "AMD",
        .name          = "K5 (Model 0)",
        .internal_name = "k5_ssa5",
        .cpus          = (const CPU[]) {
            {
                .name               = "75 (PR75)",
                .cpu_type           = CPU_K5,
                .fpus               = fpus_internal,
                .rspeed             = 75000000,
                .multi              = 1.5,
                .voltage            = 3520,
                .edx_reset          = 0x501,
                .cpuid_model        = 0x501,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 9
            },
            {
                .name               = "90 (PR90)",
                .cpu_type           = CPU_K5,
                .fpus               = fpus_internal,
                .rspeed             = 90000000,
                .multi              = 1.5,
                .voltage            = 3520,
                .edx_reset          = 0x501,
                .cpuid_model        = 0x501,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 21/2
            },
            {
                .name               = "100 (PR100)",
                .cpu_type           = CPU_K5,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 1.5,
                .voltage            = 3520,
                .edx_reset          = 0x501,
                .cpuid_model        = 0x501,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 12
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "AMD",
        .name          = "K5 (Model 1/2/3)",
        .internal_name = "k5_5k86",
        .cpus          = (const CPU[]) {
            {
                .name               = "90 (PR120)",
                .cpu_type           = CPU_5K86,
                .fpus               = fpus_internal,
                .rspeed             = 120000000,
                .multi              = 2.0,
                .voltage            = 3520,
                .edx_reset          = 0x511,
                .cpuid_model        = 0x511,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 14
            },
            {
                .name               = "100 (PR133)",
                .cpu_type           = CPU_5K86,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 3520,
                .edx_reset          = 0x514,
                .cpuid_model        = 0x514,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            {
                .name               = "105 (PR150)",
                .cpu_type           = CPU_5K86,
                .fpus               = fpus_internal,
                .rspeed             = 150000000,
                .multi              = 2.5,
                .voltage            = 3520,
                .edx_reset          = 0x524,
                .cpuid_model        = 0x524,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 35/2
            },
            {
                .name               = "116.7 (PR166)",
                .cpu_type           = CPU_5K86,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 3520,
                .edx_reset          = 0x524,
                .cpuid_model        = 0x524,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            {
                .name               = "133 (PR200)",
                .cpu_type           = CPU_5K86,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 3520,
                .edx_reset          = 0x534,
                .cpuid_model        = 0x534,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 24
            },
            { .name = "", 0 }
        }
    },
#endif /* USE_AMD_K5 */
    {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "AMD",
        .name          = "K6 (Model 6)",
        .internal_name = "k6_m6",
        .cpus          = (const CPU[]) {
            { /* out of spec */
                .name               = "66",
                .cpu_type           = CPU_K6,
                .fpus               = fpus_internal,
                .rspeed             = 66666666,
                .multi              = 1.0,
                .voltage            = 2900,
                .edx_reset          = 0x561,
                .cpuid_model        = 0x561,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 8
            },
            { /* out of spec */
                .name               = "100",
                .cpu_type           = CPU_K6,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 1.5,
                .voltage            = 2900,
                .edx_reset          = 0x561,
                .cpuid_model        = 0x561,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 12
            },
            { /* out of spec */
                .name               = "133",
                .cpu_type           = CPU_K6,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 2900,
                .edx_reset          = 0x561,
                .cpuid_model        = 0x561,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
                },
            {
                .name               = "166",
                .cpu_type           = CPU_K6,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 2900,
                .edx_reset          = 0x561,
                .cpuid_model        = 0x561,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            {
                .name               = "200",
                .cpu_type           = CPU_K6,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 2900,
                .edx_reset          = 0x561,
                .cpuid_model        = 0x561,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 24
            },
            {
                .name               = "233",
                .cpu_type           = CPU_K6,
                .fpus               = fpus_internal,
                .rspeed             = 233333333,
                .multi              = 3.5,
                .voltage            = 3200,
                .edx_reset          = 0x561,
                .cpuid_model        = 0x561,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 10,
                .cache_write_cycles = 10,
                .atclk_div          = 28
            },
            { .name = "", 0 }
        }
    }, {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "AMD",
        .name          = "K6 (Model 7)",
        .internal_name = "k6_m7",
        .cpus          = (const CPU[]) {
            { /* out of spec */
                .name               = "100",
                .cpu_type           = CPU_K6,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 1.5,
                .voltage            = 2200,
                .edx_reset          = 0x570,
                .cpuid_model        = 0x570,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 12
            },
            { /* out of spec */
                .name               = "133",
                .cpu_type           = CPU_K6,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 2200,
                .edx_reset          = 0x570,
                .cpuid_model        = 0x570,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            { /* out of spec */
                .name               = "166",
                .cpu_type           = CPU_K6,
                .fpus               = fpus_internal,
                .rspeed             = 166666666, .multi = 2.5,
                .voltage            = 2200, .edx_reset = 0x570,
                .cpuid_model        = 0x570, .cyrix_id = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            {
                .name               = "200",
                .cpu_type           = CPU_K6,
                .fpus               = fpus_internal,
                .rspeed             = 200000000, .multi = 3.0,
                .voltage            = 2200, .edx_reset = 0x570,
                .cpuid_model        = 0x570, .cyrix_id = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 24
            },
            {
                .name               = "233",
                .cpu_type           = CPU_K6,
                .fpus               = fpus_internal,
                .rspeed             = 233333333, .multi = 3.5,
                .voltage            = 2200, .edx_reset = 0x570,
                .cpuid_model        = 0x570,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 10,
                .cache_write_cycles = 10,
                .atclk_div          = 28
            },
            {
                .name               = "266",
                .cpu_type           = CPU_K6,
                .fpus               = fpus_internal,
                .rspeed             = 266666666,
                .multi              = 4.0,
                .voltage            = 2200,
                .edx_reset          = 0x570,
                .cpuid_model        = 0x570,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 24,
                .mem_write_cycles   = 24,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 32
            },
            {
                .name               = "300",
                .cpu_type           = CPU_K6,
                .fpus               = fpus_internal,
                .rspeed             = 300000000,
                .multi              = 4.5,
                .voltage            = 2200,
                .edx_reset          = 0x570,
                .cpuid_model        = 0x570,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 27,
                .mem_write_cycles   = 27,
                .cache_read_cycles  = 13,
                .cache_write_cycles = 13,
                .atclk_div          = 36
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "AMD",
        .name          = "K6-2",
        .internal_name = "k6_2",
        .cpus          = (const CPU[]) {
            { /* out of spec */
                .name               = "100",
                .cpu_type           = CPU_K6_2,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 1.5,
                .voltage            = 2200,
                .edx_reset          = 0x580,
                .cpuid_model        = 0x580,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 12
            },
            { /* out of spec */
                .name               = "133",
                .cpu_type           = CPU_K6_2,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 2200,
                .edx_reset          = 0x580,
                .cpuid_model        = 0x580,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            { /* out of spec */
                .name               = "166",
                .cpu_type           = CPU_K6_2,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 2200,
                .edx_reset          = 0x580,
                .cpuid_model        = 0x580,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            { /* out of spec */
                .name               = "200",
                .cpu_type           = CPU_K6_2,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 2200,
                .edx_reset          = 0x580,
                .cpuid_model        = 0x580,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 24
            },
            {
                .name               = "233",
                .cpu_type           = CPU_K6_2,
                .fpus               = fpus_internal,
                .rspeed             = 233333333,
                .multi              = 3.5,
                .voltage            = 2200,
                .edx_reset          = 0x580,
                .cpuid_model        = 0x580,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 10,
                .cache_write_cycles = 10,
                .atclk_div          = 28
            },
            {
                .name               = "266",
                .cpu_type           = CPU_K6_2,
                .fpus               = fpus_internal,
                .rspeed             = 266666666,
                .multi              = 4.0,
                .voltage            = 2200,
                .edx_reset          = 0x580,
                .cpuid_model        = 0x580,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 24,
                .mem_write_cycles   = 24,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 32
            },
            {
                .name               = "300",
                .cpu_type           = CPU_K6_2,
                .fpus               = fpus_internal,
                .rspeed             = 300000000,
                .multi              = 3.0,
                .voltage            = 2200,
                .edx_reset          = 0x580,
                .cpuid_model        = 0x580,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 27,
                .mem_write_cycles   = 27,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 36
            },
            {
                .name               = "333",
                .cpu_type           = CPU_K6_2,
                .fpus               = fpus_internal,
                .rspeed             = 332500000,
                .multi              = 3.5,
                .voltage            = 2200,
                .edx_reset          = 0x580,
                .cpuid_model        = 0x580,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 30,
                .mem_write_cycles   = 30,
                .cache_read_cycles  = 11,
                .cache_write_cycles = 11,
                .atclk_div          = 40
            },
            {
                .name               = "350",
                .cpu_type           = CPU_K6_2C,
                .fpus               = fpus_internal,
                .rspeed             = 350000000,
                .multi              = 3.5,
                .voltage            = 2200,
                .edx_reset          = 0x58c,
                .cpuid_model        = 0x58c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 32,
                .mem_write_cycles   = 32,
                .cache_read_cycles  = 11,
                .cache_write_cycles = 11,
                .atclk_div          = 42
            },
            {
                .name               = "366",
                .cpu_type           = CPU_K6_2C,
                .fpus               = fpus_internal,
                .rspeed             = 366666666,
                .multi              = 5.5,
                .voltage            = 2200,
                .edx_reset          = 0x58c,
                .cpuid_model        = 0x58c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 33,
                .mem_write_cycles   = 33,
                .cache_read_cycles  = 17,
                .cache_write_cycles = 17,
                .atclk_div          = 44
            },
            {
                .name               = "380",
                .cpu_type           = CPU_K6_2C,
                .fpus               = fpus_internal,
                .rspeed             = 380000000,
                .multi              = 4.0,
                .voltage            = 2200,
                .edx_reset          = 0x58c,
                .cpuid_model        = 0x58c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 34,
                .mem_write_cycles   = 34,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 46
            },
            {
                .name               = "400/66",
                .cpu_type           = CPU_K6_2C,
                .fpus               = fpus_internal,
                .rspeed             = 400000000,
                .multi              = 6.0,
                .voltage            = 2200,
                .edx_reset          = 0x58c,
                .cpuid_model        = 0x58c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 36,
                .mem_write_cycles   = 36,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 48
                },
            {
                .name               = "400/100",
                .cpu_type           = CPU_K6_2C,
                .fpus               = fpus_internal,
                .rspeed             = 400000000,
                .multi              = 4.0,
                .voltage            = 2200,
                .edx_reset          = 0x58c,
                .cpuid_model        = 0x58c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 36,
                .mem_write_cycles   = 36,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 48
            },
            {
                .name               = "450",
                .cpu_type           = CPU_K6_2C,
                .fpus               = fpus_internal,
                .rspeed             = 450000000,
                .multi              = 4.5,
                .voltage            = 2200,
                .edx_reset          = 0x58c,
                .cpuid_model        = 0x58c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 41,
                .mem_write_cycles   = 41,
                .cache_read_cycles  = 14,
                .cache_write_cycles = 14,
                .atclk_div          = 54
            },
            {
                .name               = "475",
                .cpu_type           = CPU_K6_2C,
                .fpus               = fpus_internal,
                .rspeed             = 475000000,
                .multi              = 5.0,
                .voltage            = 2400,
                .edx_reset          = 0x58c,
                .cpuid_model        = 0x58c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 43,
                .mem_write_cycles   = 43,
                .cache_read_cycles  = 15,
                .cache_write_cycles = 15,
                .atclk_div          = 57
            },
            {
                .name               = "500",
                .cpu_type           = CPU_K6_2C,
                .fpus               = fpus_internal,
                .rspeed             = 500000000,
                .multi              = 5.0,
                .voltage            = 2400,
                .edx_reset          = 0x58c,
                .cpuid_model        = 0x58c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 45,
                .mem_write_cycles   = 45,
                .cache_read_cycles  = 15,
                .cache_write_cycles = 15,
                .atclk_div          = 60
            },
            {
                .name               = "533",
                .cpu_type           = CPU_K6_2C,
                .fpus               = fpus_internal,
                .rspeed             = 533333333,
                .multi              = 5.5,
                .voltage            = 2200,
                .edx_reset          = 0x58c,
                .cpuid_model        = 0x58c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 48,
                .mem_write_cycles   = 48,
                .cache_read_cycles  = 17,
                .cache_write_cycles = 17,
                .atclk_div          = 64
            },
            {
                .name               = "550",
                .cpu_type           = CPU_K6_2C,
                .fpus               = fpus_internal,
                .rspeed             = 550000000,
                .multi              = 5.5,
                .voltage            = 2300,
                .edx_reset          = 0x58c,
                .cpuid_model        = 0x58c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 50,
                .mem_write_cycles   = 50,
                .cache_read_cycles  = 17,
                .cache_write_cycles = 17,
                .atclk_div          = 66
            },
            {
                .name               = "570",
                .cpu_type           = CPU_K6_2C,
                .fpus               = fpus_internal,
                .rspeed             = 570000000,
                .multi              = 6.0,
                .voltage            = 2300,
                .edx_reset          = 0x58c,
                .cpuid_model        = 0x58c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 52,
                .mem_write_cycles   = 52,
                .cache_read_cycles  = 18,
                .cache_write_cycles = 18,
                .atclk_div          = 68
            },
            {
                .name               = "600 (570 OC)",
                .cpu_type           = CPU_K6_2C,
                .fpus               = fpus_internal,
                .rspeed             = 600000000,
                .multi              = 6.0,
                .voltage            = 2300,
                .edx_reset          = 0x58c,
                .cpuid_model        = 0x58c,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 54,
                .mem_write_cycles   = 54,
                .cache_read_cycles  = 18,
                .cache_write_cycles = 18,
                .atclk_div          = 72
            },
            { .name = "", 0 }
        }
    }, {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "AMD",
        .name          = "K6-2+",
        .internal_name = "k6_2p",
        .cpus          = (const CPU[]) {
            { /* out of spec */
                .name               = "100",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 1.5,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 12
            },
            { /* out of spec */
                .name               = "133",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            { /* out of spec */
                .name               = "166",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            { /* out of spec */
                .name               = "200",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 24
            },
            { /* out of spec */
                .name               = "233",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 233333333,
                .multi              = 3.5,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 10,
                .cache_write_cycles = 10,
                .atclk_div          = 28
            },
            { /* out of spec */
                .name               = "266",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 266666666,
                .multi              = 4.0,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 24,
                .mem_write_cycles   = 24,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 32
            },
            { /* out of spec */
                .name               = "300",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 300000000,
                .multi              = 3.0,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 27,
                .mem_write_cycles   = 27,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 36
            },
            { /* out of spec */
                .name               = "333",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 332500000,
                .multi              = 3.5,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 30,
                .mem_write_cycles   = 30,
                .cache_read_cycles  = 11,
                .cache_write_cycles = 11,
                .atclk_div          = 40
            },
            { /* out of spec */
                .name               = "350",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 350000000,
                .multi              = 3.5,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 32,
                .mem_write_cycles   = 32,
                .cache_read_cycles  = 11,
                .cache_write_cycles = 11,
                .atclk_div          = 42
            },
            { /* out of spec */
                .name               = "366",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 366666666,
                .multi              = 5.5,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 33,
                .mem_write_cycles   = 33,
                .cache_read_cycles  = 17,
                .cache_write_cycles = 17,
                .atclk_div          = 44
            },
            { /* out of spec */
                .name               = "380",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 380000000,
                .multi              = 4.0,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 34,
                .mem_write_cycles   = 34,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 46
            },
            { /* out of spec */
                .name               = "400/66",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 400000000,
                .multi              = 6.0,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 36,
                .mem_write_cycles   = 36,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 48
            },
            { /* out of spec */
                .name               = "400/100",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 400000000,
                .multi              = 4.0,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 36,
                .mem_write_cycles   = 36,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 48
            },
            {
                .name               = "450",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 450000000,
                .multi              = 4.5,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 41,
                .mem_write_cycles   = 41,
                .cache_read_cycles  = 14,
                .cache_write_cycles = 14,
                .atclk_div          = 54
            },
            {
                .name               = "475",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 475000000,
                .multi              = 5.0,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 43,
                .mem_write_cycles   = 43,
                .cache_read_cycles  = 15,
                .cache_write_cycles = 15,
                .atclk_div          = 57
            },
            {
                .name               = "500",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 500000000,
                .multi              = 5.0,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 45,
                .mem_write_cycles   = 45,
                .cache_read_cycles  = 15,
                .cache_write_cycles = 15,
                .atclk_div          = 60
            },
            {
                .name               = "533",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 533333333,
                .multi              = 5.5,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 48,
                .mem_write_cycles   = 48,
                .cache_read_cycles  = 17,
                .cache_write_cycles = 17,
                .atclk_div          = 64
            },
            {
                .name               = "550",
                .cpu_type           = CPU_K6_2P,
                .fpus               = fpus_internal,
                .rspeed             = 550000000,
                .multi              = 5.5,
                .voltage            = 2000,
                .edx_reset          = 0x5d4,
                .cpuid_model        = 0x5d4,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 50,
                .mem_write_cycles   = 50,
                .cache_read_cycles  = 17,
                .cache_write_cycles = 17,
                .atclk_div          = 66
            },
            { .name = "", 0 }
        }
    }, {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "AMD",
        .name          = "K6-III",
        .internal_name = "k6_3",
        .cpus          = (const CPU[]) {
            { /* out of spec */
                .name               = "100",
                .cpu_type           = CPU_K6_3,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 1.5,
                .voltage            = 2200,
                .edx_reset          = 0x591,
                .cpuid_model        = 0x591,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 12
            },
            { /* out of spec */
                .name               = "133",
                .cpu_type           = CPU_K6_3,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 2200,
                .edx_reset          = 0x591,
                .cpuid_model        = 0x591,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            { /* out of spec */
                .name               = "166",
                .cpu_type           = CPU_K6_3,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 2200,
                .edx_reset          = 0x591,
                .cpuid_model        = 0x591,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            { /* out of spec */
                .name               = "200",
                .cpu_type           = CPU_K6_3,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 2200,
                .edx_reset          = 0x591,
                .cpuid_model        = 0x591,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 24
            },
            { /* out of spec */
                .name               = "233",
                .cpu_type           = CPU_K6_3,
                .fpus               = fpus_internal,
                .rspeed             = 233333333,
                .multi              = 3.5,
                .voltage            = 2200,
                .edx_reset          = 0x591,
                .cpuid_model        = 0x591,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 10,
                .cache_write_cycles = 10,
                .atclk_div          = 28
            },
            { /* out of spec */
                .name               = "266",
                .cpu_type           = CPU_K6_3,
                .fpus               = fpus_internal,
                .rspeed             = 266666666,
                .multi              = 4.0,
                .voltage            = 2200,
                .edx_reset          = 0x591,
                .cpuid_model        = 0x591,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 24,
                .mem_write_cycles   = 24,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 32
            },
            { /* out of spec */
                .name               = "300",
                .cpu_type           = CPU_K6_3,
                .fpus               = fpus_internal,
                .rspeed             = 300000000,
                .multi              = 3.0,
                .voltage            = 2200,
                .edx_reset          = 0x591,
                .cpuid_model        = 0x591,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 27,
                .mem_write_cycles   = 27,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 36
            },
            { /* out of spec */
                .name               = "333",
                .cpu_type           = CPU_K6_3,
                .fpus               = fpus_internal,
                .rspeed             = 332500000,
                .multi              = 3.5,
                .voltage            = 2200,
                .edx_reset          = 0x591,
                .cpuid_model        = 0x591,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 30,
                .mem_write_cycles   = 30,
                .cache_read_cycles  = 11,
                .cache_write_cycles = 11,
                .atclk_div          = 40
            },
            { /* out of spec */
                .name               = "350",
                .cpu_type           = CPU_K6_3,
                .fpus               = fpus_internal,
                .rspeed             = 350000000,
                .multi              = 3.5,
                .voltage            = 2200,
                .edx_reset          = 0x591,
                .cpuid_model        = 0x591,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 32,
                .mem_write_cycles   = 32,
                .cache_read_cycles  = 11,
                .cache_write_cycles = 11,
                .atclk_div          = 42
            },
            { /* out of spec */
                .name               = "366",
                .cpu_type           = CPU_K6_3,
                .fpus               = fpus_internal,
                .rspeed             = 366666666,
                .multi              = 5.5,
                .voltage            = 2200,
                .edx_reset          = 0x591,
                .cpuid_model        = 0x591,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 33,
                .mem_write_cycles   = 33,
                .cache_read_cycles  = 17,
                .cache_write_cycles = 17,
                .atclk_div          = 44
            },
            { /* out of spec */
                .name               = "380",
                .cpu_type           = CPU_K6_3,
                .fpus               = fpus_internal,
                .rspeed             = 380000000,
                .multi              = 4.0,
                .voltage            = 2200,
                .edx_reset          = 0x591,
                .cpuid_model        = 0x591,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 34,
                .mem_write_cycles   = 34,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 46
            },
            {
                .name               = "400",
                .cpu_type           = CPU_K6_3,
                .fpus               = fpus_internal,
                .rspeed             = 400000000,
                .multi              = 4.0,
                .voltage            = 2200,
                .edx_reset          = 0x591,
                .cpuid_model        = 0x591,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 36,
                .mem_write_cycles   = 36,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 48
            },
            {
                .name               = "450",
                .cpu_type           = CPU_K6_3,
                .fpus               = fpus_internal,
                .rspeed             = 450000000,
                .multi              = 4.5,
                .voltage            = 2200,
                .edx_reset          = 0x591,
                .cpuid_model        = 0x591,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 41,
                .mem_write_cycles   = 41,
                .cache_read_cycles  = 14,
                .cache_write_cycles = 14,
                .atclk_div          = 54
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "AMD",
        .name          = "K6-III+",
        .internal_name = "k6_3p",
        .cpus          = (const CPU[]) {
            { /* out of spec */
                .name               = "100",
                .cpu_type           = CPU_K6_3P,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 1.5,
                .voltage            = 2000,
                .edx_reset          = 0x5d0,
                .cpuid_model        = 0x5d0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 7,
                .mem_write_cycles   = 7,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 9
            },
            { /* out of spec */
                .name               = "133",
                .cpu_type           = CPU_K6_3P,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 2000,
                .edx_reset          = 0x5d0,
                .cpuid_model        = 0x5d0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            { /* out of spec */
                .name               = "166",
                .cpu_type           = CPU_K6_3P,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 2000,
                .edx_reset          = 0x5d0,
                .cpuid_model        = 0x5d0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            { /* out of spec */
                .name               = "200",
                .cpu_type           = CPU_K6_3P,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 2000,
                .edx_reset          = 0x5d0,
                .cpuid_model        = 0x5d0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 24
            },
            { /* out of spec */
                .name               = "233",
                .cpu_type           = CPU_K6_3P,
                .fpus               = fpus_internal,
                .rspeed             = 233333333,
                .multi              = 3.5,
                .voltage            = 2000,
                .edx_reset          = 0x5d0,
                .cpuid_model        = 0x5d0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 10,
                .cache_write_cycles = 10,
                .atclk_div          = 28
            },
            { /* out of spec */
                .name               = "266",
                .cpu_type           = CPU_K6_3P,
                .fpus               = fpus_internal,
                .rspeed             = 266666666,
                .multi              = 4.0,
                .voltage            = 2000,
                .edx_reset          = 0x5d0,
                .cpuid_model        = 0x5d0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 24,
                .mem_write_cycles   = 24,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 32
            },
            { /* out of spec */
                .name               = "300",
                .cpu_type           = CPU_K6_3P,
                .fpus               = fpus_internal,
                .rspeed             = 300000000,
                .multi              = 3.0,
                .voltage            = 2000,
                .edx_reset          = 0x5d0,
                .cpuid_model        = 0x5d0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 27,
                .mem_write_cycles   = 27,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 36
            },
            { /* out of spec */
                .name               = "333",
                .cpu_type           = CPU_K6_3P,
                .fpus               = fpus_internal,
                .rspeed             = 332500000,
                .multi              = 3.5,
                .voltage            = 2000,
                .edx_reset          = 0x5d0,
                .cpuid_model        = 0x5d0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 30,
                .mem_write_cycles   = 30,
                .cache_read_cycles  = 11,
                .cache_write_cycles = 11,
                .atclk_div          = 40
            },
            { /* out of spec */
                .name               = "350",
                .cpu_type           = CPU_K6_3P,
                .fpus               = fpus_internal,
                .rspeed             = 350000000,
                .multi              = 3.5,
                .voltage            = 2000,
                .edx_reset          = 0x5d0,
                .cpuid_model        = 0x5d0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 32,
                .mem_write_cycles   = 32,
                .cache_read_cycles  = 11,
                .cache_write_cycles = 11,
                .atclk_div          = 42
            },
            { /* out of spec */
                .name               = "366",
                .cpu_type           = CPU_K6_3P,
                .fpus               = fpus_internal,
                .rspeed             = 366666666,
                .multi              = 5.5,
                .voltage            = 2000,
                .edx_reset          = 0x5d0,
                .cpuid_model        = 0x5d0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 33,
                .mem_write_cycles   = 33,
                .cache_read_cycles  = 17,
                .cache_write_cycles = 17,
                .atclk_div          = 44
            },
            { /* out of spec */
                .name               = "380",
                .cpu_type           = CPU_K6_3P,
                .fpus               = fpus_internal,
                .rspeed             = 380000000,
                .multi              = 4.0,
                .voltage            = 2000,
                .edx_reset          = 0x5d0,
                .cpuid_model        = 0x5d0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 34,
                .mem_write_cycles   = 34,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 46
            },
            {
                .name               = "400",
                .cpu_type           = CPU_K6_3P,
                .fpus               = fpus_internal,
                .rspeed             = 400000000,
                .multi              = 4.0,
                .voltage            = 2000,
                .edx_reset          = 0x5d0,
                .cpuid_model        = 0x5d0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 36,
                .mem_write_cycles   = 36,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 48
            },
            {
                .name               = "450",
                .cpu_type           = CPU_K6_3P,
                .fpus               = fpus_internal,
                .rspeed             = 450000000,
                .multi              = 4.5,
                .voltage            = 2000,
                .edx_reset          = 0x5d0,
                .cpuid_model        = 0x5d0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 41,
                .mem_write_cycles   = 41,
                .cache_read_cycles  = 14,
                .cache_write_cycles = 14,
                .atclk_div          = 54
            },
            {
                .name               = "475",
                .cpu_type           = CPU_K6_3P,
                .fpus               = fpus_internal,
                .rspeed             = 475000000,
                .multi              = 5.0,
                .voltage            = 2000,
                .edx_reset          = 0x5d0,
                .cpuid_model        = 0x5d0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 43,
                .mem_write_cycles   = 43,
                .cache_read_cycles  = 15,
                .cache_write_cycles = 15,
                .atclk_div          = 57
            },
            {
                .name               = "500",
                .cpu_type           = CPU_K6_3P,
                .fpus               = fpus_internal,
                .rspeed             = 500000000,
                .multi              = 5.0,
                .voltage            = 2000,
                .edx_reset          = 0x5d0,
                .cpuid_model        = 0x5d0,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 45,
                .mem_write_cycles   = 45,
                .cache_read_cycles  = 15,
                .cache_write_cycles = 15,
                .atclk_div          = 60
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "Cyrix",
        .name          = "Cx6x86",
        .internal_name = "cx6x86",
        .cpus          = (const CPU[]) {
            {
                .name               = "80 (PR90+)",
                .cpu_type           = CPU_Cx6x86,
                .fpus               = fpus_internal,
                .rspeed             = 80000000,
                .multi              = 2.0,
                .voltage            = 3520,
                .edx_reset          = 0x520,
                .cpuid_model        = 0x520,
                .cyrix_id           = 0x1731,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 10
            },
            {
                .name               = "100 (PR120+)",
                .cpu_type           = CPU_Cx6x86,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 2.0,
                .voltage            = 3520,
                .edx_reset          = 0x520,
                .cpuid_model        = 0x520,
                .cyrix_id           = 0x1731,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 10,
                .mem_write_cycles   = 10,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 12
            },
            {
                .name               = "110 (PR133+)",
                .cpu_type           = CPU_Cx6x86,
                .fpus               = fpus_internal,
                .rspeed             = 110000000,
                .multi              = 2.0,
                .voltage            = 3520,
                .edx_reset          = 0x520,
                .cpuid_model        = 0x520,
                .cyrix_id           = 0x1731,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 10,
                .mem_write_cycles   = 10,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 14
            },
            {
                .name               = "120 (PR150+)",
                .cpu_type           = CPU_Cx6x86,
                .fpus               = fpus_internal,
                .rspeed             = 120000000,
                .multi              = 2.0,
                .voltage            = 3520,
                .edx_reset          = 0x520,
                .cpuid_model        = 0x520,
                .cyrix_id           = 0x1731,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 14
            },
            {
                .name               = "133 (PR166+)",
                .cpu_type           = CPU_Cx6x86,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 3520,
                .edx_reset          = 0x520,
                .cpuid_model        = 0x520,
                .cyrix_id           = 0x1731,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            {
                .name               = "150 (PR200+)",
                .cpu_type           = CPU_Cx6x86,
                .fpus               = fpus_internal,
                .rspeed             = 150000000,
                .multi              = 2.0,
                .voltage            = 3520,
                .edx_reset          = 0x520,
                .cpuid_model        = 0x520,
                .cyrix_id           = 0x1731,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 18
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "Cyrix",
        .name          = "Cx6x86L",
        .internal_name = "cx6x86l",
        .cpus          = (const CPU[]) {
            {
                .name               = "110 (PR133+)",
                .cpu_type           = CPU_Cx6x86L,
                .fpus               = fpus_internal,
                .rspeed             = 110000000,
                .multi              = 2.0,
                .voltage            = 2800,
                .edx_reset          = 0x540,
                .cpuid_model        = 0x540,
                .cyrix_id           = 0x2231,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 10,
                .mem_write_cycles   = 10,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 14
            },
            {
                .name               = "120 (PR150+)",
                .cpu_type           = CPU_Cx6x86L,
                .fpus               = fpus_internal,
                .rspeed             = 120000000,
                .multi              = 2.0,
                .voltage            = 2800,
                .edx_reset          = 0x540,
                .cpuid_model        = 0x540,
                .cyrix_id           = 0x2231,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 14
            },
            {
                .name               = "133 (PR166+)",
                .cpu_type           = CPU_Cx6x86L,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 2800,
                .edx_reset          = 0x540,
                .cpuid_model        = 0x540,
                .cyrix_id           = 0x2231,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            {
                .name               = "150 (PR200+)",
                .cpu_type           = CPU_Cx6x86L,
                .fpus               = fpus_internal,
                .rspeed             = 150000000,
                .multi              = 2.0,
                .voltage            = 2800,
                .edx_reset          = 0x540,
                .cpuid_model        = 0x540,
                .cyrix_id           = 0x2231,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 18
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "Cyrix",
        .name          = "Cx6x86MX",
        .internal_name = "cx6x86mx",
        .cpus          = (const CPU[]) {
            {
                .name               = "133 (PR166)",
                .cpu_type           = CPU_Cx6x86MX,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 2900,
                .edx_reset          = 0x600,
                .cpuid_model        = 0x600,
                .cyrix_id           = 0x0451,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            {
                .name               = "166 (PR200)",
                .cpu_type           = CPU_Cx6x86MX,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 2900,
                .edx_reset          = 0x600,
                .cpuid_model        = 0x600,
                .cyrix_id           = 0x0452,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            {
                .name               = "187.5 (PR233)",
                .cpu_type           = CPU_Cx6x86MX,
                .fpus               = fpus_internal,
                .rspeed             = 187500000,
                .multi              = 2.5,
                .voltage            = 2900,
                .edx_reset          = 0x600,
                .cpuid_model        = 0x600,
                .cyrix_id           = 0x0452,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 45/2
            },
            {
                .name               = "208.3 (PR266)",
                .cpu_type           = CPU_Cx6x86MX,
                .fpus               = fpus_internal,
                .rspeed             = 208333333,
                .multi              = 2.5,
                .voltage            = 2700,
                .edx_reset          = 0x600,
                .cpuid_model        = 0x600,
                .cyrix_id           = 0x0452,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 17,
                .mem_write_cycles   = 17,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 25
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET5_7,
        .manufacturer  = "Cyrix",
        .name          = "MII",
        .internal_name = "mii",
        .cpus          = (const CPU[]) {
            {
                .name               = "IBM 133 (PR166)",
                .cpu_type           = CPU_Cx6x86MX,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 2900,
                .edx_reset          = 0x601,
                .cpuid_model        = 0x601,
                .cyrix_id           = 0x0851,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            {
                .name               = "166 (PR200)",
                .cpu_type           = CPU_Cx6x86MX,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 2900,
                .edx_reset          = 0x601,
                .cpuid_model        = 0x601,
                .cyrix_id           = 0x0852,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            {
                .name               = "187.5 (PR233)",
                .cpu_type           = CPU_Cx6x86MX,
                .fpus               = fpus_internal,
                .rspeed             = 187500000,
                .multi              = 2.5,
                .voltage            = 2900,
                .edx_reset          = 0x601,
                .cpuid_model        = 0x601,
                .cyrix_id           = 0x0852,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 45/2
            },
            {
                .name               = "208.3 (PR266)",
                .cpu_type           = CPU_Cx6x86MX,
                .fpus               = fpus_internal,
                .rspeed             = 208333333,
                .multi              = 2.5,
                .voltage            = 2700,
                .edx_reset          = 0x601,
                .cpuid_model        = 0x601,
                .cyrix_id           = 0x0852,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 17,
                .mem_write_cycles   = 17,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 25
            },
            {
                .name               = "233 (PR300)",
                .cpu_type           = CPU_Cx6x86MX,
                .fpus               = fpus_internal,
                .rspeed             = 233333333,
                .multi              = 3.5,
                .voltage            = 2900,
                .edx_reset          = 0x601,
                .cpuid_model        = 0x601,
                .cyrix_id           = 0x0854,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 11,
                .cache_write_cycles = 11,
                .atclk_div          = 28
            },
            {
                .name               = "250/83 (PR333)",
                .cpu_type           = CPU_Cx6x86MX,
                .fpus               = fpus_internal,
                .rspeed             = 250000000,
                .multi              = 3.0,
                .voltage            = 2900,
                .edx_reset          = 0x601,
                .cpuid_model        = 0x601,
                .cyrix_id           = 0x0853,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 23,
                .mem_write_cycles   = 23,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 30
            },
            {
                .name               = "250/100 (PR366)",
                .cpu_type           = CPU_Cx6x86MX,
                .fpus               = fpus_internal,
                .rspeed             = 250000000,
                .multi              = 2.5,
                .voltage            = 2900,
                .edx_reset          = 0x601,
                .cpuid_model        = 0x601,
                .cyrix_id           = 0x0852,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 23,
                .mem_write_cycles   = 23,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 30
            },
            {
                .name               = "270 (PR350)",
                .cpu_type           = CPU_Cx6x86MX,
                .fpus               = fpus_internal,
                .rspeed             = 270000000,
                .multi              = 3.0,
                .voltage            = 2900,
                .edx_reset          = 0x601,
                .cpuid_model        = 0x601,
                .cyrix_id           = 0x0853,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 25,
                .mem_write_cycles   = 25,
                .cache_read_cycles  = 8,
                .cache_write_cycles = 8,
                .atclk_div          = 32
            },
            {
                .name               = "285 (PR400)",
                .cpu_type           = CPU_Cx6x86MX,
                .fpus               = fpus_internal,
                .rspeed             = 285000000,
                .multi              = 3.0,
                .voltage            = 2900,
                .edx_reset          = 0x601,
                .cpuid_model        = 0x601,
                .cyrix_id           = 0x0853,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 27,
                .mem_write_cycles   = 27,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 34
            },
            {
                .name               = "300 (PR433)",
                .cpu_type           = CPU_Cx6x86MX,
                .fpus               = fpus_internal,
                .rspeed             = 300000000,
                .multi              = 3.0,
                .voltage            = 2900,
                .edx_reset          = 0x601,
                .cpuid_model        = 0x601,
                .cyrix_id           = 0x0853,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 27,
                .mem_write_cycles   = 27,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 36
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET8,
        .manufacturer  = "Intel",
        .name          = "Pentium Pro",
        .internal_name = "pentiumpro",
        .cpus          = (const CPU[]) {
            { /* out of spec */
                .name               = "60",
                .cpu_type           = CPU_PENTIUMPRO,
                .fpus               = fpus_internal,
                .rspeed             = 60000000,
                .multi              = 1.0,
                .voltage            = 3100,
                .edx_reset          = 0x612,
                .cpuid_model        = 0x612,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 1,
                .cache_write_cycles = 1,
                .atclk_div          = 7
            },
            { /* out of spec */
                .name               = "66",
                .cpu_type           = CPU_PENTIUMPRO,
                .fpus               = fpus_internal,
                .rspeed             = 66666666,
                .multi              = 1.0,
                .voltage            = 3300,
                .edx_reset          = 0x617,
                .cpuid_model        = 0x617,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 1,
                .cache_write_cycles = 1,
                .atclk_div          = 8
            },
            { /* out of spec */
                .name               = "90",
                .cpu_type           = CPU_PENTIUMPRO,
                .fpus               = fpus_internal,
                .rspeed             = 90000000,
                .multi              = 1.5,
                .voltage            = 3100,
                .edx_reset          = 0x612,
                .cpuid_model        = 0x612,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 11
            },
            { /* out of spec */
                .name               = "100",
                .cpu_type           = CPU_PENTIUMPRO,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 1.5,
                .voltage            = 3300,
                .edx_reset          = 0x617,
                .cpuid_model        = 0x617,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 12
            },
            { /* out of spec */
                .name               = "120",
                .cpu_type           = CPU_PENTIUMPRO,
                .fpus               = fpus_internal,
                .rspeed             = 120000000,
                .multi              = 2.0,
                .voltage            = 3100,
                .edx_reset          = 0x612,
                .cpuid_model        = 0x612,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 5,
                .cache_write_cycles = 5,
                .atclk_div          = 14
            },
            { /* out of spec */
                .name               = "133",
                .cpu_type           = CPU_PENTIUMPRO,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 3300,
                .edx_reset          = 0x617,
                .cpuid_model        = 0x617,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 5,
                .cache_write_cycles = 5,
                .atclk_div          = 16
            }, /* out of spec */
            {
                .name               = "150",
                .cpu_type           = CPU_PENTIUMPRO,
                .fpus               = fpus_internal,
                .rspeed             = 150000000,
                .multi              = 2.5,
                .voltage            = 3100,
                .edx_reset          = 0x612,
                .cpuid_model        = 0x612,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 35/2
            },
            {
                .name               = "166",
                .cpu_type           = CPU_PENTIUMPRO,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 3300,
                .edx_reset          = 0x617,
                .cpuid_model        = 0x617,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            {
                .name               = "180",
                .cpu_type           = CPU_PENTIUMPRO,
                .fpus               = fpus_internal,
                .rspeed             = 180000000,
                .multi              = 3.0,
                .voltage            = 3300,
                .edx_reset          = 0x617,
                .cpuid_model        = 0x617,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 21
            },
            {
                .name               = "200",
                .cpu_type           = CPU_PENTIUMPRO,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 3300,
                .edx_reset          = 0x617,
                .cpuid_model        = 0x617,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 24
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET8,
        .manufacturer  = "Intel",
        .name          = "Pentium II OverDrive",
        .internal_name = "pentium2_od",
        .cpus          = (const CPU[]) {
            { /* out of spec */
                .name               = "66",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 66666666,
                .multi              = 1.0,
                .voltage            = 3300,
                .edx_reset          = 0x1632,
                .cpuid_model        = 0x1632,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 8
            },
            { /* out of spec */
                .name               = "100",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 1.5,
                .voltage            = 3300,
                .edx_reset          = 0x1632,
                .cpuid_model        = 0x1632,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 12
            },
            { /* out of spec */
                .name               = "133",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 3300,
                .edx_reset          = 0x1632,
                .cpuid_model        = 0x1632,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            { /* out of spec */
                .name               = "166",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 3300,
                .edx_reset          = 0x1632,
                .cpuid_model        = 0x1632,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            { /* out of spec */
                .name               = "200",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 3300,
                .edx_reset          = 0x1632,
                .cpuid_model        = 0x1632,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 24
            },
            { /* out of spec */
                .name               = "233",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 233333333,
                .multi              = 3.5,
                .voltage            = 3300,
                .edx_reset          = 0x1632,
                .cpuid_model        = 0x1632,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 10,
                .cache_write_cycles = 10,
                .atclk_div          = 28
            },
            { /* out of spec */
                .name               = "266",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 266666666,
                .multi              = 4.0,
                .voltage            = 3300,
                .edx_reset          = 0x1632,
                .cpuid_model        = 0x1632,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 24,
                .mem_write_cycles   = 24,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 32
            },
            {
                .name               = "300",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 300000000,
                .multi              = 5.0,
                .voltage            = 3300,
                .edx_reset          = 0x1632,
                .cpuid_model        = 0x1632,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 27,
                .mem_write_cycles   = 27,
                .cache_read_cycles  = 13,
                .cache_write_cycles = 13,
                .atclk_div          = 36
            },
            {
                .name               = "333",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 333333333,
                .multi              = 5.0,
                .voltage            = 3300,
                .edx_reset          = 0x1632,
                .cpuid_model        = 0x1632,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 27,
                .mem_write_cycles   = 27,
                .cache_read_cycles  = 13,
                .cache_write_cycles = 13,
                .atclk_div          = 40
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SLOT1,
        .manufacturer  = "Intel",
        .name          = "Pentium II (Klamath)",
        .internal_name = "pentium2_klamath",
        .cpus          = (const CPU[]) {
            { /* out of spec */
                .name               = "66",
                .cpu_type           = CPU_PENTIUM2,
                .fpus               = fpus_internal,
                .rspeed             = 66666666,
                .multi              = 1.0,
                .voltage            = 2800,
                .edx_reset          = 0x634,
                .cpuid_model        = 0x634,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 8
            },
            { /* out of spec */
                .name               = "100",
                .cpu_type           = CPU_PENTIUM2,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 1.5,
                .voltage            = 2800,
                .edx_reset          = 0x634,
                .cpuid_model        = 0x634,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 12
            },
            { /* out of spec */
                .name               = "133",
                .cpu_type           = CPU_PENTIUM2,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 2800,
                .edx_reset          = 0x634,
                .cpuid_model        = 0x634,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            { /* out of spec */
                .name               = "166",
                .cpu_type           = CPU_PENTIUM2,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 2800,
                .edx_reset          = 0x634,
                .cpuid_model        = 0x634,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            { /* out of spec */
                .name               = "200",
                .cpu_type           = CPU_PENTIUM2,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 2800,
                .edx_reset          = 0x634,
                .cpuid_model        = 0x634,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 24
            },
            {
                .name               = "233",
                .cpu_type           = CPU_PENTIUM2,
                .fpus               = fpus_internal,
                .rspeed             = 233333333,
                .multi              = 3.5,
                .voltage            = 2800,
                .edx_reset          = 0x634,
                .cpuid_model        = 0x634,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 10,
                .cache_write_cycles = 10,
                .atclk_div          = 28
            },
            {
                .name               = "266",
                .cpu_type           = CPU_PENTIUM2,
                .fpus               = fpus_internal,
                .rspeed             = 266666666,
                .multi              = 4.0,
                .voltage            = 2800,
                .edx_reset          = 0x634,
                .cpuid_model        = 0x634,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 24,
                .mem_write_cycles   = 24,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 32
            },
            {
                .name               = "300",
                .cpu_type           = CPU_PENTIUM2,
                .fpus               = fpus_internal,
                .rspeed             = 300000000,
                .multi              = 4.5,
                .voltage            = 2800,
                .edx_reset          = 0x634,
                .cpuid_model        = 0x634,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 25,
                .mem_write_cycles   = 25,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 36
            },
            { .name = "", 0 }
        }
    }, {
        .package       = CPU_PKG_SLOT1,
        .manufacturer  = "Intel",
        .name          = "Pentium II (Deschutes)",
        .internal_name = "pentium2_deschutes",
        .cpus          = (const CPU[]) {
            { /* out of spec */
                .name               = "66",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 66666666,
                .multi              = 1.0,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 8
            },
            { /* out of spec */
                .name               = "100",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 1.5,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 5,
                .cache_write_cycles = 5,
                .atclk_div          = 12
            },
            { /* out of spec */
                .name               = "133",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            { /* out of spec */
                .name               = "166",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            { /* out of spec */
                .name               = "200",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 24
            },
            { /* out of spec */
                .name               = "233",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 233333333,
                .multi              = 3.5,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 11,
                .cache_write_cycles = 11,
                .atclk_div          = 28
            },
            {
                .name               = "266",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 266666666,
                .multi              = 4.0,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 24,
                .mem_write_cycles   = 24,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 32
            },
            {
                .name               = "300",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 300000000,
                .multi              = 4.5,
                .voltage            = 2050,
                .edx_reset          = 0x651,
                .cpuid_model        = 0x651,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 25,
                .mem_write_cycles   = 25,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 36
            },
            {
                .name               = "333",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 333333333,
                .multi              = 5.0,
                .voltage            = 2050,
                .edx_reset          = 0x651,
                .cpuid_model        = 0x651,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 27,
                .mem_write_cycles   = 27,
                .cache_read_cycles  = 13,
                .cache_write_cycles = 13,
                .atclk_div          = 40
            },
            {
                .name               = "350",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 350000000,
                .multi              = 3.5,
                .voltage            = 2050,
                .edx_reset          = 0x651,
                .cpuid_model        = 0x651,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 32,
                .mem_write_cycles   = 32,
                .cache_read_cycles  = 11,
                .cache_write_cycles = 11,
                .atclk_div          = 42
            },
            {
                .name               = "400",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 400000000,
                .multi              = 4.0,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 36,
                .mem_write_cycles   = 36,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 48
            },
            {
                .name               = "450",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 450000000,
                .multi              = 4.5,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 41,
                .mem_write_cycles   = 41,
                .cache_read_cycles  = 14,
                .cache_write_cycles = 14,
                .atclk_div          = 54
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SLOT1,
        .manufacturer  = "Intel",
        .name          = "Celeron (Covington)",
        .internal_name = "celeron_covington",
        .cpus          = (const CPU[]) {
            { /* out of spec */
                .name               = "66",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 66666666,
                .multi              = 1.0,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 8
            },
            { /* out of spec */
                .name               = "100",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 1.5,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 12
            },
            { /* out of spec */
                .name               = "133",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 16
            },
            { /* out of spec */
                .name               = "166",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 15,
                .cache_write_cycles = 15,
                .atclk_div          = 20
            },
            { /* out of spec */
                .name               = "200",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 18,
                .cache_write_cycles = 18,
                .atclk_div          = 24
            },
            { /* out of spec */
                .name               = "233",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 233333333,
                .multi              = 3.5,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 21,
                .cache_write_cycles = 21,
                .atclk_div          = 28
            },
            {
                .name               = "266",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 266666666,
                .multi              = 4.0,
                .voltage            = 2050,
                .edx_reset          = 0x650,
                .cpuid_model        = 0x650,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 24,
                .mem_write_cycles   = 24,
                .cache_read_cycles  = 24,
                .cache_write_cycles = 24,
                .atclk_div          = 32
            },
            {
                .name               = "300",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 300000000,
                .multi              = 4.5,
                .voltage            = 2050,
                .edx_reset          = 0x651,
                .cpuid_model        = 0x651,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 25,
                .mem_write_cycles   = 25,
                .cache_read_cycles  = 25,
                .cache_write_cycles = 25,
                .atclk_div          = 36
            },
            { .name = "", 0 }
        }
    }, {
        .package       = CPU_PKG_SLOT2,
        .manufacturer  = "Intel",
        .name          = "Pentium II Xeon",
        .internal_name = "pentium2_xeon",
        .cpus          = (const CPU[]) {
            { /* out of spec */
                .name               = "100",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 1.0,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 12
            },
            { /* out of spec */
                .name               = "150",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 150000000,
                .multi              = 1.5,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 14,
                .mem_write_cycles   = 14,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 18
            },
            { /* out of spec */
                .name               = "200",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 2.0,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 24
            },
            { /* out of spec */
                .name               = "250",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 250000000,
                .multi              = 2.5,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 22,
                .mem_write_cycles   = 22,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 30
            },
            { /* out of spec */
                .name               = "300",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 300000000,
                .multi              = 3.0,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 27,
                .mem_write_cycles   = 27,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 36
            },
            { /* out of spec */
                .name               = "350",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 350000000,
                .multi              = 3.5,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 32,
                .mem_write_cycles   = 32,
                .cache_read_cycles  = 10,
                .cache_write_cycles = 10,
                .atclk_div          = 42
            },
            {
                .name               = "400",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 400000000,
                .multi              = 4.0,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 36,
                .mem_write_cycles   = 36,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 48
            },
            {
                .name               = "450",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 450000000,
                .multi              = 4.5,
                .voltage            = 2050,
                .edx_reset          = 0x652,
                .cpuid_model        = 0x652,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC,
                .mem_read_cycles    = 41,
                .mem_write_cycles   = 41,
                .cache_read_cycles  = 14,
                .cache_write_cycles = 14,
                .atclk_div          = 54
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET370,
        .manufacturer  = "Intel",
        .name          = "Celeron (Mendocino)",
        .internal_name = "celeron_mendocino",
        .cpus          = (const CPU[]) {
            { /* out of spec */
                .name               = "66",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 66666666,
                .multi              = 1.0,
                .voltage            = 2050,
                .edx_reset          = 0x665,
                .cpuid_model        = 0x665,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 8
            },
            { /* out of spec */
                .name               = "100",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 1.5,
                .voltage            = 2050,
                .edx_reset          = 0x665,
                .cpuid_model        = 0x665,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 8,
                .mem_write_cycles   = 8,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 12
            },
            { /* out of spec */
                .name               = "133",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 2050,
                .edx_reset          = 0x665,
                .cpuid_model        = 0x665,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 11,
                .mem_write_cycles   = 11,
                .cache_read_cycles  = 5,
                .cache_write_cycles = 5,
                .atclk_div          = 16
            },
            { /* out of spec */
                .name               = "166",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 2050,
                .edx_reset          = 0x665,
                .cpuid_model        = 0x665,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 14,
                .mem_write_cycles   = 14,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            { /* out of spec */
                .name               = "200",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 2050,
                .edx_reset          = 0x665,
                .cpuid_model        = 0x665,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 17,
                .mem_write_cycles   = 17,
                .cache_read_cycles  = 8,
                .cache_write_cycles = 8,
                .atclk_div          = 24
            },
            { /* out of spec */
                .name               = "233",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 233333333,
                .multi              = 3.5,
                .voltage            = 2050,
                .edx_reset          = 0x665,
                .cpuid_model        = 0x665,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 19,
                .mem_write_cycles   = 19,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 28
            },
            { /* out of spec */
                .name               = "266",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 266666666,
                .multi              = 4.0,
                .voltage            = 2050,
                .edx_reset          = 0x665,
                .cpuid_model        = 0x665,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 22,
                .mem_write_cycles   = 22,
                .cache_read_cycles  = 11,
                .cache_write_cycles = 11,
                .atclk_div          = 32
            },
            {
                .name               = "300A",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 300000000,
                .multi              = 4.5,
                .voltage            = 2050,
                .edx_reset          = 0x665,
                .cpuid_model        = 0x665,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 25,
                .mem_write_cycles   = 25,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 36
            },
            {
                .name               = "333",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 333333333,
                .multi              = 5.0,
                .voltage            = 2050,
                .edx_reset          = 0x665,
                .cpuid_model        = 0x665,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 27,
                .mem_write_cycles   = 27,
                .cache_read_cycles  = 13,
                .cache_write_cycles = 13,
                .atclk_div          = 40
            },
            {
                .name               = "366",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 366666666,
                .multi              = 5.5,
                .voltage            = 2050,
                .edx_reset          = 0x665,
                .cpuid_model        = 0x665,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 33,
                .mem_write_cycles   = 33,
                .cache_read_cycles  = 17,
                .cache_write_cycles = 17,
                .atclk_div          = 44
            },
            {
                .name               = "400",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 400000000,
                .multi              = 6.0,
                .voltage            = 2050,
                .edx_reset          = 0x665,
                .cpuid_model        = 0x665,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 36,
                .mem_write_cycles   = 36,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 48
            },
            {
                .name               = "433",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 433333333,
                .multi              = 6.5,
                .voltage            = 2050,
                .edx_reset          = 0x665,
                .cpuid_model        = 0x665,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 39,
                .mem_write_cycles   = 39,
                .cache_read_cycles  = 13,
                .cache_write_cycles = 13,
                .atclk_div          = 51
            },
            {
                .name               = "466",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 466666666,
                .multi              = 7.0,
                .voltage            = 2050,
                .edx_reset          = 0x665,
                .cpuid_model        = 0x665,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 42,
                .mem_write_cycles   = 42,
                .cache_read_cycles  = 14,
                .cache_write_cycles = 14,
                .atclk_div          = 56
            },
            {
                .name               = "500",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 500000000,
                .multi              = 7.5,
                .voltage            = 2050,
                .edx_reset          = 0x665,
                .cpuid_model        = 0x665,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 45,
                .mem_write_cycles   = 45,
                .cache_read_cycles  = 15,
                .cache_write_cycles = 15,
                .atclk_div          = 60
            },
            {
                .name               = "533",
                .cpu_type           = CPU_PENTIUM2D,
                .fpus               = fpus_internal,
                .rspeed             = 533333333,
                .multi              = 8.0,
                .voltage            = 2050,
                .edx_reset          = 0x665,
                .cpuid_model        = 0x665,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_REQUIRES_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 48,
                .mem_write_cycles   = 48,
                .cache_read_cycles  = 17,
                .cache_write_cycles = 17,
                .atclk_div          = 64
            },
            { .name = "", 0 }
        }
    },
    {
        .package       = CPU_PKG_SOCKET370,
        .manufacturer  = "VIA",
        .name          = "Cyrix III (Samuel)",
        .internal_name = "c3_samuel",
        .cpus          = (const CPU[]) {
            { /* out of multiplier range */
                .name               = "66",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 66666666,
                .multi              = 1.0,
                .voltage            = 2050,
                .edx_reset          = 0x660,
                .cpuid_model        = 0x660,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 6,
                .mem_write_cycles   = 6,
                .cache_read_cycles  = 3,
                .cache_write_cycles = 3,
                .atclk_div          = 8
            },
            { /* out of multiplier range */
                .name               = "100",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 100000000,
                .multi              = 1.5,
                .voltage            = 2050,
                .edx_reset          = 0x660,
                .cpuid_model        = 0x660,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 9,
                .mem_write_cycles   = 9,
                .cache_read_cycles  = 4,
                .cache_write_cycles = 4,
                .atclk_div          = 12
            },
            { /* out of multiplier range */
                .name               = "133",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 133333333,
                .multi              = 2.0,
                .voltage            = 2050,
                .edx_reset          = 0x660,
                .cpuid_model        = 0x660,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 12,
                .mem_write_cycles   = 12,
                .cache_read_cycles  = 6,
                .cache_write_cycles = 6,
                .atclk_div          = 16
            },
            { /* out of multiplier range */
                .name               = "166",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 166666666,
                .multi              = 2.5,
                .voltage            = 2050,
                .edx_reset          = 0x660,
                .cpuid_model        = 0x660,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 15,
                .mem_write_cycles   = 15,
                .cache_read_cycles  = 7,
                .cache_write_cycles = 7,
                .atclk_div          = 20
            },
            { /* out of multiplier range */
                .name               = "200",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 200000000,
                .multi              = 3.0,
                .voltage            = 2050,
                .edx_reset          = 0x660,
                .cpuid_model        = 0x660,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 18,
                .mem_write_cycles   = 18,
                .cache_read_cycles  = 8,
                .cache_write_cycles = 8,
                .atclk_div          = 24
            },
            { /* out of multiplier range */
                .name               = "233",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 233333333,
                .multi              = 3.5,
                .voltage            = 2050,
                .edx_reset          = 0x660,
                .cpuid_model        = 0x660,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 21,
                .mem_write_cycles   = 21,
                .cache_read_cycles  = 9,
                .cache_write_cycles = 9,
                .atclk_div          = 28
            },
            { /* out of multiplier range */
                .name               = "266",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 266666666,
                .multi              = 4.0,
                .voltage            = 2050,
                .edx_reset          = 0x660,
                .cpuid_model        = 0x660,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 24,
                .mem_write_cycles   = 24,
                .cache_read_cycles  = 12,
                .cache_write_cycles = 12,
                .atclk_div          = 32
            },
            { /* out of spec */
                .name               = "300",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 300000000,
                .multi              = 4.5,
                .voltage            = 2050,
                .edx_reset          = 0x660,
                .cpuid_model        = 0x660,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 27,
                .mem_write_cycles   = 27,
                .cache_read_cycles  = 13,
                .cache_write_cycles = 13,
                .atclk_div          = 36
            },
            { /* out of spec */
                .name               = "333",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 333333333,
                .multi              = 5.0,
                .voltage            = 2050,
                .edx_reset          = 0x662,
                .cpuid_model        = 0x662,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 30,
                .mem_write_cycles   = 30,
                .cache_read_cycles  = 15,
                .cache_write_cycles = 15,
                .atclk_div          = 40
            },
            { /* out of spec */
                .name               = "366",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 366666666,
                .multi              = 5.5,
                .voltage            = 2050,
                .edx_reset          = 0x662,
                .cpuid_model        = 0x662,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 33,
                .mem_write_cycles   = 33,
                .cache_read_cycles  = 16,
                .cache_write_cycles = 16,
                .atclk_div          = 44
            },
            {
                .name               = "400",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 400000000,
                .multi              = 6.0,
                .voltage            = 2050,
                .edx_reset          = 0x660,
                .cpuid_model        = 0x660,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 36,
                .mem_write_cycles   = 36,
                .cache_read_cycles  = 17,
                .cache_write_cycles = 17,
                .atclk_div          = 48
            },
            { /* out of spec */
                .name               = "433",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 433333333,
                .multi              = 6.5,
                .voltage            = 2050,
                .edx_reset          = 0x660,
                .cpuid_model        = 0x660,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 39,
                .mem_write_cycles   = 39,
                .cache_read_cycles  = 18,
                .cache_write_cycles = 18,
                .atclk_div          = 52
            },
            {
                .name               = "450",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 450000000,
                .multi              = 4.5,
                .voltage            = 2050,
                .edx_reset          = 0x660,
                .cpuid_model        = 0x660,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 41,
                .mem_write_cycles   = 41,
                .cache_read_cycles  = 14,
                .cache_write_cycles = 14,
                .atclk_div          = 54
            },
            { /* out of spec */
                .name               = "466",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 466666666,
                .multi              = 6.5,
                .voltage            = 2050,
                .edx_reset          = 0x660,
                .cpuid_model        = 0x660,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 42,
                .mem_write_cycles   = 42,
                .cache_read_cycles  = 14,
                .cache_write_cycles = 14,
                .atclk_div          = 56
            },
            {
                .name               = "500",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 500000000,
                .multi              = 5.0,
                .voltage            = 2050,
                .edx_reset          = 0x662,
                .cpuid_model        = 0x662,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 45,
                .mem_write_cycles   = 45,
                .cache_read_cycles  = 15,
                .cache_write_cycles = 15,
                .atclk_div          = 60
            },
            { /* out of spec */
                .name               = "533",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 533333333,
                .multi              = 8.0,
                .voltage            = 2050,
                .edx_reset          = 0x660,
                .cpuid_model        = 0x660,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 48,
                .mem_write_cycles   = 48,
                .cache_read_cycles  = 15,
                .cache_write_cycles = 15,
                .atclk_div          = 64
            },
            {
                .name               = "550",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 550000000,
                .multi              = 5.5,
                .voltage            = 2050,
                .edx_reset          = 0x662,
                .cpuid_model        = 0x662,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 50,
                .mem_write_cycles   = 50,
                .cache_read_cycles  = 17,
                .cache_write_cycles = 17,
                .atclk_div          = 66
            },
            {
                .name               = "600/100",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 600000000,
                .multi              = 6.0,
                .voltage            = 2050,
                .edx_reset          = 0x662,
                .cpuid_model        = 0x662,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 54,
                .mem_write_cycles   = 54,
                .cache_read_cycles  = 18,
                .cache_write_cycles = 18,
                .atclk_div          = 72
            },
            {
                .name               = "600/133",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 600000000,
                .multi              = 4.5,
                .voltage            = 2050,
                .edx_reset          = 0x663,
                .cpuid_model        = 0x663,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 54,
                .mem_write_cycles   = 54,
                .cache_read_cycles  = 13,
                .cache_write_cycles = 13,
                .atclk_div          = 72
            },
            {
                .name               = "650",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 650000000,
                .multi              = 6.5,
                .voltage            = 2050,
                .edx_reset          = 0x663,
                .cpuid_model        = 0x663,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 58,
                .mem_write_cycles   = 58,
                .cache_read_cycles  = 20,
                .cache_write_cycles = 20,
                .atclk_div          = 78
            },
            {
                .name               = "667",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 666666667,
                .multi              = 5.0,
                .voltage            = 2050,
                .edx_reset          = 0x663,
                .cpuid_model        = 0x663,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 60,
                .mem_write_cycles   = 60,
                .cache_read_cycles  = 16,
                .cache_write_cycles = 16,
                .atclk_div          = 80
            },
            {
                .name               = "700",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 700000000,
                .multi              = 7.0,
                .voltage            = 2050,
                .edx_reset          = 0x663,
                .cpuid_model        = 0x663,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 63,
                .mem_write_cycles   = 63,
                .cache_read_cycles  = 21,
                .cache_write_cycles = 21,
                .atclk_div          = 84
            },
            {
                .name               = "733",
                .cpu_type           = CPU_CYRIX3S,
                .fpus               = fpus_internal,
                .rspeed             = 733333333,
                .multi              = 5.5,
                .voltage            = 2050,
                .edx_reset          = 0x663,
                .cpuid_model        = 0x663,
                .cyrix_id           = 0,
                .cpu_flags          = CPU_SUPPORTS_DYNAREC | CPU_FIXED_MULTIPLIER,
                .mem_read_cycles    = 66,
                .mem_write_cycles   = 66,
                .cache_read_cycles  = 18,
                .cache_write_cycles = 18,
                .atclk_div          = 88
            },
            { .name = "", 0 }
        }
    },
    { .package = 0, 0 }
  // clang-format on
};
