/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum UniquenessMultipleAttributeBehavior {
    UNIQUE_WITHIN_EACH_ATTRIBUTE(0),
    UNIQUE_ACROSS_ALL_ATTRIBUTES_INCLUDING_IN_SAME_ENTRY(1),
    UNIQUE_ACROSS_ALL_ATTRIBUTES_EXCEPT_IN_SAME_ENTRY(2),
    UNIQUE_IN_COMBINATION(3);

    private final int intValue;

    private UniquenessMultipleAttributeBehavior(int intValue) {
        this.intValue = intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    @Nullable
    public static UniquenessMultipleAttributeBehavior valueOf(int intValue) {
        switch (intValue) {
            case 0: {
                return UNIQUE_WITHIN_EACH_ATTRIBUTE;
            }
            case 1: {
                return UNIQUE_ACROSS_ALL_ATTRIBUTES_INCLUDING_IN_SAME_ENTRY;
            }
            case 2: {
                return UNIQUE_ACROSS_ALL_ATTRIBUTES_EXCEPT_IN_SAME_ENTRY;
            }
            case 3: {
                return UNIQUE_IN_COMBINATION;
            }
        }
        return null;
    }

    @Nullable
    public static UniquenessMultipleAttributeBehavior forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "uniquewithineachattribute": 
            case "unique-within-each-attribute": 
            case "unique_within_each_attribute": {
                return UNIQUE_WITHIN_EACH_ATTRIBUTE;
            }
            case "uniqueacrossallattributesincludinginsameentry": 
            case "unique-across-all-attributes-including-in-same-entry": 
            case "unique_across_all_attributes_including_in_same_entry": {
                return UNIQUE_ACROSS_ALL_ATTRIBUTES_INCLUDING_IN_SAME_ENTRY;
            }
            case "uniqueacrossallattributesexceptinsameentry": 
            case "unique-across-all-attributes-except-in-same-entry": 
            case "unique_across_all_attributes_except_in_same_entry": {
                return UNIQUE_ACROSS_ALL_ATTRIBUTES_EXCEPT_IN_SAME_ENTRY;
            }
            case "uniqueincombination": 
            case "unique-in-combination": 
            case "unique_in_combination": {
                return UNIQUE_IN_COMBINATION;
            }
        }
        return null;
    }
}

