/*  This file is part of FreeDoko.
    FreeDoko is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version (see <http://www.gnu.org/licenses/>).

    Diese Datei ist Teil von FreeDoko.
    FreeDoko ist Freie Software: Sie können es unter den Bedingungen der GNU General Public License, wie von der Free Software Foundation, Version 3 der Lizenz oder (nach Ihrer Wahl) jeder neueren veröffentlichten Version, weiter verteilen und/oder modifizieren (siehe <https://www.gnu.org/licenses/>).
    */

#pragma once

#include "constants.h"

#include "rating.h"

/**
 ** median rater
 ** Returns the median value of the given values.
 **/
class Rating::Median : public Rating {
  public:
    Median() : Rating(Type::median) { }
    ~Median() override = default;

    auto value() const -> int override
    {
      if (this->values.empty())
	return INT_MIN;
      this->sort();
      if (this->values.size() % 2 == 0)
	return (this->values[this->values.size() / 2]
		+ this->values[this->values.size() / 2 + 1]);
      else
	return this->values[this->values.size() / 2];
    }
}; // class Rating::Median : public Rating
