﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/application-signals/ApplicationSignals_EXPORTS.h>
#include <aws/application-signals/model/Edge.h>
#include <aws/application-signals/model/Node.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ApplicationSignals {
namespace Model {

/**
 * <p>Represents a graph showing the dependencies between services and components
 * in your application architecture.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/DependencyGraph">AWS
 * API Reference</a></p>
 */
class DependencyGraph {
 public:
  AWS_APPLICATIONSIGNALS_API DependencyGraph() = default;
  AWS_APPLICATIONSIGNALS_API DependencyGraph(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPLICATIONSIGNALS_API DependencyGraph& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPLICATIONSIGNALS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>An array of nodes in the dependency graph, where each node represents a
   * service or component.</p>
   */
  inline const Aws::Vector<Node>& GetNodes() const { return m_nodes; }
  inline bool NodesHasBeenSet() const { return m_nodesHasBeenSet; }
  template <typename NodesT = Aws::Vector<Node>>
  void SetNodes(NodesT&& value) {
    m_nodesHasBeenSet = true;
    m_nodes = std::forward<NodesT>(value);
  }
  template <typename NodesT = Aws::Vector<Node>>
  DependencyGraph& WithNodes(NodesT&& value) {
    SetNodes(std::forward<NodesT>(value));
    return *this;
  }
  template <typename NodesT = Node>
  DependencyGraph& AddNodes(NodesT&& value) {
    m_nodesHasBeenSet = true;
    m_nodes.emplace_back(std::forward<NodesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of edges in the dependency graph, where each edge represents a
   * connection or dependency between two nodes.</p>
   */
  inline const Aws::Vector<Edge>& GetEdges() const { return m_edges; }
  inline bool EdgesHasBeenSet() const { return m_edgesHasBeenSet; }
  template <typename EdgesT = Aws::Vector<Edge>>
  void SetEdges(EdgesT&& value) {
    m_edgesHasBeenSet = true;
    m_edges = std::forward<EdgesT>(value);
  }
  template <typename EdgesT = Aws::Vector<Edge>>
  DependencyGraph& WithEdges(EdgesT&& value) {
    SetEdges(std::forward<EdgesT>(value));
    return *this;
  }
  template <typename EdgesT = Edge>
  DependencyGraph& AddEdges(EdgesT&& value) {
    m_edgesHasBeenSet = true;
    m_edges.emplace_back(std::forward<EdgesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Node> m_nodes;
  bool m_nodesHasBeenSet = false;

  Aws::Vector<Edge> m_edges;
  bool m_edgesHasBeenSet = false;
};

}  // namespace Model
}  // namespace ApplicationSignals
}  // namespace Aws
