﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codecommit/CodeCommit_EXPORTS.h>
#include <aws/codecommit/model/Difference.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CodeCommit {
namespace Model {
class GetDifferencesResult {
 public:
  AWS_CODECOMMIT_API GetDifferencesResult() = default;
  AWS_CODECOMMIT_API GetDifferencesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CODECOMMIT_API GetDifferencesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A data type object that contains information about the differences, including
   * whether the difference is added, modified, or deleted (A, D, M).</p>
   */
  inline const Aws::Vector<Difference>& GetDifferences() const { return m_differences; }
  template <typename DifferencesT = Aws::Vector<Difference>>
  void SetDifferences(DifferencesT&& value) {
    m_differencesHasBeenSet = true;
    m_differences = std::forward<DifferencesT>(value);
  }
  template <typename DifferencesT = Aws::Vector<Difference>>
  GetDifferencesResult& WithDifferences(DifferencesT&& value) {
    SetDifferences(std::forward<DifferencesT>(value));
    return *this;
  }
  template <typename DifferencesT = Difference>
  GetDifferencesResult& AddDifferences(DifferencesT&& value) {
    m_differencesHasBeenSet = true;
    m_differences.emplace_back(std::forward<DifferencesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An enumeration token that can be used in a request to return the next batch
   * of the results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  GetDifferencesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetDifferencesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Difference> m_differences;
  bool m_differencesHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeCommit
}  // namespace Aws
