// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// RuntimeAddServer Runtime Add Server
//
// Settable properties when adding a new server using HAProxy's runtime.
//
// swagger:model runtime_add_server
type RuntimeAddServer struct {
	// address
	// Read Only: true
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Address string `json:"address,omitempty"`

	// agent addr
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	AgentAddr string `json:"agent-addr,omitempty"`

	// agent check
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	AgentCheck string `json:"agent-check,omitempty"`

	// agent inter
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	AgentInter *int64 `json:"agent-inter,omitempty"`

	// agent port
	// Maximum: 65535
	// Minimum: 1
	// +kubebuilder:validation:Maximum=65535
	// +kubebuilder:validation:Minimum=1
	AgentPort *int64 `json:"agent-port,omitempty"`

	// agent send
	AgentSend string `json:"agent-send,omitempty"`

	// allow 0rtt
	Allow0rtt bool `json:"allow_0rtt,omitempty"`

	// alpn
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Alpn string `json:"alpn,omitempty"`

	// backup
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Backup string `json:"backup,omitempty"`

	// check
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Check string `json:"check,omitempty"`

	// check send proxy
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	CheckSendProxy string `json:"check-send-proxy,omitempty"`

	// check sni
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	CheckSni string `json:"check-sni,omitempty"`

	// check ssl
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	CheckSsl string `json:"check-ssl,omitempty"`

	// check alpn
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	CheckAlpn string `json:"check_alpn,omitempty"`

	// check proto
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	CheckProto string `json:"check_proto,omitempty"`

	// check via socks4
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	CheckViaSocks4 string `json:"check_via_socks4,omitempty"`

	// ciphers
	Ciphers string `json:"ciphers,omitempty"`

	// ciphersuites
	Ciphersuites string `json:"ciphersuites,omitempty"`

	// crl file
	CrlFile string `json:"crl_file,omitempty"`

	// downinter
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	Downinter *int64 `json:"downinter,omitempty"`

	// error limit
	ErrorLimit *int64 `json:"error_limit,omitempty"`

	// fall
	Fall *int64 `json:"fall,omitempty"`

	// fastinter
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	Fastinter *int64 `json:"fastinter,omitempty"`

	// force sslv3
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	ForceSslv3 string `json:"force_sslv3,omitempty"`

	// force tlsv10
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	ForceTlsv10 string `json:"force_tlsv10,omitempty"`

	// force tlsv11
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	ForceTlsv11 string `json:"force_tlsv11,omitempty"`

	// force tlsv12
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	ForceTlsv12 string `json:"force_tlsv12,omitempty"`

	// force tlsv13
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	ForceTlsv13 string `json:"force_tlsv13,omitempty"`

	// health check address
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	HealthCheckAddress string `json:"health_check_address,omitempty"`

	// health check port
	// Maximum: 65535
	// Minimum: 1
	// +kubebuilder:validation:Maximum=65535
	// +kubebuilder:validation:Minimum=1
	HealthCheckPort *int64 `json:"health_check_port,omitempty"`

	// id
	// Read Only: true
	ID string `json:"id,omitempty"`

	// inter
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	Inter *int64 `json:"inter,omitempty"`

	// maintenance
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Maintenance string `json:"maintenance,omitempty"`

	// maxconn
	Maxconn *int64 `json:"maxconn,omitempty"`

	// maxqueue
	Maxqueue *int64 `json:"maxqueue,omitempty"`

	// minconn
	Minconn *int64 `json:"minconn,omitempty"`

	// name
	// Read Only: true
	Name string `json:"name,omitempty"`

	// no sslv3
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	NoSslv3 string `json:"no_sslv3,omitempty"`

	// no tlsv10
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	NoTlsv10 string `json:"no_tlsv10,omitempty"`

	// no tlsv11
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	NoTlsv11 string `json:"no_tlsv11,omitempty"`

	// no tlsv12
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	NoTlsv12 string `json:"no_tlsv12,omitempty"`

	// no tlsv13
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	NoTlsv13 string `json:"no_tlsv13,omitempty"`

	// npn
	Npn string `json:"npn,omitempty"`

	// observe
	// Enum: ["layer4","layer7"]
	// +kubebuilder:validation:Enum=layer4;layer7;
	Observe string `json:"observe,omitempty"`

	// on error
	// Enum: ["fastinter","fail-check","sudden-death","mark-down"]
	// +kubebuilder:validation:Enum=fastinter;fail-check;sudden-death;mark-down;
	OnError string `json:"on-error,omitempty"`

	// on marked down
	// Enum: ["shutdown-sessions"]
	// +kubebuilder:validation:Enum=shutdown-sessions;
	OnMarkedDown string `json:"on-marked-down,omitempty"`

	// on marked up
	// Enum: ["shutdown-backup-sessions"]
	// +kubebuilder:validation:Enum=shutdown-backup-sessions;
	OnMarkedUp string `json:"on-marked-up,omitempty"`

	// pool low conn
	PoolLowConn *int64 `json:"pool_low_conn,omitempty"`

	// pool max conn
	PoolMaxConn *int64 `json:"pool_max_conn,omitempty"`

	// pool purge delay
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	PoolPurgeDelay *int64 `json:"pool_purge_delay,omitempty"`

	// port
	// Read Only: true
	// Maximum: 65535
	// Minimum: 1
	// +kubebuilder:validation:Maximum=65535
	// +kubebuilder:validation:Minimum=1
	Port *int64 `json:"port,omitempty"`

	// proto
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Proto string `json:"proto,omitempty"`

	// proxy v2 options
	ProxyV2Options []string `json:"proxy-v2-options,omitempty"`

	// rise
	Rise *int64 `json:"rise,omitempty"`

	// send proxy
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	SendProxy string `json:"send-proxy,omitempty"`

	// send proxy v2
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	SendProxyV2 string `json:"send-proxy-v2,omitempty"`

	// send proxy v2 ssl
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	SendProxyV2Ssl string `json:"send_proxy_v2_ssl,omitempty"`

	// send proxy v2 ssl cn
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	SendProxyV2SslCn string `json:"send_proxy_v2_ssl_cn,omitempty"`

	// slowstart
	// Minimum: 0
	// +kubebuilder:validation:Minimum=0
	Slowstart *int64 `json:"slowstart,omitempty"`

	// sni
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Sni string `json:"sni,omitempty"`

	// source
	Source string `json:"source,omitempty"`

	// ssl
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Ssl string `json:"ssl,omitempty"`

	// ssl cafile
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	SslCafile string `json:"ssl_cafile,omitempty"`

	// ssl certificate
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	SslCertificate string `json:"ssl_certificate,omitempty"`

	// ssl max ver
	// Enum: ["SSLv3","TLSv1.0","TLSv1.1","TLSv1.2","TLSv1.3"]
	// +kubebuilder:validation:Enum=SSLv3;TLSv1.0;TLSv1.1;TLSv1.2;TLSv1.3;
	SslMaxVer string `json:"ssl_max_ver,omitempty"`

	// ssl min ver
	// Enum: ["SSLv3","TLSv1.0","TLSv1.1","TLSv1.2","TLSv1.3"]
	// +kubebuilder:validation:Enum=SSLv3;TLSv1.0;TLSv1.1;TLSv1.2;TLSv1.3;
	SslMinVer string `json:"ssl_min_ver,omitempty"`

	// ssl reuse
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	SslReuse string `json:"ssl_reuse,omitempty"`

	// tfo
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Tfo string `json:"tfo,omitempty"`

	// tls tickets
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	TLSTickets string `json:"tls_tickets,omitempty"`

	// track
	Track string `json:"track,omitempty"`

	// verify
	// Enum: ["none","required"]
	// +kubebuilder:validation:Enum=none;required;
	Verify string `json:"verify,omitempty"`

	// verifyhost
	Verifyhost string `json:"verifyhost,omitempty"`

	// weight
	Weight *int64 `json:"weight,omitempty"`

	// ws
	// Enum: ["auto","h1","h2"]
	// +kubebuilder:validation:Enum=auto;h1;h2;
	Ws string `json:"ws,omitempty"`
}

// Validate validates this runtime add server
func (m *RuntimeAddServer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAgentAddr(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAgentCheck(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAgentInter(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAgentPort(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAlpn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBackup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCheck(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCheckSendProxy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCheckSni(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCheckSsl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCheckAlpn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCheckProto(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCheckViaSocks4(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDowninter(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFastinter(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateForceSslv3(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateForceTlsv10(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateForceTlsv11(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateForceTlsv12(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateForceTlsv13(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHealthCheckAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHealthCheckPort(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInter(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaintenance(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNoSslv3(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNoTlsv10(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNoTlsv11(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNoTlsv12(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNoTlsv13(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObserve(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOnError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOnMarkedDown(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOnMarkedUp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePoolPurgeDelay(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProto(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProxyV2Options(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSendProxy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSendProxyV2(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSendProxyV2Ssl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSendProxyV2SslCn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSlowstart(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSni(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSsl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSslCafile(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSslCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSslMaxVer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSslMinVer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSslReuse(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTfo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTLSTickets(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVerify(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWs(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RuntimeAddServer) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if err := validate.Pattern("address", "body", m.Address, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validateAgentAddr(formats strfmt.Registry) error {
	if swag.IsZero(m.AgentAddr) { // not required
		return nil
	}

	if err := validate.Pattern("agent-addr", "body", m.AgentAddr, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeAgentCheckPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeAgentCheckPropEnum = append(runtimeAddServerTypeAgentCheckPropEnum, v)
	}
}

const (

	// RuntimeAddServerAgentCheckEnabled captures enum value "enabled"
	RuntimeAddServerAgentCheckEnabled string = "enabled"

	// RuntimeAddServerAgentCheckDisabled captures enum value "disabled"
	RuntimeAddServerAgentCheckDisabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateAgentCheckEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeAgentCheckPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateAgentCheck(formats strfmt.Registry) error {
	if swag.IsZero(m.AgentCheck) { // not required
		return nil
	}

	// value enum
	if err := m.validateAgentCheckEnum("agent-check", "body", m.AgentCheck); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validateAgentInter(formats strfmt.Registry) error {
	if swag.IsZero(m.AgentInter) { // not required
		return nil
	}

	if err := validate.MinimumInt("agent-inter", "body", *m.AgentInter, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validateAgentPort(formats strfmt.Registry) error {
	if swag.IsZero(m.AgentPort) { // not required
		return nil
	}

	if err := validate.MinimumInt("agent-port", "body", *m.AgentPort, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("agent-port", "body", *m.AgentPort, 65535, false); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validateAlpn(formats strfmt.Registry) error {
	if swag.IsZero(m.Alpn) { // not required
		return nil
	}

	if err := validate.Pattern("alpn", "body", m.Alpn, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeBackupPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeBackupPropEnum = append(runtimeAddServerTypeBackupPropEnum, v)
	}
}

const (

	// RuntimeAddServerBackupEnabled captures enum value "enabled"
	RuntimeAddServerBackupEnabled string = "enabled"

	// RuntimeAddServerBackupDisabled captures enum value "disabled"
	RuntimeAddServerBackupDisabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateBackupEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeBackupPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateBackup(formats strfmt.Registry) error {
	if swag.IsZero(m.Backup) { // not required
		return nil
	}

	// value enum
	if err := m.validateBackupEnum("backup", "body", m.Backup); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeCheckPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeCheckPropEnum = append(runtimeAddServerTypeCheckPropEnum, v)
	}
}

const (

	// RuntimeAddServerCheckEnabled captures enum value "enabled"
	RuntimeAddServerCheckEnabled string = "enabled"

	// RuntimeAddServerCheckDisabled captures enum value "disabled"
	RuntimeAddServerCheckDisabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateCheckEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeCheckPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateCheck(formats strfmt.Registry) error {
	if swag.IsZero(m.Check) { // not required
		return nil
	}

	// value enum
	if err := m.validateCheckEnum("check", "body", m.Check); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeCheckSendProxyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeCheckSendProxyPropEnum = append(runtimeAddServerTypeCheckSendProxyPropEnum, v)
	}
}

const (

	// RuntimeAddServerCheckSendProxyEnabled captures enum value "enabled"
	RuntimeAddServerCheckSendProxyEnabled string = "enabled"

	// RuntimeAddServerCheckSendProxyDisabled captures enum value "disabled"
	RuntimeAddServerCheckSendProxyDisabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateCheckSendProxyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeCheckSendProxyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateCheckSendProxy(formats strfmt.Registry) error {
	if swag.IsZero(m.CheckSendProxy) { // not required
		return nil
	}

	// value enum
	if err := m.validateCheckSendProxyEnum("check-send-proxy", "body", m.CheckSendProxy); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validateCheckSni(formats strfmt.Registry) error {
	if swag.IsZero(m.CheckSni) { // not required
		return nil
	}

	if err := validate.Pattern("check-sni", "body", m.CheckSni, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeCheckSslPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeCheckSslPropEnum = append(runtimeAddServerTypeCheckSslPropEnum, v)
	}
}

const (

	// RuntimeAddServerCheckSslEnabled captures enum value "enabled"
	RuntimeAddServerCheckSslEnabled string = "enabled"

	// RuntimeAddServerCheckSslDisabled captures enum value "disabled"
	RuntimeAddServerCheckSslDisabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateCheckSslEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeCheckSslPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateCheckSsl(formats strfmt.Registry) error {
	if swag.IsZero(m.CheckSsl) { // not required
		return nil
	}

	// value enum
	if err := m.validateCheckSslEnum("check-ssl", "body", m.CheckSsl); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validateCheckAlpn(formats strfmt.Registry) error {
	if swag.IsZero(m.CheckAlpn) { // not required
		return nil
	}

	if err := validate.Pattern("check_alpn", "body", m.CheckAlpn, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validateCheckProto(formats strfmt.Registry) error {
	if swag.IsZero(m.CheckProto) { // not required
		return nil
	}

	if err := validate.Pattern("check_proto", "body", m.CheckProto, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeCheckViaSocks4PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeCheckViaSocks4PropEnum = append(runtimeAddServerTypeCheckViaSocks4PropEnum, v)
	}
}

const (

	// RuntimeAddServerCheckViaSocks4Enabled captures enum value "enabled"
	RuntimeAddServerCheckViaSocks4Enabled string = "enabled"

	// RuntimeAddServerCheckViaSocks4Disabled captures enum value "disabled"
	RuntimeAddServerCheckViaSocks4Disabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateCheckViaSocks4Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeCheckViaSocks4PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateCheckViaSocks4(formats strfmt.Registry) error {
	if swag.IsZero(m.CheckViaSocks4) { // not required
		return nil
	}

	// value enum
	if err := m.validateCheckViaSocks4Enum("check_via_socks4", "body", m.CheckViaSocks4); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validateDowninter(formats strfmt.Registry) error {
	if swag.IsZero(m.Downinter) { // not required
		return nil
	}

	if err := validate.MinimumInt("downinter", "body", *m.Downinter, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validateFastinter(formats strfmt.Registry) error {
	if swag.IsZero(m.Fastinter) { // not required
		return nil
	}

	if err := validate.MinimumInt("fastinter", "body", *m.Fastinter, 0, false); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeForceSslv3PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeForceSslv3PropEnum = append(runtimeAddServerTypeForceSslv3PropEnum, v)
	}
}

const (

	// RuntimeAddServerForceSslv3Enabled captures enum value "enabled"
	RuntimeAddServerForceSslv3Enabled string = "enabled"

	// RuntimeAddServerForceSslv3Disabled captures enum value "disabled"
	RuntimeAddServerForceSslv3Disabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateForceSslv3Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeForceSslv3PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateForceSslv3(formats strfmt.Registry) error {
	if swag.IsZero(m.ForceSslv3) { // not required
		return nil
	}

	// value enum
	if err := m.validateForceSslv3Enum("force_sslv3", "body", m.ForceSslv3); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeForceTlsv10PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeForceTlsv10PropEnum = append(runtimeAddServerTypeForceTlsv10PropEnum, v)
	}
}

const (

	// RuntimeAddServerForceTlsv10Enabled captures enum value "enabled"
	RuntimeAddServerForceTlsv10Enabled string = "enabled"

	// RuntimeAddServerForceTlsv10Disabled captures enum value "disabled"
	RuntimeAddServerForceTlsv10Disabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateForceTlsv10Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeForceTlsv10PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateForceTlsv10(formats strfmt.Registry) error {
	if swag.IsZero(m.ForceTlsv10) { // not required
		return nil
	}

	// value enum
	if err := m.validateForceTlsv10Enum("force_tlsv10", "body", m.ForceTlsv10); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeForceTlsv11PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeForceTlsv11PropEnum = append(runtimeAddServerTypeForceTlsv11PropEnum, v)
	}
}

const (

	// RuntimeAddServerForceTlsv11Enabled captures enum value "enabled"
	RuntimeAddServerForceTlsv11Enabled string = "enabled"

	// RuntimeAddServerForceTlsv11Disabled captures enum value "disabled"
	RuntimeAddServerForceTlsv11Disabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateForceTlsv11Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeForceTlsv11PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateForceTlsv11(formats strfmt.Registry) error {
	if swag.IsZero(m.ForceTlsv11) { // not required
		return nil
	}

	// value enum
	if err := m.validateForceTlsv11Enum("force_tlsv11", "body", m.ForceTlsv11); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeForceTlsv12PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeForceTlsv12PropEnum = append(runtimeAddServerTypeForceTlsv12PropEnum, v)
	}
}

const (

	// RuntimeAddServerForceTlsv12Enabled captures enum value "enabled"
	RuntimeAddServerForceTlsv12Enabled string = "enabled"

	// RuntimeAddServerForceTlsv12Disabled captures enum value "disabled"
	RuntimeAddServerForceTlsv12Disabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateForceTlsv12Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeForceTlsv12PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateForceTlsv12(formats strfmt.Registry) error {
	if swag.IsZero(m.ForceTlsv12) { // not required
		return nil
	}

	// value enum
	if err := m.validateForceTlsv12Enum("force_tlsv12", "body", m.ForceTlsv12); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeForceTlsv13PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeForceTlsv13PropEnum = append(runtimeAddServerTypeForceTlsv13PropEnum, v)
	}
}

const (

	// RuntimeAddServerForceTlsv13Enabled captures enum value "enabled"
	RuntimeAddServerForceTlsv13Enabled string = "enabled"

	// RuntimeAddServerForceTlsv13Disabled captures enum value "disabled"
	RuntimeAddServerForceTlsv13Disabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateForceTlsv13Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeForceTlsv13PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateForceTlsv13(formats strfmt.Registry) error {
	if swag.IsZero(m.ForceTlsv13) { // not required
		return nil
	}

	// value enum
	if err := m.validateForceTlsv13Enum("force_tlsv13", "body", m.ForceTlsv13); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validateHealthCheckAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.HealthCheckAddress) { // not required
		return nil
	}

	if err := validate.Pattern("health_check_address", "body", m.HealthCheckAddress, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validateHealthCheckPort(formats strfmt.Registry) error {
	if swag.IsZero(m.HealthCheckPort) { // not required
		return nil
	}

	if err := validate.MinimumInt("health_check_port", "body", *m.HealthCheckPort, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("health_check_port", "body", *m.HealthCheckPort, 65535, false); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validateInter(formats strfmt.Registry) error {
	if swag.IsZero(m.Inter) { // not required
		return nil
	}

	if err := validate.MinimumInt("inter", "body", *m.Inter, 0, false); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeMaintenancePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeMaintenancePropEnum = append(runtimeAddServerTypeMaintenancePropEnum, v)
	}
}

const (

	// RuntimeAddServerMaintenanceEnabled captures enum value "enabled"
	RuntimeAddServerMaintenanceEnabled string = "enabled"

	// RuntimeAddServerMaintenanceDisabled captures enum value "disabled"
	RuntimeAddServerMaintenanceDisabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateMaintenanceEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeMaintenancePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateMaintenance(formats strfmt.Registry) error {
	if swag.IsZero(m.Maintenance) { // not required
		return nil
	}

	// value enum
	if err := m.validateMaintenanceEnum("maintenance", "body", m.Maintenance); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeNoSslv3PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeNoSslv3PropEnum = append(runtimeAddServerTypeNoSslv3PropEnum, v)
	}
}

const (

	// RuntimeAddServerNoSslv3Enabled captures enum value "enabled"
	RuntimeAddServerNoSslv3Enabled string = "enabled"

	// RuntimeAddServerNoSslv3Disabled captures enum value "disabled"
	RuntimeAddServerNoSslv3Disabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateNoSslv3Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeNoSslv3PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateNoSslv3(formats strfmt.Registry) error {
	if swag.IsZero(m.NoSslv3) { // not required
		return nil
	}

	// value enum
	if err := m.validateNoSslv3Enum("no_sslv3", "body", m.NoSslv3); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeNoTlsv10PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeNoTlsv10PropEnum = append(runtimeAddServerTypeNoTlsv10PropEnum, v)
	}
}

const (

	// RuntimeAddServerNoTlsv10Enabled captures enum value "enabled"
	RuntimeAddServerNoTlsv10Enabled string = "enabled"

	// RuntimeAddServerNoTlsv10Disabled captures enum value "disabled"
	RuntimeAddServerNoTlsv10Disabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateNoTlsv10Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeNoTlsv10PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateNoTlsv10(formats strfmt.Registry) error {
	if swag.IsZero(m.NoTlsv10) { // not required
		return nil
	}

	// value enum
	if err := m.validateNoTlsv10Enum("no_tlsv10", "body", m.NoTlsv10); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeNoTlsv11PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeNoTlsv11PropEnum = append(runtimeAddServerTypeNoTlsv11PropEnum, v)
	}
}

const (

	// RuntimeAddServerNoTlsv11Enabled captures enum value "enabled"
	RuntimeAddServerNoTlsv11Enabled string = "enabled"

	// RuntimeAddServerNoTlsv11Disabled captures enum value "disabled"
	RuntimeAddServerNoTlsv11Disabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateNoTlsv11Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeNoTlsv11PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateNoTlsv11(formats strfmt.Registry) error {
	if swag.IsZero(m.NoTlsv11) { // not required
		return nil
	}

	// value enum
	if err := m.validateNoTlsv11Enum("no_tlsv11", "body", m.NoTlsv11); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeNoTlsv12PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeNoTlsv12PropEnum = append(runtimeAddServerTypeNoTlsv12PropEnum, v)
	}
}

const (

	// RuntimeAddServerNoTlsv12Enabled captures enum value "enabled"
	RuntimeAddServerNoTlsv12Enabled string = "enabled"

	// RuntimeAddServerNoTlsv12Disabled captures enum value "disabled"
	RuntimeAddServerNoTlsv12Disabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateNoTlsv12Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeNoTlsv12PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateNoTlsv12(formats strfmt.Registry) error {
	if swag.IsZero(m.NoTlsv12) { // not required
		return nil
	}

	// value enum
	if err := m.validateNoTlsv12Enum("no_tlsv12", "body", m.NoTlsv12); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeNoTlsv13PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeNoTlsv13PropEnum = append(runtimeAddServerTypeNoTlsv13PropEnum, v)
	}
}

const (

	// RuntimeAddServerNoTlsv13Enabled captures enum value "enabled"
	RuntimeAddServerNoTlsv13Enabled string = "enabled"

	// RuntimeAddServerNoTlsv13Disabled captures enum value "disabled"
	RuntimeAddServerNoTlsv13Disabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateNoTlsv13Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeNoTlsv13PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateNoTlsv13(formats strfmt.Registry) error {
	if swag.IsZero(m.NoTlsv13) { // not required
		return nil
	}

	// value enum
	if err := m.validateNoTlsv13Enum("no_tlsv13", "body", m.NoTlsv13); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeObservePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["layer4","layer7"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeObservePropEnum = append(runtimeAddServerTypeObservePropEnum, v)
	}
}

const (

	// RuntimeAddServerObserveLayer4 captures enum value "layer4"
	RuntimeAddServerObserveLayer4 string = "layer4"

	// RuntimeAddServerObserveLayer7 captures enum value "layer7"
	RuntimeAddServerObserveLayer7 string = "layer7"
)

// prop value enum
func (m *RuntimeAddServer) validateObserveEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeObservePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateObserve(formats strfmt.Registry) error {
	if swag.IsZero(m.Observe) { // not required
		return nil
	}

	// value enum
	if err := m.validateObserveEnum("observe", "body", m.Observe); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeOnErrorPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fastinter","fail-check","sudden-death","mark-down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeOnErrorPropEnum = append(runtimeAddServerTypeOnErrorPropEnum, v)
	}
}

const (

	// RuntimeAddServerOnErrorFastinter captures enum value "fastinter"
	RuntimeAddServerOnErrorFastinter string = "fastinter"

	// RuntimeAddServerOnErrorFailDashCheck captures enum value "fail-check"
	RuntimeAddServerOnErrorFailDashCheck string = "fail-check"

	// RuntimeAddServerOnErrorSuddenDashDeath captures enum value "sudden-death"
	RuntimeAddServerOnErrorSuddenDashDeath string = "sudden-death"

	// RuntimeAddServerOnErrorMarkDashDown captures enum value "mark-down"
	RuntimeAddServerOnErrorMarkDashDown string = "mark-down"
)

// prop value enum
func (m *RuntimeAddServer) validateOnErrorEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeOnErrorPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateOnError(formats strfmt.Registry) error {
	if swag.IsZero(m.OnError) { // not required
		return nil
	}

	// value enum
	if err := m.validateOnErrorEnum("on-error", "body", m.OnError); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeOnMarkedDownPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["shutdown-sessions"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeOnMarkedDownPropEnum = append(runtimeAddServerTypeOnMarkedDownPropEnum, v)
	}
}

const (

	// RuntimeAddServerOnMarkedDownShutdownDashSessions captures enum value "shutdown-sessions"
	RuntimeAddServerOnMarkedDownShutdownDashSessions string = "shutdown-sessions"
)

// prop value enum
func (m *RuntimeAddServer) validateOnMarkedDownEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeOnMarkedDownPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateOnMarkedDown(formats strfmt.Registry) error {
	if swag.IsZero(m.OnMarkedDown) { // not required
		return nil
	}

	// value enum
	if err := m.validateOnMarkedDownEnum("on-marked-down", "body", m.OnMarkedDown); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeOnMarkedUpPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["shutdown-backup-sessions"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeOnMarkedUpPropEnum = append(runtimeAddServerTypeOnMarkedUpPropEnum, v)
	}
}

const (

	// RuntimeAddServerOnMarkedUpShutdownDashBackupDashSessions captures enum value "shutdown-backup-sessions"
	RuntimeAddServerOnMarkedUpShutdownDashBackupDashSessions string = "shutdown-backup-sessions"
)

// prop value enum
func (m *RuntimeAddServer) validateOnMarkedUpEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeOnMarkedUpPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateOnMarkedUp(formats strfmt.Registry) error {
	if swag.IsZero(m.OnMarkedUp) { // not required
		return nil
	}

	// value enum
	if err := m.validateOnMarkedUpEnum("on-marked-up", "body", m.OnMarkedUp); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validatePoolPurgeDelay(formats strfmt.Registry) error {
	if swag.IsZero(m.PoolPurgeDelay) { // not required
		return nil
	}

	if err := validate.MinimumInt("pool_purge_delay", "body", *m.PoolPurgeDelay, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(m.Port) { // not required
		return nil
	}

	if err := validate.MinimumInt("port", "body", *m.Port, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("port", "body", *m.Port, 65535, false); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validateProto(formats strfmt.Registry) error {
	if swag.IsZero(m.Proto) { // not required
		return nil
	}

	if err := validate.Pattern("proto", "body", m.Proto, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerProxyV2OptionsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["authority","cert-cn","cert-key","cert-sig","crc32c","ssl","ssl-cipher","unique-id"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerProxyV2OptionsItemsEnum = append(runtimeAddServerProxyV2OptionsItemsEnum, v)
	}
}

func (m *RuntimeAddServer) validateProxyV2OptionsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerProxyV2OptionsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateProxyV2Options(formats strfmt.Registry) error {
	if swag.IsZero(m.ProxyV2Options) { // not required
		return nil
	}

	for i := 0; i < len(m.ProxyV2Options); i++ {

		// value enum
		if err := m.validateProxyV2OptionsItemsEnum("proxy-v2-options"+"."+strconv.Itoa(i), "body", m.ProxyV2Options[i]); err != nil {
			return err
		}

	}

	return nil
}

var runtimeAddServerTypeSendProxyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeSendProxyPropEnum = append(runtimeAddServerTypeSendProxyPropEnum, v)
	}
}

const (

	// RuntimeAddServerSendProxyEnabled captures enum value "enabled"
	RuntimeAddServerSendProxyEnabled string = "enabled"

	// RuntimeAddServerSendProxyDisabled captures enum value "disabled"
	RuntimeAddServerSendProxyDisabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateSendProxyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeSendProxyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateSendProxy(formats strfmt.Registry) error {
	if swag.IsZero(m.SendProxy) { // not required
		return nil
	}

	// value enum
	if err := m.validateSendProxyEnum("send-proxy", "body", m.SendProxy); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeSendProxyV2PropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeSendProxyV2PropEnum = append(runtimeAddServerTypeSendProxyV2PropEnum, v)
	}
}

const (

	// RuntimeAddServerSendProxyV2Enabled captures enum value "enabled"
	RuntimeAddServerSendProxyV2Enabled string = "enabled"

	// RuntimeAddServerSendProxyV2Disabled captures enum value "disabled"
	RuntimeAddServerSendProxyV2Disabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateSendProxyV2Enum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeSendProxyV2PropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateSendProxyV2(formats strfmt.Registry) error {
	if swag.IsZero(m.SendProxyV2) { // not required
		return nil
	}

	// value enum
	if err := m.validateSendProxyV2Enum("send-proxy-v2", "body", m.SendProxyV2); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeSendProxyV2SslPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeSendProxyV2SslPropEnum = append(runtimeAddServerTypeSendProxyV2SslPropEnum, v)
	}
}

const (

	// RuntimeAddServerSendProxyV2SslEnabled captures enum value "enabled"
	RuntimeAddServerSendProxyV2SslEnabled string = "enabled"

	// RuntimeAddServerSendProxyV2SslDisabled captures enum value "disabled"
	RuntimeAddServerSendProxyV2SslDisabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateSendProxyV2SslEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeSendProxyV2SslPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateSendProxyV2Ssl(formats strfmt.Registry) error {
	if swag.IsZero(m.SendProxyV2Ssl) { // not required
		return nil
	}

	// value enum
	if err := m.validateSendProxyV2SslEnum("send_proxy_v2_ssl", "body", m.SendProxyV2Ssl); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeSendProxyV2SslCnPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeSendProxyV2SslCnPropEnum = append(runtimeAddServerTypeSendProxyV2SslCnPropEnum, v)
	}
}

const (

	// RuntimeAddServerSendProxyV2SslCnEnabled captures enum value "enabled"
	RuntimeAddServerSendProxyV2SslCnEnabled string = "enabled"

	// RuntimeAddServerSendProxyV2SslCnDisabled captures enum value "disabled"
	RuntimeAddServerSendProxyV2SslCnDisabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateSendProxyV2SslCnEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeSendProxyV2SslCnPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateSendProxyV2SslCn(formats strfmt.Registry) error {
	if swag.IsZero(m.SendProxyV2SslCn) { // not required
		return nil
	}

	// value enum
	if err := m.validateSendProxyV2SslCnEnum("send_proxy_v2_ssl_cn", "body", m.SendProxyV2SslCn); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validateSlowstart(formats strfmt.Registry) error {
	if swag.IsZero(m.Slowstart) { // not required
		return nil
	}

	if err := validate.MinimumInt("slowstart", "body", *m.Slowstart, 0, false); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validateSni(formats strfmt.Registry) error {
	if swag.IsZero(m.Sni) { // not required
		return nil
	}

	if err := validate.Pattern("sni", "body", m.Sni, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeSslPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeSslPropEnum = append(runtimeAddServerTypeSslPropEnum, v)
	}
}

const (

	// RuntimeAddServerSslEnabled captures enum value "enabled"
	RuntimeAddServerSslEnabled string = "enabled"

	// RuntimeAddServerSslDisabled captures enum value "disabled"
	RuntimeAddServerSslDisabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateSslEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeSslPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateSsl(formats strfmt.Registry) error {
	if swag.IsZero(m.Ssl) { // not required
		return nil
	}

	// value enum
	if err := m.validateSslEnum("ssl", "body", m.Ssl); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validateSslCafile(formats strfmt.Registry) error {
	if swag.IsZero(m.SslCafile) { // not required
		return nil
	}

	if err := validate.Pattern("ssl_cafile", "body", m.SslCafile, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) validateSslCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.SslCertificate) { // not required
		return nil
	}

	if err := validate.Pattern("ssl_certificate", "body", m.SslCertificate, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeSslMaxVerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["SSLv3","TLSv1.0","TLSv1.1","TLSv1.2","TLSv1.3"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeSslMaxVerPropEnum = append(runtimeAddServerTypeSslMaxVerPropEnum, v)
	}
}

const (

	// RuntimeAddServerSslMaxVerSSLv3 captures enum value "SSLv3"
	RuntimeAddServerSslMaxVerSSLv3 string = "SSLv3"

	// RuntimeAddServerSslMaxVerTLSv1Dot0 captures enum value "TLSv1.0"
	RuntimeAddServerSslMaxVerTLSv1Dot0 string = "TLSv1.0"

	// RuntimeAddServerSslMaxVerTLSv1Dot1 captures enum value "TLSv1.1"
	RuntimeAddServerSslMaxVerTLSv1Dot1 string = "TLSv1.1"

	// RuntimeAddServerSslMaxVerTLSv1Dot2 captures enum value "TLSv1.2"
	RuntimeAddServerSslMaxVerTLSv1Dot2 string = "TLSv1.2"

	// RuntimeAddServerSslMaxVerTLSv1Dot3 captures enum value "TLSv1.3"
	RuntimeAddServerSslMaxVerTLSv1Dot3 string = "TLSv1.3"
)

// prop value enum
func (m *RuntimeAddServer) validateSslMaxVerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeSslMaxVerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateSslMaxVer(formats strfmt.Registry) error {
	if swag.IsZero(m.SslMaxVer) { // not required
		return nil
	}

	// value enum
	if err := m.validateSslMaxVerEnum("ssl_max_ver", "body", m.SslMaxVer); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeSslMinVerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["SSLv3","TLSv1.0","TLSv1.1","TLSv1.2","TLSv1.3"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeSslMinVerPropEnum = append(runtimeAddServerTypeSslMinVerPropEnum, v)
	}
}

const (

	// RuntimeAddServerSslMinVerSSLv3 captures enum value "SSLv3"
	RuntimeAddServerSslMinVerSSLv3 string = "SSLv3"

	// RuntimeAddServerSslMinVerTLSv1Dot0 captures enum value "TLSv1.0"
	RuntimeAddServerSslMinVerTLSv1Dot0 string = "TLSv1.0"

	// RuntimeAddServerSslMinVerTLSv1Dot1 captures enum value "TLSv1.1"
	RuntimeAddServerSslMinVerTLSv1Dot1 string = "TLSv1.1"

	// RuntimeAddServerSslMinVerTLSv1Dot2 captures enum value "TLSv1.2"
	RuntimeAddServerSslMinVerTLSv1Dot2 string = "TLSv1.2"

	// RuntimeAddServerSslMinVerTLSv1Dot3 captures enum value "TLSv1.3"
	RuntimeAddServerSslMinVerTLSv1Dot3 string = "TLSv1.3"
)

// prop value enum
func (m *RuntimeAddServer) validateSslMinVerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeSslMinVerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateSslMinVer(formats strfmt.Registry) error {
	if swag.IsZero(m.SslMinVer) { // not required
		return nil
	}

	// value enum
	if err := m.validateSslMinVerEnum("ssl_min_ver", "body", m.SslMinVer); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeSslReusePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeSslReusePropEnum = append(runtimeAddServerTypeSslReusePropEnum, v)
	}
}

const (

	// RuntimeAddServerSslReuseEnabled captures enum value "enabled"
	RuntimeAddServerSslReuseEnabled string = "enabled"

	// RuntimeAddServerSslReuseDisabled captures enum value "disabled"
	RuntimeAddServerSslReuseDisabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateSslReuseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeSslReusePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateSslReuse(formats strfmt.Registry) error {
	if swag.IsZero(m.SslReuse) { // not required
		return nil
	}

	// value enum
	if err := m.validateSslReuseEnum("ssl_reuse", "body", m.SslReuse); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeTfoPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeTfoPropEnum = append(runtimeAddServerTypeTfoPropEnum, v)
	}
}

const (

	// RuntimeAddServerTfoEnabled captures enum value "enabled"
	RuntimeAddServerTfoEnabled string = "enabled"

	// RuntimeAddServerTfoDisabled captures enum value "disabled"
	RuntimeAddServerTfoDisabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateTfoEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeTfoPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateTfo(formats strfmt.Registry) error {
	if swag.IsZero(m.Tfo) { // not required
		return nil
	}

	// value enum
	if err := m.validateTfoEnum("tfo", "body", m.Tfo); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeTLSTicketsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeTLSTicketsPropEnum = append(runtimeAddServerTypeTLSTicketsPropEnum, v)
	}
}

const (

	// RuntimeAddServerTLSTicketsEnabled captures enum value "enabled"
	RuntimeAddServerTLSTicketsEnabled string = "enabled"

	// RuntimeAddServerTLSTicketsDisabled captures enum value "disabled"
	RuntimeAddServerTLSTicketsDisabled string = "disabled"
)

// prop value enum
func (m *RuntimeAddServer) validateTLSTicketsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeTLSTicketsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateTLSTickets(formats strfmt.Registry) error {
	if swag.IsZero(m.TLSTickets) { // not required
		return nil
	}

	// value enum
	if err := m.validateTLSTicketsEnum("tls_tickets", "body", m.TLSTickets); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeVerifyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeVerifyPropEnum = append(runtimeAddServerTypeVerifyPropEnum, v)
	}
}

const (

	// RuntimeAddServerVerifyNone captures enum value "none"
	RuntimeAddServerVerifyNone string = "none"

	// RuntimeAddServerVerifyRequired captures enum value "required"
	RuntimeAddServerVerifyRequired string = "required"
)

// prop value enum
func (m *RuntimeAddServer) validateVerifyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeVerifyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateVerify(formats strfmt.Registry) error {
	if swag.IsZero(m.Verify) { // not required
		return nil
	}

	// value enum
	if err := m.validateVerifyEnum("verify", "body", m.Verify); err != nil {
		return err
	}

	return nil
}

var runtimeAddServerTypeWsPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["auto","h1","h2"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeAddServerTypeWsPropEnum = append(runtimeAddServerTypeWsPropEnum, v)
	}
}

const (

	// RuntimeAddServerWsAuto captures enum value "auto"
	RuntimeAddServerWsAuto string = "auto"

	// RuntimeAddServerWsH1 captures enum value "h1"
	RuntimeAddServerWsH1 string = "h1"

	// RuntimeAddServerWsH2 captures enum value "h2"
	RuntimeAddServerWsH2 string = "h2"
)

// prop value enum
func (m *RuntimeAddServer) validateWsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeAddServerTypeWsPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeAddServer) validateWs(formats strfmt.Registry) error {
	if swag.IsZero(m.Ws) { // not required
		return nil
	}

	// value enum
	if err := m.validateWsEnum("ws", "body", m.Ws); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this runtime add server based on the context it is used
func (m *RuntimeAddServer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RuntimeAddServer) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "address", "body", string(m.Address)); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", string(m.ID)); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", string(m.Name)); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeAddServer) contextValidatePort(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "port", "body", m.Port); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *RuntimeAddServer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RuntimeAddServer) UnmarshalBinary(b []byte) error {
	var res RuntimeAddServer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
