/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.DefaultFtpReply;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.IODataConnectionFactory;
import org.apache.ftpserver.impl.LocalizedDataTransferFtpReply;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.impl.ServerDataConnectionFactory;
import org.apache.ftpserver.impl.ServerFtpStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APPE
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(APPE.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        try {
            DataConnection dataConnection;
            InetAddress address;
            session.resetState();
            String fileName = request.getArgument();
            if (fileName == null) {
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 501, "APPE", null, null));
                return;
            }
            ServerDataConnectionFactory connFactory = session.getDataConnection();
            if (connFactory instanceof IODataConnectionFactory && (address = ((IODataConnectionFactory)connFactory).getInetAddress()) == null) {
                session.write(new DefaultFtpReply(503, "PORT or PASV must be issued first"));
                return;
            }
            FtpFile file = null;
            try {
                file = session.getFileSystemView().getFile(fileName);
            }
            catch (Exception e) {
                this.LOG.debug("File system threw exception", (Throwable)e);
            }
            if (file == null) {
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 550, "APPE.invalid", fileName, null));
                return;
            }
            fileName = file.getAbsolutePath();
            if (file.doesExist() && !file.isFile()) {
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 550, "APPE.invalid", fileName, file));
                return;
            }
            if (!file.isWritable()) {
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 550, "APPE.permission", fileName, file));
                return;
            }
            session.write((Object)LocalizedFtpReply.translate(session, request, context, 150, "APPE", fileName));
            try {
                dataConnection = session.getDataConnection().openConnection();
            }
            catch (Exception e) {
                this.LOG.debug("Exception when getting data input stream", (Throwable)e);
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 425, "APPE", fileName, file));
                session.getDataConnection().closeDataConnection();
                return;
            }
            boolean failure = false;
            long transSz = 0L;
            long offset = 0L;
            if (file.doesExist()) {
                offset = file.getSize();
            }
            try (OutputStream os = file.createOutputStream(offset);){
                transSz = dataConnection.transferFromClient(session.getFtpletSession(), os);
                if (os != null) {
                    os.close();
                }
                this.LOG.info("File uploaded {}", (Object)fileName);
                ServerFtpStatistics ftpStat = (ServerFtpStatistics)context.getFtpStatistics();
                ftpStat.setUpload(session, file, transSz);
            }
            catch (SocketException e) {
                this.LOG.debug("SocketException during file upload", (Throwable)e);
                failure = true;
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 426, "APPE", fileName, file));
            }
            catch (IOException e) {
                this.LOG.debug("IOException during file upload", (Throwable)e);
                failure = true;
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 551, "APPE", fileName, file));
            }
            if (!failure) {
                session.write((Object)LocalizedDataTransferFtpReply.translate(session, request, context, 226, "APPE", fileName, file, transSz));
            }
        }
        finally {
            session.getDataConnection().closeDataConnection();
        }
    }
}

