"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Layer = void 0;
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _utils = require("../utils");
// Reference: https://github.com/statsig-io/js-lite/blob/main/src/Layer.ts
var Layer = exports.Layer = /*#__PURE__*/function () {
  function Layer(name, layerValue, ruleID, evaluationDetails) {
    var logParameterFunction = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
    var secondaryExposures = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : [];
    var undelegatedSecondaryExposures = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : [];
    var allocatedExperimentName = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : '';
    var explicitParameters = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : [];
    (0, _classCallCheck2.default)(this, Layer);
    this._logParameterFunction = logParameterFunction;
    this._name = name;
    this._value = JSON.parse(JSON.stringify(layerValue !== null && layerValue !== void 0 ? layerValue : {}));
    this._ruleID = ruleID !== null && ruleID !== void 0 ? ruleID : '';
    this._evaluationDetails = evaluationDetails;
    this._secondaryExposures = secondaryExposures;
    this._undelegatedSecondaryExposures = undelegatedSecondaryExposures;
    this._allocatedExperimentName = allocatedExperimentName;
    this._explicitParameters = explicitParameters;
  }
  return (0, _createClass2.default)(Layer, [{
    key: "get",
    value: function get(key, defaultValue, typeGuard) {
      var _this = this;
      var val = this._value[key];
      if (val == null) {
        return defaultValue;
      }
      var logAndReturn = function logAndReturn() {
        _this._logLayerParameterExposure(key);
        return val;
      };
      if (typeGuard) {
        return typeGuard(val) ? logAndReturn() : defaultValue;
      }
      if (defaultValue == null) {
        return logAndReturn();
      }
      if ((0, _typeof2.default)(val) === (0, _typeof2.default)(defaultValue) && Array.isArray(defaultValue) === Array.isArray(val)) {
        return logAndReturn();
      }
      return defaultValue;
    }
  }, {
    key: "getValue",
    value: function getValue(key, defaultValue) {
      // eslint-disable-next-line eqeqeq
      if (defaultValue == undefined) {
        defaultValue = null;
      }
      var val = this._value[key];
      if (val != null) {
        this._logLayerParameterExposure(key);
      }
      return val !== null && val !== void 0 ? val : defaultValue;
    }
  }, {
    key: "_logLayerParameterExposure",
    value: function _logLayerParameterExposure(parameterName) {
      var _this$_logParameterFu;
      (_this$_logParameterFu = this._logParameterFunction) === null || _this$_logParameterFu === void 0 || _this$_logParameterFu.call(this, this, parameterName);
    }
  }], [{
    key: "fromLayer",
    value: function fromLayer(layer) {
      var _layer$__evaluation, _layer$__evaluation2, _layer$__evaluation3, _layer$__evaluation4;
      var value = new Layer(layer.name, layer.__value, layer.ruleID, (0, _utils.migrateEvaluationDetails)(layer.details), function (_layer, parameterName) {
        return layer.get(parameterName);
      }, (_layer$__evaluation = layer.__evaluation) === null || _layer$__evaluation === void 0 ? void 0 : _layer$__evaluation.secondary_exposures, (_layer$__evaluation2 = layer.__evaluation) === null || _layer$__evaluation2 === void 0 ? void 0 : _layer$__evaluation2.undelegated_secondary_exposures, (_layer$__evaluation3 = layer.__evaluation) === null || _layer$__evaluation3 === void 0 ? void 0 : _layer$__evaluation3.allocated_experiment_name, (_layer$__evaluation4 = layer.__evaluation) === null || _layer$__evaluation4 === void 0 ? void 0 : _layer$__evaluation4.explicit_parameters);
      return value;
    }
  }]);
}();