import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/**
 * The lifecycle methods owned by this provided are used to align internal
 * timings with those of the rbd lifecycle.
 *
 * The events are intentionally distinct to those exposed by rbd to avoid
 * any confusion around whether events are fired internally or externally
 * first.
 */

import React, { createContext, useCallback, useContext, useState } from 'react';

// eslint-disable-next-line import/no-extraneous-dependencies

import { combine } from '@atlaskit/pragmatic-drag-and-drop/combine';
import { batchUpdatesForReact16 } from '../utils/batch-updates-for-react-16';
import { rbdInvariant } from './rbd-invariant';

/**
 * The data associated with each type of lifecycle event.
 */

function createRegistry() {
  return {
    onPendingDragStart: [],
    onPrePendingDragUpdate: [],
    onPendingDragUpdate: [],
    onBeforeDragEnd: []
  };
}
function createLifecycleManager() {
  var registry = createRegistry();
  var addResponder = function addResponder(event, responder) {
    registry[event].push(responder);
    return function () {
      // @ts-expect-error - type narrowing issues
      registry[event] = registry[event].filter(function (value) {
        return value !== responder;
      });
    };
  };
  var dispatch = function dispatch(event, data) {
    batchUpdatesForReact16(function () {
      var _iterator = _createForOfIteratorHelper(registry[event]),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _responder = _step.value;
          _responder(data);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    });
  };
  return {
    addResponder: addResponder,
    dispatch: dispatch
  };
}

/**
 * Creates a new lifecycle manager, returning methods for interfacing with it.
 */
export function useLifecycle() {
  var _useState = useState(createLifecycleManager),
    _useState2 = _slicedToArray(_useState, 1),
    lifecycleManager = _useState2[0];
  return lifecycleManager;
}
var LifecycleContext = /*#__PURE__*/createContext(null);
export function LifecycleContextProvider(_ref) {
  var children = _ref.children,
    lifecycle = _ref.lifecycle;
  /**
   * Allows for `<Draggable>` and `<Droppable>` instances to know about the
   * lifecycle timings.
   *
   * Designed to have a similar API to the pdnd monitors.
   */
  var monitorForLifecycle = useCallback(function (responders) {
    var cleanupFns = [];
    for (var _i = 0, _Object$entries = Object.entries(responders); _i < _Object$entries.length; _i++) {
      var entry = _Object$entries[_i];
      var _ref2 = entry,
        _ref3 = _slicedToArray(_ref2, 2),
        _event = _ref3[0],
        _responder2 = _ref3[1];
      cleanupFns.push(lifecycle.addResponder(_event, _responder2));
    }
    return combine.apply(void 0, cleanupFns);
  }, [lifecycle]);
  return /*#__PURE__*/React.createElement(LifecycleContext.Provider, {
    value: monitorForLifecycle
  }, children);
}
export function useMonitorForLifecycle() {
  var monitorForLifecycle = useContext(LifecycleContext);
  rbdInvariant(monitorForLifecycle !== null, 'useLifecycle() should only be called inside of a <DragDropContext />');
  return monitorForLifecycle;
}