import type { DragStart, DragUpdate, DroppableId } from 'react-beautiful-dnd';
import type { Action } from '../internal-types';
type DroppableState = {
    draggingFromThisWith: string | null;
    draggingOverWith: string | null;
    isDraggingOver: boolean;
};
export type DroppableAction = Action<'DRAG_START', {
    droppableId: DroppableId;
    start: DragStart;
}> | Action<'DRAG_UPDATE', {
    droppableId: DroppableId;
    update: DragUpdate;
}> | Action<'DRAG_CLEAR'>;
export declare const idleState: DroppableState;
export declare function reducer(state: DroppableState, action: DroppableAction): DroppableState;
export {};
