/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies.photonics;

import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.photonics.PLayer;
import com.sun.electric.technology.technologies.photonics.Photonics;

public class PhotoDetector
extends PrimitiveNode {
    private static final double BASEWIDTH = 10.0;
    private static final double BASEHEIGHT = 50.0;
    private static final double METALWIDTH = 5.0;
    private static final double METALGAP = 5.0;
    private static final double TAPERHEIGHT = 20.0;
    private static final double FULLWIDTH = 30.0;
    private static final double FULLHEIGHT = 50.0;
    private PrimitivePort pp1;
    private PrimitivePort pp2;
    private PrimitivePort pp3;

    public PhotoDetector(Photonics tech, Technology.NodeLayer[] layers) {
        super("Photo-Detector", tech, EPoint.ORIGIN, EPoint.ORIGIN, null, 30.0, 50.0, ERectangle.fromLambda(-15.0, -25.0, 30.0, 50.0), ERectangle.fromLambda(-5.0, -25.0, 10.0, 50.0), layers);
        this.setMinSize(30.0, 50.0, "");
        this.pp1 = PrimitivePort.newInst(this, new ArcProto[]{Photonics.opticalArc}, "pd-bot", 270, 0, 0, PortCharacteristic.UNKNOWN, EdgeH.c(0.0), EdgeV.b(-25.0), EdgeH.c(0.0), EdgeV.b(-25.0));
        this.pp2 = PrimitivePort.newInst(this, new ArcProto[]{Photonics.metal1Arc}, "pd-lft", 180, 90, 1, PortCharacteristic.UNKNOWN, EdgeH.fromLeft(-15.0), EdgeV.c(0.0), EdgeH.fromLeft(-15.0), EdgeV.c(0.0));
        this.pp3 = PrimitivePort.newInst(this, new ArcProto[]{Photonics.metal1Arc}, "pd-rgt", 0, 90, 2, PortCharacteristic.UNKNOWN, EdgeH.fromRight(-15.0), EdgeV.c(0.0), EdgeH.fromRight(-15.0), EdgeV.c(0.0));
        this.addPrimitivePorts(this.pp1, this.pp2, this.pp3);
    }

    @Override
    public void genShape(AbstractShapeBuilder b, ImmutableNodeInst n) {
        assert (n.protoId == this.getId());
        long width = n.size.getFixpX() + Photonics.lambdaToFixp(10.0);
        long height = n.size.getFixpY() + Photonics.lambdaToFixp(50.0);
        long taperHeight = Photonics.lambdaToFixp(20.0);
        long waveguideWidth = Photonics.lambdaToFixp(Photonics.photonicsWaveguide.getWidth());
        PLayer[] ol = Photonics.getOpticalLayers(true);
        for (int l = 0; l < ol.length; ++l) {
            Layer layer = ol[l].findLayer();
            if (layer == null) continue;
            long extend = Photonics.lambdaToFixp(ol[l].getWidth()) - waveguideWidth;
            b.setCurNode(n);
            b.pushPoint(-width / 2L - extend / 2L, -height / 2L + taperHeight);
            b.pushPoint(-width / 2L - extend / 2L, height / 2L);
            b.pushPoint(width / 2L + extend / 2L, height / 2L);
            b.pushPoint(width / 2L + extend / 2L, -height / 2L + taperHeight);
            b.pushPoly(Poly.Type.FILLED, layer, null, null);
            b.setCurNode(n);
            b.pushPoint(-width / 2L - extend / 2L, -height / 2L + taperHeight);
            b.pushPoint(-waveguideWidth / 2L - extend / 2L, -height / 2L);
            b.pushPoint(waveguideWidth / 2L + extend / 2L, -height / 2L);
            b.pushPoint(width / 2L + extend / 2L, -height / 2L + taperHeight);
            b.pushPoly(Poly.Type.FILLED, layer, null, null);
        }
        long metalGap = Photonics.lambdaToFixp(5.0);
        long metalWidth = Photonics.lambdaToFixp(5.0);
        long cutSpacing = Photonics.lambdaToFixp(5.0);
        long cutSize = Photonics.lambdaToFixp(1.0);
        int numCuts = (int)((height - cutSize) / cutSpacing);
        if (numCuts % 2 == 1) {
            --numCuts;
        }
        long metalLowLeft = height;
        long metalHighLeft = -height;
        long metalLowRight = height;
        long metalHighRight = -height;
        for (int i = 0; i < numCuts; ++i) {
            long yPos = (long)(-(numCuts - 1)) * cutSpacing / 2L + (long)i * cutSpacing;
            b.setCurNode(n);
            b.pushPoint(-cutSize / 2L, yPos - cutSize / 2L);
            b.pushPoint(-cutSize / 2L, yPos + cutSize / 2L);
            b.pushPoint(cutSize / 2L, yPos + cutSize / 2L);
            b.pushPoint(cutSize / 2L, yPos - cutSize / 2L);
            b.pushPoly(Poly.Type.FILLED, Photonics.polyCutLayer, null, null);
            b.setCurNode(n);
            if (i % 2 == 0) {
                b.pushPoint(cutSize / 2L, yPos - cutSize / 2L);
                b.pushPoint(cutSize / 2L, yPos + cutSize / 2L);
                b.pushPoint(-width / 2L - metalGap, yPos + cutSize / 2L);
                b.pushPoint(-width / 2L - metalGap, yPos - cutSize / 2L);
                if (yPos + cutSize / 2L > metalHighLeft) {
                    metalHighLeft = yPos + cutSize / 2L;
                }
                if (yPos - cutSize / 2L < metalLowLeft) {
                    metalLowLeft = yPos - cutSize / 2L;
                }
            } else {
                b.pushPoint(-cutSize / 2L, yPos - cutSize / 2L);
                b.pushPoint(-cutSize / 2L, yPos + cutSize / 2L);
                b.pushPoint(width / 2L + metalGap, yPos + cutSize / 2L);
                b.pushPoint(width / 2L + metalGap, yPos - cutSize / 2L);
                if (yPos + cutSize / 2L > metalHighRight) {
                    metalHighRight = yPos + cutSize / 2L;
                }
                if (yPos - cutSize / 2L < metalLowRight) {
                    metalLowRight = yPos - cutSize / 2L;
                }
            }
            b.pushPoly(Poly.Type.FILLED, Photonics.metal1Layer, null, null);
        }
        b.setCurNode(n);
        b.pushPoint(-width / 2L - metalGap, metalLowLeft);
        b.pushPoint(-width / 2L - metalGap - metalWidth, metalLowLeft);
        b.pushPoint(-width / 2L - metalGap - metalWidth, metalHighLeft);
        b.pushPoint(-width / 2L - metalGap, metalHighLeft);
        b.pushPoly(Poly.Type.FILLED, Photonics.metal1Layer, null, null);
        b.setCurNode(n);
        b.pushPoint(width / 2L + metalGap, metalLowRight);
        b.pushPoint(width / 2L + metalGap + metalWidth, metalLowRight);
        b.pushPoint(width / 2L + metalGap + metalWidth, metalHighRight);
        b.pushPoint(width / 2L + metalGap, metalHighRight);
        b.pushPoly(Poly.Type.FILLED, Photonics.metal1Layer, null, null);
    }
}

