"""Test the merge utility"""
import os
from junit2htmlreport import runner
from pathlib import Path
TESTS = Path(__file__).parent


def test_merge_folder(tmp_path):
    outfile = os.path.join(tmp_path, "test-merged.xml")
    outmatrix = os.path.join(tmp_path, "matrix.html")
    runner.run(["--merge", outfile, str(TESTS)])
    runner.run(["--theme", "dark", outfile])
    assert os.path.exists(f"{outfile}.html")

    tests = list([str(x) for x in TESTS.glob("*.xml")])
    runner.run(["--report-matrix", outmatrix] + tests)
    assert os.path.exists(outmatrix)
