from datetime import datetime, timedelta, timezone

import pytest

from key_value.aio.stores.memory.store import MemoryStore


@pytest.fixture
def memory_store() -> MemoryStore:
    return MemoryStore(max_entries_per_collection=500)


def now() -> datetime:
    return datetime.now(tz=timezone.utc)


def now_plus(seconds: int) -> datetime:
    return now() + timedelta(seconds=seconds)


def is_around(value: float, delta: float = 1) -> bool:
    return value - delta < value < value + delta
