# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.networkcloud.aio import NetworkCloudMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkCloudMgmtConsolesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkCloudMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_consoles_list_by_virtual_machine(self, resource_group):
        response = self.client.consoles.list_by_virtual_machine(
            resource_group_name=resource_group.name,
            virtual_machine_name="str",
            api_version="2025-07-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_consoles_get(self, resource_group):
        response = await self.client.consoles.get(
            resource_group_name=resource_group.name,
            virtual_machine_name="str",
            console_name="str",
            api_version="2025-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_consoles_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.consoles.begin_create_or_update(
                resource_group_name=resource_group.name,
                virtual_machine_name="str",
                console_name="str",
                console_parameters={
                    "enabled": "str",
                    "extendedLocation": {"name": "str", "type": "str"},
                    "location": "str",
                    "sshPublicKey": {"keyData": "str"},
                    "detailedStatus": "str",
                    "detailedStatusMessage": "str",
                    "etag": "str",
                    "expiration": "2020-02-20 00:00:00",
                    "id": "str",
                    "name": "str",
                    "privateLinkServiceId": "str",
                    "provisioningState": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                    "virtualMachineAccessId": "str",
                },
                api_version="2025-07-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_consoles_begin_delete(self, resource_group):
        response = await (
            await self.client.consoles.begin_delete(
                resource_group_name=resource_group.name,
                virtual_machine_name="str",
                console_name="str",
                api_version="2025-07-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_consoles_begin_update(self, resource_group):
        response = await (
            await self.client.consoles.begin_update(
                resource_group_name=resource_group.name,
                virtual_machine_name="str",
                console_name="str",
                api_version="2025-07-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
