"""add cascade delete from workspace

Revision ID: 18891ca61db6
Revises: aa56852fa76d
Create Date: 2021-04-08 12:09:04.182543+00:00

"""
from alembic import op

# revision identifiers, used by Alembic.
revision = '18891ca61db6'
down_revision = 'aa56852fa76d'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('credential_workspace_id_fkey', 'credential', type_='foreignkey')
    op.create_foreign_key('credential_workspace_id_fkey', 'credential', 'workspace', ['workspace_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('host_workspace_id_fkey', 'host', type_='foreignkey')
    op.create_foreign_key('host_workspace_id_fkey', 'host', 'workspace', ['workspace_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('hostname_workspace_id_fkey', 'hostname', type_='foreignkey')
    op.create_foreign_key('hostname_workspace_id_fkey', 'hostname', 'workspace', ['workspace_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('rule_action_uc', 'rule_action', type_='unique')
    op.drop_constraint('service_workspace_id_fkey', 'service', type_='foreignkey')
    op.create_foreign_key('service_workspace_id_fkey', 'service', 'workspace', ['workspace_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('vulnerability_workspace_id_fkey', 'vulnerability', type_='foreignkey')
    op.create_foreign_key('vulnerability_workspace_id_fkey', 'vulnerability', 'workspace', ['workspace_id'], ['id'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('vulnerability_workspace_id_fkey', 'vulnerability', type_='foreignkey')
    op.create_foreign_key('vulnerability_workspace_id_fkey', 'vulnerability', 'workspace', ['workspace_id'], ['id'])
    op.drop_constraint('service_workspace_id_fkey', 'service', type_='foreignkey')
    op.create_foreign_key('service_workspace_id_fkey', 'service', 'workspace', ['workspace_id'], ['id'])
    op.create_unique_constraint('rule_action_uc', 'rule_action', ['rule_id', 'action_id'])
    op.drop_constraint('hostname_workspace_id_fkey', 'hostname', type_='foreignkey')
    op.create_foreign_key('hostname_workspace_id_fkey', 'hostname', 'workspace', ['workspace_id'], ['id'])
    op.drop_constraint('host_workspace_id_fkey', 'host', type_='foreignkey')
    op.create_foreign_key('host_workspace_id_fkey', 'host', 'workspace', ['workspace_id'], ['id'])
    op.drop_constraint('credential_workspace_id_fkey', 'credential', type_='foreignkey')
    op.create_foreign_key('credential_workspace_id_fkey', 'credential', 'workspace', ['workspace_id'], ['id'])
    # ### end Alembic commands ###
