/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.http.capi;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.couchbase.mock.JsonUtils;
import org.couchbase.mock.http.capi.CAPIServer;
import org.couchbase.mock.http.capi.PathInfo;
import org.couchbase.mock.httpio.HandlerUtil;
import org.couchbase.mock.views.DesignDocument;
import org.couchbase.mock.views.DesignParseException;

class DesignHandler
implements HttpRequestHandler {
    private final CAPIServer capiServer;

    public DesignHandler(CAPIServer capiServer) {
        this.capiServer = capiServer;
    }

    private static void setXCouchbaseMeta(HttpResponse response, DesignDocument ddoc) {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        tmp.put("id", ddoc.getId());
        tmp.put("type", "json");
        tmp.put("rev", -1);
        String s = JsonUtils.encode(tmp);
        response.addHeader("X-Couchbase-Meta", s);
    }

    static void setOkResponse(HttpResponse response, DesignDocument ddoc) {
        JsonObject obj = new JsonObject();
        obj.addProperty("ok", true);
        obj.addProperty("id", ddoc.getId());
        HandlerUtil.makeJsonResponse(response, obj.toString());
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (!this.capiServer.verifier.verify(request, response, context)) {
            return;
        }
        String mName = request.getRequestLine().getMethod();
        if (!CAPIServer.ALLOWED_DDOC_METHODS.contains(mName)) {
            response.setStatusCode(405);
            return;
        }
        PathInfo info = new PathInfo(request.getRequestLine().getUri());
        DesignDocument ddoc = this.capiServer.findDesign(info);
        if (!info.getViewName().isEmpty()) {
            if (ddoc == null) {
                CAPIServer.makeNotFoundError(response, String.format("Design document %s not found", info.getDesignId()));
            } else {
                CAPIServer.makeNotFoundError(response, String.format("View `%s` not defined in local design document `%s`", info.getViewName(), info.getDesignId()));
            }
            return;
        }
        if (!mName.equals("PUT") && ddoc == null) {
            CAPIServer.makeNotFoundError(response);
            return;
        }
        if (mName.equals("GET")) {
            HandlerUtil.makeJsonResponse(response, ddoc.getBody());
            DesignHandler.setXCouchbaseMeta(response, ddoc);
        } else if (mName.equals("HEAD")) {
            response.setStatusCode(501);
        } else if (mName.equals("DELETE")) {
            this.capiServer.removeDesign(ddoc);
            DesignHandler.setOkResponse(response, ddoc);
        } else if (mName.equals("PUT")) {
            if (!(request instanceof HttpEntityEnclosingRequest)) {
                response.setStatusCode(400);
                HandlerUtil.makeStringResponse(response, CAPIServer.makeError("badarg"));
                return;
            }
            Header ctHeader = request.getLastHeader("Content-Type");
            if (ctHeader == null || !ctHeader.getValue().equals(ContentType.APPLICATION_JSON.getMimeType())) {
                response.setStatusCode(400);
                HandlerUtil.makeStringResponse(response, CAPIServer.makeError("invalid_design_document", "Content is not json."));
                return;
            }
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            String txt = EntityUtils.toString(entity);
            try {
                ddoc = DesignDocument.create(txt, info.getDesignName());
                this.capiServer.addDesign(ddoc);
                response.setStatusCode(201);
                DesignHandler.setXCouchbaseMeta(response, ddoc);
                DesignHandler.setOkResponse(response, ddoc);
            }
            catch (DesignParseException ex) {
                String msg = ex.getMessage();
                if (msg == null) {
                    msg = "Couldn't parse JSON";
                }
                HandlerUtil.make400Response(response, CAPIServer.makeError("bad_request", msg));
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                HandlerUtil.make400Response(response, sw.toString());
            }
        }
    }
}

