#!/usr/bin/perl

use strict;
use warnings;
use Test::Most tests => 101;

use App::Prove::Plugin::TraceUse;

cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("   1.  DateTime 0.78, -e line 0 [main]")], [qw/DateTime 0.78/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("   2.    strict 1.07, DateTime.pm line 8")], [qw/strict 1.07/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("   3.    warnings 1.13, DateTime.pm line 9")], [qw/warnings 1.13/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("   4.    Carp 1.26, DateTime.pm line 42")], [qw/Carp 1.26/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("   5.      Exporter 5.66, Carp.pm line 35")], [qw/Exporter 5.66/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  71.        Exporter::Heavy 5.66, Exporter.pm line 16")], [qw/Exporter::Heavy 5.66/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("   6.    DateTime::Duration 0.78, DateTime.pm line 43")], [qw/DateTime::Duration 0.78/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("   7.      DateTime::Helpers 0.78, DateTime/Duration.pm line 11")], [qw/DateTime::Helpers 0.78/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("   8.        Scalar::Util 1.25, DateTime/Helpers.pm line 9")], [qw/Scalar::Util 1.25/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("   9.          List::Util 1.25, Scalar/Util.pm line 11")], [qw/List::Util 1.25/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  10.            XSLoader 0.16, List/Util.pm line 20")], [qw/XSLoader 0.16/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  11.      Params::Validate 1.07, DateTime/Duration.pm line 12")], [qw/Params::Validate 1.07/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  12.        Module::Implementation 0.06, Params/Validate.pm line 12")], [qw/Module::Implementation 0.06/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  13.          Module::Runtime 0.013, Module/Implementation.pm line 9")], [qw/Module::Runtime 0.013/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  18.            Params::Validate::XS 1.07, Module/Runtime.pm line 317")], [qw/Params::Validate::XS 1.07/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  45.            Class::Load::XS, Module/Runtime.pm line 317 (FAILED)")], [qw/Class::Load::XS/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  46.            Class::Load::PP 0.20, Module/Runtime.pm line 317")], [qw/Class::Load::PP 0.20/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  47.              Package::Stash 0.33, Class/Load/PP.pm line 9")], [qw/Package::Stash 0.33/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  48.                Package::Stash::XS 0.25, Package/Stash.pm line 24 (eval 20)")], [qw/Package::Stash::XS 0.25/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  49.                Package::DeprecationManager 0.13, Package/Stash.pm line 56")], [qw/Package::DeprecationManager 0.13/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  14.          Try::Tiny 0.11, Module/Implementation.pm line 10")], [qw/Try::Tiny 0.11/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  15.            vars 1.02, Try/Tiny.pm line 6")], [qw/vars 1.02/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  16.              warnings::register 1.02, vars.pm line 7")], [qw/warnings::register 1.02/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  17.        Params::Validate::Constants 1.07, Params/Validate.pm line 13")], [qw/Params::Validate::Constants 1.07/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  19.      overload 1.18, DateTime/Duration.pm line 21")], [qw/overload 1.18/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  20.        overloading 0.02, overload.pm line 85")], [qw/overloading 0.02/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  21.      constant 1.23, DateTime/Duration.pm line 23")], [qw/constant 1.23/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  22.        utf8 1.09, constant.pm line 36")], [qw/utf8 1.09/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  23.          utf8_heavy.pl, utf8.pm line 17")], [qw/utf8_heavy.pl/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  24.            unicore/Heavy.pl, utf8_heavy.pl line 176 [utf8]")], [qw{unicore/Heavy.pl}], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  25.            unicore/lib/Perl/_PerlIDS.pl, utf8_heavy.pl line 518 [utf8]")], [qw{unicore/lib/Perl/_PerlIDS.pl}], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  26.    DateTime::Locale 0.45, DateTime.pm line 45")], [qw/DateTime::Locale 0.45/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  27.      DateTime::Locale::Base, DateTime/Locale.pm line 10")], [qw/DateTime::Locale::Base/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  28.        List::MoreUtils 0.33, DateTime/Locale/Base.pm line 8")], [qw/List::MoreUtils 0.33/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  29.          DynaLoader 1.14, List/MoreUtils.pm line 6")], [qw/DynaLoader 1.14/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  30.            Config, DynaLoader.pm line 22")], [qw/Config/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  31.      DateTime::Locale::Catalog, DateTime/Locale.pm line 11")], [qw/DateTime::Locale::Catalog/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  57.      DateTime::Locale::en_US, DateTime/Locale.pm line 280 (eval 25)")], [qw/DateTime::Locale::en_US/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  32.    DateTime::TimeZone 1.57, DateTime.pm line 46")], [qw/DateTime::TimeZone 1.57/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  33.      DateTime::TimeZone::Catalog 1.57, DateTime/TimeZone.pm line 11")], [qw/DateTime::TimeZone::Catalog 1.57/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  34.      DateTime::TimeZone::Floating 1.57, DateTime/TimeZone.pm line 12")], [qw/DateTime::TimeZone::Floating 1.57/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  35.        parent 0.225, DateTime/TimeZone/Floating.pm line 9")], [qw/parent 0.225/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  36.          Class::Singleton 1.4, parent.pm line 20")], [qw/Class::Singleton 1.4/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  37.          DateTime::TimeZone::OffsetOnly 1.57, parent.pm line 20")], [qw/DateTime::TimeZone::OffsetOnly 1.57/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  38.            DateTime::TimeZone::UTC 1.57, DateTime/TimeZone/OffsetOnly.pm line 11")], [qw/DateTime::TimeZone::UTC 1.57/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  39.      DateTime::TimeZone::Local 1.57, DateTime/TimeZone.pm line 13")], [qw/DateTime::TimeZone::Local 1.57/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  40.        Class::Load 0.20, DateTime/TimeZone/Local.pm line 9")], [qw/Class::Load 0.20/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  41.          base 2.18, Class/Load.pm line 7")], [qw/base 2.18/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  58.            DateTime::Locale::en, base.pm line 81 (eval 26)")], [qw/DateTime::Locale::en/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  59.            DateTime::Locale::root, base.pm line 81 (eval 27)")], [qw/DateTime::Locale::root/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  42.          Data::OptList 0.107, Class/Load.pm line 8")], [qw/Data::OptList 0.107/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  43.            Params::Util 1.07, Data/OptList.pm line 10")], [qw/Params::Util 1.07/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  44.            Sub::Install 0.926, Data/OptList.pm line 11")], [qw/Sub::Install 0.926/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  50.        File::Spec 3.39_02, DateTime/TimeZone/Local.pm line 11")], [qw/File::Spec 3.39_02/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  51.          File::Spec::Unix 3.39_02, File/Spec.pm line 22")], [qw/File::Spec::Unix 3.39_02/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  52.    POSIX 1.30, DateTime.pm line 49")], [qw/POSIX 1.30/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  53.      Fcntl 1.11, POSIX.pm line 17")], [qw/Fcntl 1.11/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  54.      Tie::Hash 1.04, POSIX.pm line 419 [POSIX::SigRt]")], [qw/Tie::Hash 1.04/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  55.    integer 1.00, DateTime.pm line 702")], [qw/integer 1.00/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  56.    DateTime::Infinite 0.78, DateTime.pm line 70")], [qw/DateTime::Infinite 0.78/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  60.  Set::Object 1.26, -e line 0 [main]")], [qw/Set::Object 1.26/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  61.    AutoLoader 5.72, Set/Object.pm line 503")], [qw/AutoLoader 5.72/], "module parse" );
#cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  62.    Set::Object::Weak, Set/Object.pm line 1091")], [qw/Set::Object::Weak/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  63.  LWP::Simple 6.00, -e line 0 [main]")], [qw/LWP::Simple 6.00/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  64.    HTTP::Status 6.03, LWP/Simple.pm line 14")], [qw/HTTP::Status 6.03/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  65.    LWP::UserAgent 6.05, LWP/Simple.pm line 26")], [qw/LWP::UserAgent 6.05/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  66.      HTTP::Request 6.00, LWP/UserAgent.pm line 10")], [qw/HTTP::Request 6.00/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  67.        HTTP::Message 6.03, HTTP/Request.pm line 3")], [qw/HTTP::Message 6.03/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  68.          HTTP::Headers 6.00, HTTP/Message.pm line 7")], [qw/HTTP::Headers 6.00/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  69.            Storable 2.34, HTTP/Headers.pm line 282")], [qw/Storable 2.34/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  70.              Log::Agent, Storable.pm line 27 (FAILED)")], [qw/Log::Agent/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  72.          URI 1.60, HTTP/Message.pm line 12 (eval 31)")], [qw/URI 1.60/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  73.            URI::Escape 3.31, URI.pm line 22")], [qw/URI::Escape 3.31/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  74.      HTTP::Response 6.03, LWP/UserAgent.pm line 11")], [qw/HTTP::Response 6.03/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  75.      HTTP::Date 6.02, LWP/UserAgent.pm line 12")], [qw/HTTP::Date 6.02/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  76.        Time::Local 1.2000, HTTP/Date.pm line 11")], [qw/Time::Local 1.2000/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  77.      LWP 6.05, LWP/UserAgent.pm line 14")], [qw/LWP 6.05/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  78.      LWP::Protocol 6.00, LWP/UserAgent.pm line 15")], [qw/LWP::Protocol 6.00/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  79.        LWP::MemberMixin, LWP/Protocol.pm line 3")], [qw/LWP::MemberMixin/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  80.      HTTP::Config 6.00, LWP/UserAgent.pm line 770")], [qw/HTTP::Config 6.00/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  81.      Encode 2.44, LWP/UserAgent.pm line 999")], [qw/Encode 2.44/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  82.        Encode::Alias 2.15, Encode.pm line 48")], [qw/Encode::Alias 2.15/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  83.        bytes 1.04, Encode.pm line 325 [Encode::utf8]")], [qw/bytes 1.04/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  84.        Encode::Config 2.05, Encode.pm line 53")], [qw/Encode::Config 2.05/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  85.        Encode::ConfigLocal, Encode.pm line 60 (FAILED)")], [qw/Encode::ConfigLocal/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  86.        Encode::Encoding 2.05, Encode.pm line 241")], [qw/Encode::Encoding 2.05/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  87.      Encode::Locale 1.03, LWP/UserAgent.pm line 1000")], [qw/Encode::Locale 1.03/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  88.        I18N::Langinfo 0.08_02, Encode/Locale.pm line 58")], [qw/I18N::Langinfo 0.08_02/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  89.  XML::LibXML 2.0004, -e line 0 [main]")], [qw/XML::LibXML 2.0004/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  90.    XML::LibXML::Error 2.0004, XML/LibXML.pm line 24")], [qw/XML::LibXML::Error 2.0004/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  91.      Data::Dumper 2.135_06, XML/LibXML/Error.pm line 257")], [qw/Data::Dumper 2.135_06/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  92.    XML::LibXML::NodeList 2.0004, XML/LibXML.pm line 25")], [qw/XML::LibXML::NodeList 2.0004/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  93.      XML::LibXML::Boolean 2.0004, XML/LibXML/NodeList.pm line 15")], [qw/XML::LibXML::Boolean 2.0004/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  94.        XML::LibXML::Number 2.0004, XML/LibXML/Boolean.pm line 12")], [qw/XML::LibXML::Number 2.0004/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  95.          XML::LibXML::Literal 2.0004, XML/LibXML/Number.pm line 12")], [qw/XML::LibXML::Literal 2.0004/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  96.    XML::LibXML::XPathContext 2.0004, XML/LibXML.pm line 26")], [qw/XML::LibXML::XPathContext 2.0004/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  97.    IO::Handle 1.33, XML/LibXML.pm line 27")], [qw/IO::Handle 1.33/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  98.      Symbol 1.07, IO/Handle.pm line 264")], [qw/Symbol 1.07/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  99.      SelectSaver 1.02, IO/Handle.pm line 265")], [qw/SelectSaver 1.02/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version(" 100.      IO 1.25_06, IO/Handle.pm line 266")], [qw/IO 1.25_06/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version(" 101.    XML::LibXML::AttributeHash 2.0004, XML/LibXML.pm line 1497 [XML::LibXML::Element]")], [qw/XML::LibXML::AttributeHash 2.0004/], "module parse" );
cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version(" 102.    XML::SAX::Exception 1.08, XML/LibXML.pm line 1995 [XML::LibXML::_SAXParser]")], [qw/XML::SAX::Exception 1.08/], "module parse" );


# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  17.        Params::Validate::Constants 1.07, Params/Validate.pm line 13")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  19.      overload 1.18, DateTime/Duration.pm line 21")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  20.        overloading 0.02, overload.pm line 85")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  21.      constant 1.23, DateTime/Duration.pm line 23")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  22.        utf8 1.09, constant.pm line 36")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  23.          utf8_heavy.pl, utf8.pm line 17")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  24.            unicore/Heavy.pl, utf8_heavy.pl line 176 [utf8]")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  25.            unicore/lib/Perl/_PerlIDS.pl, utf8_heavy.pl line 518 [utf8]")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  26.    DateTime::Locale 0.45, DateTime.pm line 45")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  27.      DateTime::Locale::Base, DateTime/Locale.pm line 10")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  28.        List::MoreUtils 0.33, DateTime/Locale/Base.pm line 8")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  29.          DynaLoader 1.14, List/MoreUtils.pm line 6")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  30.            Config, DynaLoader.pm line 22")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  31.      DateTime::Locale::Catalog, DateTime/Locale.pm line 11")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  57.      DateTime::Locale::en_US, DateTime/Locale.pm line 280 (eval 25)")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  32.    DateTime::TimeZone 1.57, DateTime.pm line 46")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  33.      DateTime::TimeZone::Catalog 1.57, DateTime/TimeZone.pm line 11")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  34.      DateTime::TimeZone::Floating 1.57, DateTime/TimeZone.pm line 12")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  35.        parent 0.225, DateTime/TimeZone/Floating.pm line 9")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  36.          Class::Singleton 1.4, parent.pm line 20")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  37.          DateTime::TimeZone::OffsetOnly 1.57, parent.pm line 20")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  38.            DateTime::TimeZone::UTC 1.57, DateTime/TimeZone/OffsetOnly.pm line 11")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  39.      DateTime::TimeZone::Local 1.57, DateTime/TimeZone.pm line 13")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  40.        Class::Load 0.20, DateTime/TimeZone/Local.pm line 9")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  41.          base 2.18, Class/Load.pm line 7")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  58.            DateTime::Locale::en, base.pm line 81 (eval 26)")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  59.            DateTime::Locale::root, base.pm line 81 (eval 27)")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  42.          Data::OptList 0.107, Class/Load.pm line 8")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  43.            Params::Util 1.07, Data/OptList.pm line 10")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  44.            Sub::Install 0.926, Data/OptList.pm line 11")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  50.        File::Spec 3.39_02, DateTime/TimeZone/Local.pm line 11")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  51.          File::Spec::Unix 3.39_02, File/Spec.pm line 22")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  52.    POSIX 1.30, DateTime.pm line 49")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  53.      Fcntl 1.11, POSIX.pm line 17")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  54.      Tie::Hash 1.04, POSIX.pm line 419 [POSIX::SigRt]")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  55.    integer 1.00, DateTime.pm line 702")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  56.    DateTime::Infinite 0.78, DateTime.pm line 70")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  60.  Set::Object 1.26, -e line 0 [main]")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  61.    [AutoLoader 5.72, Set/Object.pm line 503")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  62.    Set::Object::Weak, Set/Object.pm line 1091")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  63.  LWP::Simple 6.00, -e line 0 [main]")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  64.    HTTP::Status 6.03, LWP/Simple.pm line 14")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  65.    LWP::UserAgent 6.05, LWP/Simple.pm line 26")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  66.      HTTP::Request 6.00, LWP/UserAgent.pm line 10")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  67.        HTTP::Message 6.03, HTTP/Request.pm line 3")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  68.          HTTP::Headers 6.00, HTTP/Message.pm line 7")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  69.            Storable 2.34, HTTP/Headers.pm line 282")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  70.              Log::Agent, Storable.pm line 27 (FAILED)")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  72.          URI 1.60, HTTP/Message.pm line 12 (eval 31)")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  73.            URI::Escape 3.31, URI.pm line 22")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  74.      HTTP::Response 6.03, LWP/UserAgent.pm line 11")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  75.      HTTP::Date 6.02, LWP/UserAgent.pm line 12")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  76.        Time::Local 1.2000, HTTP/Date.pm line 11")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  77.      LWP 6.05, LWP/UserAgent.pm line 14")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  78.      LWP::Protocol 6.00, LWP/UserAgent.pm line 15")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  79.        LWP::MemberMixin, LWP/Protocol.pm line 3")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  80.      HTTP::Config 6.00, LWP/UserAgent.pm line 770")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  81.      Encode 2.44, LWP/UserAgent.pm line 999")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  82.        Encode::Alias 2.15, Encode.pm line 48")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  83.        bytes 1.04, Encode.pm line 325 [Encode::utf8]")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  84.        Encode::Config 2.05, Encode.pm line 53")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  85.        Encode::ConfigLocal, Encode.pm line 60 (FAILED)")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  86.        Encode::Encoding 2.05, Encode.pm line 241")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  87.      Encode::Locale 1.03, LWP/UserAgent.pm line 1000")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  88.        I18N::Langinfo 0.08_02, Encode/Locale.pm line 58")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  89.  XML::LibXML 2.0004, -e line 0 [main]")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  90.    XML::LibXML::Error 2.0004, XML/LibXML.pm line 24")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  91.      Data::Dumper 2.135_06, XML/LibXML/Error.pm line 257")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  92.    XML::LibXML::NodeList 2.0004, XML/LibXML.pm line 25")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  93.      XML::LibXML::Boolean 2.0004, XML/LibXML/NodeList.pm line 15")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  94.        XML::LibXML::Number 2.0004, XML/LibXML/Boolean.pm line 12")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  95.          XML::LibXML::Literal 2.0004, XML/LibXML/Number.pm line 12")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  96.    XML::LibXML::XPathContext 2.0004, XML/LibXML.pm line 26")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  97.    IO::Handle 1.33, XML/LibXML.pm line 27")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  98.      Symbol 1.07, IO/Handle.pm line 264")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version("  99.      SelectSaver 1.02, IO/Handle.pm line 265")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version(" 100.      IO 1.25_06, IO/Handle.pm line 266")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version(" 101.    XML::LibXML::AttributeHash 2.0004, XML/LibXML.pm line 1497 [XML::LibXML::Element]")], [qw//], "module parse" );
# cmp_deeply( [App::Prove::Plugin::TraceUse::_parse_module_and_version(" 102.    XML::SAX::Exception 1.08, XML/LibXML.pm line 1995 [XML::LibXML::_SAXParser]")], [qw//], "module parse" );

done_testing();
